/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IObjectBase;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.view.IListController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.BeanUtils;
import com.kingdee.shr.base.syssetting.web.util.UrlParamEncryptHelper;
import com.kingdee.shr.common.model.RemoteCallMessage;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public final class WafUtils {
    protected static Logger logger = Logger.getLogger(WafUtils.class);

    public static IObjectBase getBusinessObject(String clz) throws SHRWebException {
        IObjectBase objectBase = null;
        try {
            Class<?> model = Class.forName(clz + "Factory");
            Method method = model.getMethod("getRemoteInstance", new Class[0]);
            objectBase = (IObjectBase)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage());
        }
        return objectBase;
    }

    public static String constructURL(String url, String method, String param) {
        String resultURL = url;
        if (url.indexOf("?") > 0) {
            resultURL = url + "?";
        }
        resultURL = resultURL + "method" + "=" + method + "&" + param;
        return resultURL;
    }

    public static String getRequestUrl(HttpServletRequest request, HttpServletResponse response, String url) {
        String redirectUrl = url;
        redirectUrl = redirectUrl + '?';
        Map paramMap = request.getParameterMap();
        Iterator paramIterator = paramMap.keySet().iterator();
        while (paramIterator.hasNext()) {
            String key = (String)paramIterator.next();
            String value = request.getParameter(key);
            redirectUrl = redirectUrl + key + "=" + URLEncoder.encode(value);
            if (!paramIterator.hasNext()) continue;
            redirectUrl = redirectUrl + '&';
        }
        return redirectUrl;
    }

    public static ICoreBase getBusinessInterface(String businessObjectDesc) {
        if (businessObjectDesc == null) {
            return null;
        }
        String bo = businessObjectDesc + "Factory";
        try {
            Class<?> businessObjectFactory = Class.forName(bo);
            Method method = businessObjectFactory.getMethod("getRemoteInstance", new Class[0]);
            Object value = method.invoke(null, new Object[0]);
            return (ICoreBase)value;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)(bo + " not found!"));
        }
        catch (SecurityException e) {
            logger.error((Object)("Get " + bo + " error:" + e.getMessage()));
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)(bo + " not found!"));
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("Get " + bo + " error:" + e.getMessage()));
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("Get " + bo + " error:" + e.getMessage()));
        }
        catch (InvocationTargetException e) {
            logger.error((Object)("Get " + bo + " error:" + e.getMessage()));
        }
        return null;
    }

    public static ICoreBase getBusinessInterface(Class businessObjectInterface) {
        if (businessObjectInterface == null) {
            return null;
        }
        String[] names = businessObjectInterface.getName().split("\\.");
        String className = "";
        String classNameSub = "";
        if (names.length > 0) {
            classNameSub = names[names.length - 1].substring(1);
        }
        className = businessObjectInterface.getName().substring(0, businessObjectInterface.getName().lastIndexOf(".") + 1) + classNameSub;
        return WafUtils.getBusinessInterface(className);
    }

    public static String getListUrlByBOSType(String bosType) {
        if (bosType == null) {
            return null;
        }
        EntityObjectInfo entityInfo = WafUtils.getEntityInfoByBOSType(bosType);
        String rootPackage = WafUtils.rootPackage(entityInfo);
        rootPackage = rootPackage.replace("com.kingdee.eas", "");
        return rootPackage.replace(".", "/") + "/" + entityInfo.getName().substring(0, 1).toLowerCase() + entityInfo.getName().substring(1) + "ListController";
    }

    public static IListController getListControllerByBOSType(String bosType) {
        IListController listController = null;
        if (bosType == null) {
            return null;
        }
        EntityObjectInfo entityInfo = WafUtils.getEntityInfoByBOSType(bosType);
        String rootPackage = WafUtils.rootPackage(entityInfo);
        rootPackage = rootPackage + ".web";
        try {
            listController = (IListController)BeanUtils.getBean(rootPackage + "." + entityInfo.getName() + "ListPageController");
        }
        catch (SHRWebException e) {
            e.printStackTrace();
        }
        return listController;
    }

    public static String rootPackage(EntityObjectInfo entityInfo) {
        String str = entityInfo.getPackage();
        int index = str.lastIndexOf(".");
        if (index == -1) {
            return str;
        }
        return str.substring(0, index);
    }

    public static EntityObjectInfo getEntityInfoByBOSType(String bosType) {
        ConfigMDUtil.setContextToThread((Context)SHRContext.getInstance().getContext());
        IMetaDataLoader mdLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        BOSObjectType bosObjectType = BOSObjectType.create((String)bosType);
        EntityObjectInfo entityInfo = mdLoader.getEntity(bosObjectType);
        return entityInfo;
    }

    public static String calcConversationID() {
        return new String("" + System.currentTimeMillis());
    }

    public static List combinQueryResultToObject(List<Map<String, Object>> listData) {
        ArrayList resultList = new ArrayList();
        for (int nIndex = 0; nIndex < listData.size(); ++nIndex) {
            Map<String, Object> row = listData.get(nIndex);
            HashMap<String, Object> newRow = new HashMap<String, Object>();
            Set<String> keySet = row.keySet();
            for (String key : keySet) {
                String[] keyLevel = key.split("\\.");
                if (keyLevel.length <= 0) {
                    keyLevel = new String[]{key};
                }
                Map<String, Object> partMap = newRow;
                for (int nLevelIndex = 0; nLevelIndex < keyLevel.length - 1; ++nLevelIndex) {
                    String keyPart = keyLevel[nLevelIndex];
                    if (!partMap.containsKey(keyPart)) {
                        partMap.put(keyPart, new HashMap());
                    }
                    partMap = (Map)partMap.get(keyPart);
                }
                partMap.put(keyLevel[keyLevel.length - 1], row.get(key));
            }
            resultList.add(newRow);
        }
        return resultList;
    }

    public static Set sortMapKeys(Set keySets) {
        return new TreeSet(new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().length() - o2.toString().length();
            }
        });
    }

    public static String getRequestAction(HttpServletRequest request) {
        String method = request.getParameter("method");
        if (StringUtils.isEmpty((String)method)) {
            method = "initalize";
        }
        return method;
    }

    public static String getDataPlatformMethod(Context ctx, HttpServletRequest request) throws SHRWebException {
        try {
            String message = UrlParamEncryptHelper.decodeForAes(request.getParameter("param"));
            RemoteCallMessage remoteCallMessage = (RemoteCallMessage)JSONUtils.convertJsonToObject((Context)ctx, (String)message, RemoteCallMessage.class);
            String method = remoteCallMessage.getRemoteMethod();
            if ("init".equals(method)) {
                method = "initalize";
            }
            return method;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SHRWebException(e);
        }
    }
}

