/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.controller;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.common.util.XssFilterUtil;
import com.kingdee.shr.ueditor.UeditorConfigManager;
import com.kingdee.shr.ueditor.UeditorHelper;
import com.kingdee.shr.ueditor.define.BaseState;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/ueditor"})
public class UeditorController
extends WebComponentController {
    @RequestMapping(params={"method=uploadimage"})
    public void uploadImageAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String returnData = "";
        try {
            boolean isAjaxUpload;
            request.setCharacterEncoding("utf-8");
            response.setHeader("Content-Type", "text/html");
            boolean bl = isAjaxUpload = request.getHeader("X_Requested_With") != null;
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                JSONUtils.writeJson(response, new BaseState(false, 5));
            }
            String fileName = "";
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            for (Map.Entry entity : fileMap.entrySet()) {
                fileName = ((MultipartFile)entity.getValue()).getOriginalFilename();
            }
            XssFilterUtil.stripXSS((String)fileName, (String)"fileName");
            Map conf = null;
            conf = new UeditorConfigManager(request.getSession().getServletContext().getRealPath("/")).getConfig("operateCaptionConfig", request.getParameter("domainVal"), request.getParameter("noRename"), fileName);
            returnData = UeditorHelper.uploadImage((Map)conf, (Map)fileMap, (boolean)isAjaxUpload);
        }
        catch (IOException | JSONException e) {
            this.logger.error((Object)"UeditorController.uploadImageAction [{}]", e);
        }
        JSONUtils.writeJson(response, returnData);
    }

    @RequestMapping(params={"method=getConfig"})
    public void getConfigAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String returnData = "";
        try {
            returnData = new UeditorConfigManager(request.getSession().getServletContext().getRealPath("/")).getAllConfig().toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JSONUtils.writeJson(response, returnData);
    }

    @RequestMapping(params={"method=exportImageZip"})
    public void exportImageZip(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        String returnData = "";
        String fileAddress = UeditorHelper.getFileAddress((String)request.getSession().getServletContext().getRealPath("/"));
        try {
            File file = new File(fileAddress);
            String filename = file.getName();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            String downloadName = sdf.format(new Date()) + filename + ".zip";
            ServletOutputStream os = response.getOutputStream();
            Set UrlSet = UeditorHelper.getAllContentUrl((Context)SHRContext.getInstance().getContext(), (String)request.getSession().getServletContext().getRealPath("/"));
            byte[] data = UeditorHelper.createZip((String)fileAddress, (Set)UrlSet);
            response.reset();
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Access-Control-Expose-Headers", "*");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(downloadName, "UTF-8"));
            response.addHeader("Content-Length", "" + data.length);
            response.setContentType("application/octet-stream;charset=UTF-8");
            IOUtils.write((byte[])data, (OutputStream)os);
            os.flush();
            os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONUtils.writeJson(response, returnData);
    }

    @RequestMapping(params={"method=imagesAnalysis"})
    public void imagesAnalysis(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        String returnData = "";
        try {
            returnData = UeditorHelper.imagesAnalysis((String)SHRSyssettingUtil.getShrWebWarPath(), (Context)SHRContext.getInstance().getContext());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        JSONUtils.writeJson(response, returnData);
    }
}

