/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.controller;

import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.core.IWebController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.log.OperateLogManager;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class DynamicController
implements IWebController {
    private static Logger logger = Logger.getLogger(DynamicController.class);

    @RequestMapping(value={"/dynamic"})
    public String executeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String handler = DynamicUtil.getHandler(request);
        if (StringUtils.isEmpty((String)handler)) {
            logger.error((Object)"handler is not found, please check uipk or handler request parameter");
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "fail_and_retry"));
        }
        String action = request.getParameter("method");
        if (StringUtils.isEmpty((String)action)) {
            action = "initalize";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("dynamic request, uipk: {0}, handler: {1}, method: {2}", DynamicUtil.getUIPK(request), handler, action));
        }
        String viewName = this.doDispatch(request, response, modelMap, handler, action);
        this.afterDispatcher(request, response, modelMap);
        return viewName;
    }

    private String doDispatch(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, String handler, String action) throws SHRWebException {
        OperateLogManager.preWriteLog(request);
        long startTime = System.currentTimeMillis();
        String invokeHandlerMethod = DynamicUtil.invokeHandlerMethod(request, response, modelMap, handler, action + "Action");
        OperateLogManager.writeAccesLog(request, startTime);
        OperateLogManager.postWriteLog(request);
        return invokeHandlerMethod;
    }

    private void afterDispatcher(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        UIViewInfo uiViewInfo = UIViewUtil.getCurrentUIViewInfo((ServletRequest)request);
        modelMap.addAttribute("viewMeta", (Object)uiViewInfo);
        Object temp = request.getAttribute("isInitPageModelMapParam");
        if (temp instanceof Boolean && ((Boolean)temp).booleanValue()) {
            request.removeAttribute("isInitPageModelMapParam");
            return;
        }
        if (uiViewInfo != null) {
            modelMap.putAll(uiViewInfo.getVarDefine(SHRContext.getInstance().getContext()));
        }
    }

    @Override
    public ServletContext getServletContext() throws SHRWebException {
        return SHRContext.getInstance().getServletContext();
    }

    @Override
    public Locale getLocale() throws SHRWebException {
        return SHRContext.getInstance().getContext().getLocale();
    }

    @Override
    public ResourceBundle getResourceBundle() throws SHRWebException {
        return null;
    }

    @Override
    public String getMessage(String key) throws SHRWebException {
        return null;
    }

    @Override
    public List getLocalKeys() throws SHRWebException {
        return null;
    }

    @Override
    public void setInitalizeStatus(boolean value) throws SHRWebException {
    }

    @Override
    public boolean getInitalizeStatus() throws SHRWebException {
        return false;
    }
}

