/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.QueryPKInfo;
import com.kingdee.bos.privacy.PrivacyPropertyManager;
import com.kingdee.eas.base.commonquery.DataObject;
import com.kingdee.eas.base.commonquery.QueryUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.shr.base.syssetting.IUIView;
import com.kingdee.shr.base.syssetting.UIType;
import com.kingdee.shr.base.syssetting.UIViewCollection;
import com.kingdee.shr.base.syssetting.UIViewFactory;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.app.util.XMLUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrUIViewNotFoundException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.permission.data.PermissionRuleConfigBean;
import com.kingdee.shr.base.syssetting.permission.data.ShrCheckDataPermissionUtil;
import com.kingdee.shr.base.syssetting.util.EntityCheckHisUtil;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.util.ParamUtil;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.util.SHRPermissionWebUtils;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingUIViewUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.ButtonInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.ISearchUIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.view.converter.IFragmentUIViewConverter;
import com.kingdee.shr.base.syssetting.web.dynamic.view.converter.IUIViewConverter;
import com.kingdee.shr.base.syssetting.web.dynamic.view.converter.UIViewConverterFactory;
import com.kingdee.shr.base.syssetting.web.handler.HRBillEntryEditHandler;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.ml.MLServiceFactory;
import com.kingdee.shr.ml.ResourceType;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPath;
import org.springframework.ui.ModelMap;

public class UIViewUtil {
    private static Logger logger = Logger.getLogger(UIViewUtil.class);
    private static final String CACHE_TYPE = "shr.uiView";
    private static final String ENTRYS = "entrys";

    public static com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo initUIViewInfo(ServletRequest request) throws SHRWebException {
        return UIViewUtil.getCurrentUIViewInfo(request);
    }

    public static com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo getCurrentUIViewInfo(ServletRequest request) throws SHRWebException {
        String uipk = UIViewUtil.getUipk(request);
        return UIViewUtil.getUIViewInfoByUIPK(SHRContext.getInstance().getContext(), uipk);
    }

    public static String getUipk(ServletRequest request) {
        String uipk = UIViewUtil.getParameterByRequest(request, "uipk");
        if (StringUtils.isEmpty((String)uipk)) {
            String model = UIViewUtil.getParameterByRequest(request, "view_model");
            String type = UIViewUtil.getParameterByRequest(request, "view_type");
            String uri = UIViewUtil.getParameterByRequest(request, "view_uri");
            if (!StringUtils.isEmpty((String)uri)) {
                uipk = uri;
            } else if (!StringUtils.isEmpty((String)model) && !StringUtils.isEmpty((String)type)) {
                uipk = UIViewUtil.assembleKey(model, type);
            } else {
                return null;
            }
        }
        return uipk;
    }

    public static com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo getUIViewInfoByUIPK(String uipk) throws SHRWebException {
        return UIViewUtil.getUIViewInfoByUIPK(SHRContext.getInstance().getContext(), uipk);
    }

    public static com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo getUIViewInfoByUIPK(Context ctx, String uipk) throws SHRWebException {
        if (StringUtils.isEmpty((String)uipk)) {
            return null;
        }
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo = UIViewUtil.getUIViewInfoFromCache(ctx, uipk);
        if (viewInfo == null) {
            if (UIViewUtil.isRequestFragment(uipk)) {
                String[] str = uipk.split("\\$");
                String str1 = str[1];
                if (!StringUtils.isEmpty((String)str1)) {
                    str1 = str1.replaceAll("'", "").replaceAll("\\|", "").replaceAll("location", "").replaceAll("\\[", "").replaceAll("\\]", "").replaceAll("=", "").replaceAll("\\\\", "").replaceAll("\\+", "").replaceAll("window", "");
                }
                viewInfo = UIViewUtil.generateUIViewFragment(ctx, str[0], str1);
            } else {
                viewInfo = UIViewUtil.generateUIView(ctx, uipk);
            }
            UIViewUtil.addUIViewInfo(ctx, uipk, viewInfo);
        }
        return viewInfo;
    }

    public static boolean existUIViewInfo(String uipk) {
        return UIViewUtil.existUIViewInfo(SHRContext.getInstance().getContext(), uipk);
    }

    public static boolean existUIViewInfo(Context ctx, String uipk) {
        if (StringUtils.isEmpty((String)uipk)) {
            return false;
        }
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo = null;
        try {
            uiViewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
        }
        catch (SHRWebException e) {
            logger.error((Object)e.getMessage());
        }
        return uiViewInfo != null;
    }

    private static com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo generateUIView(Context ctx, String uipk) throws SHRWebException {
        UIViewInfo dbUIViewInfo = UIViewUtil.getUIViewFromDB(ctx, uipk);
        if (dbUIViewInfo == null) {
            if (!StringUtils.isEmpty((String)uipk)) {
                System.out.println(MessageFormat.format("current request dbUIViewInfo is null. uipk is : [{0}]", uipk));
            } else {
                logger.error((Object)"current request dbUIViewInfo is null. uipk is empty");
            }
            if (uipk.contains(" ")) {
                System.out.println(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "view_contain_blank"), uipk));
            }
            throw new ShrUIViewNotFoundException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "view_not_found"));
        }
        UIViewUtil.dealTreeNavigationElement(dbUIViewInfo);
        IUIViewConverter converter = UIViewConverterFactory.getUIViewConverter(dbUIViewInfo, ctx);
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo = converter.exec();
        ShrCheckDataPermissionUtil.initUIViewInfoPermissionConfig(ctx, uiViewInfo);
        return uiViewInfo;
    }

    private static void dealTreeNavigationElement(UIViewInfo dbUIViewInfo) {
        String content = UIViewUtil.dealConfig(dbUIViewInfo.getContent());
        String extend = UIViewUtil.dealConfig(dbUIViewInfo.getExtend());
        if (!StringUtils.isEmpty((String)content)) {
            dbUIViewInfo.setContent(content);
        }
        if (!StringUtils.isEmpty((String)extend)) {
            dbUIViewInfo.setExtend(extend);
        }
    }

    private static String dealConfig(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        try {
            XMLOutputter output = XMLUtil.getXMLOutputter();
            Document doc = XMLUtil.parseXML((String)text);
            Element rootElement = doc.getRootElement();
            XPath xPathTreeNavigation = XPath.newInstance((String)"//treeNavigation");
            XPath xPathFilterItem = XPath.newInstance((String)"//filterItem[@isAdminOrg='true']");
            List treeNavigations = xPathTreeNavigation.selectNodes((Object)rootElement);
            List filterItems = xPathFilterItem.selectNodes((Object)rootElement);
            if (null == treeNavigations || treeNavigations.isEmpty()) {
                return null;
            }
            if (null == filterItems || filterItems.isEmpty()) {
                return null;
            }
            for (Element e : treeNavigations) {
                Element parent = e.getParentElement();
                parent.removeContent((Content)e);
            }
            return output.outputString(doc);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean isAdminTreeAndContainLevelConflict(Document doc) throws JDOMException, SHRWebException {
        if (null == doc) {
            return false;
        }
        Element rootElement = doc.getRootElement();
        XPath xPathTreeNavigation = XPath.newInstance((String)"//treeNavigation");
        XPath xPathFilterItem = XPath.newInstance((String)"//filterItem[@isAdminOrg='true']");
        List treeNavigations = xPathTreeNavigation.selectNodes((Object)rootElement);
        List filterItems = xPathFilterItem.selectNodes((Object)rootElement);
        if (null == treeNavigations || treeNavigations.size() <= 0) {
            return false;
        }
        return null != filterItems && filterItems.size() > 0;
    }

    private static boolean isRequestFragment(String uipk) {
        return uipk.indexOf("$") != -1;
    }

    public static UIViewInfo getUIViewFromDB(String uipk) throws SHRWebException {
        return UIViewUtil.getUIViewFromDB(SHRContext.getInstance().getContext(), uipk);
    }

    public static UIViewInfo getUIViewFromDB(Context ctx, String uipk) throws SHRWebException {
        try {
            if (com.kingdee.util.LocaleUtils.locale_zh_CN.toString().equals(LocaleUtils.getLocal((Context)ctx))) {
                return UIViewFactory.getLocalInstance((Context)ctx).getValueByUipk(uipk, SysSettingUIViewUtil.getUIViewSelector());
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("uipks", uipk);
            params.put("isConvert", true);
            Object obj = MLServiceFactory.getLocalInstance((Context)ctx).convert(ResourceType.UIView, params);
            if (null == obj) {
                return null;
            }
            return (UIViewInfo)obj;
        }
        catch (BOSException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e.getMessage(), e);
        }
    }

    private static com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo generateUIViewFragment(Context ctx, String parentkey, String subType) throws SHRWebException {
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo parentUIViewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, parentkey);
        if (parentUIViewInfo == null) {
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "view_not_exist"), parentkey));
        }
        IFragmentUIViewConverter converter = UIViewConverterFactory.getFragmentUIViewConverter(parentUIViewInfo, ctx);
        converter.setSubType(subType);
        return converter.exec();
    }

    public static com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo getUIViewInfoFromCache(String uipk) {
        return UIViewUtil.getUIViewInfoFromCache(SHRContext.getInstance().getContext(), uipk);
    }

    public static com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo getUIViewInfoFromCache(Context ctx, String uipk) {
        return (com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo)CacheService.getInstance().get(CACHE_TYPE, UIViewUtil.getKey(uipk, ctx.getLocale().toString()));
    }

    private static final String getKey(String key, String locale) {
        return MessageFormat.format("{0}_{1}", key, locale);
    }

    public static void addUIViewInfo(Context ctx, String key, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo) {
        CacheService.getInstance().put(CACHE_TYPE, UIViewUtil.getKey(key, ctx.getLocale().toString()), (Object)uiViewInfo);
    }

    public static void cleanViewInfo(String ... args) {
        CacheService cacheService = CacheService.getInstance();
        for (String key : args) {
            cacheService.remove(CACHE_TYPE, UIViewUtil.getKey(key, com.kingdee.util.LocaleUtils.locale_l1.getDisplayName()));
            cacheService.remove(CACHE_TYPE, UIViewUtil.getKey(key, com.kingdee.util.LocaleUtils.locale_l2.getDisplayName()));
            cacheService.remove(CACHE_TYPE, UIViewUtil.getKey(key, com.kingdee.util.LocaleUtils.locale_l3.getDisplayName()));
            cacheService.remove(CACHE_TYPE, UIViewUtil.getKey(UIViewUtil.assembleFragmentKey(key, ENTRYS), com.kingdee.util.LocaleUtils.locale_l1.getDisplayName()));
            cacheService.remove(CACHE_TYPE, UIViewUtil.getKey(UIViewUtil.assembleFragmentKey(key, ENTRYS), com.kingdee.util.LocaleUtils.locale_l2.getDisplayName()));
            cacheService.remove(CACHE_TYPE, UIViewUtil.getKey(UIViewUtil.assembleFragmentKey(key, ENTRYS), com.kingdee.util.LocaleUtils.locale_l3.getDisplayName()));
            cacheService.remove(CACHE_TYPE, UIViewUtil.getKey(UIViewUtil.assembleFragmentKey(key, "fragment"), com.kingdee.util.LocaleUtils.locale_l1.getDisplayName()));
            cacheService.remove(CACHE_TYPE, UIViewUtil.getKey(UIViewUtil.assembleFragmentKey(key, "fragment"), com.kingdee.util.LocaleUtils.locale_l2.getDisplayName()));
            cacheService.remove(CACHE_TYPE, UIViewUtil.getKey(UIViewUtil.assembleFragmentKey(key, "fragment"), com.kingdee.util.LocaleUtils.locale_l3.getDisplayName()));
        }
    }

    public static void cleanViewInfoByModel(Context ctx, String model) {
        String oql = "select id,uipk  where model = '" + model + "'";
        try {
            IUIView iuiView = UIViewFactory.getLocalInstance((Context)ctx);
            UIViewCollection uiViewCollection = iuiView.getUIViewCollection(oql);
            String[] uipkArr = new String[uiViewCollection.size()];
            for (int i = 0; i < uiViewCollection.size(); ++i) {
                UIViewInfo uiViewInfo = uiViewCollection.get(i);
                uipkArr[i] = uiViewInfo.getUipk();
            }
            UIViewUtil.cleanViewInfo(uipkArr);
        }
        catch (BOSException e) {
            UIViewUtil.cleanViewInfo();
        }
    }

    public static void cleanViewInfo() {
        CacheService.getInstance().removeAll(CACHE_TYPE);
    }

    private static String getResourceKey(ResourceType resourceType, String fileName, String locale) {
        return MessageFormat.format("{0}_{1}_{2}", resourceType.getValue(), fileName, locale);
    }

    private static Map getResouceFromCache(ResourceType resourceType, String fileName, String locale) {
        return (Map)CacheService.getInstance().get(CACHE_TYPE, UIViewUtil.getResourceKey(resourceType, fileName, locale));
    }

    private static void addResource(ResourceType resourceType, String fileName, String locale, Map value) {
        CacheService.getInstance().put(CACHE_TYPE, UIViewUtil.getResourceKey(resourceType, fileName, locale), (Object)value);
    }

    private static Map getResouce(String fileName, ResourceType resourceType) throws EASBizException, BOSException {
        Context ctx = SHRContext.getInstance().getContext();
        return UIViewUtil.getResouce(ctx, fileName, resourceType);
    }

    private static Map getResouce(Context ctx, String fileName, ResourceType resourceType) throws EASBizException, BOSException {
        Map result;
        String locale = ctx.getLocale().toString();
        if (fileName.indexOf("$") != -1) {
            fileName = fileName.split("\\$")[0];
        }
        if (null == (result = UIViewUtil.getResouceFromCache(resourceType, fileName, locale)) || result.size() <= 0) {
            result = com.kingdee.util.LocaleUtils.locale_zh_CN.toString().equals(LocaleUtils.getLocal((Context)ctx)) ? SHRWebResource.getSHRFileResource(ctx, resourceType.getValue(), fileName) : SHRWebResource.getFileResource((Context)ctx, (String)resourceType.getValue(), (String)fileName);
            UIViewUtil.addResource(resourceType, fileName, locale, result);
        }
        if (null == result) {
            result = Collections.EMPTY_MAP;
        }
        return result;
    }

    public static Map getFreemarkerResouce(String fileName) throws EASBizException, BOSException {
        return UIViewUtil.getResouce(fileName, ResourceType.FTL);
    }

    public static Map getJsResouce(String fileName) throws EASBizException, BOSException {
        return UIViewUtil.getResouce(fileName, ResourceType.JS);
    }

    public static Map getJsResouce(Context ctx, String fileName) throws EASBizException, BOSException {
        return UIViewUtil.getResouce(ctx, fileName, ResourceType.JS);
    }

    private static String getParameterByRequest(ServletRequest request, String name) {
        String value = request.getParameter(name);
        if (StringUtils.isEmpty((String)value)) {
            value = (String)request.getAttribute(name);
        }
        return value;
    }

    public static String assembleKey(String ... args) {
        StringBuilder sb = new StringBuilder();
        String split = ".";
        for (String str : args) {
            if (sb.length() > 0) {
                sb.append(split);
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static String assembleFragmentKey(String key, String fragmentKey) {
        return key + "$" + fragmentKey;
    }

    public static SelectorItemCollection assembleSelector(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) {
        return UIViewUtil.assembleSelector(SHRContext.getInstance().getContext(), viewInfo);
    }

    public static SelectorItemCollection assembleSelector(Context ctx, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) {
        return UIViewUtil.assembleSelector(ctx, viewInfo, null);
    }

    public static SelectorItemCollection assembleSelector(Context ctx, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo, String shruicode) {
        if (!(viewInfo instanceof com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo)) {
            return null;
        }
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo = viewInfo;
        if (uiViewInfo.getFields() == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        List<FieldInfo> fields = uiViewInfo.getFields();
        String fieldName = null;
        DataType dataType = null;
        HashSet<String> dump = new HashSet<String>();
        for (FieldInfo fieldInfo : fields) {
            if (fieldInfo.getProperty() == null) continue;
            dataType = fieldInfo.getDataType();
            fieldName = fieldInfo.getName();
            if (DataType.OBJECTCOLLECTION.equals((Object)dataType)) continue;
            if (DataType.OBJECTVALUE.equals((Object)dataType)) {
                String displayName = null;
                String fieldEntityName = MetaDataUtil.getEntityNameByPropertyInfo((Context)ctx, (String)viewInfo.getEntityName(), (PropertyInfo)fieldInfo.getProperty());
                if (MetaDataUtil.asSubEntity(fieldEntityName, "com.kingdee.eas.framework.app.TreeBase") && !dump.contains(displayName = fieldName + ".displayName")) {
                    sic.add(new SelectorItemInfo(displayName));
                    dump.add(displayName);
                }
                if (!dump.contains(displayName = null != fieldInfo && null != fieldInfo.getAttributes() && !StringUtils.isEmpty((String)fieldInfo.getAttributes().get("displayFormat")) ? fieldName + "." + fieldInfo.getAttributes().get("displayFormat") : fieldName + ".name")) {
                    sic.add(new SelectorItemInfo(displayName));
                    dump.add(displayName);
                }
                String id = fieldName + ".id";
                String name = fieldName + ".name";
                if (!dump.contains(id)) {
                    sic.add(new SelectorItemInfo(id));
                    dump.add(id);
                }
                if (dump.contains(name)) continue;
                sic.add(new SelectorItemInfo(name));
                dump.add(name);
                continue;
            }
            if (dump.contains(fieldName)) continue;
            sic.add(new SelectorItemInfo(fieldName));
            dump.add(fieldName);
        }
        String key = ShrCheckDataPermissionUtil.getKey(SHRPermissionWebUtils.getRealUipk(viewInfo.getUipk()), shruicode);
        Map<String, PermissionRuleConfigBean> tt = viewInfo.getPermissionRule();
        if (tt == null || !tt.containsKey(key)) {
            return sic;
        }
        PermissionRuleConfigBean prb = tt.get(key);
        Map<String, Object> fieldConfig = prb.getFieldConfig();
        for (Map.Entry<String, Object> entry : fieldConfig.entrySet()) {
            PropertyInfo p;
            if (dump.contains(entry.getValue()) || null == (p = MetaDataUtil.getPropertyInfo((Context)ctx, (String)viewInfo.getEntityName(), (String)((String)entry.getValue())))) continue;
            sic.add(new SelectorItemInfo((String)entry.getValue()));
            dump.add((String)entry.getValue());
        }
        return sic;
    }

    public static SelectorItemCollection assembleListSelector(Context ctx, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) {
        if (!(viewInfo instanceof com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo)) {
            return null;
        }
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo = viewInfo;
        if (uiViewInfo.getFields() == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        List<FieldInfo> fields = uiViewInfo.getFields();
        if (null == fields || fields.isEmpty()) {
            return null;
        }
        String query = viewInfo.getQuery();
        HashSet<String> dump = new HashSet<String>();
        if (StringUtils.isEmpty((String)query)) {
            PropertyInfo p = null;
            String fieldName = null;
            DataType dataType = null;
            for (FieldInfo fieldInfo : fields) {
                p = null;
                fieldName = fieldInfo.getName();
                p = MetaDataUtil.getPropertyInfo((Context)ctx, (String)viewInfo.getEntityName(), (String)fieldName);
                if (null == p || DataType.OBJECTCOLLECTION.equals((Object)(dataType = fieldInfo.getDataType()))) continue;
                if (DataType.OBJECTVALUE.equals((Object)dataType) && p instanceof LinkPropertyInfo) {
                    String id;
                    String displayName = null;
                    displayName = null != fieldInfo && null != fieldInfo.getAttributes() && !StringUtils.isEmpty((String)fieldInfo.getAttributes().get("displayFormat")) ? fieldName + "." + fieldInfo.getAttributes().get("displayFormat") : fieldName + ".name";
                    if (!dump.contains(displayName)) {
                        sic.add(new SelectorItemInfo(displayName));
                        dump.add(displayName);
                    }
                    if (dump.contains(id = fieldName + ".id")) continue;
                    sic.add(new SelectorItemInfo(id));
                    dump.add(id);
                    continue;
                }
                if (dump.contains(fieldName)) continue;
                sic.add(new SelectorItemInfo(fieldName));
                dump.add(fieldName);
            }
            p = null;
            p = MetaDataUtil.getPropertyInfo((Context)ctx, (String)viewInfo.getEntityName(), (String)"id");
            if (null != p && !dump.contains("id")) {
                sic.add(new SelectorItemInfo("id"));
                dump.add("id");
            }
        } else {
            QueryInfo q = QueryUtils.getQueryInfo((Context)ctx, (String)query);
            if (null != q) {
                QueryFieldCollection coll;
                ArrayList queryFieldInfos = q.getSelector().getFields();
                QueryPKInfo qp = q.getQueryPK();
                for (FieldInfo fieldInfo : fields) {
                    boolean isHasField = false;
                    for (QueryFieldInfo queryFieldInfo : queryFieldInfos) {
                        if (!queryFieldInfo.getName().equalsIgnoreCase(fieldInfo.getName())) continue;
                        isHasField = true;
                        break;
                    }
                    if (!isHasField) continue;
                    sic.add(new SelectorItemInfo(fieldInfo.getName()));
                    dump.add(fieldInfo.getName());
                }
                DataObject d = QueryUtils.getRefMetaData((Context)ctx, (QueryInfo)q, (String)"id");
                if (null != d && !dump.contains("id")) {
                    sic.add(new SelectorItemInfo("id"));
                    dump.add("id");
                }
                if (null != qp && null != (coll = qp.getKeyPropertys()) && !coll.isEmpty()) {
                    int total = coll.size();
                    for (int i = 0; i < total; ++i) {
                        QueryFieldInfo qf = coll.get(i);
                        if (dump.contains(qf.getName())) continue;
                        dump.add(qf.getName());
                        sic.add(new SelectorItemInfo(qf.getName()));
                    }
                }
            }
        }
        return sic;
    }

    public static Set<String> getObjectCollectionTypeFileds(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) {
        HashSet<String> set = new HashSet<String>();
        if (!(viewInfo instanceof com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo)) {
            return set;
        }
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo = viewInfo;
        if (uiViewInfo.getFields() == null) {
            return set;
        }
        List<FieldInfo> fields = uiViewInfo.getFields();
        Map<String, PropertyInfo> properties = MetaDataUtil.getProperties(viewInfo.getEntityName());
        String fieldName = null;
        for (FieldInfo fieldInfo : fields) {
            RelationshipType relationshipType;
            PropertyInfo propertyInfo;
            if (fieldInfo.getProperty() == null || fieldInfo.getName() == null || set.contains(fieldName = fieldInfo.getName().split("\\.")[0]) || !((propertyInfo = properties.get(fieldName)) instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relationshipType = ((LinkPropertyInfo)propertyInfo).getRelationship().getType()))) continue;
            set.add(fieldName);
        }
        return set;
    }

    public static Map<String, String> getObjectCollectionFields(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!(viewInfo instanceof com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo)) {
            return map;
        }
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo = viewInfo;
        if (uiViewInfo.getFields() == null) {
            return map;
        }
        List<FieldInfo> fields = uiViewInfo.getFields();
        Map<String, PropertyInfo> properties = MetaDataUtil.getProperties(viewInfo.getEntityName());
        String fieldName = null;
        for (FieldInfo fieldInfo : fields) {
            RelationshipType relationshipType;
            PropertyInfo propertyInfo;
            if (fieldInfo.getProperty() == null || fieldInfo.getName() == null || map.containsKey(fieldName = fieldInfo.getName().split("\\.")[0]) || !((propertyInfo = properties.get(fieldName)) instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relationshipType = ((LinkPropertyInfo)propertyInfo).getRelationship().getType()))) continue;
            map.put(fieldName, ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject().getFullName());
        }
        return map;
    }

    public static String getAdminOrgFieldName(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo) {
        String searchPattern = "//field [@isAdminOrg='true']";
        return UIViewUtil.findFieldName0(uiViewInfo, searchPattern);
    }

    public static String getHROrgFieldName(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo) {
        String searchPattern = "//field [@isHROrg='true']";
        return UIViewUtil.findFieldName0(uiViewInfo, searchPattern);
    }

    public static String getDefaultManageFieldName(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo) {
        String searchPattern = "//field [@isDefaultManage='true']";
        return UIViewUtil.findFieldName0(uiViewInfo, searchPattern);
    }

    public static String getKeyFieldName(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo) {
        String searchPattern = "//field [@key='true']";
        return UIViewUtil.findFieldName0(uiViewInfo, searchPattern);
    }

    public static boolean hasDefaultValueSolution(String content) {
        if (StringUtils.isEmpty((String)content)) {
            return false;
        }
        String searchPattern = "//defaultValueSolution";
        boolean result = UIViewUtil.findElementBySearchPattern(content, searchPattern);
        return result;
    }

    public static boolean findElementBySearchPattern(String content, String searchPattern) {
        boolean result = false;
        try {
            Document doc = XMLUtil.parseXML((String)content);
            result = UIViewUtil.findElement(doc, searchPattern);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String findFieldName0(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo, String searchPattern) {
        return UIViewUtil.findFieldName0(uiViewInfo.getContent(), searchPattern);
    }

    public static String findFieldName0(String content, String searchPattern) {
        String filedName = "";
        try {
            Document doc = XMLUtil.parseXML((String)content);
            Element rootElement = doc.getRootElement();
            XPath xPath = XPath.newInstance((String)searchPattern);
            List fields = xPath.selectNodes((Object)rootElement);
            Iterator iterator = fields.iterator();
            if (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                filedName = element.getAttributeValue("name");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return filedName;
    }

    public static boolean findElement(Document document, String searchPattern) {
        boolean flag = false;
        try {
            XPath xPath = XPath.newInstance((String)searchPattern);
            Element rootElement = document.getRootElement();
            List selecteElements = xPath.selectNodes((Object)rootElement);
            if (null != selecteElements && selecteElements.size() > 0) {
                flag = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return flag;
    }

    public static String getFieldDataType(String uipk, String fieldName) {
        return UIViewUtil.getFieldDataType(SHRContext.getInstance().getContext(), uipk, fieldName);
    }

    public static String getFieldDataType(Context ctx, String uipk, String fieldName) {
        String fieldDataType = "";
        try {
            com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uIViewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
            FieldInfo fieldInfo = uIViewInfo.getField(fieldName);
            if (null == fieldInfo) {
                return fieldDataType;
            }
            DataType dataType = fieldInfo.getDataType();
            if (null != dataType) {
                fieldDataType = dataType.getAlias();
            }
        }
        catch (SHRWebException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return fieldDataType;
    }

    public static String getFieldRuntimeAlias(Context ctx, String uipk, String fieldName) {
        String fieldRuntimeAlias = "";
        try {
            com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uIViewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
            FieldInfo fieldInfo = uIViewInfo.getField(fieldName);
            if (null != fieldInfo) {
                fieldRuntimeAlias = fieldInfo.getAlias();
            }
        }
        catch (SHRWebException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return fieldRuntimeAlias;
    }

    public static String getQuryName(String uipk) {
        return UIViewUtil.getQuryName(SHRContext.getInstance().getContext(), uipk);
    }

    public static String getQuryName(Context ctx, String uipk) {
        String query = "";
        try {
            com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uIViewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
            if (null != uIViewInfo) {
                query = uIViewInfo.getQuery();
            }
        }
        catch (SHRWebException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return query;
    }

    public static boolean isContainHrOrgUnit(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo, String hrOrgUnitFieldName) {
        FieldInfo fieldInfo = uiViewInfo.getField(hrOrgUnitFieldName);
        if (null != fieldInfo) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static List<FieldInfo> getSchemeFields(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo) {
        ArrayList<FieldInfo> schemeFields = new ArrayList<FieldInfo>();
        for (FieldInfo fieldInfo : uiViewInfo.getFields()) {
            if (StringUtils.isEmpty((String)fieldInfo.getSchemeField())) continue;
            schemeFields.add(fieldInfo);
        }
        return schemeFields;
    }

    public static SorterItemCollection assembleEditGridSorterItemCollection(HttpServletRequest request) throws SHRWebException {
        String[] sorter;
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo = UIViewUtil.getCurrentUIViewInfo((ServletRequest)request);
        SorterItemCollection sorterColl = new SorterItemCollection();
        String orderBy = viewInfo.getOrderBy();
        if (StringUtils.isEmpty((String)orderBy)) {
            return sorterColl;
        }
        for (String item : sorter = orderBy.split(",")) {
            SorterItemInfo info = new SorterItemInfo();
            String[] itemArr = item.split(" ");
            String[] targetItem = new String[2];
            for (String item0 : itemArr) {
                if (StringUtils.isEmpty((String)item0)) continue;
                String targetItem0 = targetItem[0];
                if (StringUtils.isEmpty((String)targetItem0)) {
                    targetItem[0] = item0.trim();
                    continue;
                }
                targetItem[1] = item0.trim();
            }
            info.setPropertyName(targetItem[0]);
            if (SortType.ASCEND.toString().equalsIgnoreCase(targetItem[1])) {
                info.setSortType(SortType.ASCEND);
            } else if (SortType.DESCEND.toString().equalsIgnoreCase(targetItem[1])) {
                info.setSortType(SortType.DESCEND);
            }
            sorterColl.add(info);
        }
        return sorterColl;
    }

    public static String getAdvancedSearchFieldsFieldRuntimeAlias(String uipk, String fieldName) {
        return UIViewUtil.getAdvancedSearchFieldsFieldRuntimeAlias(SHRContext.getInstance().getContext(), uipk, fieldName);
    }

    public static String getAdvancedSearchFieldsFieldRuntimeAlias(Context ctx, String uipk, String fieldName) {
        String alias;
        block4: {
            alias = "";
            try {
                List<FieldInfo> quickSearchList;
                com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewinfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
                if (StringUtils.isEmpty((String)viewinfo.getSearchView())) {
                    alias = "";
                    break block4;
                }
                com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo searchView = UIViewUtil.getUIViewInfoByUIPK(ctx, viewinfo.getSearchView());
                if (!(searchView instanceof ISearchUIViewInfo) || (quickSearchList = ((ISearchUIViewInfo)((Object)searchView)).getAdvancedSearchFields()) == null) break block4;
                int size = quickSearchList.size();
                for (int i = 0; i < size; ++i) {
                    String name = quickSearchList.get(i).getName();
                    if (StringUtils.isEmpty((String)name) || !name.equalsIgnoreCase(fieldName)) continue;
                    alias = quickSearchList.get(i).getAlias();
                    break;
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return alias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveExtView(String extendUIViewText, String uipk) throws IOException {
        if (extendUIViewText != null && extendUIViewText.length() > 0) {
            File file;
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
            String date = df.format(new Date());
            String dirPath = System.getProperty("EAS_HOME") + "/server/deploy/eastemplate/extview/" + uipk;
            String path = dirPath + "/" + date + ".xml";
            File dirFile = new File(SHRCheck.checkFilePath((String)dirPath));
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            if (!(file = new File(SHRCheck.checkFilePath((String)path))).exists()) {
                file.createNewFile();
            }
            try (FileOutputStream os = null;){
                os = new FileOutputStream(SHRCheck.checkFilePath((String)path));
                if (os != null) {
                    ((OutputStream)os).write(extendUIViewText.getBytes());
                }
            }
        }
    }

    public static boolean isBaseItemShowSealUpHrOrgUnit(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo uiViewInfo, String searchPattern, String nameAttr) {
        boolean result = false;
        try {
            String content = uiViewInfo.getContent();
            Document doc = XMLUtil.parseXML((String)content);
            Element rootElement = doc.getRootElement();
            XPath xPath = XPath.newInstance((String)searchPattern);
            List fields = xPath.selectNodes((Object)rootElement);
            String _nameAttr = null;
            String _url = null;
            for (Element element : fields) {
                _nameAttr = element.getAttributeValue("name");
                _url = element.getAttributeValue("url");
                if (StringUtils.isEmpty((String)_nameAttr) || !_nameAttr.equals(nameAttr) || StringUtils.isEmpty((String)_url) || _url.indexOf("&amp;isUnSealUp=false") <= -1) continue;
                result = true;
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static void checkHisEntity(CoreBaseInfo model) throws SHRWebException {
        UIViewInfo info = (UIViewInfo)model;
        String entityName = info.getModel();
        Context ctx = SHRContext.getInstance().getContext();
        StringBuffer str = new StringBuffer();
        String content = !StringUtils.isEmpty((String)info.getExtend()) ? info.getExtend() : info.getContent();
        try {
            String ais = ctx.getAIS();
            Document doc = XMLUtil.parseXML((String)content);
            Element rootElement = doc.getRootElement();
            XPath xPathField = XPath.newInstance((String)"//field");
            XPath xPathColumn = XPath.newInstance((String)"//column");
            List fieldList = xPathField.selectNodes((Object)rootElement);
            List cols = xPathColumn.selectNodes((Object)rootElement);
            EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
            EntityObjectInfo hisEntityObjectInfo = EntityCheckHisUtil.getHisEntityObjectInfo((Context)ctx, (EntityObjectInfo)entity);
            if (hisEntityObjectInfo != null) {
                PropertyInfo propertyByName;
                PropertyInfo propertyInfo;
                String name;
                if (fieldList != null && fieldList.size() > 0) {
                    for (Element e : fieldList) {
                        name = e.getAttributeValue("name");
                        propertyInfo = entity.getPropertyByName(name);
                        if (propertyInfo == null || !propertyInfo.isConfigured() || (propertyByName = hisEntityObjectInfo.getPropertyByName(name)) != null) continue;
                        str.append(name).append(", ");
                    }
                }
                if (cols != null && !cols.isEmpty()) {
                    for (Element e : cols) {
                        name = e.getAttributeValue("name");
                        propertyInfo = entity.getPropertyByName(name);
                        if (propertyInfo == null || !propertyInfo.isConfigured() || (propertyByName = hisEntityObjectInfo.getPropertyByName(name)) != null) continue;
                        str.append(name).append(", ");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (!StringUtils.isEmpty((String)str.toString())) {
            String strMsg = MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonplateResourse", (String)"login_and_add_field", (Context)ctx), EntityCheckHisUtil.getHisEntity((Context)ctx, (String)entityName));
            str.append(strMsg);
            String strResult = MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonplateResourse", (String)"model_noconfig_field", (Context)ctx), str.toString());
            throw new ShrWebBizException(strResult);
        }
    }

    public static void doUivewContentXmlOutputter(CoreBaseInfo model, boolean isProductionMode) throws SHRWebException {
        UIViewInfo info = (UIViewInfo)model;
        if (UIViewUtil.isCreateBaseItemViews(info)) {
            return;
        }
        try {
            if (isProductionMode) {
                if (!StringUtils.isEmpty((String)info.getExtend())) {
                    Document doc = XMLUtil.parseXML((String)info.getExtend());
                    info.setExtend(XMLUtil.getXMLOutputter().outputString(doc));
                    if (UIViewUtil.isAdminTreeAndContainLevelConflict(doc)) {
                        throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.CommonplateResourse", "noallow_config"));
                    }
                }
            } else {
                if (StringUtils.isEmpty((String)info.getContent())) {
                    throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.CommonplateResourse", "view_content_noempty"));
                }
                Document doc = XMLUtil.parseXML((String)info.getContent());
                info.setContent(XMLUtil.getXMLOutputter().outputString(doc));
                if (UIViewUtil.isAdminTreeAndContainLevelConflict(doc)) {
                    throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.CommonplateResourse", "noallow_config"));
                }
            }
        }
        catch (BOSException e) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.CommonplateResourse", "view_content_noxml") + e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        catch (SHRWebException e) {
            throw e;
        }
    }

    public static boolean isCreateBaseItemViews(UIViewInfo info) {
        Object __ = info.get(UIViewUtil.getIsCreateBaseItemViewsFieldName());
        if (null != __) {
            return "0".equals(String.valueOf(__)) ? Boolean.FALSE : Boolean.TRUE;
        }
        return false;
    }

    public static String getIsCreateBaseItemViewsFieldName() {
        return "isCreateBaseItemViews";
    }

    public static void doUIViewFetch(String uipk) throws SHRWebException {
        if (BOSConfigUtil.isEnableMultiLan()) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uipks", uipk);
        try {
            MLServiceFactory.getRemoteInstance().fetchData(params, ResourceType.UIView);
        }
        catch (EASBizException e) {
            throw new ShrWebBizException(e);
        }
        catch (BOSException e) {
            throw new SHRWebException(e);
        }
    }

    public static final boolean isAutoTimeZoneTransForTimeOrDatetimeProperty(Element element, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) {
        FieldInfo fieldInfo;
        String pre;
        String isAutoTimeZoneTrans = element.getAttributeValue("isAutoTimeZoneTrans");
        if (!StringUtils.isEmpty((String)isAutoTimeZoneTrans)) {
            return Boolean.parseBoolean(isAutoTimeZoneTrans);
        }
        String field = element.getAttributeValue("name");
        if ("editGrid".equals(element.getParentElement().getName()) && field.indexOf(pre = element.getParentElement().getAttributeValue("name")) == -1) {
            field = MessageFormat.format("{0}.{1}", pre, field);
        }
        return (fieldInfo = viewInfo.getField(field)) == null || null == fieldInfo.getProperty() || !"false".equals(fieldInfo.getProperty().getExtendedProperty("isAutoTimeZoneTrans"));
    }

    public static final boolean isAutoTimeZoneTransForTimeOrDatetimeProperty(FieldInfo fieldInfo, Map<String, String> attributes) {
        if (null != attributes && !StringUtils.isEmpty((String)attributes.get("isAutoTimeZoneTrans"))) {
            return Boolean.parseBoolean(attributes.get("isAutoTimeZoneTrans"));
        }
        return fieldInfo == null || null == fieldInfo.getProperty() || !"false".equals(fieldInfo.getProperty().getExtendedProperty("isAutoTimeZoneTrans"));
    }

    public static final void setDateTimeOrTimeOptions(Context ctx, Element element, Map<String, Object> options, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo, DataType dataType) throws EASBizException, BOSException {
        options.put("ctrlType", dataType.getName());
        options.put("showTimeZoneForCtrl", UserNantionalUtil.isShowTimeZoneForCtrl((Context)ctx));
        String isShowUTC = element.getAttributeValue("isShowUTC");
        String isReadonlyUTC = element.getAttributeValue("isReadonlyUTC");
        if (!StringUtils.isEmpty((String)isShowUTC)) {
            options.put("isShowUTC", Boolean.parseBoolean(isShowUTC));
        } else {
            options.put("isShowUTC", true);
        }
        if (!StringUtils.isEmpty((String)isReadonlyUTC)) {
            options.put("isReadonlyUTC", Boolean.parseBoolean(isReadonlyUTC));
        } else {
            options.put("isReadonlyUTC", true);
        }
        options.put("isAutoTimeZoneTrans", UIViewUtil.isAutoTimeZoneTransForTimeOrDatetimeProperty(element, viewInfo));
        if (DataType.DATE.equals((Object)dataType)) {
            options.put("isAutoTimeZoneTrans", false);
            options.put("isShowUTC", false);
            options.put("isReadonlyUTC", false);
            options.put("showTimeZoneForCtrl", false);
        }
        options.put("isRemoveSeconds", UIViewUtil.isRemoveSecondsForDateTime(element));
        options.put("isRemoveDay", UIViewUtil.isRemoveDayForDateTime(element));
    }

    public static final boolean isRemoveSecondsForDateTime(Element element) {
        String isRemoveSeconds = element.getAttributeValue("isRemoveSeconds");
        if ("true".equals(isRemoveSeconds)) {
            return true;
        }
        return !"false".equals(isRemoveSeconds);
    }

    public static final boolean isRemoveDayForDateTime(Element element) {
        String isRemoveDay = element.getAttributeValue("isRemoveDay");
        if ("true".equals(isRemoveDay)) {
            return true;
        }
        if ("false".equals(isRemoveDay)) {
            return false;
        }
        return false;
    }

    public static final void setNumberFieldOptions(Context ctx, Element element, Map<String, Object> options, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) {
        Integer decimalPrecision = Integer.parseInt(UIViewUtil.getDecimalPrecisionAttrValue(ctx, element, viewInfo));
        String formatType = element.getAttributeValue("formatType");
        String ignoreDecimalFormatter = element.getAttributeValue("ignoreDecimalFormatter");
        String roundType = element.getAttributeValue("roundType");
        options.put("decimalPrecision", decimalPrecision);
        if (StringUtils.isEmpty((String)formatType)) {
            options.put("formatType", "number");
        } else {
            options.put("formatType", formatType);
        }
        if (StringUtils.isEmpty((String)ignoreDecimalFormatter)) {
            options.put("ignoreDecimalFormatter", false);
        } else {
            options.put("ignoreDecimalFormatter", Boolean.parseBoolean(ignoreDecimalFormatter));
        }
        if (StringUtils.isEmpty((String)roundType)) {
            options.put("roundType", "round");
        } else {
            options.put("roundType", roundType);
        }
    }

    public static void checkBeforeSaveExt(Context ctx, UIViewInfo uiViewInfo, Boolean isProductionMode, Map<String, Object> param) throws IOException, SHRWebException {
        ArrayList<String> ignoreUipk = new ArrayList<String>();
        ignoreUipk.add("com.kingdee.shr.base.syssetting.app.UIView.list");
        ignoreUipk.add("com.kingdee.shr.base.syssetting.app.UIView.form");
        ignoreUipk.add("com.kingdee.shr.baseconfig.app.ImportDataBackUp.list");
        ignoreUipk.add("com.kingdee.shr.base.syssetting.app.MSFConfig.form");
        if (isProductionMode.booleanValue() && ignoreUipk.contains(uiViewInfo.getUipk())) {
            throw new ShrWebBizException(MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonplateResourse", (String)"view_notallow_edit", (Context)ctx), uiViewInfo.getName()));
        }
        UIViewUtil.quotesToEscape(uiViewInfo);
        UIViewUtil.checkHisEntity((CoreBaseInfo)uiViewInfo);
        UIViewUtil.checkGuide(uiViewInfo, param);
        UIViewUtil.doUivewContentXmlOutputter((CoreBaseInfo)uiViewInfo, isProductionMode);
        UIViewUtil.saveExtView(uiViewInfo.getExtend(), uiViewInfo.getUipk());
        UIViewUtil.checkFormEntry(uiViewInfo);
        UIViewUtil.checkEncryptField(ctx, uiViewInfo);
        UIViewUtil.doUiviewContentAttachment(ctx, uiViewInfo, isProductionMode);
    }

    public static void checkBeforeSave(Context ctx, UIViewInfo uiViewInfo, Boolean isProductionMode) throws IOException, SHRWebException {
        UIViewUtil.checkBeforeSaveExt(ctx, uiViewInfo, isProductionMode, null);
    }

    private static void checkGuide(UIViewInfo uiViewInfo, Map<String, Object> param) throws SHRWebException {
        List fields = null;
        String content = "";
        String operate = (String)param.get("operateStatus");
        content = !StringUtils.isEmpty((String)uiViewInfo.getExtend()) ? uiViewInfo.getExtend() : uiViewInfo.getContent();
        if (StringUtils.isEmpty((String)content)) {
            return;
        }
        try {
            Document doc = XMLUtil.parseXML((String)content);
            fields = XMLUtil.getElements((Document)doc, (String)"//step");
            if (fields.size() > 0) {
                if ("ADDNEW".equalsIgnoreCase(operate)) {
                    int index = 0;
                    for (Element element : fields) {
                        if (StringUtils.isEmpty((String)element.getAttributeValue("nodeId"))) {
                            element.setAttribute("nodeId", "node" + index);
                        }
                        ++index;
                    }
                    String docStr = XMLUtil.xmlToString((Document)doc);
                    if (!StringUtils.isEmpty((String)uiViewInfo.getExtend())) {
                        uiViewInfo.setExtend(docStr);
                    } else {
                        uiViewInfo.setContent(docStr);
                    }
                } else if ("EDIT".equalsIgnoreCase(operate)) {
                    for (Element element : fields) {
                        if (!StringUtils.isEmpty((String)element.getAttributeValue("nodeId"))) continue;
                        throw new ShrWebBizException("step\u6807\u7b7e\u5fc5\u987b\u914d\u7f6enodeId\u5c5e\u6027,\u4e14\u5c5e\u6027\u503c\u4e0d\u80fd\u91cd\u590d\uff01");
                    }
                }
            }
        }
        catch (BOSException | IOException | JDOMException e) {
            throw new SHRWebException(e);
        }
    }

    public static void doUiviewContentAttachment(Context ctx, UIViewInfo uiViewInfo, Boolean isProductionMode) throws SHRWebException {
        if (null == uiViewInfo) {
            return;
        }
        try {
            Document doc;
            if (!StringUtils.isEmpty((String)uiViewInfo.getContent())) {
                doc = XMLUtil.parseXML((String)uiViewInfo.getContent());
                UIViewUtil.attachmentCheckAndInit(ctx, doc.getRootElement());
                uiViewInfo.setContent(XMLUtil.getXMLOutputter().outputString(doc));
            }
            if (!StringUtils.isEmpty((String)uiViewInfo.getExtend())) {
                doc = XMLUtil.parseXML((String)uiViewInfo.getExtend());
                UIViewUtil.attachmentCheckAndInit(ctx, doc.getRootElement());
                uiViewInfo.setExtend(XMLUtil.getXMLOutputter().outputString(doc));
            }
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
    }

    private static void attachmentCheckAndInit(Context ctx, Element rootElement) throws SHRWebException {
        if (null == rootElement) {
            return;
        }
        ArrayList<Element> list = new ArrayList<Element>();
        XMLUtil.getElements((Element)rootElement, (String)"attachment", list);
        if (list.isEmpty()) {
            return;
        }
        HashMap<String, Integer> attachmentMap = new HashMap<String, Integer>();
        HashMap<String, Integer> itemMap = new HashMap<String, Integer>();
        UIViewUtil.checkAttachmentDump(list, attachmentMap, itemMap);
        StringBuilder error = new StringBuilder();
        for (Map.Entry entry : attachmentMap.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            error.append("\u6307\u4ee4attachment\u4e2dfield\u5c5e\u6027\u503c[").append((String)entry.getKey()).append("]\u5b58\u5728 ").append((Integer)entry.getValue() - 1).append(" \u6b21\u91cd\u590d;\n");
        }
        for (Map.Entry entry : itemMap.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            error.append("\u6307\u4ee4item\u4e2dfield\u5c5e\u6027\u503c[").append((String)entry.getKey()).append("]\u5b58\u5728 ").append((Integer)entry.getValue() - 1).append(" \u6b21\u91cd\u590d;\n");
        }
        if (!StringUtils.isEmpty((String)error.toString())) {
            error.append("\u8bf7\u624b\u5de5\u8c03\u6574\u552f\u4e00\u540e\u518d\u4fdd\u5b58\u3002");
            throw new ShrWebBizException(error.toString());
        }
        UIViewUtil.initAttachmentForUnFill(list, attachmentMap, itemMap);
    }

    public static void initAttachmentForUnFill(List<Element> list, Map<String, Integer> attachmentMap, Map<String, Integer> itemMap) {
        if (null == list || null == attachmentMap || null == itemMap) {
            return;
        }
        int maxItemNullIndex = -1;
        for (Map.Entry<String, Integer> entry : itemMap.entrySet()) {
            if (!entry.getKey().startsWith("null")) continue;
            try {
                int temp = Integer.parseInt(entry.getKey().replace("null", ""));
                if (temp <= maxItemNullIndex) continue;
                maxItemNullIndex = temp;
            }
            catch (Exception temp) {}
        }
        maxItemNullIndex = maxItemNullIndex == -1 ? 0 : ++maxItemNullIndex;
        for (Element e : list) {
            String itemField;
            String attachmentField = e.getAttributeValue("field");
            List listItems = e.getChildren("item");
            if (!StringUtils.isEmpty((String)attachmentField)) {
                if (null == listItems || listItems.isEmpty()) continue;
                for (Element ee : listItems) {
                    itemField = ee.getAttributeValue("field");
                    if (!StringUtils.isEmpty((String)itemField)) continue;
                    itemField = MessageFormat.format("null{0}", Integer.toString(maxItemNullIndex++));
                    itemMap.put(itemField, 1);
                    ee.setAttribute("field", itemField);
                }
                continue;
            }
            if (null != listItems && !listItems.isEmpty()) {
                for (Element ee : listItems) {
                    itemField = ee.getAttributeValue("field");
                    if (StringUtils.isEmpty((String)itemField)) {
                        itemField = MessageFormat.format("null{0}", Integer.toString(maxItemNullIndex++));
                        itemMap.put(itemField, 1);
                        ee.setAttribute("field", itemField);
                    }
                    if (!StringUtils.isEmpty((String)attachmentField) || attachmentMap.containsKey(itemField)) continue;
                    attachmentField = itemField;
                }
                e.setAttribute("field", attachmentField);
                continue;
            }
            String itemField2 = MessageFormat.format("null{0}", Integer.toString(maxItemNullIndex++));
            itemMap.put(itemField2, 1);
            e.setAttribute("field", itemField2);
        }
    }

    public static void checkAttachmentDump(List<Element> list, Map<String, Integer> attachmentMap, Map<String, Integer> itemMap) {
        if (null == list || null == attachmentMap || null == itemMap) {
            return;
        }
        for (Element e : list) {
            String itemField;
            String attachmentField = e.getAttributeValue("field");
            List listItems = e.getChildren("item");
            if (!StringUtils.isEmpty((String)attachmentField)) {
                UIViewUtil.setMapIndex(attachmentMap, attachmentField);
                if (null == listItems || listItems.isEmpty()) {
                    UIViewUtil.setMapIndex(itemMap, attachmentField);
                    continue;
                }
                for (Element ee : listItems) {
                    itemField = ee.getAttributeValue("field");
                    if (StringUtils.isEmpty((String)itemField)) continue;
                    UIViewUtil.setMapIndex(itemMap, itemField);
                }
                continue;
            }
            if (null == listItems || listItems.isEmpty()) continue;
            for (Element ee : listItems) {
                itemField = ee.getAttributeValue("field");
                if (StringUtils.isEmpty((String)itemField)) continue;
                UIViewUtil.setMapIndex(itemMap, itemField);
            }
        }
    }

    private static void setMapIndex(Map<String, Integer> map, String key) {
        if (map.containsKey(key)) {
            map.put(key, map.get(key) + 1);
        } else {
            map.put(key, 1);
        }
    }

    private static void quotesToEscape(UIViewInfo uiViewInfo) {
        String content = "";
        if (!StringUtils.isEmpty((String)uiViewInfo.getExtend()) && (content = uiViewInfo.getExtend()).contains("&quot;")) {
            uiViewInfo.setExtend(content.replace("&quot;", "'"));
        }
    }

    private static void checkEncryptField(UIViewInfo uiViewInfo) throws SHRWebException {
        UIViewUtil.checkEncryptField(SHRContext.getInstance().getContext(), uiViewInfo);
    }

    private static void checkEncryptField(Context ctx, UIViewInfo uiViewInfo) throws SHRWebException {
        Element element;
        String orderBy;
        List<Element> uiViewElement;
        boolean isEncrypt = ParamUtil.IsEnableEncrypt((Context)ctx);
        if (isEncrypt && (uiViewElement = UIViewUtil.getUIViewElement(uiViewInfo, "//grid")) != null && uiViewElement.size() > 0 && null != (orderBy = (element = uiViewElement.get(0)).getAttributeValue("sorterItems")) && !StringUtils.isEmpty((String)orderBy)) {
            String[] orderBySplit = orderBy.split(",");
            for (int i = 0; i < orderBySplit.length; ++i) {
                if (null == orderBySplit[i]) continue;
                if (orderBySplit[i].substring(orderBySplit[i].lastIndexOf(".") + 1).equalsIgnoreCase("asc") || orderBySplit[i].substring(orderBySplit[i].lastIndexOf(".") + 1).equalsIgnoreCase("desc")) {
                    String[] segSortRule = orderBySplit[i].split(" ");
                    orderBySplit[i] = segSortRule[0];
                }
                if (null == uiViewInfo.getId() || null == uiViewInfo.getUipk() || !UIViewUtil.isEncryptField(ctx, uiViewInfo.getUipk(), orderBySplit[i])) continue;
                throw new ShrWebBizException(MessageFormat.format(SHRSysSettingResourceUtil.getResource((String)"cannotBeSorted", (Context)ctx), orderBySplit[i]));
            }
        }
    }

    private static void checkFormEntry(UIViewInfo uiViewInfo) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String uipk = uiViewInfo.getUipk();
        if (uiViewInfo.getType().equals((Object)UIType.form)) {
            try {
                List<Element> uiViewElement = UIViewUtil.getUIViewElement(uiViewInfo, "//editGrid");
                if (uiViewElement != null && uiViewElement.size() > 0) {
                    Element element = uiViewElement.get(0);
                    String remoteDataSource = element.getAttributeValue("remoteDataSource");
                    String showImport = element.getAttributeValue("showImport");
                    String showSearch = element.getAttributeValue("showSearch");
                    if (StringUtils.isEmpty((String)remoteDataSource)) {
                        remoteDataSource = "false";
                    }
                    if (StringUtils.isEmpty((String)showImport)) {
                        showImport = "false";
                    }
                    if (StringUtils.isEmpty((String)showSearch)) {
                        showSearch = "false";
                    }
                    if (remoteDataSource.equals("true")) {
                        String attributeValue = element.getAttributeValue("hasPager");
                        if (!attributeValue.equals("true")) {
                            throw new ShrWebBizException(SHRSysSettingResourceUtil.getResource((String)"hasPager_isFalse", (Context)ctx));
                        }
                        String handler = "";
                        List<Element> handlers = UIViewUtil.getUIViewElement(uiViewInfo, "//handler");
                        if (handlers != null && handlers.size() > 0) {
                            Element elementHandler = handlers.get(0);
                            handler = elementHandler.getAttributeValue("class");
                        }
                        if (StringUtils.isEmpty((String)handler)) {
                            throw new ShrWebBizException(SHRSysSettingResourceUtil.getResource((String)"noHandler", (Context)ctx));
                        }
                        Class clazz = MsfClassLoaderFactory.forName((String)handler);
                        Object newInstance = clazz.newInstance();
                        if (!(newInstance instanceof HRBillEntryEditHandler)) {
                            throw new ShrWebBizException(SHRSysSettingResourceUtil.getResource((String)"notExtendHRBillEntryEditHandler", (Context)ctx));
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new SHRWebException(e);
            }
        }
    }

    public static List<Element> getUIViewElement(UIViewInfo uiViewInfo, String searchPattern) throws SHRWebException {
        String content = "";
        content = !StringUtils.isEmpty((String)uiViewInfo.getExtend()) ? uiViewInfo.getExtend() : uiViewInfo.getContent();
        if (content == null) {
            return null;
        }
        try {
            Document doc = XMLUtil.parseXML((String)content);
            Element rootElement = doc.getRootElement();
            XPath xPath = XPath.newInstance((String)searchPattern);
            List fields = xPath.selectNodes((Object)rootElement);
            return fields;
        }
        catch (BOSException | JDOMException e) {
            throw new SHRWebException(e);
        }
    }

    public static List<Element> getElement(Element rootElement, String searchPattern) throws SHRWebException {
        try {
            XPath xPath = XPath.newInstance((String)searchPattern);
            List fields = xPath.selectNodes((Object)rootElement);
            return fields;
        }
        catch (JDOMException e) {
            throw new SHRWebException(e);
        }
    }

    public static String getDecimalPrecisionAttrValue(Context ctx, Element element, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo) {
        String defineVal;
        String DEFAULT_DECIMAL_PRECISION = "2";
        String attrValue = null;
        if (element != null) {
            attrValue = element.getAttributeValue("decimalPrecision");
        }
        if (!StringUtils.isEmpty(attrValue)) {
            return attrValue;
        }
        Map<String, String> varDefine = viewInfo.getVarDefine(ctx);
        if (null != varDefine && varDefine.containsKey("decimalPrecision") && !StringUtils.isEmpty((String)(defineVal = varDefine.get("decimalPrecision")))) {
            return defineVal;
        }
        return "2";
    }

    public static boolean isEncryptField(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo, String columnName) throws SHRWebException {
        return UIViewUtil.isEncryptField(SHRContext.getInstance().getContext(), viewInfo, columnName);
    }

    public static boolean isEncryptField(Context ctx, com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo, String columnName) throws SHRWebException {
        boolean isEncryptField = false;
        boolean isEnableEncrypt = ParamUtil.IsEnableEncrypt((Context)ctx);
        if (isEnableEncrypt) {
            if (viewInfo.getType().equals(UIType.dynamicList.getName())) {
                try {
                    StructureConfigInfo structureConfigByKey = StructureConfigConvertHelper.getStructureConfigByKey((Context)ctx, (String)columnName, (String)viewInfo.getModel());
                    if (structureConfigByKey == null) {
                        return false;
                    }
                    String entityName = structureConfigByKey.getEntityName();
                    String[] keys = columnName.split("\\.");
                    String number = keys[1];
                    isEncryptField = UIViewUtil.isEncrypt(ctx, entityName, number);
                }
                catch (BOSException e) {
                    throw new SHRWebException(e);
                }
            } else if (viewInfo.getType().equals(UIType.list.getName()) || viewInfo.getType().equals(UIType.F7.getName())) {
                String queryPk = viewInfo.getQuery();
                if (!StringUtils.isEmpty((String)queryPk)) {
                    String entityFullName = MetaDataUtil.getQueryEntityFullName(queryPk, columnName);
                    isEncryptField = UIViewUtil.isEncrypt(ctx, entityFullName, columnName);
                } else {
                    String model = viewInfo.getModel();
                    if (columnName.contains(".")) {
                        Object entityName;
                        FieldInfo field = viewInfo.getField(columnName);
                        int index = columnName.lastIndexOf(".");
                        if (field == null || field.getProperty() == null) {
                            String columnNameNew = columnName.substring(0, index);
                            field = viewInfo.getField(columnNameNew);
                        }
                        if (field != null && field.getProperty() != null && (entityName = field.getProperty().get("entityName")) != null) {
                            model = (String)entityName;
                        }
                        columnName = columnName.substring(index + 1);
                    }
                    isEncryptField = UIViewUtil.isEncrypt(ctx, model, columnName);
                }
            } else if (viewInfo.getType().equals(UIType.form.getName())) {
                isEncryptField = UIViewUtil.isEncrypt(ctx, viewInfo.getModel(), columnName);
            }
        }
        return isEncryptField;
    }

    public static boolean isEncrypt(Context ctx, String entityName, String fieldName) {
        boolean isEncryptField = false;
        if (StringUtils.isEmpty((String)entityName)) {
            return isEncryptField;
        }
        try {
            EntityObjectInfo entityObject = MetaDataUtil.getEntityObjectByEntityName((Context)ctx, (String)entityName);
            String tabelName = entityObject.getTable().getName();
            if (fieldName.contains(".")) {
                String[] fieldArr = fieldName.split("\\.");
                fieldName = fieldArr[1];
            }
            PropertyInfo propertyInfo = MetaDataUtil.getPropertyInfo((Context)ctx, (String)entityName, (String)fieldName);
            fieldName = propertyInfo.getMappingField().getName();
            boolean multilingual = false;
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProp = (OwnPropertyInfo)propertyInfo;
                multilingual = ownProp.isMultilingual();
            }
            if (multilingual) {
                fieldName = fieldName + "_" + ctx.getLocale().getLanguage().toString();
            }
            isEncryptField = PrivacyPropertyManager.isPrivacyField((Context)ctx, (String)tabelName, (String)fieldName);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)e);
            }
            isEncryptField = false;
        }
        return isEncryptField;
    }

    public static boolean isEncryptField(String uipk, String columnName) throws SHRWebException {
        return UIViewUtil.isEncryptField(SHRContext.getInstance().getContext(), uipk, columnName);
    }

    public static boolean isEncryptField(Context ctx, String uipk, String columnName) throws SHRWebException {
        if (StringUtils.isEmpty((String)uipk) || StringUtils.isEmpty((String)columnName)) {
            return false;
        }
        com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo = UIViewUtil.getUIViewInfoByUIPK(ctx, uipk);
        if (null == viewInfo) {
            return false;
        }
        return UIViewUtil.isEncryptField(ctx, viewInfo, columnName);
    }

    public static String getOperateStatus(ServletRequest servletRequest, ModelMap modelMap) {
        String operateStatus = "";
        if (modelMap != null) {
            operateStatus = (String)modelMap.get((Object)"operateState");
        }
        if (StringUtils.isEmpty((String)operateStatus)) {
            operateStatus = (String)servletRequest.getAttribute("operateState");
        }
        if (StringUtils.isEmpty((String)operateStatus)) {
            operateStatus = servletRequest.getParameter("operateState");
        }
        return operateStatus;
    }

    public static boolean isButtonInView(com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo viewInfo, String buttonName) {
        if (null != viewInfo) {
            Map<String, ButtonInfo> btns = viewInfo.getButtons();
            if (null == btns || btns.isEmpty()) {
                return false;
            }
            ButtonInfo btn = btns.get(buttonName);
            if (null != btn && btn.isVisible()) {
                return true;
            }
        }
        return false;
    }
}

