/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.dynamic.util;

import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.util.StringUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XMLUtil {
    public static XMLOutputter getXMLOutputter() {
        XMLOutputter outter = new XMLOutputter();
        Format prettyFormat = Format.getCompactFormat();
        prettyFormat.setLineSeparator("\n");
        prettyFormat.setIndent("    ");
        prettyFormat.setEncoding("UTF-8");
        outter.setFormat(prettyFormat);
        return outter;
    }

    public static String attributesToString(Element element) {
        return XMLUtil.attributesToString(element, null);
    }

    public static String attributesToString(Element element, Collection<String> excludeAttribute) {
        if (element == null) {
            return "";
        }
        List attributes = element.getAttributes();
        Attribute attribute = null;
        StringBuilder sb = new StringBuilder();
        int size = attributes.size();
        for (int i = 0; i < size; ++i) {
            attribute = (Attribute)attributes.get(i);
            if (excludeAttribute != null && excludeAttribute.contains(attribute.getName())) continue;
            sb.append(XMLUtil.attributeToString(attribute));
        }
        return sb.toString();
    }

    public static String attributeToString(Attribute attribute) {
        StringBuilder sb = new StringBuilder();
        String value = attribute.getValue();
        if (!StringUtils.isEmpty((String)value)) {
            sb.append(" ");
            sb.append(attribute.getName());
            sb.append("=");
            sb.append("\"");
            sb.append(value);
            sb.append("\"");
        }
        return sb.toString();
    }

    public static Document parseXML(String xml) throws SHRWebException {
        SAXBuilder builder = new SAXBuilder();
        com.kingdee.shr.base.syssetting.app.util.XMLUtil.setReaderFeature((SAXBuilder)builder);
        Document doc = null;
        try {
            doc = builder.build((Reader)new StringReader(xml));
        }
        catch (JDOMException e) {
            throw new SHRWebException(e);
        }
        catch (IOException e) {
            throw new SHRWebException(e);
        }
        return doc;
    }

    public static List<Element> getAllElements(String elementName, UIViewInfo uiviewInfo) throws SHRWebException {
        if (null == uiviewInfo || StringUtils.isEmpty((String)uiviewInfo.getContent()) || StringUtils.isEmpty((String)elementName)) {
            return null;
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        Document doc = XMLUtil.parseXML(uiviewInfo.getContent());
        Element root = doc.getRootElement();
        XMLUtil.getAllElements(root, elementName, elements);
        return elements;
    }

    private static void getAllElements(Element root, String elementName, List<Element> elements) {
        if (null == root) {
            return;
        }
        if (root.getName().equals(elementName)) {
            elements.add(root);
        }
        Element element = null;
        List children = root.getChildren();
        if (null == children || children.isEmpty()) {
            return;
        }
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            element = (Element)children.get(i);
            XMLUtil.getAllElements(element, elementName, elements);
        }
    }

    public static Element getElement(Element root, String elementName) {
        if (root.getName().equalsIgnoreCase(elementName)) {
            return root;
        }
        Element element = null;
        Element result = null;
        if (root.getChildren() != null) {
            List children = root.getChildren();
            int size = children.size();
            for (int i = 0; i < size && (result = XMLUtil.getElement(element = (Element)children.get(i), elementName)) == null; ++i) {
            }
        }
        return result;
    }

    public static List<Element> getElements(Element root, String elementName, List<Element> elements) {
        if (root.getName().equalsIgnoreCase(elementName)) {
            elements.add(root);
        }
        Element element = null;
        Object result = null;
        if (root.getChildren() != null) {
            List children = root.getChildren();
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                element = (Element)children.get(i);
                XMLUtil.getElements(element, elementName, elements);
            }
        }
        return elements;
    }

    public static Element mergeElement(Element base, Element newElement) {
        if (!base.getName().equalsIgnoreCase(newElement.getName())) {
            return base;
        }
        XMLUtil.overwriteAttribute(base, newElement);
        List children = base.getChildren();
        Element subElement = null;
        Element newSubElement = null;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            subElement = (Element)children.get(i);
            newSubElement = XMLUtil.getElement(newElement, subElement.getName());
            if (newSubElement == null) continue;
            XMLUtil.mergeElement(subElement, newSubElement);
            newSubElement.detach();
        }
        children = newElement.getChildren();
        while (children.size() > 0) {
            subElement = (Element)children.get(0);
            subElement.detach();
            base.addContent((Content)subElement);
        }
        return base;
    }

    public static void overwriteAttribute(Element base, Element newElement) {
        List attributes = newElement.getAttributes();
        Attribute attribute = null;
        int size = attributes.size();
        for (int i = 0; i < size; ++i) {
            attribute = (Attribute)attributes.get(i);
            base.setAttribute(attribute.getName(), attribute.getValue());
        }
    }

    public static void removeExcludeAttribute(Element element, Collection<String> excludeAttribute) {
        for (String item : excludeAttribute) {
            element.removeAttribute(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveXML(Document doc, String filePath) {
        OutputStreamWriter writer = null;
        try {
            XMLOutputter xmlopt = new XMLOutputter();
            writer = new FileWriter(filePath);
            xmlopt.output(doc, (Writer)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

