/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.exception;

import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.util.StringUtils;
import freemarker.core.Environment;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SHRTemplateExceptionHandler
implements TemplateExceptionHandler {
    private static Logger logger = Logger.getLogger(SHRTemplateExceptionHandler.class);

    public void handleTemplateException(TemplateException te, Environment env, Writer out) throws TemplateException {
        if (te.getMessage().contains("evaluated to null string")) {
            logger.error((Object)te.getMessage(), (Throwable)te);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)SHRContext.getInstance().getRequest();
        String contextPath = request.getContextPath();
        PrintWriter pw = out instanceof PrintWriter ? (PrintWriter)out : new PrintWriter(out);
        String messageWithoutStackTop = te.getMessageWithoutStackTop();
        String causeMessage = "";
        if (null != te.getCause() && !StringUtils.isEmpty((String)te.getCause().getMessage())) {
            causeMessage = te.getCause().getMessage();
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder reason = new StringBuilder();
        sb.append("</title></xmp></script></noscript></style></object>");
        sb.append("</head></pre></table>");
        sb.append("</form></table></table></table></a></u></i></b>");
        sb.append("\t<script language=\"javascript\" src=\"" + contextPath + "/scripts/framework/exception.js\"></script>");
        sb.append(" <h3>").append(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "translate_fail")).append("</h3>");
        sb.append(" <pre><xmp>");
        if (!StringUtils.isEmpty((String)causeMessage)) {
            String showMessage = "";
            try {
                showMessage = causeMessage.substring(causeMessage.indexOf("(") + 1, causeMessage.lastIndexOf(")"));
            }
            catch (Exception e) {
                showMessage = causeMessage;
            }
            reason.append(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "file_not_found"), showMessage));
            reason.append("\n");
            reason.append(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "reason_maybe"));
        } else {
            String tag = "";
            String attr = "";
            try {
                tag = messageWithoutStackTop.substring(messageWithoutStackTop.indexOf("Macro") + "Macro".length(), messageWithoutStackTop.indexOf("has"));
                attr = messageWithoutStackTop.substring(messageWithoutStackTop.lastIndexOf(" "), messageWithoutStackTop.length() - 1);
                reason.append(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "config_error"), tag, attr));
            }
            catch (Exception e) {
                reason.append(messageWithoutStackTop);
            }
        }
        sb.append(MessageFormat.format(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "reason_is"), reason));
        pw.println(sb.toString());
        pw.println("</xmp></pre>");
        pw.println("</html>");
        pw.flush();
        throw te;
    }
}

