/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.web.controller.DataGridController;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.handler.EditHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;

public class HRBillEntryEditHandler
extends EditHandler {
    private static Logger logger = Logger.getLogger(HRBillEntryEditHandler.class);

    public String getListDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        DataGridController dataGrid = new DataGridController();
        String billRelateField = request.getParameter("componentID");
        UIViewInfo currentUIViewInfo = UIViewUtil.getCurrentUIViewInfo((ServletRequest)request);
        String fullName = MetaDataUtil.getEntryEntityName(currentUIViewInfo.getModel(), billRelateField);
        request.setAttribute("view_model", (Object)fullName);
        this.prepareFilterInfo(request, response, modelMap, fullName, billRelateField);
        GridDataEntity gridDataEntity = dataGrid.getEntityGridEntryData(request, modelMap);
        this.afterGetListData(request, response, gridDataEntity);
        JSONUtils.writeJson(response, gridDataEntity);
        return null;
    }

    private void afterGetListData(HttpServletRequest request, HttpServletResponse response, GridDataEntity gridDataEntity) {
    }

    @Override
    protected void runDelete(HttpServletRequest request, String id) throws BOSException, EASBizException, SHRWebException {
        ObjectUuidPK pk;
        EntityObjectInfo entityObject = MetaDataUtil.getEntityObject(id);
        String entryEntityName = entityObject.getFullName();
        ICoreBase iCoreBase = MetaDataUtil.getBizInterface((Context)SHRContext.getInstance().getContext(), (String)entryEntityName);
        if (!iCoreBase.exists((IObjectPK)(pk = new ObjectUuidPK(id)))) {
            throw new ShrWebBizException(SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "unable_delete"));
        }
        iCoreBase.delete((IObjectPK)pk);
    }

    private void prepareFilterInfo(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, String fullName, String billRelateField) throws SHRWebException {
        FilterInfo filterInfo;
        String billID = request.getParameter("billId");
        EntityViewInfo defaultViewInfo = new EntityViewInfo();
        UIViewInfo currentUIViewInfo = UIViewUtil.getCurrentUIViewInfo((ServletRequest)request);
        try {
            String billFieldName = MetaDataUtil.getEntryBillField(currentUIViewInfo.getModel(), fullName);
            filterInfo = new FilterInfo(billFieldName + "='" + billID + "'");
        }
        catch (ParserException e1) {
            throw new SHRWebException(e1);
        }
        FilterInfo customFilter = this.getCustomFilter(request, response);
        try {
            filterInfo.mergeFilter(customFilter, "AND");
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        defaultViewInfo.setFilter(filterInfo);
        this.getEntrySelector(billRelateField, defaultViewInfo, currentUIViewInfo);
        modelMap.put((Object)"DataGridEntityView", (Object)defaultViewInfo);
    }

    protected void getEntrySelector(String billRelateField, EntityViewInfo defaultViewInfo, UIViewInfo currentUIViewInfo) {
        SelectorItemCollection sic = defaultViewInfo.getSelector();
        if (null == sic || sic.isEmpty()) {
            sic = new SelectorItemCollection();
            defaultViewInfo.setSelector(sic);
            List<FieldInfo> fields = currentUIViewInfo.getFields();
            for (FieldInfo fieldInfo : fields) {
                String fieldName = fieldInfo.getName();
                PropertyInfo property = fieldInfo.getProperty();
                if (!fieldName.startsWith(billRelateField + ".")) continue;
                fieldName = fieldName.replace(billRelateField + ".", "");
                if (property instanceof LinkPropertyInfo) {
                    Map<String, String> attributes = fieldInfo.getAttributes();
                    String displayFormat = attributes.get("displayFormat");
                    if (!StringUtils.isEmpty((String)displayFormat)) {
                        sic.add(new SelectorItemInfo(fieldName + "." + displayFormat));
                    } else {
                        sic.add(new SelectorItemInfo(fieldName + ".name"));
                    }
                    sic.add(new SelectorItemInfo(fieldName));
                    continue;
                }
                sic.add(new SelectorItemInfo(fieldName));
            }
        }
    }

    protected FilterInfo getCustomFilter(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        return null;
    }
}

