/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.EntityF7ConfigHelper;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.model.FieldInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.DynamicUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.UIViewUtil;
import com.kingdee.shr.base.syssetting.web.dynamic.util.XMLUtil;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.templatetranslator.AbstractElementTranslator;
import com.kingdee.shr.base.syssetting.web.templatetranslator.IElementTranslatorStore;
import com.kingdee.shr.base.syssetting.web.templatetranslator.TemplateTranslateException;
import com.kingdee.shr.base.syssetting.web.templatetranslator.freemarker.TranslatorUtil;
import com.kingdee.shr.ml.util.UserNantionalUtil;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;

public class FieldTranslator
extends AbstractElementTranslator {
    private static final Logger logger = Logger.getLogger(FieldTranslator.class);
    private static int NUMBER_MAX_LENGTH = 9;
    private static int DEFAULT_DECIMAL_PRECISION = 2;
    private static String DEFAULT_DECIMAL_ROUNDTYPE = "round";

    @Override
    public String translate(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        String parentElementName = element.getParentElement().getName();
        if ("list".equalsIgnoreCase(parentElementName) || "grid".equalsIgnoreCase(parentElementName)) {
            return store.getElementTranslator(this.getContext(), "gridField").translate(element, viewInfo, store);
        }
        if ("dynamicGrid".equalsIgnoreCase(parentElementName)) {
            return store.getElementTranslator(this.getContext(), "dynamicGridField").translate(element, viewInfo, store);
        }
        return this.createFormTemplateField(element, viewInfo, store);
    }

    private String createFormTemplateField(Element element, UIViewInfo viewInfo, IElementTranslatorStore store) throws TemplateTranslateException {
        String type = element.getAttributeValue("type");
        if ("hidden".equalsIgnoreCase(type)) {
            return this.createHiddenField(element, viewInfo);
        }
        StringBuilder sb = new StringBuilder();
        String result = null;
        String nolabel = element.getAttributeValue("nolabel");
        if (nolabel == null || !"1".equals(nolabel)) {
            String colspan = element.getAttributeValue("colspan");
            String col = element.getAttributeValue("col");
            String style = element.getAttributeValue("style");
            String required = element.getAttributeValue("required");
            String ctrlType = element.getAttributeValue("ctrl");
            sb.append("<@ctrl.field id=\"labCon{0}\" name=\"{0}\" caption=\"{1}\" col={2} colSpan={3} visible={4} style=\"{5}\" required={6}>\n");
            sb.append(this.translateChildren(element, viewInfo, store));
            sb.append("{7}");
            sb.append("</@ctrl.field>");
            String fieldName = element.getAttributeValue("name");
            FieldInfo fieldInfo = viewInfo.getField(fieldName);
            String label = fieldInfo.getAlias();
            result = MessageFormat.format(sb.toString(), fieldName, StringUtils.isEmpty((String)label) ? "" : label, col, colspan, this.isVisible(), StringUtils.isEmpty((String)style) ? "" : style, required, this.createInnerField(element, viewInfo));
        } else {
            result = this.createInnerField(element, viewInfo);
        }
        return result;
    }

    private String createInnerField(Element element, UIViewInfo viewInfo) throws TemplateTranslateException {
        StringBuilder sb = new StringBuilder();
        sb.append("<#if readonly==\"false\">\n");
        sb.append("{0}");
        sb.append("<#else>\n");
        sb.append("{1}");
        sb.append("</#if>\n");
        return MessageFormat.format(sb.toString(), this.createInputField(element, viewInfo), this.createReadOnlyField(element, viewInfo));
    }

    private String createInputField(Element element, UIViewInfo viewInfo) throws TemplateTranslateException {
        String fieldCtrl = element.getAttributeValue("ctrl");
        if (!StringUtils.isEmpty((String)fieldCtrl)) {
            return this.createInputFieldByCtrl(fieldCtrl, element, viewInfo);
        }
        String fieldDataType = element.getAttributeValue("dataType");
        if (!StringUtils.isEmpty((String)fieldDataType)) {
            return this.createInputFieldByDataType(fieldDataType, element, viewInfo);
        }
        String fieldName = element.getAttributeValue("name");
        FieldInfo fieldInfo = viewInfo.getField(fieldName);
        String result = null;
        DataType dataType = fieldInfo.getDataType();
        if (DataType.STRING.equals((Object)dataType)) {
            result = "true".equalsIgnoreCase(fieldInfo.getProperty().getExtendedProperty("looseBasicItem")) ? this.createSelectText(element, viewInfo) : this.createStringfield(element, viewInfo);
        } else if (DataType.DATE.equals((Object)dataType) || DataType.TIME.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType)) {
            result = this.createDateField(element, viewInfo, fieldInfo, dataType);
        } else if (DataType.INTEGER.equals((Object)dataType) || DataType.LONG.equals((Object)dataType) || DataType.SHORT.equals((Object)dataType)) {
            result = this.createIntegerField(element, viewInfo);
        } else if (DataType.DOUBLE.equals((Object)dataType) || DataType.DECIMAL.equals((Object)dataType) || DataType.FLOAT.equals((Object)dataType)) {
            result = this.createDecimalField(element, viewInfo);
        } else if (DataType.ENUM.equals((Object)dataType)) {
            result = this.createSelectField(element, (OwnPropertyInfo)fieldInfo.getProperty(), viewInfo);
        } else if (DataType.BOOLEAN.equals((Object)dataType)) {
            result = this.createCheckBox(element, viewInfo);
        } else if (DataType.OBJECTVALUE.equals((Object)dataType)) {
            result = this.createPromptBox(element, (LinkPropertyInfo)fieldInfo.getProperty(), viewInfo);
        }
        return result;
    }

    private String createInputFieldByCtrl(String ctrlType, Element element, UIViewInfo viewInfo) throws TemplateTranslateException {
        String result = null;
        if ("dateSpanPicker".equalsIgnoreCase(ctrlType)) {
            result = this.createDateSpanPickerField(element, viewInfo, DataType.DATE);
        } else if ("textarea".equalsIgnoreCase(ctrlType) || "code".equalsIgnoreCase(ctrlType)) {
            result = this.createTextarea(element, viewInfo);
        } else if ("password".equalsIgnoreCase(ctrlType)) {
            result = this.createPassword(element, viewInfo);
        }
        return result;
    }

    private String createInputFieldByDataType(String dataType, Element element, UIViewInfo viewInfo) throws TemplateTranslateException {
        String result = null;
        String fieldName = element.getAttributeValue("name");
        FieldInfo fieldInfo = viewInfo.getField(fieldName);
        if (DataType.STRING.getName().equalsIgnoreCase(dataType)) {
            result = this.createStringfield(element, viewInfo);
        } else if (DataType.DATE.getName().equalsIgnoreCase(dataType)) {
            result = this.createDateField(element, viewInfo, fieldInfo, DataType.DATE);
        } else if (DataType.TIME.getName().equalsIgnoreCase(dataType)) {
            result = this.createTimeField(element, viewInfo, DataType.TIME);
        } else if (DataType.TIMESTAMP.getName().equalsIgnoreCase(dataType)) {
            result = this.createDateField(element, viewInfo, fieldInfo, DataType.TIMESTAMP);
        } else if (DataType.INTEGER.getName().equalsIgnoreCase(dataType) || DataType.LONG.getName().equalsIgnoreCase(dataType) || DataType.SHORT.getName().equalsIgnoreCase(dataType)) {
            result = this.createIntegerField(element, viewInfo);
        } else if ("number".equalsIgnoreCase(dataType)) {
            result = this.createDecimalField(element, viewInfo);
        } else if (DataType.BOOLEAN.getName().equalsIgnoreCase(dataType)) {
            result = this.createCheckBox(element, viewInfo);
        } else if (DataType.ENUM.getName().equalsIgnoreCase(dataType)) {
            result = this.createSelectField(element, (OwnPropertyInfo)fieldInfo.getProperty(), viewInfo);
        } else if ("f7".equalsIgnoreCase(dataType)) {
            try {
                result = this.createPromptBox(element, (LinkPropertyInfo)fieldInfo.getProperty(), viewInfo);
            }
            catch (ClassCastException e) {
                logger.error((Object)MessageFormat.format(" property instanceof LinkPropertyInfo is false ,uipk is : {0}, fieldName is {1} , runtime dataType is {2}  ", viewInfo.getUipk(), fieldName, dataType));
            }
        } else if (DataType.DOUBLE.getName().equals(dataType) || DataType.DECIMAL.getName().equals(dataType) || DataType.FLOAT.getName().equals(dataType)) {
            result = this.createDecimalField(element, viewInfo);
        }
        return result;
    }

    private String createHiddenField(Element element, UIViewInfo viewInfo) {
        String pattern = "<input id=\"{0}\" name=\"{1}\" type=\"hidden\" value=\"{2}\">";
        String name = element.getAttributeValue("name");
        FieldInfo fieldInfo = viewInfo.getField(name);
        String value = null;
        value = DataType.BOOLEAN.equals((Object)fieldInfo.getDataType()) ? "${booleanFormater(getModelValue(model, '" + name + "'), '1', '0')}" : (DataType.ENUM.equals((Object)fieldInfo.getDataType()) ? "${getModelValue(getEnumValue(model, '" + name + "'), 'value')}" : (DataType.DATE.equals((Object)fieldInfo.getDataType()) ? "${dateTimeFormater(getModelValue(model, '" + name + "'),'" + DataType.DATE.getName() + "')}" : (DataType.TIMESTAMP.equals((Object)fieldInfo.getDataType()) ? "${dateTimeFormater(getModelValue(model, '" + name + "'),'" + DataType.TIMESTAMP.getName() + "')}" : (DataType.TIME.equals((Object)fieldInfo.getDataType()) ? "${dateTimeFormater(getModelValue(model, '" + name + "'),'" + DataType.TIME.getName() + "')}" : (DataType.OBJECTVALUE.equals((Object)fieldInfo.getDataType()) ? "${getModelValue(model, '" + name + ".id')}" : (null != fieldInfo && DataType.STRING.equals((Object)fieldInfo.getDataType()) && null != fieldInfo.getProperty() && ((OwnPropertyInfo)fieldInfo.getProperty()).isMultilingual() ? "${getModelValue(model, '" + name + "_" + this.getContext().getLocale().getDisplayName() + "')}" : "${getModelValue(model, '" + name + "')}"))))));
        return MessageFormat.format(pattern, DynamicUtil.convertId(name) + "${uuid}", name, value);
    }

    private String createDateSpanPickerField(Element element, UIViewInfo viewInfo, DataType dataType) {
        Map<String, Object> options = this.assembleFieldOptions(element, viewInfo);
        String fieldName = element.getAttributeValue("name");
        options.put("value", "${dateTimeFormater(getModelValue(model, '" + fieldName + "'), '" + dataType.getName() + "')}");
        TranslatorUtil.copyAttribute(element, options, "enumOptions");
        TranslatorUtil.copyAttribute(element, options, "beginOrEnd");
        return this.convertFieldString("dateSpanPicker", options);
    }

    private String createIntegerField(Element element, UIViewInfo viewInfo) throws TemplateTranslateException {
        Map<String, Object> options = this.assembleFieldOptions(element, viewInfo);
        this.appendValidation(options, "digits", "true");
        HashMap<String, HashMap<String, Object>> extendOptions = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, Object> numberOptions = new HashMap<String, Object>();
        try {
            this.setNumberFieldOptions(element, numberOptions, viewInfo);
            extendOptions.put("numberOptions", numberOptions);
            numberOptions.put("decimalPrecision", 0);
            UserNantionalUtil.numberExtendOptionsSetting((Context)this.getContext(), extendOptions, (boolean)true);
        }
        catch (EASBizException e) {
            throw new TemplateTranslateException(e);
        }
        catch (BOSException e) {
            throw new TemplateTranslateException(e);
        }
        options.put("extendOptions", JSONUtils.convertObjectToJson(this.getContext(), extendOptions).replaceAll("\"", "'"));
        String fieldName = element.getAttributeValue("name");
        options.put("value", "${getModelValue(model, '" + fieldName + "')}");
        options.put("isNumberfield", true);
        return this.convertFieldString("textField", options);
    }

    private String createDecimalField(Element element, UIViewInfo viewInfo) throws TemplateTranslateException {
        Map<String, Object> options = this.assembleFieldOptions(element, viewInfo);
        if ("integer".equalsIgnoreCase(element.getAttributeValue("dataType"))) {
            this.appendValidation(options, "digits", "true");
        } else {
            this.appendValidation(options, "number", "true");
        }
        String fieldName = element.getAttributeValue("name");
        HashMap<String, HashMap<String, Object>> extendOptions = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, Object> numberOptions = new HashMap<String, Object>();
        String ignoreDecimalFormatter = element.getAttributeValue("ignoreDecimalFormatter");
        if (StringUtils.isEmpty((String)ignoreDecimalFormatter) || "false".equals(ignoreDecimalFormatter)) {
            String decimalPrecision = UIViewUtil.getDecimalPrecisionAttrValue(this.getContext(), element, viewInfo);
            String roundType = element.getAttributeValue("roundType");
            if (StringUtils.isEmpty((String)roundType)) {
                roundType = DEFAULT_DECIMAL_ROUNDTYPE;
            }
            options.put("value", "${decimalFormatter(getModelValue(model, '" + fieldName + "'), '" + decimalPrecision + "','" + roundType + "',false)}");
        } else {
            options.put("value", "${getModelValue(model, '" + fieldName + "')}");
        }
        try {
            this.setNumberFieldOptions(element, numberOptions, viewInfo);
            extendOptions.put("numberOptions", numberOptions);
            UserNantionalUtil.numberExtendOptionsSetting((Context)this.getContext(), extendOptions, (boolean)false);
        }
        catch (EASBizException e) {
            throw new TemplateTranslateException(e);
        }
        catch (BOSException e) {
            throw new TemplateTranslateException(e);
        }
        options.put("extendOptions", JSONUtils.convertObjectToJson(this.getContext(), extendOptions).replaceAll("\"", "'"));
        options.put("isNumberfield", true);
        return this.convertFieldString("textField", options);
    }

    private String createDateField(Element element, UIViewInfo viewInfo, FieldInfo fieldInfo, DataType dataType) throws TemplateTranslateException {
        Map<String, Object> options = this.assembleFieldOptions(element, viewInfo);
        String fieldName = element.getAttributeValue("name");
        options.put("value", "${dateTimeFormater(getModelValue(model, '" + fieldName + "'),'" + dataType.getName() + "')}");
        TranslatorUtil.copyAttribute(element, options, "yearRange");
        TranslatorUtil.copyAttribute(element, options, "showButtonPanel");
        if (DataType.DATE.equals((Object)dataType)) {
            this.appendValidation(options, "dateISO", "true");
        }
        this.setDateTimeOrTimeOptions(element, options, viewInfo, dataType);
        return this.convertFieldString("dateTimePicker", options);
    }

    private String createTimeField(Element element, UIViewInfo viewInfo, DataType dataType) throws TemplateTranslateException {
        Map<String, Object> options = this.assembleFieldOptions(element, viewInfo);
        String fieldName = element.getAttributeValue("name");
        options.put("value", "${dateTimeFormater(getModelValue(model, '" + fieldName + "'), '" + dataType.getName() + "')}");
        String minuteStep = element.getAttributeValue("minuteStep");
        Integer default_minuteStep = 15;
        if (!StringUtils.isEmpty((String)minuteStep)) {
            options.put("minuteStep", minuteStep);
        } else {
            options.put("minuteStep", default_minuteStep);
        }
        this.setDateTimeOrTimeOptions(element, options, viewInfo, DataType.TIME);
        return this.convertFieldString("dateTimePicker", options);
    }

    private String createSelectField(Element element, OwnPropertyInfo ownPropertyInfo, UIViewInfo viewInfo) throws TemplateTranslateException {
        Map<String, Object> options = this.assembleFieldOptions(element, viewInfo);
        String enumSource = element.getAttributeValue("enumSource");
        if (StringUtils.isEmpty((String)enumSource)) {
            enumSource = null != ownPropertyInfo && DataType.ENUM.equals((Object)ownPropertyInfo.getDataType()) && !StringUtils.isEmpty((String)ownPropertyInfo.getMetaDataRef()) ? ownPropertyInfo.getMetaDataRef() : "";
        }
        options.put("enumSource", enumSource);
        String fieldName = element.getAttributeValue("name");
        if (element.getAttribute("value") != null) {
            options.put("value", element.getAttributeValue("value"));
        } else {
            options.put("value", "${getModelValue(getEnumValue(model, '" + fieldName + "'), 'value')}");
        }
        if (element.getAttribute("enumOptions") != null) {
            String enumOptions = element.getAttributeValue("enumOptions");
            enumOptions = enumOptions.replace("'", "\\\"");
            options.put("enumOptions", enumOptions);
        }
        TranslatorUtil.copyAttribute(element, options, "filter");
        TranslatorUtil.copyAttribute(element, options, "optionSource");
        TranslatorUtil.copyAttribute(element, options, "url");
        return this.convertFieldString("select", options);
    }

    private String createStringfield(Element element, UIViewInfo viewInfo) {
        return this.createTextfield(element, viewInfo);
    }

    private String createTextfield(Element element, UIViewInfo viewInfo) {
        Map<String, Object> options = this.assembleFieldOptions(element, viewInfo);
        String isMultiLan = element.getAttributeValue("isMultiLan");
        if ("true".equals(isMultiLan)) {
            options.put("isMultiLan", true);
        } else {
            options.put("isMultiLan", this.isMultiLan(element, viewInfo));
        }
        String isHtmlDecode = element.getAttributeValue("isHtmlDecode");
        if ("false".equals(isHtmlDecode)) {
            options.put("isHtmlDecode", false);
        } else {
            options.put("isHtmlDecode", true);
        }
        TranslatorUtil.copyAttribute(element, options, "max_length");
        this.setStringIsTrimAll(element, options);
        return this.convertFieldString("textField", options);
    }

    private String createTextarea(Element element, UIViewInfo viewInfo) {
        Map<String, Object> options = this.assembleFieldOptions(element, viewInfo);
        if (element.getAttributeValue("rows") != null) {
            options.put("rows", element.getAttributeValue("rows").toString());
        } else {
            options.put("rows", String.valueOf(20));
        }
        String style = element.getAttributeValue("style");
        if (!StringUtils.isEmpty((String)style)) {
            options.put("style", style);
        }
        options.put("isMultiLan", this.isMultiLan(element, viewInfo));
        this.setStringIsTrimAll(element, options);
        return this.convertFieldString("textArea", options);
    }

    private String createPassword(Element element, UIViewInfo viewInfo) {
        Map<String, Object> options = this.assembleFieldOptions(element, viewInfo);
        options.put("type", "password");
        return this.convertFieldString("textField", options);
    }

    private String createSelectText(Element element, UIViewInfo viewInfo) {
        Map<String, Object> options = this.assembleFieldOptions(element, viewInfo);
        String category = viewInfo.getEntityName() + "." + options.get("name");
        options.put("category", category);
        return this.convertFieldString("selectText", options);
    }

    private String createCheckBox(Element element, UIViewInfo viewInfo) {
        Map<String, Object> options = this.assembleFieldOptions(element, viewInfo);
        String fieldName = element.getAttributeValue("name");
        options.remove("value");
        String checked = element.getAttributeValue("checked");
        if (!StringUtils.isEmpty((String)checked) && "checked".equals(checked)) {
            options.put("checked", "checked");
        }
        options.put("dataValue", "${booleanFormater(getModelValue(model, '" + fieldName + "'), \\\"1\\\", \\\"0\\\")}");
        return this.convertFieldString("checkbox", options);
    }

    private String createPromptBox(Element element, LinkPropertyInfo propertyInfo, UIViewInfo viewInfo) throws TemplateTranslateException {
        Map<String, Object> options = this.assembleFieldOptions(element, viewInfo);
        String fieldName = element.getAttributeValue("name");
        String f7EntityName = MetaDataUtil.getEntityNameByPropertyInfo((Context)this.getContext(), (String)viewInfo.getEntityName(), (PropertyInfo)propertyInfo);
        this.setF7Config(element, options, f7EntityName);
        options.put("value", this.assemblePromptBoxValue(fieldName, options));
        String f7Title = element.getAttributeValue("F7Title");
        if (StringUtils.isEmpty((String)f7Title)) {
            f7Title = viewInfo.getField(fieldName).getAlias();
        }
        options.put("title", f7Title);
        String entityName = viewInfo.getEntityName();
        String isHROrg = element.getAttributeValue("isHROrg");
        if (!StringUtils.isEmpty((String)isHROrg)) {
            if ("true".equalsIgnoreCase(isHROrg)) {
                options.put("isHROrg", "true");
            } else if ("false".equalsIgnoreCase(isHROrg)) {
                options.put("isHROrg", "false");
            }
        } else {
            options.put("isHROrg", "${isDefaultHROrgFiled('" + entityName + "','" + fieldName + "')}");
        }
        String bindPermMethod = element.getAttributeValue("bindPermMethod");
        if (!StringUtils.isEmpty((String)bindPermMethod) && !"null".equalsIgnoreCase(bindPermMethod)) {
            options.put("permItemId", "${getF7BindPermItemId('" + bindPermMethod + "')}");
        }
        TranslatorUtil.copyAttribute(element, options, "query");
        TranslatorUtil.copyAttribute(element, options, "isAutoSort");
        TranslatorUtil.copyAttribute(element, options, "autoComplete");
        TranslatorUtil.copyAttribute(element, options, "domain");
        this.setPromptBoxFilter(element, options, f7EntityName);
        TranslatorUtil.copyAttribute(element, options, "multiselect");
        TranslatorUtil.copyAttribute(element, options, "searchFields");
        TranslatorUtil.copyAttribute(element, options, "filterConfig");
        TranslatorUtil.copyAttribute(element, options, "isHRBaseItem");
        TranslatorUtil.copyAttribute(element, options, "bizFilterFields");
        TranslatorUtil.copyAttribute(element, options, "f7ReKeyValue");
        TranslatorUtil.copyAttribute(element, options, "submitFormat");
        TranslatorUtil.copyAttribute(element, options, "fieldSeparator");
        TranslatorUtil.copyAttribute(element, options, "afterOnchangeClearFields");
        TranslatorUtil.copyAttribute(element, options, "permItemId");
        TranslatorUtil.copyAttribute(element, options, "extendedProperty");
        TranslatorUtil.copyAttribute(element, options, "autoCompleteQueryField");
        TranslatorUtil.copyAttribute(element, options, "searchLikePattern");
        TranslatorUtil.copyAttribute(element, options, "isTree");
        TranslatorUtil.copyAttribute(element, options, "treeUrl");
        TranslatorUtil.copyAttribute(element, options, "isContainLowerOrg");
        TranslatorUtil.copyAttribute(element, options, "isEnableExpFilter");
        TranslatorUtil.copyAttribute(element, options, "pgSizes");
        TranslatorUtil.copyAttribute(element, options, "dataShowMode");
        TranslatorUtil.copyAttribute(element, options, "isAdminOrg");
        return this.convertFieldString("promptBox", options);
    }

    private void setF7Config(Element element, Map<String, Object> options, String f7EntityName) throws TemplateTranslateException {
        this.setF7DefaultConfig(options, f7EntityName);
        TranslatorUtil.copyAttribute(element, options, "uipk");
        this.setF7ConfigByView(element, options);
        TranslatorUtil.copyAttribute(element, options, "displayFormat");
        TranslatorUtil.copyAttribute(element, options, "customformatter");
        TranslatorUtil.copyAttribute(element, options, "customparam");
        TranslatorUtil.copyAttribute(element, options, "f7Type");
        TranslatorUtil.copyAttribute(element, options, "isHasMultileDialog");
        TranslatorUtil.copyAttribute(element, options, "afterOnchangeClearFields");
        String treeFilterConfig = element.getAttributeValue("treeFilterConfig");
        if (!StringUtils.isEmpty((String)treeFilterConfig)) {
            options.put("treeFilterConfig", treeFilterConfig);
        }
        options.remove("alias");
        if ("dropdownlist".equals(options.get("f7Type"))) {
            options.put("f7Type", "shrPromptComplete");
        }
    }

    private void setF7DefaultConfig(Map<String, Object> options, String f7EntityName) throws TemplateTranslateException {
        Map<String, String> defaultF7Config = this.getDefaultF7Config(f7EntityName);
        if (defaultF7Config == null) {
            return;
        }
        if (!StringUtils.isEmpty((String)defaultF7Config.get("uipk"))) {
            options.put("uipk", defaultF7Config.get("uipk"));
        }
        if (!StringUtils.isEmpty((String)defaultF7Config.get("displayFormat"))) {
            options.put("displayFormat", defaultF7Config.get("displayFormat"));
        }
        if (!StringUtils.isEmpty((String)defaultF7Config.get("functionName"))) {
            options.put("customformatter", defaultF7Config.get("functionName"));
        }
        if (!StringUtils.isEmpty((String)defaultF7Config.get("param"))) {
            options.put("customparam", defaultF7Config.get("param"));
        }
    }

    private void setF7ConfigByView(Element element, Map<String, Object> options) throws TemplateTranslateException {
        try {
            String uipk = (String)options.get("uipk");
            if (!UIViewUtil.existUIViewInfo(this.getContext(), uipk)) {
                return;
            }
            UIViewInfo uiViewInfo = UIViewUtil.getUIViewInfoByUIPK(this.getContext(), uipk);
            Document doc = XMLUtil.parseXML(uiViewInfo.getContent());
            Element f7TypeElement = XMLUtil.getElement(doc.getRootElement(), "f7Type");
            if (f7TypeElement != null) {
                if (!StringUtils.isEmpty((String)f7TypeElement.getAttributeValue("value"))) {
                    options.put("f7Type", f7TypeElement.getAttributeValue("value"));
                }
                TranslatorUtil.copyAttribute(f7TypeElement, options, "displayFormat");
            }
        }
        catch (SHRWebException e) {
            throw new TemplateTranslateException(e.getMessage(), e);
        }
    }

    private String assemblePromptBoxValue(String fieldName, Map<String, Object> options) {
        ArrayList<String> names = new ArrayList<String>();
        names.add("id");
        names.add("name");
        String displayFormat = (String)options.get("displayFormat");
        if (!StringUtils.isEmpty((String)displayFormat)) {
            names.add(displayFormat);
        }
        return this.assemblePromptBoxValue(fieldName, names);
    }

    private String assemblePromptBoxValue(String fieldName, List<String> names) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String name = null;
        int size = names.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            name = names.get(i);
            sb.append("'");
            sb.append(name);
            sb.append("'");
            sb.append(":");
            sb.append("\\\"${getModelValue(model, '" + fieldName + "." + name + "')}\\\"");
        }
        sb.append("}");
        return sb.toString();
    }

    private Map<String, String> getDefaultF7Config(String entityName) throws TemplateTranslateException {
        if (StringUtils.isEmpty((String)entityName)) {
            return null;
        }
        try {
            HashMap<String, String> config = EntityF7ConfigHelper.getDefaultF7Config((String)entityName);
            if (config == null) {
                config = new HashMap<String, String>();
            }
            String uipk = this.getDefaultF7UIPK(entityName, config);
            config.put("uipk", uipk);
            return config;
        }
        catch (BOSException e) {
            throw new TemplateTranslateException(e.getMessage(), e);
        }
    }

    private String getDefaultF7UIPK(String entityName, Map<String, String> config) throws TemplateTranslateException {
        String uipk = null;
        if (config != null) {
            uipk = config.get("f7");
        }
        try {
            if (StringUtils.isEmpty(uipk)) {
                uipk = entityName + ".F7";
                UIViewInfo uiViewInfo = UIViewUtil.getUIViewInfoByUIPK(this.getContext(), uipk);
                if (null == uiViewInfo) {
                    uipk = null;
                }
            }
        }
        catch (SHRWebException e) {
            uipk = null;
        }
        if (StringUtils.isEmpty((String)uipk)) {
            uipk = entityName + ".list";
        }
        return uipk;
    }

    private void setPromptBoxFilter(Element element, Map<String, Object> options, String entityName) {
        TranslatorUtil.copyAttribute(element, options, "filter");
    }

    private Map<String, Object> assembleFieldOptions(Element element, UIViewInfo viewInfo) {
        String readonly;
        String required;
        HashMap<String, Object> options = new HashMap<String, Object>();
        String fieldName = element.getAttributeValue("name");
        options.put("id", DynamicUtil.convertId(fieldName) + "${uuid}");
        options.put("name", fieldName);
        if (element.getAttributeValue("value") != null) {
            TranslatorUtil.copyAttribute(element, options, "value");
        } else {
            options.put("value", "${getModelValue(model, '" + fieldName + "')?html}");
        }
        String validate = element.getAttributeValue("validate");
        if (!StringUtils.isEmpty((String)validate)) {
            options.put("validate", JSONUtils.convertJsonToObject(this.getContext(), validate, Map.class));
        }
        if (!StringUtils.isEmpty((String)(required = element.getAttributeValue("required")))) {
            this.appendValidation(options, "required", required);
        }
        if (!StringUtils.isEmpty((String)(readonly = element.getAttributeValue("readonly"))) && "true".equals(readonly)) {
            options.put("readonly", "readonly");
        }
        this.setMaxLength(options, element, viewInfo);
        String isEmail = element.getAttributeValue("isEmail");
        if (!StringUtils.isEmpty((String)isEmail)) {
            this.appendValidation(options, "isEmail", isEmail);
        }
        TranslatorUtil.copyAttribute(element, options, "placeholder");
        TranslatorUtil.copyAttribute(element, options, "autocomplete");
        TranslatorUtil.copyAttribute(element, options, "isToTemplate");
        TranslatorUtil.copyAttribute(element, options, "joinSelectField");
        TranslatorUtil.copyAttribute(element, options, "isMenuIcon");
        TranslatorUtil.copyAttribute(element, options, "numberfieldBlank");
        return options;
    }

    private void setMaxLength(Map<String, Object> options, Element element, UIViewInfo viewInfo) {
        String pattern;
        int length = -1;
        String max_length = element.getAttributeValue("max_length");
        if (!StringUtils.isEmpty((String)max_length)) {
            length = Integer.parseInt(max_length);
            if (length <= 0) {
                pattern = "max_length config error , model: {0}, field: {1}, maxlength is {2}";
                logger.error((Object)MessageFormat.format(pattern, viewInfo.getModel(), element.getAttributeValue("name"), max_length));
                length = NUMBER_MAX_LENGTH;
            }
        } else {
            String fieldName = element.getAttributeValue("name");
            FieldInfo fieldInfo = viewInfo.getField(fieldName);
            DataType dataType = fieldInfo.getDataType();
            if (DataType.STRING.equals((Object)dataType)) {
                if (fieldInfo.getProperty() != null && null != fieldInfo.getProperty().getMappingField() && (length = fieldInfo.getProperty().getMappingField().getLength()) <= 0) {
                    length = DynamicUtil.getTableFileldLengthFromDB(viewInfo.getEntityName(), fieldName);
                }
                if (length <= 0) {
                    length = 255;
                }
            } else if (DataType.INTEGER.equals((Object)dataType) || DataType.LONG.equals((Object)dataType) || DataType.SHORT.equals((Object)dataType)) {
                length = NUMBER_MAX_LENGTH;
            } else if (DataType.DOUBLE.equals((Object)dataType) || DataType.DECIMAL.equals((Object)dataType) || DataType.FLOAT.equals((Object)dataType)) {
                length = NUMBER_MAX_LENGTH;
            }
        }
        if (length != -1) {
            if (length == 0) {
                pattern = "model: {0}, field: {1}, maxlength is 0";
                logger.warn((Object)MessageFormat.format(pattern, viewInfo.getModel(), element.getAttributeValue("name")));
            } else {
                this.appendValidation(options, "maxlength", String.valueOf(length));
            }
        }
    }

    private void appendValidation(Map<String, Object> options, String name, String value) {
        HashMap<String, String> validate = (HashMap<String, String>)options.get("validate");
        if (validate == null) {
            validate = new HashMap<String, String>();
            options.put("validate", validate);
        }
        validate.put(name, value);
    }

    private String convertFieldString(String type, Map<String, Object> options) {
        return this.convertFieldString("ctrl", type, options);
    }

    protected String createReadOnlyField(Element element, UIViewInfo viewInfo) throws TemplateTranslateException {
        String fieldCtrl = element.getAttributeValue("ctrl");
        if (!StringUtils.isEmpty((String)fieldCtrl)) {
            return this.createReadOnlyFieldByCtrl(fieldCtrl, element, viewInfo);
        }
        String fieldDataType = element.getAttributeValue("dataType");
        if (!StringUtils.isEmpty((String)fieldDataType)) {
            return this.createReadOnlyFieldByDataType(fieldDataType, element, viewInfo);
        }
        String fieldName = element.getAttributeValue("name");
        Map<String, Object> options = null;
        FieldInfo fieldInfo = viewInfo.getField(fieldName);
        DataType dataType = fieldInfo.getDataType();
        if (DataType.ENUM.equals((Object)dataType)) {
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            options.put("value", "${getModelValue(getEnumValue(model, '" + fieldName + "'), 'value')}");
            options.put("originalValue", "${getModelValue(getEnumValue(model, '" + fieldName + "'), 'value')}");
            options.put("alias", "${getEnumValue(model, '" + fieldName + "')?html}");
        } else if (DataType.BOOLEAN.equals((Object)dataType)) {
            String tr = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "true");
            String fa = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "false");
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            options.put("value", "${booleanFormater(getModelValue(model, '" + fieldName + "'), \\\"1\\\", \\\"0\\\")}");
            options.put("originalValue", "${booleanFormater(getModelValue(model, '" + fieldName + "'),\\\"true\\\", \\\"false\\\")}");
            options.put("alias", "${booleanFormater(getModelValue(model, '" + fieldName + "'), \\\"" + tr + "\\\", \\\"" + fa + "\\\")}");
        } else if (DataType.DATE.equals((Object)dataType) || DataType.TIME.equals((Object)dataType) || DataType.TIMESTAMP.equals((Object)dataType)) {
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            this.setTimeOrDateOrTimestampOptions(dataType.getName(), element, viewInfo, options);
        } else if (DataType.STRING.equals((Object)dataType)) {
            String ctrl = element.getAttributeValue("ctrl");
            if ("textarea".equalsIgnoreCase(ctrl) || "code".equalsIgnoreCase(ctrl)) {
                options = this.getPreCtrlOptions(element, viewInfo, ctrl);
                if ("textarea".equalsIgnoreCase(ctrl)) {
                    options.put("originalValue", "${getModelValue(model, '" + fieldName + "')}");
                }
                return this.convertReadOnlyFieldString("span", options);
            }
        } else if (DataType.OBJECTVALUE.equals((Object)dataType)) {
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            String f7EntityName = MetaDataUtil.getEntityNameByPropertyInfo((Context)this.getContext(), (String)viewInfo.getEntityName(), (PropertyInfo)fieldInfo.getProperty());
            this.setF7Config(element, options, f7EntityName);
            options.remove("uipk");
            options.remove("f7Type");
            options.put("value", this.assemblePromptBoxValue(fieldName, options));
            options.put("originalValue", "\\\"${getModelValue(model, '" + fieldName + ".id')}\\\"");
            options.put("dataType", "object");
        } else if (DataType.DOUBLE.equals((Object)dataType) || DataType.DECIMAL.equals((Object)dataType) || DataType.FLOAT.equals((Object)dataType)) {
            String ignoreDecimalFormatter = element.getAttributeValue("ignoreDecimalFormatter");
            if (StringUtils.isEmpty((String)ignoreDecimalFormatter) || "false".equals(ignoreDecimalFormatter)) {
                String decimalPrecision = UIViewUtil.getDecimalPrecisionAttrValue(this.getContext(), element, viewInfo);
                String roundType = element.getAttributeValue("roundType");
                if (StringUtils.isEmpty((String)roundType)) {
                    roundType = DEFAULT_DECIMAL_ROUNDTYPE;
                }
                options = this.assembleReadOnlyFieldOptions(element, viewInfo);
                options.put("value", "${decimalFormatter(getModelValue(model, '" + fieldName + "'), '" + decimalPrecision + "','" + roundType + "',true)}");
                options.put("alias", "${decimalFormatter(getModelValue(model, '" + fieldName + "'), '" + decimalPrecision + "','" + roundType + "',true)}");
            } else {
                options = this.assembleReadOnlyFieldOptions(element, viewInfo);
                options.put("value", "${getModelValue(model, '" + fieldName + "')}");
                options.put("alias", "${getModelValue(model, '" + fieldName + "')}");
            }
            options.put("originalValue", "${getModelValue(model, '" + fieldName + "')}");
        } else if (DataType.LONG.equals((Object)dataType) || DataType.INTEGER.equals((Object)dataType) || DataType.SHORT.equals((Object)dataType)) {
            String ignoreDecimalFormatter = element.getAttributeValue("ignoreDecimalFormatter");
            if (StringUtils.isEmpty((String)ignoreDecimalFormatter) || "false".equals(ignoreDecimalFormatter)) {
                String decimalPrecision = "0";
                String roundType = element.getAttributeValue("roundType");
                if (StringUtils.isEmpty((String)roundType)) {
                    roundType = DEFAULT_DECIMAL_ROUNDTYPE;
                }
                options = this.assembleReadOnlyFieldOptions(element, viewInfo);
                options.put("value", "${decimalFormatter(getModelValue(model, '" + fieldName + "'), '" + decimalPrecision + "','" + roundType + "',true)}");
                options.put("alias", "${decimalFormatter(getModelValue(model, '" + fieldName + "'), '" + decimalPrecision + "','" + roundType + "',true)}");
            } else {
                options = this.assembleReadOnlyFieldOptions(element, viewInfo);
                options.put("value", "${getModelValue(model, '" + fieldName + "')}");
                options.put("alias", "${getModelValue(model, '" + fieldName + "')}");
            }
            options.put("originalValue", "${getModelValue(model, '" + fieldName + "')}");
        }
        if (options == null) {
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            options.put("originalValue", "${getModelValue(model, '" + fieldName + "')}");
        }
        TranslatorUtil.copyAttribute(element, options, "afterOnchangeClearFields");
        this.setSensitiveRule(options, fieldInfo, element, viewInfo);
        return this.convertReadOnlyFieldString("fieldDisplay", options);
    }

    private String createReadOnlyFieldByCtrl(String ctrlType, Element element, UIViewInfo viewInfo) throws TemplateTranslateException {
        Map<String, Object> options = null;
        FieldInfo fieldInfo = viewInfo.getField(element.getAttributeValue("name"));
        if ("password".equalsIgnoreCase(ctrlType)) {
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            options.put("value", "");
            options.put("originalValue", "");
            options.put("alias", "*********");
        } else {
            if ("textarea".equalsIgnoreCase(ctrlType) || "code".equalsIgnoreCase(ctrlType)) {
                options = this.getPreCtrlOptions(element, viewInfo, ctrlType);
                if ("textarea".equalsIgnoreCase(ctrlType)) {
                    options.put("originalValue", "${getModelValue(model, '" + element.getAttributeValue("name") + "')}");
                }
                options.put("class", "textarea-height");
                return this.convertReadOnlyFieldString("span", options);
            }
            if ("dateSpanPicker".equals(ctrlType)) {
                DataType dataType = fieldInfo.getDataType();
                options = this.assembleReadOnlyFieldOptions(element, viewInfo);
                this.setTimeOrDateOrTimestampOptions(dataType.getName(), element, viewInfo, options);
                return this.convertReadOnlyFieldString("fieldDisplay", options);
            }
        }
        if (options == null) {
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            options.put("originalValue", "${getModelValue(model, '" + element.getAttributeValue("name") + "')}");
        }
        this.setSensitiveRule(options, fieldInfo, element, viewInfo);
        return this.convertReadOnlyFieldString("fieldDisplay", options);
    }

    private void setTimeOrDateOrTimestampOptions(String dataType, Element element, UIViewInfo viewInfo, Map<String, Object> options) throws TemplateTranslateException {
        String fieldName = element.getAttributeValue("name");
        boolean isAutoTimeZoneTrans = this.isAutoTimeZoneTransForTimeOrDatetimeProperty(element, viewInfo);
        boolean isRemoveSeconds = this.isRemoveSecondsForDateTime(element);
        boolean isRemoveDay = this.isRemoveDayForDateTime(element);
        options.put("value", "${dateTimeFormaterDisplay(getModelValue(model, '" + fieldName + "'), '" + dataType + "', " + isAutoTimeZoneTrans + "," + isRemoveSeconds + "," + isRemoveDay + ")}");
        options.put("originalValue", "${dateTimeFormater(getModelValue(model, '" + fieldName + "'), '" + dataType + "')}");
        options.put("alias", "${dateTimeFormaterDisplay(getModelValue(model, '" + fieldName + "'), '" + dataType + "', " + isAutoTimeZoneTrans + "," + isRemoveSeconds + "," + isRemoveDay + ")}");
    }

    private String createReadOnlyFieldByDataType(String dataType, Element element, UIViewInfo viewInfo) throws TemplateTranslateException {
        Map<String, Object> options = null;
        String fieldName = element.getAttributeValue("name");
        FieldInfo fieldInfo = viewInfo.getField(fieldName);
        if (DataType.BOOLEAN.getName().equalsIgnoreCase(dataType)) {
            String tr = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "true");
            String fa = SHRWebResource.getString("com.kingdee.shr.base.syssetting.SHRSyssettingResource", "false");
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            options.put("value", "${booleanFormater(getModelValue(model, '" + fieldName + "'), \\\"1\\\", \\\"0\\\")}");
            options.put("originalValue", "${booleanFormater(getModelValue(model, '" + fieldName + "'),\\\"true\\\",\\\"false\\\")}");
            options.put("alias", "${booleanFormater(getModelValue(model, '" + fieldName + "'), \\\"" + tr + "\\\", \\\"" + fa + "\\\")}");
        } else if (DataType.DATE.getName().equalsIgnoreCase(dataType)) {
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            this.setTimeOrDateOrTimestampOptions(dataType, element, viewInfo, options);
        } else if (DataType.TIME.getName().equalsIgnoreCase(dataType)) {
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            this.setTimeOrDateOrTimestampOptions(dataType, element, viewInfo, options);
        } else if (DataType.TIMESTAMP.getName().equalsIgnoreCase(dataType)) {
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            this.setTimeOrDateOrTimestampOptions(dataType, element, viewInfo, options);
        } else if ("f7".equalsIgnoreCase(dataType)) {
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            String f7EntityName = MetaDataUtil.getEntityNameByPropertyInfo((Context)this.getContext(), (String)viewInfo.getEntityName(), (PropertyInfo)fieldInfo.getProperty());
            this.setF7Config(element, options, f7EntityName);
            options.remove("uipk");
            options.put("value", this.assemblePromptBoxValue(fieldName, options));
            options.put("originalValue", "\\\"${getModelValue(model, '" + fieldName + ".id')}\\\"");
            options.put("dataType", "object");
        } else if (DataType.ENUM.toString().equalsIgnoreCase(dataType)) {
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            options.put("value", "${getModelValue(getEnumValue(model, '" + fieldName + "'), 'value')}");
            options.put("originalValue", "${getModelValue(getEnumValue(model, '" + fieldName + "'), 'value')}");
            options.put("alias", "${getEnumValue(model, '" + fieldName + "')?html}");
        } else if (DataType.DOUBLE.getName().equals(dataType) || DataType.DECIMAL.getName().equals(dataType) || DataType.FLOAT.getName().equals(dataType)) {
            String ignoreDecimalFormatter = element.getAttributeValue("ignoreDecimalFormatter");
            if (StringUtils.isEmpty((String)ignoreDecimalFormatter) || "false".equals(ignoreDecimalFormatter)) {
                String decimalPrecision = UIViewUtil.getDecimalPrecisionAttrValue(this.getContext(), element, viewInfo);
                String roundType = element.getAttributeValue("roundType");
                if (StringUtils.isEmpty((String)roundType)) {
                    roundType = DEFAULT_DECIMAL_ROUNDTYPE;
                }
                options = this.assembleReadOnlyFieldOptions(element, viewInfo);
                options.put("value", "${decimalFormatter(getModelValue(model, '" + fieldName + "'), '" + decimalPrecision + "','" + roundType + "',true)}");
                options.put("alias", "${decimalFormatter(getModelValue(model, '" + fieldName + "'), '" + decimalPrecision + "','" + roundType + "',true)}");
            } else {
                options = this.assembleReadOnlyFieldOptions(element, viewInfo);
                options.put("value", "${getModelValue(model, '" + fieldName + "')}");
                options.put("alias", "${getModelValue(model, '" + fieldName + "')}");
            }
            options.put("originalValue", "${getModelValue(model, '" + fieldName + "')}");
        }
        if (options == null) {
            options = this.assembleReadOnlyFieldOptions(element, viewInfo);
            options.put("originalValue", "${getModelValue(model, '" + fieldName + "')}");
        }
        this.setSensitiveRule(options, fieldInfo, element, viewInfo);
        return this.convertReadOnlyFieldString("fieldDisplay", options);
    }

    private Map<String, Object> getPreCtrlOptions(Element element, UIViewInfo viewInfo, String ctrl) {
        Map<String, Object> options = this.assembleReadOnlyFieldOptions(element, viewInfo);
        String alias = (String)options.get("alias");
        StringBuilder sb = new StringBuilder();
        sb.append("<pre");
        if ("textarea".equalsIgnoreCase(ctrl)) {
            sb.append(" class=\\\"textarea-format\\\"");
        }
        sb.append(">");
        sb.append(alias);
        sb.append("</pre>");
        options.put("alias", sb.toString());
        return options;
    }

    private Map<String, Object> assembleReadOnlyFieldOptions(Element element, UIViewInfo viewInfo) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        String fieldName = element.getAttributeValue("name");
        String joinSelectField = element.getAttributeValue("joinSelectField");
        options.put("id", DynamicUtil.convertId(fieldName) + "${uuid}");
        String alias = element.getAttributeValue("value");
        if (alias == null) {
            alias = joinSelectField != null ? "${getModelValue(model, '" + joinSelectField + "')?html}-${getModelValue(model, '" + fieldName + "')?html}" : "${getModelValue(model, '" + fieldName + "')?html}";
        } else if (joinSelectField != null) {
            alias = "${getModelValue(model, '" + joinSelectField + "')?html}" + alias;
        }
        options.put("alias", alias);
        options.put("class", "field_input");
        TranslatorUtil.copyAttribute(element, options, "emptyDisplay");
        TranslatorUtil.copyAttribute(element, options, "sensitiveRule");
        return options;
    }

    private String convertReadOnlyFieldString(String type, Map<String, Object> options) {
        return this.convertFieldString(type, options);
    }

    @Override
    public boolean requireLayout() {
        Element element = this.getElement();
        String parentElementName = element.getParentElement().getName();
        if ("list".equalsIgnoreCase(parentElementName) || "grid".equalsIgnoreCase(parentElementName) || "dynamicGrid".equalsIgnoreCase(parentElementName)) {
            return false;
        }
        return this.isVisible();
    }

    private boolean isVisible() {
        boolean visible = true;
        Element element = this.getElement();
        if (element != null && "false".equals(element.getAttributeValue("visible"))) {
            visible = false;
        }
        return visible;
    }
}

