/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.app.util.MetaDataUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public final class FastFilterUtil {
    public static final String ADMIN_ORG_INNER = "adminOrgInner";
    public static final String ADMIN_ORG_OUTER = "adminOrgOuter";
    public static final String ADMIN_ORG_RANGE = "adminOrgRange";

    public static FilterInfo generateBizFastFilterInfo(String fastFilterItems) throws SHRWebException {
        FilterInfo filter = null;
        if (!StringUtils.isEmpty((CharSequence)fastFilterItems)) {
            filter = new FilterInfo();
            HashMap map = JSONUtils.convertJsonToObject(SHRContext.getInstance().getContext(), fastFilterItems);
            for (Object key : map.keySet()) {
                String selectData;
                if (null == map.get(key) || !(map.get(key) instanceof Map) || ADMIN_ORG_RANGE.equals(key.toString())) continue;
                Map subMap = (Map)map.get(key);
                String property = String.valueOf(key);
                String dataType = String.valueOf(subMap.get("dataType"));
                String uipk = String.valueOf(subMap.get("uipk"));
                String enumSource = String.valueOf(subMap.get("enumSource"));
                String url = String.valueOf(subMap.get("url"));
                if ("F7".equals(dataType)) {
                    String stringValues = String.valueOf(subMap.get("values"));
                    boolean isAdminOrg = false;
                    if (subMap.containsKey("isAdminOrg")) {
                        isAdminOrg = (Boolean)subMap.get("isAdminOrg");
                    }
                    if ((key.equals("adminOrgUnit") || key.equals("adminOrg") || isAdminOrg) && subMap.get("includeSub") != null) {
                        boolean isIncludeSub = (Boolean)subMap.get("isIncludeSub");
                        if (!isIncludeSub) {
                            Set<String> orgIdList = FastFilterUtil.getOrgIds(subMap);
                            if (orgIdList == null || orgIdList.size() <= 0) continue;
                            filter.getFilterItems().add(new FilterItemInfo(key + ".id", orgIdList, CompareType.INCLUDE));
                            continue;
                        }
                        String orgIncludeSubSQL = FastFilterUtil.getOrgIncludeSubSQL(subMap);
                        if (StringUtils.isEmpty((CharSequence)orgIncludeSubSQL)) continue;
                        filter.getFilterItems().add(new FilterItemInfo(key + ".id", (Object)orgIncludeSubSQL, CompareType.INNER));
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)stringValues)) continue;
                    if (property.indexOf(".") <= 0) {
                        property = property + ".id";
                    }
                    if (stringValues.indexOf(",") <= 0) {
                        filter.getFilterItems().add(new FilterItemInfo(property, (Object)stringValues, CompareType.EQUALS));
                        continue;
                    }
                    filter.getFilterItems().add(new FilterItemInfo(property, FastFilterUtil.generateSet(stringValues.split(",")), CompareType.INCLUDE));
                    continue;
                }
                if ("String".equals(dataType)) {
                    String stringValues = String.valueOf(subMap.get("values"));
                    if (ADMIN_ORG_RANGE.equals(property) || StringUtils.isEmpty((CharSequence)stringValues)) continue;
                    if (property.indexOf(".") <= 0) {
                        property = property + ".id";
                    }
                    if (stringValues.indexOf(",") <= 0) {
                        filter.getFilterItems().add(new FilterItemInfo(property, (Object)stringValues, CompareType.EQUALS));
                        continue;
                    }
                    filter.getFilterItems().add(new FilterItemInfo(property, FastFilterUtil.generateSet(stringValues.split(",")), CompareType.INCLUDE));
                    continue;
                }
                if ("Date".equals(dataType) || "dateTime".equalsIgnoreCase(dataType)) {
                    String datePoint;
                    if (null == subMap.get("values") || String.class.equals(subMap.get("values").getClass()) && StringUtils.isEmpty((CharSequence)String.valueOf(subMap.get("values")))) continue;
                    Map mapValues = null;
                    if (!(subMap.get("values") instanceof Map)) continue;
                    mapValues = (Map)subMap.get("values");
                    String startDate = mapValues.get("startDate") == null ? null : String.valueOf(mapValues.get("startDate"));
                    String endDate = mapValues.get("endDate") == null ? null : String.valueOf(mapValues.get("endDate"));
                    String string = datePoint = mapValues.get("date") == null ? null : String.valueOf(mapValues.get("date"));
                    if ("dateTime".equalsIgnoreCase(dataType)) {
                        startDate = String.valueOf(mapValues.get("startDatetime"));
                        endDate = String.valueOf(mapValues.get("endDatetime"));
                    }
                    String parten = FastFilterUtil.getParten();
                    String queryDateType = String.valueOf(subMap.get("queryDateType"));
                    if ("datetime".equalsIgnoreCase(dataType) || "datetime".equalsIgnoreCase(queryDateType)) {
                        parten = "yyyy-MM-dd HH:mm:ss";
                    }
                    if (!StringUtils.isEmpty((CharSequence)startDate) && !StringUtils.isEmpty((CharSequence)endDate)) {
                        filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.getSqlDate(startDate, parten), CompareType.GREATER_EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.getSqlDate(endDate, parten), CompareType.LESS_EQUALS));
                        continue;
                    }
                    if (!StringUtils.isEmpty((CharSequence)startDate) && StringUtils.isEmpty((CharSequence)endDate)) {
                        filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.getSqlDate(startDate, parten), CompareType.GREATER_EQUALS));
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)startDate) && !StringUtils.isEmpty((CharSequence)endDate)) {
                        filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.getSqlDate(endDate, parten), CompareType.LESS_EQUALS));
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)datePoint)) continue;
                    filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.getSqlDate(datePoint, parten), CompareType.EQUALS));
                    continue;
                }
                if ("Enum".equals(dataType)) {
                    boolean isCustomDefine = (Boolean)subMap.get("isCustomDefine");
                    String type = String.valueOf(subMap.get("enumOptionsType"));
                    String stringValues = String.valueOf(subMap.get("values"));
                    if (StringUtils.isEmpty((CharSequence)stringValues)) continue;
                    try {
                        if (isCustomDefine) {
                            if ("boolean".equals(type)) {
                                if (stringValues.split(",").length != 1) continue;
                                filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.getBoolean(stringValues), CompareType.EQUALS));
                                continue;
                            }
                            filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.generateEnumSet(stringValues.split(","), (String)null, type), CompareType.INCLUDE));
                            continue;
                        }
                        filter.getFilterItems().add(new FilterItemInfo(property, (Object)FastFilterUtil.generateEnumSet(stringValues.split(","), enumSource, null), CompareType.INCLUDE));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!"Number".equals(dataType) || null == subMap.get("values") || String.class.equals(subMap.get("values").getClass()) && StringUtils.isEmpty((CharSequence)String.valueOf(subMap.get("values")))) continue;
                Map mapValues = (Map)subMap.get("values");
                String startNumber = mapValues.get("startNumber") == null ? null : String.valueOf(mapValues.get("startNumber"));
                String endNumber = mapValues.get("endNumber") == null ? null : String.valueOf(mapValues.get("endNumber"));
                String string = selectData = mapValues.get("selectData") == null ? null : String.valueOf(mapValues.get("selectData"));
                if (!StringUtils.isEmpty((CharSequence)selectData) && selectData.equals("range")) {
                    if (!StringUtils.isEmpty((CharSequence)startNumber) && !StringUtils.isEmpty((CharSequence)endNumber)) {
                        if (startNumber.indexOf(".") <= 0 || endNumber.indexOf(".") <= 0) {
                            filter.getFilterItems().add(new FilterItemInfo(property, (Object)Integer.valueOf(startNumber), CompareType.GREATER_EQUALS));
                            filter.getFilterItems().add(new FilterItemInfo(property, (Object)Integer.valueOf(endNumber), CompareType.LESS_EQUALS));
                            continue;
                        }
                        if (startNumber.indexOf(".") - 1 <= -1 && endNumber.indexOf(".") - 1 <= -1) continue;
                        filter.getFilterItems().add(new FilterItemInfo(property, (Object)new BigDecimal(startNumber), CompareType.GREATER_EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo(property, (Object)new BigDecimal(endNumber), CompareType.LESS_EQUALS));
                        continue;
                    }
                    if (!StringUtils.isEmpty((CharSequence)startNumber) && StringUtils.isEmpty((CharSequence)endNumber)) {
                        if (startNumber.indexOf(".") <= 0) {
                            filter.getFilterItems().add(new FilterItemInfo(property, (Object)Integer.valueOf(startNumber), CompareType.GREATER_EQUALS));
                            continue;
                        }
                        filter.getFilterItems().add(new FilterItemInfo(property, (Object)new BigDecimal(startNumber), CompareType.GREATER_EQUALS));
                        continue;
                    }
                    if (!StringUtils.isEmpty((CharSequence)startNumber) || StringUtils.isEmpty((CharSequence)endNumber)) continue;
                    if (endNumber.indexOf(".") <= 0) {
                        filter.getFilterItems().add(new FilterItemInfo(property, (Object)Integer.valueOf(endNumber), CompareType.LESS_EQUALS));
                        continue;
                    }
                    filter.getFilterItems().add(new FilterItemInfo(property, (Object)new BigDecimal(endNumber), CompareType.LESS_EQUALS));
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)startNumber) || StringUtils.isEmpty((CharSequence)selectData) || selectData.equals("range")) continue;
                if (startNumber.indexOf(".") <= 0) {
                    filter.getFilterItems().add(new FilterItemInfo(property, (Object)Integer.valueOf(startNumber), CompareType.getEnum((String)selectData)));
                    continue;
                }
                if (startNumber.indexOf(".") - 1 <= -1) continue;
                filter.getFilterItems().add(new FilterItemInfo(property, (Object)new BigDecimal(startNumber), CompareType.getEnum((String)selectData)));
            }
        }
        return filter;
    }

    public static String getOrgIncludeSubSQL(Map subMap) throws SHRWebException {
        ArrayList dataItem = (ArrayList)subMap.get("dataItem");
        if (dataItem.size() <= 0) {
            return null;
        }
        String longNumber = ((Map)dataItem.get(0)).get("longNumber") == null ? "" : ((Map)dataItem.get(0)).get("longNumber").toString();
        int level = 0;
        if (null != subMap.get("includeSub") && !StringUtils.isEmpty((CharSequence)String.valueOf(subMap.get("includeSub")).trim())) {
            level = Integer.parseInt(String.valueOf(subMap.get("includeSub")).trim());
        }
        if (StringUtils.isEmpty((CharSequence)longNumber)) {
            longNumber = FastFilterUtil.getAdminOrgUnitLongNumberById(((Map)dataItem.get(0)).get("id"));
        }
        int targetLevel = longNumber.split("!").length + level;
        String sql = "SELECT FID FROM T_ORG_ADMIN WHERE (FLONGNUMBER = '" + longNumber + "' or FLONGNUMBER LIKE '" + longNumber + "!%') ";
        if (level > 0) {
            sql = sql + " and Flevel <=" + targetLevel;
        }
        if (dataItem.size() > 1) {
            sql = "SELECT FID FROM T_ORG_ADMIN WHERE (FLONGNUMBER = '" + longNumber + "' or FLONGNUMBER LIKE '" + longNumber + "!%')";
            if (level > 0) {
                sql = "SELECT FID FROM T_ORG_ADMIN WHERE ((FLONGNUMBER = '" + longNumber + "' or FLONGNUMBER LIKE '" + longNumber + "!%') and Flevel <=" + targetLevel + ")";
            }
        }
        for (int i = 0; i < dataItem.size(); ++i) {
            if (i <= 0) continue;
            String string = longNumber = ((Map)dataItem.get(i)).get("longNumber") == null ? "" : ((Map)dataItem.get(i)).get("longNumber").toString();
            if (StringUtils.isEmpty((CharSequence)longNumber)) {
                longNumber = FastFilterUtil.getAdminOrgUnitLongNumberById(((Map)dataItem.get(i)).get("id"));
            }
            if (StringUtils.isEmpty((CharSequence)longNumber)) continue;
            targetLevel = longNumber.split("!").length + level;
            sql = level > 0 ? sql + " or ((FLONGNUMBER ='" + longNumber + "' or FLONGNUMBER LIKE '" + longNumber + "!%') and Flevel <=" + targetLevel + ")" : sql + " or (FLONGNUMBER = '" + longNumber + "'  or FLONGNUMBER LIKE '" + longNumber + "!%')";
        }
        return sql;
    }

    public static Set<String> getOrgIds(Map subMap) throws SHRWebException {
        ArrayList dataItem = (ArrayList)subMap.get("dataItem");
        if (dataItem.size() <= 0) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < dataItem.size(); ++i) {
            String id = (String)((Map)dataItem.get(i)).get("id");
            idSet.add(id);
        }
        return idSet;
    }

    public static String getOrgIdStr(Map subMap) throws SHRWebException {
        Set<String> orgIds = FastFilterUtil.getOrgIds(subMap);
        String ids = "";
        String sql = "";
        if (orgIds != null && orgIds.size() > 0) {
            for (String orgId : orgIds) {
                ids = ids + "'" + orgId + "',";
            }
            if (ids.length() > 0) {
                ids = ids.substring(0, ids.length() - 1);
            }
            sql = "SELECT FID FROM T_ORG_ADMIN WHERE FID in (" + ids + ")";
        }
        return sql;
    }

    public static String getAdminOrgUnitLongNumberById(Object id) throws SHRWebException {
        AdminOrgUnitInfo adminOrgUnitInfo;
        try {
            try {
                adminOrgUnitInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id.toString()));
            }
            catch (BOSException e) {
                throw new SHRWebException(e.getMessage(), e);
            }
        }
        catch (EASBizException e) {
            throw new SHRWebException(e.getMessage(), e);
        }
        return adminOrgUnitInfo.getLongNumber();
    }

    @Deprecated
    public static Set generateEnumSet(String[] values, Map enumMap, String dataType) {
        HashSet<Object> sets = new HashSet<Object>();
        for (String str : values) {
            if (null == enumMap) {
                if ("int".equals(dataType)) {
                    sets.add(Integer.parseInt(str));
                    continue;
                }
                if ("String".equals(dataType)) {
                    sets.add(str);
                    continue;
                }
                if ("double".equals(dataType)) {
                    sets.add(Double.parseDouble(str));
                    continue;
                }
                if ("float".equals(dataType)) {
                    sets.add(Float.valueOf(Float.parseFloat(str)));
                    continue;
                }
                if ("long".equals(dataType)) {
                    sets.add(Long.parseLong(str));
                    continue;
                }
                sets.add(str);
                continue;
            }
            Object obj = FastFilterUtil.getEnumValue(str, enumMap);
            if (null == obj) continue;
            sets.add(obj);
        }
        return sets;
    }

    @Deprecated
    private static Object getEnumValue(String string, Map enumMap) {
        Iterator iterator = enumMap.values().iterator();
        Object enumObject = null;
        Object enumVal = null;
        while (iterator.hasNext()) {
            long val;
            enumObject = iterator.next();
            if (enumObject instanceof IntEnum) {
                int val2 = ((IntEnum)enumObject).getValue();
                if (val2 != Integer.parseInt(string)) continue;
                enumVal = val2;
                break;
            }
            if (enumObject instanceof StringEnum) {
                String val3 = ((StringEnum)enumObject).getValue();
                if (!val3.equals(string)) continue;
                enumVal = val3;
                break;
            }
            if (enumObject instanceof DoubleEnum) {
                double val4 = ((DoubleEnum)enumObject).getValue();
                if (val4 != Double.parseDouble(string)) continue;
                enumVal = val4;
                break;
            }
            if (enumObject instanceof DynamicEnum) {
                String val5 = ((DynamicEnum)enumObject).getValue();
                if (!val5.equals(string)) continue;
                enumVal = val5;
                break;
            }
            if (enumObject instanceof FloatEnum) {
                float val6 = ((FloatEnum)enumObject).getValue();
                if (val6 != Float.parseFloat(string)) continue;
                enumVal = Float.valueOf(val6);
                break;
            }
            if (!(enumObject instanceof LongEnum) || (val = ((LongEnum)enumObject).getValue()) != Long.parseLong(string)) continue;
            enumVal = val;
            break;
        }
        return enumVal;
    }

    public static Set generateEnumSet(String[] values, String enumSource, String dataType) {
        HashSet<Object> sets = new HashSet<Object>();
        for (String str : values) {
            if (!StringUtils.isEmpty((CharSequence)dataType)) {
                if ("int".equals(dataType)) {
                    sets.add(Integer.parseInt(str));
                    continue;
                }
                if ("String".equals(dataType)) {
                    sets.add(str);
                    continue;
                }
                if ("double".equals(dataType)) {
                    sets.add(Double.parseDouble(str));
                    continue;
                }
                if ("float".equals(dataType)) {
                    sets.add(Float.valueOf(Float.parseFloat(str)));
                    continue;
                }
                if ("long".equals(dataType)) {
                    sets.add(Long.parseLong(str));
                    continue;
                }
                sets.add(str);
                continue;
            }
            Object obj = FastFilterUtil.getEnumValue(str, enumSource);
            if (null == obj) continue;
            sets.add(obj);
        }
        return sets;
    }

    public static boolean getBoolean(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        if ("0".equalsIgnoreCase(str)) {
            return false;
        }
        if ("1".equals(str)) {
            return true;
        }
        return Boolean.parseBoolean(str);
    }

    private static int getBoolean0(String str) {
        if ("false".equals(str)) {
            return 0;
        }
        if ("true".equals(str)) {
            return 1;
        }
        return Integer.parseInt(str);
    }

    private static Object getEnumValue(String value, String enumSource) {
        Object _enum_ = MetaDataUtil.findEnumByValue((String)enumSource, (Object)value);
        if (null != _enum_) {
            if (_enum_ instanceof IntEnum) {
                return ((IntEnum)_enum_).getValue();
            }
            if (_enum_ instanceof StringEnum) {
                return ((StringEnum)_enum_).getValue();
            }
            if (_enum_ instanceof DoubleEnum) {
                return ((DoubleEnum)_enum_).getValue();
            }
            if (_enum_ instanceof DynamicEnum) {
                return ((DynamicEnum)_enum_).getValue();
            }
            if (_enum_ instanceof FloatEnum) {
                return Float.valueOf(((FloatEnum)_enum_).getValue());
            }
            if (_enum_ instanceof LongEnum) {
                return ((LongEnum)_enum_).getValue();
            }
        }
        return null;
    }

    public static String getParten() {
        return "yyyy-MM-dd";
    }

    public static Set<String> generateSet(String[] values) {
        HashSet<String> sets = new HashSet<String>();
        for (String string : values) {
            if (StringUtils.isEmpty((CharSequence)string)) continue;
            sets.add(string);
        }
        return sets;
    }

    public static Date getSqlDate(String dateString, String parten) throws SHRWebException {
        SimpleDateFormat sdf = new SimpleDateFormat(parten);
        Date date = null;
        try {
            date = new Date(sdf.parse(dateString).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new SHRWebException(e);
        }
        return date;
    }
}

