/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.cp.eip.sso.otp.OTPManager;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.ContextFactory;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.guilogin.web.wechart.WeChartUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHRInterfaceLoginUtil {
    private static final Logger logger = LoggerFactory.getLogger(SHRInterfaceLoginUtil.class);

    public static Context login(HttpServletRequest request, HttpServletResponse response) {
        Context ctx = null;
        try {
            String userAuthPattern;
            HttpSession session = request.getSession();
            ctx = (Context)session.getAttribute("pureWebContext");
            if (ctx != null) {
                return ctx;
            }
            String userNumber = request.getParameter("username");
            String password = request.getParameter("password");
            String dataCenter = request.getParameter("dataCenter");
            if (dataCenter == null || "".equals(dataCenter)) {
                dataCenter = OTPManager.getAutoLoginDataCenter();
            }
            String easSessionId = Uuid.create().toString();
            String locale = request.getParameter("locale");
            if (!StringUtils.isEmpty((String)locale)) {
                if (!(locale.equalsIgnoreCase("L1") || locale.equalsIgnoreCase("L2") || locale.equalsIgnoreCase("L3"))) {
                    locale = "L2";
                }
            } else {
                locale = "L2";
            }
            if ((userAuthPattern = request.getParameter("userAuthPattern")) == null || userAuthPattern.trim().length() == 0) {
                userAuthPattern = "OTP";
            }
            String newuser = WeChartUtil.authenWechart((HttpServletRequest)request, (String)userAuthPattern, (String)userNumber, (String)password, (String)dataCenter, (String)easSessionId, (String)locale);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("user", userNumber);
            param.put("dataCenter", dataCenter);
            UserInfo user = SHRInterfaceLoginUtil.getUserInfo(userNumber, dataCenter);
            ctx = SHRInterfaceLoginUtil.loginSHR(user, param);
            session.setAttribute("pureWebContext", (Object)ctx);
            SHRContext context = ContextFactory.getContext(request.getSession().getServletContext(), (ServletRequest)request, (ServletResponse)response);
            if (context != null) {
                ConfigMDUtil.setContextToThread((Context)context.getContext());
            }
            logger.error("login shr sucess");
        }
        catch (Exception e) {
            logger.error("login shr error:" + e.getMessage());
        }
        return ctx;
    }

    public static Context loginSHR(UserInfo user, HashMap param) throws Exception {
        String userName = user.getNumber();
        String dataCenter = (String)param.get("dataCenter");
        String authType = "BaseTrdLtpaToken";
        LtpaToken token = LtpaTokenManager.generate((String)userName, (String)LtpaTokenManager.getDefaultLtpaConfig());
        String authPassword = token.getTokenStr();
        String encodePwd = CryptoTean.encrypt((String)userName, (String)authPassword);
        Locale locale = new Locale("l2");
        String clientIP = "UNKNOW";
        DCInfo dcInfo = OTPManager.getDCInfo((String)dataCenter);
        LoginContext loginCtx = new LoginContext(userName, encodePwd, "eas", dcInfo.getNumber(), locale, clientIP, clientIP);
        loginCtx.put("UserAuthPattern", (Object)authType);
        loginCtx.put("dbTypeCode", (Object)dcInfo.getDBName());
        loginCtx.put("dbType", (Object)DbType.getName((int)dcInfo.getDBType()));
        loginCtx.put("ClientIP", (Object)clientIP);
        String contextID = (String)loginCtx.get("contextID");
        if (contextID != null) {
            loginCtx.setContextID(contextID);
        }
        Context userContext = new Context((IObjectPK)new ObjectUuidPK(user.getId()), loginCtx.getSlnName(), loginCtx.getAis(), loginCtx.getLocale(), loginCtx.getContextID());
        loginCtx.setContextID(userContext.getContextID());
        ILoginModule loginModule = LoginModuleFactory.getRemoteInstance();
        Context userCtx = loginModule.fullLogin(loginCtx);
        WebContextUtil.initRpcConfig((Context)userCtx);
        return userCtx;
    }

    public static UserInfo getUserInfo(String userNumber, String dataCenter) {
        Context ctx = new Context(null, "eas", dataCenter, new Locale("l2"));
        UserInfo user = null;
        String l = LocaleUtils.getShortCode((Context)ctx);
        Object[] params = new Object[]{userNumber};
        String sql = "select FID,FNAME_" + l + ",FNumber from t_pm_user where FNumber = ?";
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (dataSet.next()) {
                user = new UserInfo();
                user.setId(BOSUuid.read((String)dataSet.getString("FID")));
                user.setName(dataSet.getString("FNAME_" + l));
                user.setNumber(dataSet.getString("FNumber"));
            }
        }
        catch (Exception e) {
            user = null;
            logger.error("SHRInterfaceLoginUtil == getUserId== " + e);
        }
        return user;
    }
}

