/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.web.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.shr.base.permission.api.service.SHRFunctionPermissionService;
import com.kingdee.shr.base.syssetting.app.cache.PermItemURLCache;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.permission.data.ShrCheckDataPermissionUtil;
import com.kingdee.shr.base.syssetting.util.SHRPermissionWebUtils;
import com.kingdee.shr.base.syssetting.util.WafUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.context.RenderContext;
import com.kingdee.shr.base.syssetting.web.dynamic.model.UIViewInfo;
import com.kingdee.shr.base.syssetting.web.dynamic.util.XMLUtil;
import com.kingdee.shr.base.syssetting.web.util.Button;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.xpath.XPath;

public abstract class SHRWebPermissionHelper {
    private static Logger logger = Logger.getLogger(SHRWebPermissionHelper.class);

    public static boolean currentPageButtonVisible(RenderContext context, String componentName) {
        return SHRWebPermissionHelper.currentPageButtonHasFunctionPermission(context, componentName);
    }

    private static Boolean currentPageButtonVisible(UIViewInfo uiViewInfo, String componentName) {
        List<Button> listButtons = SHRWebPermissionHelper.getButtonsFromView(uiViewInfo);
        boolean isSHRButton = SHRWebPermissionHelper.isButton(componentName, listButtons);
        boolean isDropDownButton = SHRWebPermissionHelper.isDropDownButton(componentName, listButtons);
        if (!isSHRButton && !isDropDownButton) {
            return true;
        }
        if (!isDropDownButton && !SHRWebPermissionHelper.buttonIsVisible(uiViewInfo, componentName)) {
            return false;
        }
        return null;
    }

    private static boolean buttonIsVisible(UIViewInfo uiViewInfo, String componentName) {
        boolean flag = false;
        List<Button> listButtons = SHRWebPermissionHelper.getButtonsFromView(uiViewInfo);
        for (Button button : listButtons) {
            if (!componentName.equalsIgnoreCase(button.getName()) || !"true".equalsIgnoreCase(button.getVisible())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean getButtonVisible(Element element, String componentName) {
        boolean flag = false;
        Attribute buttonName = element.getAttribute("name");
        Attribute buttonVisible = element.getAttribute("visible");
        if ("dropDownButton".equals(element.getName())) {
            List dropDownButtonChildren = element.getChildren();
            for (Element element2 : dropDownButtonChildren) {
                Attribute buttonName0 = element2.getAttribute("name");
                Attribute buttonVisible0 = element2.getAttribute("visible");
                if (StringUtils.isEmpty((String)componentName) || !componentName.equals(buttonName0.getValue()) || buttonVisible0 != null && !"true".equalsIgnoreCase(buttonVisible0.getValue())) continue;
                flag = true;
                break;
            }
        }
        if (!StringUtils.isEmpty((String)componentName) && componentName.equals(buttonName.getValue()) && (buttonVisible == null || "true".equalsIgnoreCase(buttonVisible.getValue()))) {
            flag = true;
        }
        return flag;
    }

    public static boolean isHRButtonVisible(Element element, String componentName) {
        boolean flag = false;
        Attribute buttonName = element.getAttribute("name");
        Attribute buttonVisible = element.getAttribute("visible");
        if ("dropDownButton".equals(element.getName())) {
            List dropDownButtonChildren = element.getChildren();
            for (Element element2 : dropDownButtonChildren) {
                Attribute buttonName0 = element2.getAttribute("name");
                Attribute buttonVisible0 = element2.getAttribute("visible");
                if (StringUtils.isEmpty((String)componentName) || !componentName.equals(buttonName0.getValue()) || buttonVisible0 != null && !"true".equalsIgnoreCase(buttonVisible0.getValue())) continue;
                flag = true;
                break;
            }
        }
        if (!StringUtils.isEmpty((String)componentName) && componentName.equals(buttonName.getValue()) && (buttonVisible == null || "true".equalsIgnoreCase(buttonVisible.getValue()))) {
            flag = true;
        }
        return flag;
    }

    public static List<Button> getButtonsFromView(UIViewInfo uiViewInfo) {
        ArrayList<Button> allButtonList = new ArrayList<Button>();
        try {
            String content = uiViewInfo.getContent();
            Document doc = XMLUtil.parseXML(content);
            Element rootElement = doc.getRootElement();
            String dropDownButtonSearchPattern = "//dropDownButton";
            String buttonSearchPattern = "//button";
            List<Button> dropDownButtonList = SHRWebPermissionHelper.doFindButtons(rootElement, dropDownButtonSearchPattern);
            List<Button> buttonList = SHRWebPermissionHelper.doFindButtons(rootElement, buttonSearchPattern);
            if (dropDownButtonList == null || dropDownButtonList.size() == 0) {
                allButtonList.addAll(buttonList);
                return allButtonList;
            }
            allButtonList.addAll(buttonList);
            for (Button dropButton : dropDownButtonList) {
                Set<Button> subButton = dropButton.getDropDownSubButton();
                for (Button button : subButton) {
                    if (allButtonList.contains(button)) continue;
                    allButtonList.add(button);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return allButtonList;
    }

    private static List<Button> doFindButtons(Element rootElement, String searchPattern) throws JDOMException {
        ArrayList<Button> listButtons = new ArrayList<Button>();
        XPath x = XPath.newInstance((String)searchPattern);
        List buttonElements = x.selectNodes((Object)rootElement);
        for (Element element : buttonElements) {
            Button button = new Button();
            String buttonName = element.getName();
            String elementName = element.getName();
            String visible = element.getAttributeValue("visible");
            String elementValue = element.getAttributeValue("name");
            String elementCaption = element.getAttributeValue("caption");
            button.setName(elementValue);
            button.setCaption(elementCaption);
            if ("dropDownButton".equalsIgnoreCase(elementName)) {
                button.setType("dropDownButton");
                HashSet<Button> set = null;
                if (null == button.getDropDownSubButton()) {
                    set = new HashSet<Button>();
                    List subElements = element.getChildren();
                    for (Element element2 : subElements) {
                        String subElementVisible = element2.getAttributeValue("visible");
                        String subElementName = element2.getAttributeValue("name");
                        String subElementCaption = element2.getAttributeValue("caption");
                        Button subButton = new Button();
                        subButton.setName(subElementName);
                        subButton.setType("button");
                        subButton.setCaption(subElementCaption);
                        subButton.setVisible(subElementVisible);
                        set.add(subButton);
                    }
                    button.setDropDownSubButton(set);
                }
            } else if ("button".equalsIgnoreCase(elementName)) {
                button.setType("button");
            }
            visible = StringUtils.isEmpty((String)visible) || "true".equalsIgnoreCase(visible) ? "true" : "false";
            button.setVisible(visible);
            String caption = element.getAttributeValue("caption");
            button.setCaption(caption);
            listButtons.add(button);
        }
        return listButtons;
    }

    public static boolean dropDownButtonVisibleBySubButtonVisible(RenderContext context, String componentName) {
        UIViewInfo uiViewInfo = (UIViewInfo)context.get("viewMeta");
        List<Button> listButtons = new ArrayList<Button>();
        try {
            Document doc = XMLUtil.parseXML(uiViewInfo.getContent());
            Element rootElement = doc.getRootElement();
            String dropDownButtonSearchPattern = "//dropDownButton";
            listButtons = SHRWebPermissionHelper.doFindButtons(rootElement, dropDownButtonSearchPattern);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (SHRWebPermissionHelper.isDropDownButton(componentName, listButtons)) {
            return SHRWebPermissionHelper.dropDownButtonHasFunctionPermission(context, componentName, listButtons);
        }
        return true;
    }

    public static boolean dropDownButtonHasFunctionPermission(RenderContext context, String componentName, List<Button> listButtons) {
        boolean flag = false;
        block0: for (Button button : listButtons) {
            if (!componentName.equalsIgnoreCase(button.getName()) || !"true".equalsIgnoreCase(button.getVisible())) continue;
            Set<Button> subButtons = button.getDropDownSubButton();
            for (Button subButton : subButtons) {
                flag = SHRWebPermissionHelper.currentPageButtonHasFunctionPermission(context, subButton.getName());
                if (!flag) continue;
                flag = true;
                break block0;
            }
        }
        return flag;
    }

    public static boolean isButton(String componentName, List<Button> listButtons) {
        boolean flag = false;
        for (Button button : listButtons) {
            if (!componentName.equalsIgnoreCase(button.getName()) || !"button".equalsIgnoreCase(button.getType())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isDropDownButton(String componentName, List<Button> listButtons) {
        boolean flag = false;
        for (Button button : listButtons) {
            if (!componentName.equalsIgnoreCase(button.getName()) || !button.isDropDownButton()) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean currentPageButtonHasFunctionPermission(RenderContext context, String componentName) {
        UIViewInfo uiViewInfo = (UIViewInfo)context.get("viewMeta");
        return SHRWebPermissionHelper.currentPageButtonHasFunctionPermission0(componentName, uiViewInfo);
    }

    public static boolean currentPageButtonHasFunctionPermission0(String componentName, UIViewInfo uiViewInfo) {
        HttpServletRequest request;
        String uipk = uiViewInfo.getUipk();
        if (uipk.indexOf("$") > -1) {
            uipk = uipk.split("\\$")[0];
        }
        if (ShrCheckDataPermissionUtil.checkIsShrWfButNoPermitemPermission(request = (HttpServletRequest)SHRContext.getInstance().getRequest())) {
            return true;
        }
        String shruicode = SHRPermissionWebUtils.getShrUiCode(request);
        String module = request.getParameter("module");
        String currentRequestButtonPermItemUrl = SHRPermissionWebUtils.doAssemblePermissionURL(null, "/dynamic.do", uipk, componentName, module, shruicode);
        return SHRWebPermissionHelper.doCheckFunctionPermission(currentRequestButtonPermItemUrl);
    }

    public static boolean doCheckFunctionPermission(String permissionUrl) {
        boolean flag = true;
        try {
            Context ctx = SHRContext.getInstance().getContext();
            PermItemInfo permItemInfo = SHRWebPermissionHelper.getPermisionInfoByUrl(ctx, permissionUrl);
            if (null != permItemInfo) {
                return SHRWebPermissionHelper.hasFunctionPermission(ctx, permItemInfo);
            }
            flag = true;
        }
        catch (SHRWebException e) {
            flag = false;
        }
        return flag;
    }

    public static boolean hasFunctionPermission(String uipk, String componentName) throws SHRWebException {
        return SHRWebPermissionHelper.hasFunctionPermission(SHRWebPermissionHelper.assembleCurrentRequestButtonPermItemUrl(uipk, componentName));
    }

    public static String assembleCurrentRequestButtonPermItemUrl(String uipk, String buttonName) {
        String url = MessageFormat.format("/dynamic.do?method={0}#uri={1}", buttonName, uipk);
        logger.info((Object)("[ SHRPermissionWebUtils.assembleCurrentRequestPermItemUrl url is " + url + " ]"));
        return url;
    }

    public static boolean hasFunctionPermission(String url) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        PermItemInfo permItemInfo = SHRWebPermissionHelper.getPermisionInfoByUrl(ctx, url);
        return SHRWebPermissionHelper.hasFunctionPermission(ctx, permItemInfo);
    }

    public static String assembleRequestUrl(HttpServletRequest request) {
        String url = request.getServletPath();
        String uipk = request.getParameter("uipk");
        String method = WafUtils.getRequestAction(request);
        url = url + "?method=" + method;
        if (!StringUtils.isEmpty((String)uipk)) {
            url = url + "#uri=" + uipk;
        }
        return url;
    }

    public static boolean hasFunctionPermission(Context ctx, PermItemInfo permItemInfo) throws SHRWebException {
        boolean flag = true;
        if (permItemInfo != null && !StringUtils.isEmpty((String)permItemInfo.getName())) {
            try {
                SHRFunctionPermissionService.checkCurrnetUserFunctionPermission((Context)ctx, (PermItemInfo)permItemInfo);
            }
            catch (Exception e) {
                flag = false;
            }
        }
        return flag;
    }

    public static PermItemInfo getPermisionInfoByUrl(Context ctx, String url) throws SHRWebException {
        PermItemInfo permItemInfo = PermItemURLCache.getPermItemInfoByURL((Context)ctx, (String)url);
        return permItemInfo;
    }
}

