<Data version="20170616">
	<Sources>
		<BizMetaSource name="s1625623871023" bizMetaType="EASDBCenter" dbCenterId="SP1UPD861" type="BizMeta">
			<UserSQLs>
				<UserSQL name="dm1625626235278" sqlType="KSQL"><![CDATA[select case when a.BALANCE is null then 0 else a.BALANCE end BALANCE,
	case when a.outAmount is null then 0 else a.outAmount end outAmount, 
	case when a.inAmount is null then 0 else a.inAmount end inAmount,
	case when a.bananceDate is null then a.transDetailDate else a.bananceDate end bizDate,
a.AccountBankID,a.currencyId,curr.FNAME_L2 currname,a.companyid,o.FNAME_L2 companyName from
(select balance.FBALANCE BALANCE,
	case when balance.FAccountBankID is null then transDetail.fbankaccountid else balance.FAccountBankID end AccountBankID,
	case when balance.fcurrencyid is null then transDetail.fcurrencyid else balance.fcurrencyid end currencyId,
	case when balance.FCOMPANYID is null then transDetail.FCOMPANYID else balance.FCOMPANYID end companyid,
	balance.fbizdate bananceDate,transDetail.outAmount,transDetail.inAmount,transDetail.fbizdate transDetailDate from
	(select * from T_BE_AccountBankBalance where fbizDate >=CURDATE()-10 ) balance
	full join 
	(select sum(fDebitAmount) outAmount,sum(fCreditAmount) inAmount,fbankaccountid,fcurrencyid,fbizdate,FCOMPANYID from T_BE_TransDetail  where fbizdate>=CURDATE()-10 group by fbankaccountid,fcurrencyid,fbizdate,FCOMPANYID) transDetail on transDetail.fbankaccountid = balance.FAccountBankID and transDetail.fcurrencyid = balance.fcurrencyid and transDetail.FCOMPANYID = balance.FCOMPANYID and transDetail.fbizdate = balance.fbizdate
) a 
left join T_ORG_BaseUnit o on o.fid = a.companyid
left join T_BD_AccountBanks banks on banks.fid = a.AccountBankID
left join T_BD_Currency curr on curr.fid = a.currencyId]]></UserSQL>
				<UserSQL name="dm1625623946374" sqlType="KSQL"><![CDATA[select temp.DEBITAMOUNT+temp.CREDITAMOUNT total,temp.FBIZDATE,temp.FCOMPANYID,temp.FBANK,bank2.FNAME_L2 from 
	(select a.DEBITAMOUNT,a.CREDITAMOUNT,a.FBIZDATE,a.FBANK,a.FCOMPANYID,
	case when (SELECT CHARINDEX('!',bank.FLONGNUMBER))>0 then substring(bank.FLONGNUMBER ,0,SELECT CHARINDEX('!',bank.FLONGNUMBER)-1) else bank.FLONGNUMBER end LONGNUMBER from
		(select Journal.DEBITAMOUNT,Journal.CREDITAMOUNT,Journal.FBIZDATE,Journal.FCOMPANYID,banks.FBANK from 
		(select sum(temp.FDEBITAMOUNT*temp.CONVERTRATE) DEBITAMOUNT,sum(temp.FCREDITAMOUNT*temp.CONVERTRATE) CREDITAMOUNT,temp.FACCOUNTBANKID,temp.FBIZDATE,temp.FCOMPANYID 
		from (SELECT j.fid,j.FDEBITAMOUNT,j.FCREDITAMOUNT,j.FACCOUNTBANKID,j.FBIZDATE,j.FCOMPANYID,j.FCURRENCYID,company.FBASECURRENCYID,j.FTYPE,
			case when ExchangeRate.FCONVERTRATE is null then 1 else ExchangeRate.FCONVERTRATE end CONVERTRATE FROM T_CAS_Journal j
			left join T_ORG_Company company on company.fid = j.FCOMPANYID
			left join T_BD_ExchangeAux ExchangeAux on ExchangeAux.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4' and ExchangeAux.FSOURCECURRENCYID = j.FCURRENCYID and ExchangeAux.FTARGETCURRENCYID = company.FBASECURRENCYID 
			left join (SELECT a.FCONVERTRATE,a.FEXCHANGEAUXID
				FROM T_BD_ExchangeRate a
				inner join (SELECT DISTINCT (q.FEXCHANGEAUXID) EXCHANGEAUXID, max(q.FAVAILTIME) AVAILTIME FROM T_BD_ExchangeRate q where q.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4'  GROUP BY q.FEXCHANGEAUXID) b on a.FAVAILTIME = b.AVAILTIME and a.FEXCHANGEAUXID = b.EXCHANGEAUXID
				where a.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4') ExchangeRate on ExchangeRate.FEXCHANGEAUXID = ExchangeAux.fid
			where j.FBIZDATE = CURDATE() and j.FTYPE = 2) temp group by FACCOUNTBANKID,FBIZDATE,FCOMPANYID ) Journal
		
		left join T_BD_AccountBanks banks on banks.fid = Journal.FACCOUNTBANKID) a
	left join T_BD_Bank bank on bank.fid = A.FBANK) temp
left join T_BD_Bank bank2 on bank2.FLONGNUMBER=temp.LONGNUMBER]]></UserSQL>
				<UserSQL name="dm1625624084231" sqlType="KSQL"><![CDATA[select sum(Journal.FDEBITAMOUNT*Journal.CONVERTRATE) DEBITAMOUNT,sum(Journal.FCREDITAMOUNT*Journal.CONVERTRATE) CREDITAMOUNT,month(Journal.FBIZDATE) m from 
	(SELECT j.fid,j.FDEBITAMOUNT,j.FCREDITAMOUNT,j.FACCOUNTBANKID,j.FBIZDATE,j.FCOMPANYID,j.FCURRENCYID,company.FBASECURRENCYID,j.FTYPE,
			case when ExchangeRate.FCONVERTRATE is null then 1 else ExchangeRate.FCONVERTRATE end CONVERTRATE FROM T_CAS_Journal j
			left join T_ORG_Company company on company.fid = j.FCOMPANYID
			left join T_BD_ExchangeAux ExchangeAux on ExchangeAux.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4' and ExchangeAux.FSOURCECURRENCYID = j.FCURRENCYID and ExchangeAux.FTARGETCURRENCYID = company.FBASECURRENCYID 
			left join (SELECT a.FCONVERTRATE,a.FEXCHANGEAUXID
				FROM T_BD_ExchangeRate a
				inner join (SELECT DISTINCT (q.FEXCHANGEAUXID) EXCHANGEAUXID, max(q.FAVAILTIME) AVAILTIME FROM T_BD_ExchangeRate q where q.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4'  GROUP BY q.FEXCHANGEAUXID) b on a.FAVAILTIME = b.AVAILTIME and a.FEXCHANGEAUXID = b.EXCHANGEAUXID
				where a.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4') ExchangeRate on ExchangeRate.FEXCHANGEAUXID = ExchangeAux.fid) Journal
where year(Journal.FBIZDATE) = year(CURDATE()) and FTYPE = 2 group by month(Journal.FBIZDATE)]]></UserSQL>
				<UserSQL name="dm1625624715652" sqlType="KSQL"><![CDATA[select  total.bankBalance,total.journalBalance,case when banks.FIsSetBankInterface = 1 then total.bankBalance else total.journalBalance end balance,total.currencyId,curr.FNAME_L2 currencyName,total.accountBankId,banks.FNAME_L2 bankName,total.companyId,o.FNAME_L2 companyName from
	(select bankBalance,subResult+amount journalBalance,
		case when bankBalance is null then FCurrencyId else bankCURRENCY end currencyId,
		case when bankBalance is null then FAccountBankID else bankACCOUNTBANK end accountBankId,
		case when bankBalance is null then FCompanyId else bankCOMPANY end companyId from
		(select case when journal.subResult is null then 0 else journal.subResult end subResult,journal.amount,journal.FCurrencyId,journal.FAccountBankID,journal.FCompanyId,be.bankBalance bankBalance,be.FACCOUNTBANKID bankACCOUNTBANK,be.FCURRENCYID bankCURRENCY,be.FCOMPANYID bankCOMPANY from 
		 (select subResult,sum(FDebitAmount-FCreditAmount) amount,FCurrencyId,FAccountBankID,FCompanyId from 
		 (select balance.SubResult,
		 case when summary.FDebitAmount is null then 0 else summary.FDebitAmount end FDebitAmount,
		 case when summary.FCreditAmount is null then 0 else summary.FCreditAmount end FCreditAmount,summary.FCreateDate,
		 case when balance.FCurrencyId is null then summary.FCurrencyId else balance.FCurrencyId end FCurrencyId,
		 case when balance.FAccountBankID is null then summary.FAccountBankID else balance.FAccountBankID end FAccountBankID,
		 case when balance.FCompanyId is null then summary.FCompanyId else balance.FCompanyId end FCompanyId
		 from 
		  (select a.FDebitAmount,a.FCreditAmount,a.FCreateDate,a.FCurrencyId,a.FAccountBankID,a.FCompanyId from t_cas_JournalSummary a
			left join (select sysStaCtr.FCompanyID CompanyID,per.FBEGINDATE BEGINDATE from T_BD_SystemStatusCtrol sysStaCtr
							left join T_BD_SystemStatus sysSta  on sysStaCtr.FSystemStatusID=sysSta.FID  
							left join T_BD_Period per on sysStaCtr.FCurrentPeriodID = per.fid
							where sysSta.FName=7) System on System.CompanyID = a.FCompanyId
			where a.FCreateDate >=System.BEGINDATE and a.FCreateDate <= CURDATE() and a.FType = 2 ) as summary
		full join 
		(select a.FMonthStartAmt SubResult,a.FCurrencyId,a.FAccountBankID,a.FCompanyId from T_CAS_JournalBalance  a
		left join (select sysStaCtr.FCompanyID CompanyID,sysStaCtr.FCurrentPeriodID CurrentPeriodID from T_BD_SystemStatusCtrol sysStaCtr
				left join T_BD_SystemStatus sysSta  on sysStaCtr.FSystemStatusID=sysSta.FID
				where sysSta.FName=7) System on System.CompanyID = a.FCompanyId
		where a.FPeriodId =System.CurrentPeriodID and a.FIsInit =0  and a.FType = 2) balance  on summary.FCurrencyId=balance.FCurrencyId and  summary.FAccountBankID = balance.FAccountBankID and summary.FCompanyId = balance.FCompanyId) 
		 group by FAccountBankID,FCurrencyId,FCompanyId,subResult) journal
		  
		 full join 
		 (select FBALANCE bankBalance,FCOMPANYID,FACCOUNTBANKID,FCURRENCYID from T_BE_AccountBankBalance where fbizDate = CURDATE()) be on be.FCOMPANYID = journal.FCompanyId and be.FACCOUNTBANKID = journal.FAccountBankID and be.FCURRENCYID = journal.FCurrencyId)) total  
left join T_ORG_BaseUnit o on o.fid = total.companyId
left join T_BD_AccountBanks banks on banks.fid = total.accountBankId
left join T_BD_Currency curr on curr.fid = total.currencyId 
order by balance desc]]></UserSQL>
				<UserSQL name="dm1625624403202" sqlType="KSQL"><![CDATA[select (a.subResult+a.amount)*a.CONVERTRATE journalBalance,a.subResult,a.amount,a.FCOMPANYID,a.LONGNUMBER,bank1.FNAME_L2 from				
	(select j.subResult,j.amount,j.FCurrencyId,j.FAccountBankID,j.FCompanyId,
	  case when (SELECT CHARINDEX('!',bank.FLONGNUMBER))>0 then substring(bank.FLONGNUMBER ,0,SELECT CHARINDEX('!',bank.FLONGNUMBER)-1) else bank.FLONGNUMBER end LONGNUMBER,
	  case when ExchangeRate.FCONVERTRATE is null then 1 else ExchangeRate.FCONVERTRATE end CONVERTRATE from
		(select case when subResult is null then 0 else subResult end subResult,sum(FDebitAmount-FCreditAmount) amount,FCurrencyId,FAccountBankID,FCompanyId from 
				 (select balance.SubResult,
				 case when summary.FDebitAmount is null then 0 else summary.FDebitAmount end FDebitAmount,
				 case when summary.FCreditAmount is null then 0 else summary.FCreditAmount end FCreditAmount,summary.FCreateDate,
				 case when balance.FCurrencyId is null then summary.FCurrencyId else balance.FCurrencyId end FCurrencyId,
				 case when balance.FAccountBankID is null then summary.FAccountBankID else balance.FAccountBankID end FAccountBankID,
				 case when balance.FCompanyId is null then summary.FCompanyId else balance.FCompanyId end FCompanyId
				 from 
				  (select a.FDebitAmount,a.FCreditAmount,a.FCreateDate,a.FCurrencyId,a.FAccountBankID,a.FCompanyId from t_cas_JournalSummary a
					left join T_BD_AccountBanks b on a.FACCOUNTBANKID = b.fid
					left join T_BD_Bank c on b.FBANK = c.FID
					left join (select sysStaCtr.FCompanyID CompanyID,per.FBEGINDATE BEGINDATE from T_BD_SystemStatusCtrol sysStaCtr
									left join T_BD_SystemStatus sysSta  on sysStaCtr.FSystemStatusID=sysSta.FID  
									left join T_BD_Period per on sysStaCtr.FCurrentPeriodID = per.fid
									where sysSta.FName=7) System on System.CompanyID = a.FCompanyId
					where a.FCreateDate >=System.BEGINDATE and a.FCreateDate <= CURDATE() and a.FType = 2 ) as summary
				full join 
				(select a.FMonthStartAmt SubResult,a.FCurrencyId,a.FAccountBankID,a.FCompanyId from T_CAS_JournalBalance  a
				left join T_BD_AccountBanks b on a.FACCOUNTBANKID = b.fid
				left join T_BD_Bank c on b.FBANK = c.FID
				left join (select sysStaCtr.FCompanyID CompanyID,sysStaCtr.FCurrentPeriodID CurrentPeriodID from T_BD_SystemStatusCtrol sysStaCtr
								left join T_BD_SystemStatus sysSta  on sysStaCtr.FSystemStatusID=sysSta.FID
								where sysSta.FName=7) System on System.CompanyID = a.FCompanyId
				where a.FPeriodId =System.CurrentPeriodID and a.FIsInit =0  and a.FType = 2 ) balance  on summary.FCurrencyId=balance.FCurrencyId and  summary.FAccountBankID = balance.FAccountBankID and summary.FCompanyId = balance.FCompanyId)
				 group by FAccountBankID,FCurrencyId,FCompanyId,subResult) j
		left join T_ORG_Company company on company.fid = j.FCOMPANYID
				left join T_BD_ExchangeAux ExchangeAux on ExchangeAux.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4' and ExchangeAux.FSOURCECURRENCYID = j.FCURRENCYID and ExchangeAux.FTARGETCURRENCYID = company.FBASECURRENCYID 
				left join (SELECT a.FCONVERTRATE,a.FEXCHANGEAUXID
					FROM T_BD_ExchangeRate a
					inner join (SELECT DISTINCT (q.FEXCHANGEAUXID) EXCHANGEAUXID, max(q.FAVAILTIME) AVAILTIME FROM T_BD_ExchangeRate q where q.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4'  GROUP BY q.FEXCHANGEAUXID) b on a.FAVAILTIME = b.AVAILTIME and a.FEXCHANGEAUXID = b.EXCHANGEAUXID
					where a.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4') ExchangeRate on ExchangeRate.FEXCHANGEAUXID = ExchangeAux.fid
		left join T_BD_AccountBanks banks on banks.fid = j.FACCOUNTBANKID
		left join T_BD_Bank bank on bank.fid = banks.FBANK) a
left join T_BD_Bank bank1 on bank1.FLONGNUMBER = a.LONGNUMBER]]></UserSQL>
				<UserSQL name="dm1625624529855" sqlType="KSQL"><![CDATA[select (a.subResult+a.amount)*a.CONVERTRATE journalBalance,a.subResult,a.amount,a.FCOMPANYID,a.LONGNUMBER,bank1.FNAME_L2,o.FNAME_L2 companyName from				
	(select j.subResult,j.amount,j.FCurrencyId,j.FAccountBankID,j.FCompanyId,
	  case when (SELECT CHARINDEX('!',bank.FLONGNUMBER))>0 then substring(bank.FLONGNUMBER ,0,SELECT CHARINDEX('!',bank.FLONGNUMBER)-1) else bank.FLONGNUMBER end LONGNUMBER,
	  case when ExchangeRate.FCONVERTRATE is null then 1 else ExchangeRate.FCONVERTRATE end CONVERTRATE from
		(select case when subResult is null then 0 else subResult end subResult,sum(FDebitAmount-FCreditAmount) amount,FCurrencyId,FAccountBankID,FCompanyId from 
				 (select balance.SubResult,
				 case when summary.FDebitAmount is null then 0 else summary.FDebitAmount end FDebitAmount,
				 case when summary.FCreditAmount is null then 0 else summary.FCreditAmount end FCreditAmount,summary.FCreateDate,
				 case when balance.FCurrencyId is null then summary.FCurrencyId else balance.FCurrencyId end FCurrencyId,
				 case when balance.FAccountBankID is null then summary.FAccountBankID else balance.FAccountBankID end FAccountBankID,
				 case when balance.FCompanyId is null then summary.FCompanyId else balance.FCompanyId end FCompanyId
				 from 
				  (select a.FDebitAmount,a.FCreditAmount,a.FCreateDate,a.FCurrencyId,a.FAccountBankID,a.FCompanyId from t_cas_JournalSummary a
					left join T_BD_AccountBanks b on a.FACCOUNTBANKID = b.fid
					left join T_BD_Bank c on b.FBANK = c.FID
					left join (select sysStaCtr.FCompanyID CompanyID,per.FBEGINDATE BEGINDATE from T_BD_SystemStatusCtrol sysStaCtr
									left join T_BD_SystemStatus sysSta  on sysStaCtr.FSystemStatusID=sysSta.FID  
									left join T_BD_Period per on sysStaCtr.FCurrentPeriodID = per.fid
									where sysSta.FName=7) System on System.CompanyID = a.FCompanyId
					where a.FCreateDate >=System.BEGINDATE and a.FCreateDate <= CURDATE() and a.FType = 2) as summary
				full join 
				(select a.FMonthStartAmt SubResult,a.FCurrencyId,a.FAccountBankID,a.FCompanyId from T_CAS_JournalBalance  a
				left join T_BD_AccountBanks b on a.FACCOUNTBANKID = b.fid
				left join T_BD_Bank c on b.FBANK = c.FID
				left join (select sysStaCtr.FCompanyID CompanyID,sysStaCtr.FCurrentPeriodID CurrentPeriodID from T_BD_SystemStatusCtrol sysStaCtr
								left join T_BD_SystemStatus sysSta  on sysStaCtr.FSystemStatusID=sysSta.FID
								where sysSta.FName=7) System on System.CompanyID = a.FCompanyId
				where a.FPeriodId =System.CurrentPeriodID and a.FIsInit =0  and a.FType = 2) balance  on summary.FCurrencyId=balance.FCurrencyId and  summary.FAccountBankID = balance.FAccountBankID and summary.FCompanyId = balance.FCompanyId)
				 group by FAccountBankID,FCurrencyId,FCompanyId,subResult) j
		left join T_ORG_Company company on company.fid = j.FCOMPANYID
				left join T_BD_ExchangeAux ExchangeAux on ExchangeAux.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4' and ExchangeAux.FSOURCECURRENCYID = j.FCURRENCYID and ExchangeAux.FTARGETCURRENCYID = company.FBASECURRENCYID 
				left join (SELECT a.FCONVERTRATE,a.FEXCHANGEAUXID
					FROM T_BD_ExchangeRate a
					inner join (SELECT DISTINCT (q.FEXCHANGEAUXID) EXCHANGEAUXID, max(q.FAVAILTIME) AVAILTIME FROM T_BD_ExchangeRate q where q.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4'  GROUP BY q.FEXCHANGEAUXID) b on a.FAVAILTIME = b.AVAILTIME and a.FEXCHANGEAUXID = b.EXCHANGEAUXID
					where a.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4') ExchangeRate on ExchangeRate.FEXCHANGEAUXID = ExchangeAux.fid
		left join T_BD_AccountBanks banks on banks.fid = j.FACCOUNTBANKID
		left join T_BD_Bank bank on bank.fid = banks.FBANK) a
left join T_BD_Bank bank1 on bank1.FLONGNUMBER = a.LONGNUMBER
 left join T_ORG_BaseUnit o on o.fid = a.FCOMPANYID]]></UserSQL>
				<UserSQL name="dm1625624271866" sqlType="KSQL"><![CDATA[SELECT (journal.FDEBITAMOUNT+journal.FCREDITAMOUNT)*Journal.CONVERTRATE amount,journal.FDEBITAMOUNT*Journal.CONVERTRATE DEBITAMOUNT,journal.FCREDITAMOUNT*Journal.CONVERTRATE CREDITAMOUNT,journal.FCOMPANYID,beBank.FBEPROVINCE FROM 
	(SELECT j.fid,j.FDEBITAMOUNT,j.FCREDITAMOUNT,j.FACCOUNTBANKID,j.FBIZDATE,j.FCOMPANYID,j.FCURRENCYID,company.FBASECURRENCYID,j.FTYPE,
			case when ExchangeRate.FCONVERTRATE is null then 1 else ExchangeRate.FCONVERTRATE end CONVERTRATE FROM T_CAS_Journal j
			left join T_ORG_Company company on company.fid = j.FCOMPANYID
			left join T_BD_ExchangeAux ExchangeAux on ExchangeAux.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4' and ExchangeAux.FSOURCECURRENCYID = j.FCURRENCYID and ExchangeAux.FTARGETCURRENCYID = company.FBASECURRENCYID 
			left join (SELECT a.FCONVERTRATE,a.FEXCHANGEAUXID
				FROM T_BD_ExchangeRate a
				inner join (SELECT DISTINCT (q.FEXCHANGEAUXID) EXCHANGEAUXID, max(q.FAVAILTIME) AVAILTIME FROM T_BD_ExchangeRate q where q.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4'  GROUP BY q.FEXCHANGEAUXID) b on a.FAVAILTIME = b.AVAILTIME and a.FEXCHANGEAUXID = b.EXCHANGEAUXID
				where a.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4') ExchangeRate on ExchangeRate.FEXCHANGEAUXID = ExchangeAux.fid) journal
left join T_BD_AccountBanks banks on banks.fid = journal.FACCOUNTBANKID
left join T_BD_Bank bank on bank.fid = banks.FBANK
left join T_BE_BEBank beBank on beBank.fid = bank.FACCOUNTBANKID
where journal.FTYPE = 2 and month(Journal.FBIZDATE) = month(CURDATE()) and year(Journal.FBIZDATE) = year(CURDATE())]]></UserSQL>
				<UserSQL name="dm1625624337106" sqlType="KSQL"><![CDATA[SELECT (journal.FDEBITAMOUNT+journal.FCREDITAMOUNT)*Journal.CONVERTRATE amount ,journal.FDEBITAMOUNT*Journal.CONVERTRATE DEBITAMOUNT,journal.FCREDITAMOUNT*Journal.CONVERTRATE CREDITAMOUNT,journal.FCOMPANYID,country.FNAME_L2 FROM 
(SELECT j.fid,j.FDEBITAMOUNT,j.FCREDITAMOUNT,j.FACCOUNTBANKID,j.FBIZDATE,j.FCOMPANYID,j.FCURRENCYID,company.FBASECURRENCYID,j.FTYPE,
			case when ExchangeRate.FCONVERTRATE is null then 1 else ExchangeRate.FCONVERTRATE end CONVERTRATE FROM T_CAS_Journal j
			left join T_ORG_Company company on company.fid = j.FCOMPANYID
			left join T_BD_ExchangeAux ExchangeAux on ExchangeAux.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4' and ExchangeAux.FSOURCECURRENCYID = j.FCURRENCYID and ExchangeAux.FTARGETCURRENCYID = company.FBASECURRENCYID 
			left join (SELECT a.FCONVERTRATE,a.FEXCHANGEAUXID
				FROM T_BD_ExchangeRate a
				inner join (SELECT DISTINCT (q.FEXCHANGEAUXID) EXCHANGEAUXID, max(q.FAVAILTIME) AVAILTIME FROM T_BD_ExchangeRate q where q.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4'  GROUP BY q.FEXCHANGEAUXID) b on a.FAVAILTIME = b.AVAILTIME and a.FEXCHANGEAUXID = b.EXCHANGEAUXID
				where a.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4') ExchangeRate on ExchangeRate.FEXCHANGEAUXID = ExchangeAux.fid) journal
left join T_BD_AccountBanks banks on banks.fid = journal.FACCOUNTBANKID
left join T_BD_Country country on country.fid = banks.FCOUNTRYID
where journal.FTYPE = 2 and month(Journal.FBIZDATE) = month(CURDATE()) and year(Journal.FBIZDATE) = year(CURDATE())]]></UserSQL>
			</UserSQLs>
		</BizMetaSource>
		<BizMetaSource name="s1626230914332" bizMetaType="EASDBCenter" dbCenterId="cloud" type="BizMeta">
			<UserSQLs>
				<UserSQL name="dm1626230948430" sqlType="KSQL"><![CDATA[select 	a.balance,a.balanceCurrency,a.TimeDepositBillAmount,a.TimeDepositBillCurrency,a.FinancingAccountAmount,a.FinancingAccountCurrency,a.currencyId,curr.FNAME_L2 currencyName,curr.fid currid,
case when ExchangeRate.FCONVERTRATE is null then 1 else ExchangeRate.FCONVERTRATE end CONVERTRATE from
	 (select balance,balanceCurrency,TimeDepositBillAmount,TimeDepositBillCurrency,FinancingAccountAmount,FinancingAccountCurrency,
	 case when balanceCurrency is not null then balanceCurrency 
		  when TimeDepositBillCurrency is not null then TimeDepositBillCurrency
		  else FinancingAccountCurrency end currencyId
	 from
		(select sum(balance) balance,currencyId balanceCurrency from
			(select  case when banks.FIsSetBankInterface = 1 then total.bankBalance else total.journalBalance end balance,total.currencyId,total.accountBankId from		
				(select bankBalance,subResult+amount journalBalance,
					case when bankBalance is null then FCurrencyId else bankCURRENCY end currencyId,
					case when bankBalance is null then FAccountBankID else bankACCOUNTBANK end accountBankId from			
					(select case when journal.subResult is null then 0 else journal.subResult end subResult,journal.amount,journal.FCurrencyId,journal.FAccountBankID,be.bankBalance bankBalance,be.FACCOUNTBANKID bankACCOUNTBANK,be.FCURRENCYID bankCURRENCY from 
					 (select subResult,sum(FDebitAmount-FCreditAmount) amount,FCurrencyId,FAccountBankID from 
					 (select balance.SubResult,
					 case when summary.FDebitAmount is null then 0 else summary.FDebitAmount end FDebitAmount,
					 case when summary.FCreditAmount is null then 0 else summary.FCreditAmount end FCreditAmount,summary.FCreateDate,
					 case when balance.FCurrencyId is null then summary.FCurrencyId else balance.FCurrencyId end FCurrencyId,
					 case when balance.FAccountBankID is null then summary.FAccountBankID else balance.FAccountBankID end FAccountBankID
					 from 
					  (select a.FDebitAmount,a.FCreditAmount,a.FCreateDate,a.FCurrencyId,a.FAccountBankID,a.FCompanyId from t_cas_JournalSummary a
						left join (select sysStaCtr.FCompanyID CompanyID,per.FBEGINDATE BEGINDATE from T_BD_SystemStatusCtrol sysStaCtr
										left join T_BD_SystemStatus sysSta  on sysStaCtr.FSystemStatusID=sysSta.FID  
										left join T_BD_Period per on sysStaCtr.FCurrentPeriodID = per.fid
										where sysSta.FName=7) System on System.CompanyID = a.FCompanyId
						where a.FCreateDate >=System.BEGINDATE and a.FCreateDate <= CURDATE() and a.FType = 2 ) as summary
					full join 
					(select a.FMonthStartAmt SubResult,a.FCurrencyId,a.FAccountBankID,a.FCompanyId from T_CAS_JournalBalance  a
					left join (select sysStaCtr.FCompanyID CompanyID,sysStaCtr.FCurrentPeriodID CurrentPeriodID from T_BD_SystemStatusCtrol sysStaCtr
									left join T_BD_SystemStatus sysSta  on sysStaCtr.FSystemStatusID=sysSta.FID
									where sysSta.FName=7) System on System.CompanyID = a.FCompanyId
					where a.FPeriodId =System.CurrentPeriodID and a.FIsInit =0  and a.FType = 2) balance  on summary.FCurrencyId=balance.FCurrencyId and  summary.FAccountBankID = balance.FAccountBankID ) 
					 group by FAccountBankID,FCurrencyId,subResult) journal
					  
					 full join 
					 (select FBALANCE bankBalance,FCOMPANYID,FACCOUNTBANKID,FCURRENCYID from T_BE_AccountBankBalance where fbizDate = CURDATE()) be on  be.FACCOUNTBANKID = journal.FAccountBankID and be.FCURRENCYID = journal.FCurrencyId)			 
					 ) total 			 
			left join T_BD_AccountBanks banks on banks.fid = total.accountBankId) 
		group by currencyId) balance
	full join
	(select FCURRENCYID TimeDepositBillCurrency,sum(FREMAMT) TimeDepositBillAmount from T_TD_TimeDepositBill group by FCURRENCYID) TimeDepositBill on TimeDepositBillCurrency = balanceCurrency
	full join 
	(select FCURRENCYID FinancingAccountCurrency,sum(FBALANCE) FinancingAccountAmount from T_IVT_FinancingAccount group by FCURRENCYID) FinancingAccount on FinancingAccountCurrency = balanceCurrency) a
left join T_BD_Currency curr on curr.fid = a.currencyId	

left join T_ORG_Company com  on com.fid = '00000000-0000-0000-0000-000000000000CCE7AED4' 			
left join T_BD_ExchangeAux ExchangeAux on ExchangeAux.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4' and ExchangeAux.FSOURCECURRENCYID = a.currencyId and ExchangeAux.FTARGETCURRENCYID = com.FBASECURRENCYID and ExchangeAux.FEXCHANGETABLEID = com.FBASEEXGTABLEID
left join (SELECT a.fid,a.FCONVERTRATE,a.FEXCHANGEAUXID
	FROM T_BD_ExchangeRate a
	inner join (SELECT DISTINCT (q.FEXCHANGEAUXID) EXCHANGEAUXID, max(q.FAVAILTIME) AVAILTIME FROM T_BD_ExchangeRate q where q.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4'  GROUP BY q.FEXCHANGEAUXID) b on a.FAVAILTIME = b.AVAILTIME and a.FEXCHANGEAUXID = b.EXCHANGEAUXID
	where a.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4') ExchangeRate on ExchangeRate.FEXCHANGEAUXID = ExchangeAux.fid]]></UserSQL>
			</UserSQLs>
		</BizMetaSource>
		<BizMetaSource name="s1658902155102" bizMetaType="EASDBCenter" dbCenterId="ORANEW0518" type="BizMeta">
			<UserSQLs>
				<UserSQL name="dm1658902200566" sqlType="KSQL"><![CDATA[select  total.bankBalance,total.journalBalance,case when banks.FIsSetBankInterface = 1 then total.bankBalance else total.journalBalance end balance,
 total.bankBalance*CONVERTRATE exbankBalance,total.journalBalance*CONVERTRATE exjournalBalance,case when banks.FIsSetBankInterface = 1 then total.bankBalance*CONVERTRATE else total.journalBalance*CONVERTRATE end exbalance,
 total.currencyId,curr.FNAME_L2 currencyName,total.accountBankId,banks.FNAME_L2 bankName,total.companyId,o.FNAME_L2 companyName from
	(select bankBalance,journalBalance,currencyId,accountBankId,companyId,case when ExchangeRate.FCONVERTRATE is null then 1 else ExchangeRate.FCONVERTRATE end CONVERTRATE from 
		 (select bankBalance,subResult+amount journalBalance,
		case when bankBalance is null then FCurrencyId else bankCURRENCY end currencyId,
		case when bankBalance is null then FAccountBankID else bankACCOUNTBANK end accountBankId,
		case when bankBalance is null then FCompanyId else bankCOMPANY end companyId from
		(	select case when journal.subResult is null then 0 else journal.subResult end subResult,journal.amount,journal.FCurrencyId,journal.FAccountBankID,journal.FCompanyId,be.bankBalance bankBalance,be.FACCOUNTBANKID bankACCOUNTBANK,be.FCURRENCYID bankCURRENCY,be.FCOMPANYID bankCOMPANY from 
		 (select subResult,sum(FDebitAmount-FCreditAmount) amount,FCurrencyId,FAccountBankID,FCompanyId from 
		 (select balance.SubResult,
		 case when summary.FDebitAmount is null then 0 else summary.FDebitAmount end FDebitAmount,
		 case when summary.FCreditAmount is null then 0 else summary.FCreditAmount end FCreditAmount,summary.FCreateDate,
		 case when balance.FCurrencyId is null then summary.FCurrencyId else balance.FCurrencyId end FCurrencyId,
		 case when balance.FAccountBankID is null then summary.FAccountBankID else balance.FAccountBankID end FAccountBankID,
		 case when balance.FCompanyId is null then summary.FCompanyId else balance.FCompanyId end FCompanyId
		 from 
		  (select a.FDebitAmount,a.FCreditAmount,a.FCreateDate,a.FCurrencyId,a.FAccountBankID,a.FCompanyId from t_cas_JournalSummary a
			left join (select sysStaCtr.FCompanyID CompanyID,per.FBEGINDATE BEGINDATE from T_BD_SystemStatusCtrol sysStaCtr
							left join T_BD_SystemStatus sysSta  on sysStaCtr.FSystemStatusID=sysSta.FID  
							left join T_BD_Period per on sysStaCtr.FCurrentPeriodID = per.fid
							where sysSta.FName=7) System on System.CompanyID = a.FCompanyId
			where a.FCreateDate >=System.BEGINDATE and a.FCreateDate <= CURDATE() and a.FType = 2 ) as summary
		full join 
		(select a.FMonthStartAmt SubResult,a.FCurrencyId,a.FAccountBankID,a.FCompanyId from T_CAS_JournalBalance  a
		left join (select sysStaCtr.FCompanyID CompanyID,sysStaCtr.FCurrentPeriodID CurrentPeriodID from T_BD_SystemStatusCtrol sysStaCtr
				left join T_BD_SystemStatus sysSta  on sysStaCtr.FSystemStatusID=sysSta.FID
				where sysSta.FName=7) System on System.CompanyID = a.FCompanyId
		where a.FPeriodId =System.CurrentPeriodID and a.FIsInit =0  and a.FType = 2) balance  on summary.FCurrencyId=balance.FCurrencyId and  summary.FAccountBankID = balance.FAccountBankID and summary.FCompanyId = balance.FCompanyId) 
		 group by FAccountBankID,FCurrencyId,FCompanyId,subResult) journal

		 full join 
		 (select FBALANCE bankBalance,FCOMPANYID,FACCOUNTBANKID,FCURRENCYID from T_BE_AccountBankBalance where fbizDate = CURDATE()) be on be.FCOMPANYID = journal.FCompanyId and be.FACCOUNTBANKID = journal.FAccountBankID and be.FCURRENCYID = journal.FCurrencyId ) ) b
		 
		 left join T_ORG_Company company on company.fid = b.companyId
		 
		 left join T_BD_ExchangeAux ExchangeAux on ExchangeAux.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4' and ExchangeAux.FSOURCECURRENCYID = b.currencyId and ExchangeAux.FTARGETCURRENCYID = company.FBASECURRENCYID 
			left join (SELECT c.fid,c.FCONVERTRATE,c.FEXCHANGEAUXID
				FROM T_BD_ExchangeRate c
				inner join (SELECT DISTINCT (q.FEXCHANGEAUXID) EXCHANGEAUXID, max(q.FAVAILTIME) AVAILTIME FROM T_BD_ExchangeRate q where q.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4'  GROUP BY q.FEXCHANGEAUXID) d on c.FAVAILTIME = d.AVAILTIME and c.FEXCHANGEAUXID = d.EXCHANGEAUXID
				where c.FCONTROLUNITID = '00000000-0000-0000-0000-000000000000CCE7AED4') ExchangeRate on ExchangeRate.FEXCHANGEAUXID = ExchangeAux.fid) total  
		 
left join T_ORG_BaseUnit o on o.fid = total.companyId
left join T_BD_AccountBanks banks on banks.fid = total.accountBankId
left join T_BD_Currency curr on curr.fid = total.currencyId 
order by balance desc]]></UserSQL>
			</UserSQLs>
		</BizMetaSource>
	</Sources>
	<ExtractSchedule dayAtMonthly="0" weekAtWeekly="1" time="75600" />
	<Entities>
		<Entity name="dm1625623946374" alias="日结算量排名-按金融机构" associateName="dm1625623946374" directModel="false" source="s1625623871023">
			<Properties>
				<Property name="TOTAL" associateName="TOTAL" alias="交易金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FBIZDATE" associateName="FBIZDATE" alias="日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FBANK" associateName="FBANK" alias="金融机构ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNAME_L2" associateName="FNAME_L2" alias="金融机构" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1625624084231" alias="每月资金流量趋势" associateName="dm1625624084231" directModel="false" source="s1625623871023">
			<Properties>
				<Property name="DEBITAMOUNT" associateName="DEBITAMOUNT" alias="流入金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CREDITAMOUNT" associateName="CREDITAMOUNT" alias="流出金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="M" associateName="M" alias="月" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1625624271866" alias="国内结算量看板" associateName="dm1625624271866" directModel="false" source="s1625623871023">
			<Properties>
				<Property name="AMOUNT" associateName="AMOUNT" alias="交易金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="DEBITAMOUNT" associateName="DEBITAMOUNT" alias="流入金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CREDITAMOUNT" associateName="CREDITAMOUNT" alias="流出金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FBEPROVINCE" associateName="FBEPROVINCE" alias="省份" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1625624337106" alias="国际结算量看板" associateName="dm1625624337106" directModel="false" source="s1625623871023">
			<Properties>
				<Property name="AMOUNT" associateName="AMOUNT" alias="交易金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="DEBITAMOUNT" associateName="DEBITAMOUNT" alias="流入金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CREDITAMOUNT" associateName="CREDITAMOUNT" alias="流出金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNAME_L2" associateName="FNAME_L2" alias="国家" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1625624403202" alias="集团存款银行占比" associateName="dm1625624403202" directModel="false" source="s1625623871023">
			<Properties>
				<Property name="JOURNALBALANCE" associateName="JOURNALBALANCE" alias="交易金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="SUBRESULT" associateName="SUBRESULT" alias="SUBRESULT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="AMOUNT" associateName="AMOUNT" alias="AMOUNT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="LONGNUMBER" associateName="LONGNUMBER" alias="长编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNAME_L2" associateName="FNAME_L2" alias="金融机构" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1625624529855" alias="集团存款单位占比" associateName="dm1625624529855" directModel="false" source="s1625623871023">
			<Properties>
				<Property name="JOURNALBALANCE" associateName="JOURNALBALANCE" alias="交易金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="SUBRESULT" associateName="SUBRESULT" alias="SUBRESULT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="AMOUNT" associateName="AMOUNT" alias="AMOUNT" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="LONGNUMBER" associateName="LONGNUMBER" alias="长编码" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNAME_L2" associateName="FNAME_L2" alias="金融机构" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COMPANYNAME" associateName="COMPANYNAME" alias="公司" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1625624715652" alias="银行账户余额" associateName="dm1625624715652" directModel="false" source="s1625623871023">
			<Properties>
				<Property name="BANKBALANCE" associateName="BANKBALANCE" alias="银企余额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="JOURNALBALANCE" associateName="JOURNALBALANCE" alias="日记账余额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BALANCE" associateName="BALANCE" alias="账户余额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CURRENCYID" associateName="CURRENCYID" alias="币别ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCYNAME" associateName="CURRENCYNAME" alias="币别" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ACCOUNTBANKID" associateName="ACCOUNTBANKID" alias="银行账户ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BANKNAME" associateName="BANKNAME" alias="银行账户" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COMPANYID" associateName="COMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COMPANYNAME" associateName="COMPANYNAME" alias="公司" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
			<Filters>
				<Item property="BALANCE" compare="NOT_NULL" lb="1" rb="1" compareType="APPOINTED" />
			</Filters>
		</Entity>
		<Entity name="dm1625626235278" alias="资金流入流出分析" associateName="dm1625626235278" directModel="false" source="s1625623871023">
			<Properties>
				<Property name="BALANCE" associateName="BALANCE" alias="余额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="OUTAMOUNT" associateName="OUTAMOUNT" alias="流入" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="INAMOUNT" associateName="INAMOUNT" alias="流出" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BIZDATE" associateName="BIZDATE" alias="日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="ACCOUNTBANKID" associateName="ACCOUNTBANKID" alias="金融机构id" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCYID" associateName="CURRENCYID" alias="CURRENCYID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRNAME" associateName="CURRNAME" alias="CURRNAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COMPANYID" associateName="COMPANYID" alias="COMPANYID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COMPANYNAME" associateName="COMPANYNAME" alias="COMPANYNAME" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1626230948430" alias="货币资金余额整体情况看板" associateName="dm1626230948430" directModel="false" source="s1626230914332">
			<Properties>
				<Property name="BALANCE" associateName="BALANCE" alias="活期" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BALANCECURRENCY" associateName="BALANCECURRENCY" alias="活期币别" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="TIMEDEPOSITBILLAMOUNT" associateName="TIMEDEPOSITBILLAMOUNT" alias="定期" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="TIMEDEPOSITBILLCURRENCY" associateName="TIMEDEPOSITBILLCURRENCY" alias="定期币别" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINANCINGACCOUNTAMOUNT" associateName="FINANCINGACCOUNTAMOUNT" alias="理财" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FINANCINGACCOUNTCURRENCY" associateName="FINANCINGACCOUNTCURRENCY" alias="理财币别" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCYID" associateName="CURRENCYID" alias="币别ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCYNAME" associateName="CURRENCYNAME" alias="币别" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRID" associateName="CURRID" alias="CURRID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CONVERTRATE" associateName="CONVERTRATE" alias="汇率" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1658902200566" alias="银行账户余额折人民币合计" associateName="dm1658902200566" directModel="false" source="s1658902155102">
			<Properties>
				<Property name="BANKBALANCE" associateName="BANKBALANCE" alias="银企余额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="JOURNALBALANCE" associateName="JOURNALBALANCE" alias="日记账余额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="BALANCE" associateName="BALANCE" alias="账户余额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="EXBANKBALANCE" associateName="EXBANKBALANCE" alias="折人民币银企余额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="EXJOURNALBALANCE" associateName="EXJOURNALBALANCE" alias="折人民币日记账余额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="EXBALANCE" associateName="EXBALANCE" alias="折人民币账户余额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="CURRENCYID" associateName="CURRENCYID" alias="币别ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="CURRENCYNAME" associateName="CURRENCYNAME" alias="币别" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="ACCOUNTBANKID" associateName="ACCOUNTBANKID" alias="银行账户ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="BANKNAME" associateName="BANKNAME" alias="银行账户" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COMPANYID" associateName="COMPANYID" alias="公司ID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="COMPANYNAME" associateName="COMPANYNAME" alias="公司" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
	</Entities>
	<Relations />
	<UnionEntityInnerRelations />
</Data>