<Data version="20170616">
	<Sources>
		<BizMetaSource name="s1656660661450" bizMetaType="EASDBCenter" dbCenterId="SP1UPDBC860" type="BizMeta">
			<UserSQLs>
				<UserSQL name="dm1656666071933" sqlType="KSQL"><![CDATA[select FID,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FNoTaxAmtTotal,FTaxAmtTotal,FPriceTaxTotal
from
(
	select invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate ,
	case invoice.FInvoiceType
	  when N'0' then N'增值税普通发票'
	  when N'1' then N'增值税专用发票'
	  when N'2' then N'增值税电子普通发票'
	  when N'3' then N'增值税电子专用发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal
	from T_IM_MakeInvoice invoice
	inner join t_org_company company on invoice.Fcompanyid = company.fid
	where invoice.FIsRedVoice=0 and invoice.FStatus = '4' 

	union all

	select invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when '3' then N'机动车发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal
	from T_IM_VehicleMakeInvoice invoice
	inner join t_org_company company on invoice.Fcompanyid = company.fid
	where invoice.FIsRedVoice=0 and invoice.FStatus = '4' 

	union all 

	select invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when '4' then N'二手车销售统一发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal ,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal
	from T_IM_UsedCarMakeInvoice invoice
	inner join t_org_company company on invoice.Fcompanyid = company.fid
	where invoice.FIsRedVoice=0 and invoice.FStatus = '4' 
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1656666364925" sqlType="KSQL"><![CDATA[select FID,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FNoTaxAmtTotal,FTaxAmtTotal,FPriceTaxTotal
from
(
	select invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate ,
	case invoice.FInvoiceType
	  when N'0' then N'增值税普通发票'
	  when N'1' then N'增值税专用发票'
	  when N'2' then N'增值税电子普通发票'
	  when N'3' then N'增值税电子专用发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal
	from T_IM_MakeInvoice invoice
	inner join t_org_company company on invoice.Fcompanyid = company.fid
	where FIsRedVoice=1 and invoice.FStatus = '4' 

	union all

	select invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when '3' then N'机动车发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal
	from T_IM_VehicleMakeInvoice invoice
	inner join t_org_company company on invoice.Fcompanyid = company.fid
	where FIsRedVoice=1 and invoice.FStatus = '4' 

	union all 

	select invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when '4' then N'二手车销售统一发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal ,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal
	from T_IM_UsedCarMakeInvoice invoice
	inner join t_org_company company on invoice.Fcompanyid = company.fid
	where FIsRedVoice=1 and invoice.FStatus = '4' 
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1656660697474" sqlType="KSQL"><![CDATA[select FID,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FNoTaxAmtTotal,FTaxAmtTotal,FPriceTaxTotal,FTaxRate
from
(
	select invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'0' then N'增值税普通发票'
	  when N'1' then N'增值税专用发票'
	  when N'2' then N'增值税电子普通发票'
	  when N'3' then N'增值税电子专用发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal,
	case isnull(invoice.FNoTaxAmtTotal,0)
	  when 0 then 0
	  else ROUND(DECIMAL(invoice.FTaxAmtTotal/invoice.FNoTaxAmtTotal,21,8),4)
	  end as FTaxRate
	from T_IM_MakeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	where invoice.FStatus = '4'

	union all

	select invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when '3' then N'机动车发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal,
	case  isnull(invoice.FNoTaxAmtTotal,0)
	  when 0 then 0
	  else ROUND(DECIMAL(invoice.FTaxAmtTotal/invoice.FNoTaxAmtTotal,21,8),4)
	  end as FTaxRate
	from T_IM_VehicleMakeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	where invoice.FStatus = '4'

	union all 

	select invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when '4' then N'二手车销售统一发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal,
	case  isnull(invoice.FNoTaxAmtTotal,0)
	  when 0 then 0
	  else ROUND(DECIMAL(invoice.FTaxAmtTotal/invoice.FNoTaxAmtTotal,21,8),4)
	  end as FTaxRate 
	from T_IM_UsedCarMakeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	where FStatus = '4'
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1656666488794" sqlType="KSQL"><![CDATA[select FID,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FNoTaxAmtTotal,FTaxAmtTotal,FPriceTaxTotal
from
(
	select invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate ,
	case invoice.FInvoiceType
	  when N'0' then N'增值税普通发票'
	  when N'1' then N'增值税专用发票'
	  when N'2' then N'增值税电子普通发票'
	  when N'3' then N'增值税电子专用发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal
	from T_IM_MakeInvoice invoice
	inner join t_org_company company on invoice.Fcompanyid = company.fid
	where invoice.FStatus = '99' 

	union all

	select invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when '3' then N'机动车发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal
	from T_IM_VehicleMakeInvoice invoice
	inner join t_org_company company on invoice.Fcompanyid = company.fid
	where invoice.FStatus = '99' 

	union all 

	select invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when '4' then N'二手车销售统一发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal ,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal
	from T_IM_UsedCarMakeInvoice invoice
	inner join t_org_company company on invoice.Fcompanyid = company.fid
	where invoice.FStatus = '99' 
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1656727157397" sqlType="KSQL"><![CDATA[select FID,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FNoTaxAmtTotal,FTaxAmtTotal,FPriceTaxTotal,
FBlueNoTaxAmtTotal,FBlueTaxAmtTotal,FBluePriceTaxTotal,
FRedNoTaxAmtTotal,FRedTaxAmtTotal,FRedPriceTaxTotal,FBuyerName
from
(
	select  
	invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'0' then N'增值税普通发票'
	  when N'1' then N'增值税专用发票'
	  when N'2' then N'增值税电子普通发票'
	  when N'3' then N'增值税电子专用发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal,
	case FIsRedVoice 
	  when 0 then isnull(invoice.FNoTaxAmtTotal,0) 
	  else 0
	  end as FBlueNoTaxAmtTotal,
	case FIsRedVoice 
	  when 0 then isnull(invoice.FTaxAmtTotal,0) 
	  else 0
	  end as FBlueTaxAmtTotal,
	case FIsRedVoice 
	  when 0 then isnull(invoice.FPriceTaxTotal,0) 
	  else 0
	  end as FBluePriceTaxTotal,
	case FIsRedVoice 
	  when 1 then isnull(invoice.FNoTaxAmtTotal,0) 
	  else 0
	  end as FRedNoTaxAmtTotal,
	case FIsRedVoice 
	  when 1 then isnull(invoice.FTaxAmtTotal,0) 
	  else 0
	  end as FRedTaxAmtTotal,
	case FIsRedVoice 
	  when 1 then isnull(invoice.FPriceTaxTotal,0) 
	  else 0
	  end as FRedPriceTaxTotal,
	FReceiveCompany as FBuyerName
	from T_IM_MakeInvoice as invoice
	left join T_ORG_Company AS company on invoice.Fcompanyid = company.fid
	where invoice.FStatus = '4'

	union all

	select invoice.FID as FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when '3' then N'机动车发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal,
	case FIsRedVoice 
	  when 0 then isnull(invoice.FNoTaxAmtTotal,0) 
	  else 0
	  end as FBlueNoTaxAmtTotal,
	case FIsRedVoice 
	  when 0 then isnull(invoice.FTaxAmtTotal,0) 
	  else 0
	  end as FBlueTaxAmtTotal,
	case FIsRedVoice 
	  when 0 then isnull(invoice.FPriceTaxTotal,0) 
	  else 0
	  end as FBluePriceTaxTotal,
	case FIsRedVoice 
	  when 1 then isnull(invoice.FNoTaxAmtTotal,0) 
	  else 0
	  end as FRedNoTaxAmtTotal,
	case FIsRedVoice 
	  when 1 then isnull(invoice.FTaxAmtTotal,0) 
	  else 0
	  end as FRedTaxAmtTotal,
	case FIsRedVoice 
	  when 1 then isnull(invoice.FPriceTaxTotal,0) 
	  else 0
	  end as FRedPriceTaxTotal,
	FBuyerName 
	from T_IM_VehicleMakeInvoice as invoice
	left join T_ORG_Company AS company on invoice.Fcompanyid = company.fid
	where invoice.FStatus = '4'

	union all 

	select invoice.FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,invoice.FInvoiceDate,
	case invoice.FInvoiceType
	  when '4' then N'二手车销售统一发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal ,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal,
	case FIsRedVoice 
	  when 0 then isnull(invoice.FNoTaxAmtTotal,0) 
	  else 0
	  end as FBlueNoTaxAmtTotal,
	case FIsRedVoice 
	  when 0 then isnull(invoice.FTaxAmtTotal,0) 
	  else 0
	  end as FBlueTaxAmtTotal,
	case FIsRedVoice 
	  when 0 then isnull(invoice.FPriceTaxTotal,0) 
	  else 0
	  end as FBluePriceTaxTotal,
	case FIsRedVoice 
	  when 1 then isnull(invoice.FNoTaxAmtTotal,0) 
	  else 0
	  end as FRedNoTaxAmtTotal,
	case FIsRedVoice 
	  when 1 then isnull(invoice.FTaxAmtTotal,0) 
	  else 0
	  end as FRedTaxAmtTotal,
	case FIsRedVoice 
	  when 1 then isnull(invoice.FPriceTaxTotal,0) 
	  else 0
	  end as FRedPriceTaxTotal,
	FBuyerName
	from T_IM_UsedCarMakeInvoice as invoice
	left join T_ORG_Company AS company on invoice.Fcompanyid = company.fid
	where FStatus = '4'	
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1656917918103" sqlType="KSQL"><![CDATA[select FID,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FNoTaxAmtTotal,FTaxAmtTotal,FPriceTaxTotal,
FPlateNo,FExtensionNo
from
(
	select invoice.FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'0' then N'增值税普通发票'
	  when N'1' then N'增值税专用发票'
	  when N'2' then N'增值税电子普通发票'
	  when N'3' then N'增值税电子专用发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal,
	CONVERT(NVARCHAR(80),invoice.FPlateNo) as FPlateNo,
	CONVERT(NVARCHAR(80),invoice.FExtensionNo) as FExtensionNo
	from T_IM_MakeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	where invoice.FStatus = '4'

	union all

	select invoice.FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when '3' then N'机动车发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal,
	CONVERT(NVARCHAR(80),invoice.FPlateNo) as FPlateNo,
	CONVERT(NVARCHAR(80),invoice.FExtensionNo) as FExtensionNo
	from T_IM_VehicleMakeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	where invoice.FStatus = '4'

	union all 

	select invoice.FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when '4' then N'二手车销售统一发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal,
	CONVERT(NVARCHAR(80),invoice.FPlateNo) as FPlateNo,
	CONVERT(NVARCHAR(80),invoice.FExtensionNo) as FExtensionNo
	from T_IM_UsedCarMakeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	where FStatus = '4'
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
				<UserSQL name="dm1656917975503" sqlType="KSQL"><![CDATA[select FID,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FNoTaxAmtTotal,FTaxAmtTotal,FPriceTaxTotal,
FMakeInvoiceType
from
(
	select invoice.FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'0' then N'增值税普通发票'
	  when N'1' then N'增值税专用发票'
	  when N'2' then N'增值税电子普通发票'
	  when N'3' then N'增值税电子专用发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal,
	case invoice.FMakeInvoiceType
	 when 1 then '当期销售'
	 when 2 then '预开票'
	 when 3 then '补开发票'
	 else '未定义'
	 end as FMakeInvoiceType
	from T_IM_MakeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	where invoice.FStatus = '4'
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               'd7dacebe-4aa1-4a78-878a-d58a4825b2fePERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
			</UserSQLs>
		</BizMetaSource>
	</Sources>
	<ExtractSchedule dayAtMonthly="0" weekAtWeekly="1" time="75600" />
	<Entities>
		<Entity name="dm1656660697474" alias="已开票数据汇总" associateName="dm1656660697474" directModel="false" source="s1656660661450">
			<Design x="10" y="10" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="FCOMPANYID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="开票日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNOTAXAMTTOTAL" associateName="FNOTAXAMTTOTAL" alias="金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FTAXAMTTOTAL" associateName="FTAXAMTTOTAL" alias="税额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FPRICETAXTOTAL" associateName="FPRICETAXTOTAL" alias="价税合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FTAXRATE" associateName="FTAXRATE" alias="平均税率" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1656666071933" alias="已开票数据汇总-已开蓝票" associateName="dm1656666071933" directModel="false" source="s1656660661450">
			<Design x="250" y="10" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="FCOMPANYID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="开票日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNOTAXAMTTOTAL" associateName="FNOTAXAMTTOTAL" alias="金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FTAXAMTTOTAL" associateName="FTAXAMTTOTAL" alias="税额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FPRICETAXTOTAL" associateName="FPRICETAXTOTAL" alias="价税合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1656666364925" alias="已开票数据汇总-已开红票" associateName="dm1656666364925" directModel="false" source="s1656660661450">
			<Design x="490" y="10" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="FCOMPANYID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="开票日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNOTAXAMTTOTAL" associateName="FNOTAXAMTTOTAL" alias="金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FTAXAMTTOTAL" associateName="FTAXAMTTOTAL" alias="税额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FPRICETAXTOTAL" associateName="FPRICETAXTOTAL" alias="价税合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1656666488794" alias="已开票数据汇总-作废发票" associateName="dm1656666488794" directModel="false" source="s1656660661450">
			<Design x="730" y="10" width="200" height="90" />
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="FCOMPANYID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="开票日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNOTAXAMTTOTAL" associateName="FNOTAXAMTTOTAL" alias="金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FTAXAMTTOTAL" associateName="FTAXAMTTOTAL" alias="税额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FPRICETAXTOTAL" associateName="FPRICETAXTOTAL" alias="价税合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1656727157397" alias="开票量排行" associateName="dm1656727157397" directModel="false" source="s1656660661450">
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="FCOMPANYID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="开票日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNOTAXAMTTOTAL" associateName="FNOTAXAMTTOTAL" alias="发票金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FTAXAMTTOTAL" associateName="FTAXAMTTOTAL" alias="发票税额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FPRICETAXTOTAL" associateName="FPRICETAXTOTAL" alias="发票价税合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FBLUENOTAXAMTTOTAL" associateName="FBLUENOTAXAMTTOTAL" alias="蓝字发票金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FBLUETAXAMTTOTAL" associateName="FBLUETAXAMTTOTAL" alias="蓝字发票税额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FBLUEPRICETAXTOTAL" associateName="FBLUEPRICETAXTOTAL" alias="蓝字发票价税合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FREDNOTAXAMTTOTAL" associateName="FREDNOTAXAMTTOTAL" alias="红字发票金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FREDTAXAMTTOTAL" associateName="FREDTAXAMTTOTAL" alias="红字发票税额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FREDPRICETAXTOTAL" associateName="FREDPRICETAXTOTAL" alias="红字发票价税设计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FBUYERNAME" associateName="FBUYERNAME" alias="开票名称" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1656917918103" alias="开票数据分布" associateName="dm1656917918103" directModel="false" source="s1656660661450">
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="FCOMPANYID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="开票日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNOTAXAMTTOTAL" associateName="FNOTAXAMTTOTAL" alias="金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FTAXAMTTOTAL" associateName="FTAXAMTTOTAL" alias="税额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FPRICETAXTOTAL" associateName="FPRICETAXTOTAL" alias="价税合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FPLATENO" associateName="FPLATENO" alias="税盘号" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FEXTENSIONNO" associateName="FEXTENSIONNO" alias="分机号" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="F1656918960092" associateName="F1656918960092" alias="税盘号_分机号" dataType="STRING" formula="[FPLATENO]+'-'+[FEXTENSIONNO]" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
		<Entity name="dm1656917975503" alias="开票数据分布-申报类型分布" associateName="dm1656917975503" directModel="false" source="s1656660661450">
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="FCOMPANYID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="开票日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNOTAXAMTTOTAL" associateName="FNOTAXAMTTOTAL" alias="金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FTAXAMTTOTAL" associateName="FTAXAMTTOTAL" alias="税额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FPRICETAXTOTAL" associateName="FPRICETAXTOTAL" alias="价税合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FMAKEINVOICETYPE" associateName="FMAKEINVOICETYPE" alias="申报类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
	</Entities>
	<Relations />
	<UnionEntityInnerRelations />
</Data>