<Data version="20170616">
	<Sources>
		<BizMetaSource name="s1656912750834" bizMetaType="EASDBCenter" dbCenterId="SP1UPDBC860" type="BizMeta">
			<UserSQLs>
				<UserSQL name="dm1656912828955" sqlType="KSQL"><![CDATA[select FID,FcompanyID,FCompanyName,FInvoiceDate,FInvoiceType,
FNoTaxAmtTotal,FTaxAmtTotal,FPriceTaxTotal
from
(
	select invoice.FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when N'0' then N'增值税普通发票'
	  when N'1' then N'增值税专用发票'
	  when N'2' then N'增值税电子普通发票'
	  when N'3' then N'增值税电子专用发票'
	  else N''
	  end as FInvoiceType, 
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal
	from T_IM_MakeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	where invoice.FStatus = '4'

	union all

	select invoice.FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when '3' then N'机动车发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal
	from T_IM_VehicleMakeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	where invoice.FStatus = '4'

	union all 

	select invoice.FID,
	company.FID as FcompanyID,
	company.Fname_L2 as FCompanyName,
	invoice.FInvoiceDate as FInvoiceDate,
	case invoice.FInvoiceType
	  when '4' then N'二手车销售统一发票'
	  else N''
	  end as FInvoiceType,
	isnull(invoice.FNoTaxAmtTotal,0) as FNoTaxAmtTotal,
	isnull(invoice.FTaxAmtTotal,0) as FTaxAmtTotal,
	isnull(invoice.FPriceTaxTotal,0) as FPriceTaxTotal
	from T_IM_UsedCarMakeInvoice as invoice
	inner join t_org_company as company on invoice.Fcompanyid = company.fid
	where FStatus = '4'
) as invoicePool 
where invoicePool.FCompanyID in (SELECT BaseUnit.FID
  FROM T_ORG_BaseUnit BaseUnit
 INNER JOIN T_ORG_Structure Structure
    ON Structure.FUnitId = BaseUnit.FID
 WHERE Structure.FTreeId = '00000000-0000-0000-0000-0000000000024F2827FD' and BaseUnit.FISLEAF =1 
   AND EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '161ba95b-0774-42a2-bc60-f30855317001PERMITEM'
           AND UserOrgPerm.FPermType = 10
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '161ba95b-0774-42a2-bc60-f30855317001PERMITEM'
           AND RolePerm.FPermType = 10
           AND UserRoleOrg.Forgid = BaseUnit.fid)
   AND NOT EXISTS (SELECT 1
          FROM T_PM_UserOrgPerm USERORGPERM
         WHERE UserOrgPerm.FOwner =
               '@USER_ID'
           AND UserOrgPerm.FPermItemID =
               '161ba95b-0774-42a2-bc60-f30855317001PERMITEM'
           AND UserOrgPerm.FPermType = 20
           AND USERORGPERM.Forgid = BaseUnit.fid
        UNION ALL
        SELECT 1
          FROM T_PM_RolePerm RolePerm
         INNER JOIN T_PM_UserRoleOrg UserRoleOrg
            ON RolePerm.FRoleID = UserRoleOrg.FRoleID
         WHERE UserRoleOrg.FUserID =
               '@USER_ID'
           AND RolePerm.FPermItemID =
               '161ba95b-0774-42a2-bc60-f30855317001PERMITEM'
           AND RolePerm.FPermType = 20
           AND UserRoleOrg.Forgid = BaseUnit.fid))]]></UserSQL>
			</UserSQLs>
		</BizMetaSource>
	</Sources>
	<ExtractSchedule dayAtMonthly="0" weekAtWeekly="1" time="75600" />
	<Entities>
		<Entity name="dm1656912828955" alias="已开票数据" associateName="dm1656912828955" directModel="false" source="s1656912750834">
			<Properties>
				<Property name="FID" associateName="FID" alias="FID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYID" associateName="FCOMPANYID" alias="FCOMPANYID" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FCOMPANYNAME" associateName="FCOMPANYNAME" alias="财务组织" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FINVOICEDATE" associateName="FINVOICEDATE" alias="开票日期" dataType="DATETIME" appointedDataType="DATETIME" hideInDataModeling="false" />
				<Property name="FINVOICETYPE" associateName="FINVOICETYPE" alias="发票类型" dataType="STRING" appointedDataType="STRING" hideInDataModeling="false" />
				<Property name="FNOTAXAMTTOTAL" associateName="FNOTAXAMTTOTAL" alias="金额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FTAXAMTTOTAL" associateName="FTAXAMTTOTAL" alias="税额" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
				<Property name="FPRICETAXTOTAL" associateName="FPRICETAXTOTAL" alias="价税合计" dataType="NUMBER" appointedDataType="NUMBER" format="#,##0.00" hideInDataModeling="false" />
			</Properties>
			<Parilds />
		</Entity>
	</Entities>
	<Relations />
	<UnionEntityInnerRelations />
</Data>