/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.formater;

import com.kingdee.bos.sql.datatype.DataType;
import com.kingdee.bos.sql.dom.AbstractUpdateItem;
import com.kingdee.bos.sql.dom.SqlBlockStmt;
import com.kingdee.bos.sql.dom.SqlColumnDef;
import com.kingdee.bos.sql.dom.SqlInsert;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlTableCheck;
import com.kingdee.bos.sql.dom.SqlTableConstraint;
import com.kingdee.bos.sql.dom.SqlTableForeignKey;
import com.kingdee.bos.sql.dom.SqlTablePrimaryKey;
import com.kingdee.bos.sql.dom.SqlTableUnique;
import com.kingdee.bos.sql.dom.SqlUpdate;
import com.kingdee.bos.sql.dom.SqlUpdateItem;
import com.kingdee.bos.sql.dom.SubQueryUpdateItem;
import com.kingdee.bos.sql.dom.expr.SqlAggregateExpr;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlConvertTypeExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.dom.expr.SqlNCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlNullExpr;
import com.kingdee.bos.sql.dom.stmt.SqlBreakStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCloseStmt;
import com.kingdee.bos.sql.dom.stmt.SqlContinueStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCreateIndexStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCursorLoopStmt;
import com.kingdee.bos.sql.dom.stmt.SqlDeallocateStmt;
import com.kingdee.bos.sql.dom.stmt.SqlFetchStmt;
import com.kingdee.bos.sql.dom.stmt.SqlGotoStmt;
import com.kingdee.bos.sql.dom.stmt.SqlIfStmt;
import com.kingdee.bos.sql.dom.stmt.SqlInsertStmt;
import com.kingdee.bos.sql.dom.stmt.SqlLabelStmt;
import com.kingdee.bos.sql.dom.stmt.SqlOpenStmt;
import com.kingdee.bos.sql.dom.stmt.SqlSetLocalVariantStmt;
import com.kingdee.bos.sql.dom.stmt.SqlShowColumnsStmt;
import com.kingdee.bos.sql.dom.stmt.SqlShowTablesStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.dom.stmt.SqlUpdateStmt;
import com.kingdee.bos.sql.dom.stmt.SqlWhileStmt;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.formater.TSQLFormater;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.bos.sql.util.UUTN;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MSTransactSQLFormater
extends TSQLFormater {
    public MSTransactSQLFormater() {
        this(null);
    }

    public MSTransactSQLFormater(StringBuffer sb) {
        super(sb);
        this.max_length_of_index_name = 128;
        this.max_length_of_table_name = 128;
        this.max_length_of_constraint_name = 128;
        this.max_length_of_column_name = 128;
        this.max_length_of_column_count = 1023;
        this.max_length_of_row_size = 8000;
    }

    @Override
    protected void formatShowTablesStmt(SqlShowTablesStmt stmt) {
        String sql = "select name from sysobjects where type = N'U' order by name";
        this.buffer.append(sql);
    }

    @Override
    public void formatInsertStmt(SqlInsertStmt stmt) throws FormaterException {
        boolean flag;
        Iterator iterator;
        this.buffer.append("INSERT INTO ");
        SqlInsert insert = stmt.insert;
        String tableName = this.formatTableName(insert.tableName);
        this.buffer.append(tableName);
        if (!insert.columnList.isEmpty()) {
            this.buffer.append(" (");
            iterator = insert.columnList.iterator();
            flag = false;
            boolean hasRowNum = false;
            for (int i = 0; i < insert.columnList.size(); ++i) {
                Object colItem = insert.columnList.get(i);
                if (colItem instanceof SqlIdentifierExpr) {
                    SqlIdentifierExpr identExpr = (SqlIdentifierExpr)colItem;
                    if (identExpr.value.equalsIgnoreCase("KSQL_SEQ")) {
                        hasRowNum = true;
                    }
                    if (!hasRowNum) {
                        if (flag) {
                            this.buffer.append(", ");
                        }
                        this.buffer.append(identExpr.value);
                    }
                } else if (colItem instanceof String) {
                    if (flag) {
                        this.buffer.append(", ");
                    }
                    this.buffer.append((String)colItem);
                } else {
                    throw new FormaterException("unexpect expression: '" + colItem + "'");
                }
                flag = !hasRowNum || flag;
                hasRowNum = false;
            }
            this.buffer.append(")");
        }
        if (insert.valueList.size() != 0) {
            this.buffer.append(" VALUES (");
            iterator = insert.valueList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr valueExpr = (SqlExpr)iterator.next();
                this.formatExpr(valueExpr);
                flag = true;
            }
            this.buffer.append(")");
        } else {
            this.buffer.append(" ");
            this.formatSelectBase(stmt.insert.subQuery);
        }
    }

    @Override
    protected void formatShowColumnsStmt(SqlShowColumnsStmt stmt) {
        String tableName = stmt.tableName;
        String sql = tableName != null && tableName.length() != 0 ? "select a.name COLUMN_NAME, b.name DATA_TYPE, a.length DEFAULT_LENGTH, a.prec DATA_PRECISION, a.scale DATA_SCALE, a.isnullable NULLABLE, object_name(a.id) as TABLE_NAME from syscolumns a inner join systypes b on a.xusertype = b.xusertype where object_name(a.id) = '" + this.formatTableName(stmt.tableName) + "' order by colorder" : "select a.name COLUMN_NAME, b.name DATA_TYPE, a.length DEFAULT_LENGTH, a.prec DATA_PRECISION, a.scale DATA_SCALE, a.isnullable NULLABLE, object_name(a.id) as TABLE_NAME from syscolumns a inner join systypes b on a.xusertype = b.xusertype order by colorder";
        this.buffer.append(sql);
    }

    @Override
    protected String formatTableName(String tableName) {
        if (tableName == null || tableName.length() <= 0) {
            String msg = "\"tableName\" is empty!";
            throw new IllegalArgumentException(msg);
        }
        if (tableName.startsWith("GZT")) {
            tableName = "##" + tableName;
        }
        if (tableName.indexOf(" ") >= 0) {
            tableName = "[" + tableName + "]";
        }
        return tableName;
    }

    @Override
    protected void formatCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        this.validateCreateTableStmt(stmt);
        this.buffer.append("CREATE TABLE");
        this.buffer.append(" ");
        this.buffer.append(this.formatTableName(stmt.name));
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.columnList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlColumnDef column = (SqlColumnDef)iterator.next();
            this.formatColumnDef(column);
            flag = true;
        }
        this.formatTableConstraintList(stmt.constraintList);
        this.buffer.append(")");
        String ts = null;
        if (UUTN.isTempTable(stmt.name) && this.options != null) {
            ts = this.options.getTempTableSpace();
        }
        if (ts == null) {
            ts = stmt.tableSpace;
        }
        this.formatTableSpace(ts);
    }

    @Override
    protected void formatTableConstraint(SqlTableConstraint constraint) throws FormaterException {
        this.validConstraintName(constraint.name);
        if (constraint.name != null && constraint.name.length() != 0) {
            this.buffer.append("CONSTRAINT ");
            this.buffer.append(constraint.name);
        }
        if (constraint instanceof SqlTablePrimaryKey) {
            SqlTablePrimaryKey primaryKey = (SqlTablePrimaryKey)constraint;
            if (primaryKey.clustered) {
                this.buffer.append(" PRIMARY KEY (");
            } else {
                this.buffer.append(" PRIMARY KEY NONCLUSTERED (");
            }
            boolean flag = false;
            Iterator iterator = primaryKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableUnique) {
            SqlTableUnique unique = (SqlTableUnique)constraint;
            if (unique.clustered) {
                this.buffer.append(" UNIQUE CLUSTERED (");
            } else {
                this.buffer.append(" UNIQUE (");
            }
            boolean flag = false;
            Iterator iterator = unique.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableUnique) {
            SqlTableUnique unique = (SqlTableUnique)constraint;
            this.buffer.append(" UNIQUE (");
            boolean flag = false;
            Iterator iterator = unique.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableForeignKey) {
            SqlTableForeignKey foreignKey = (SqlTableForeignKey)constraint;
            this.buffer.append(" FOREIGN KEY (");
            boolean flag = false;
            Iterator iterator = foreignKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
            this.buffer.append(" REFERENCES ");
            this.buffer.append(foreignKey.refTableName);
            this.buffer.append(" (");
            flag = false;
            iterator = foreignKey.refColumnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String refColumnName = (String)iterator.next();
                this.buffer.append(refColumnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableCheck) {
            SqlTableCheck check = (SqlTableCheck)constraint;
            this.buffer.append(" CHECK (");
            this.formatExpr(check.expr, false);
            this.buffer.append(")");
        } else {
            throw new FormaterException("not support constraint:" + constraint);
        }
    }

    protected final void formatTableSpace(String tableSpace) {
        if (tableSpace != null && tableSpace.length() > 0) {
            this.buffer.append(" ON " + tableSpace);
        }
    }

    @Override
    protected void formatColumnDef(SqlColumnDef column) throws FormaterException {
        if (column.name.indexOf(" ") >= 0) {
            this.buffer.append("[");
            this.buffer.append(column.name);
            this.buffer.append("] ");
        } else {
            this.buffer.append(column.name);
            this.buffer.append(" ");
        }
        if (column.dataType.equalsIgnoreCase("BIGINT")) {
            this.buffer.append("BIGINT");
        } else if (column.dataType.equalsIgnoreCase("BINARY")) {
            this.buffer.append("BINARY (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BIT")) {
            this.buffer.append("BIT");
        } else if (column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
            this.formatColumnCollate(column);
        } else if (column.dataType.equalsIgnoreCase("DATETIME")) {
            this.buffer.append("DATETIME");
        } else if (column.dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("DECIMAL (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("FLOAT")) {
            this.buffer.append("FLOAT");
        } else if (column.dataType.equalsIgnoreCase("IMAGE")) {
            this.buffer.append("IMAGE");
        } else if (column.dataType.equalsIgnoreCase("INT") && !column.autoIncrement) {
            this.buffer.append("INT");
        } else if (column.dataType.equalsIgnoreCase("MONEY")) {
            this.buffer.append("MONEY");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("NCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
            this.formatColumnCollate(column);
        } else if (column.dataType.equalsIgnoreCase("NTEXT")) {
            this.buffer.append("NTEXT");
            this.formatColumnCollate(column);
        } else if (column.dataType.equalsIgnoreCase("NUMERIC")) {
            this.buffer.append("NUMERIC (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR")) {
            this.buffer.append("NVARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
            this.formatColumnCollate(column);
        } else if (column.dataType.equalsIgnoreCase("REAL")) {
            this.buffer.append("REAL");
        } else if (column.dataType.equalsIgnoreCase("SMALLDATETIME")) {
            this.buffer.append("SMALLDATETIME");
        } else if (column.dataType.equalsIgnoreCase("SMALLINT")) {
            this.buffer.append("SMALLINT");
        } else if (column.dataType.equalsIgnoreCase("SMALLMONEY")) {
            this.buffer.append("SMALLMONEY");
        } else if (column.dataType.equalsIgnoreCase("SQL_VARIANT")) {
            this.buffer.append("SQL_VARIANT");
        } else if (column.dataType.equalsIgnoreCase("TEXT")) {
            this.buffer.append("TEXT");
            this.formatColumnCollate(column);
        } else if (column.dataType.equalsIgnoreCase("TIMESTAMP")) {
            this.buffer.append("TIMESTAMP");
        } else if (column.dataType.equalsIgnoreCase("TINYINT")) {
            this.buffer.append("TINYINT");
        } else if (column.dataType.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
            this.buffer.append("UNIQUEIDENTIFIER");
        } else if (column.dataType.equalsIgnoreCase("VARCHAR")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
            this.formatColumnCollate(column);
        } else if (column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("VARBINARY (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("IMAGE");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("TEXT");
            this.formatColumnCollate(column);
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("NTEXT");
            this.formatColumnCollate(column);
        } else {
            this.buffer.append(column.dataType);
        }
        if (!column.autoIncrement) {
            if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
                if (!column.isPrimaryKey) {
                    this.buffer.append(" NULL");
                }
            } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
                this.buffer.append(" NOT NULL");
            }
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.autoIncrement) {
            this.buffer.append(" IDENTITY(1, 1)");
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
            if (!column.clustered) {
                this.buffer.append(" NONCLUSTERED");
            }
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
            if (column.clustered) {
                this.buffer.append(" CLUSTERED");
            }
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    private void formatColumnCollate(SqlColumnDef column) {
        if (column.collateName != null && column.collateName.length() > 0) {
            this.buffer.append(" COLLATE ");
            this.buffer.append(column.collateName);
        } else {
            this.buffer.append(" COLLATE Chinese_PRC_CS_AS");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void formatMethodInvokeExpr(SqlMethodInvokeExpr expr) throws FormaterException {
        String methodNameI;
        if (expr.owner != null) {
            this.formatExpr(expr.owner);
            this.buffer.append('.');
        }
        if ((methodNameI = expr.methodName.toUpperCase(Locale.ENGLISH)).compareTo("ABS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ABS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ACOS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ACOS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ASIN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ASIN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATAN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ATAN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATN2") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("ATN2(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CEILING") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("CEILING(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("COS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("COS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("EXP") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("EXP(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("FLOOR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("FLOOR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MOD") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" % ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOG") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LOG(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("POWER") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("POWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ROUND") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            this.buffer.append("ROUND(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SIGN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SIGN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SIN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SIN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SQRT") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SQRT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TAN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("TAN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CONVERT") == 0) {
            if (expr.parameters.size() != 2) {
                throw new FormaterException("ERROR");
            }
            if (!(expr.parameters.get(0) instanceof SqlIdentifierExpr)) {
                throw new FormaterException("ERROR");
            }
            String typeName = ((SqlIdentifierExpr)expr.parameters.get((int)0)).value;
            if (typeName == null) throw new FormaterException("ERROR");
            if (typeName.length() == 0) {
                throw new FormaterException("ERROR");
            }
            if (typeName.compareToIgnoreCase("BINARY") == 0 || typeName.compareToIgnoreCase("VARBINARY") == 0 || typeName.compareToIgnoreCase("CHAR") == 0 || typeName.compareToIgnoreCase("VARCHAR") == 0 || typeName.compareToIgnoreCase("NCHAR") == 0 || typeName.compareToIgnoreCase("NVARCHAR") == 0 || typeName.compareToIgnoreCase("DATETIME") == 0 || typeName.compareToIgnoreCase("DECIMAL") == 0 || typeName.compareToIgnoreCase("INT") == 0 || typeName.compareToIgnoreCase("SMALLINT") == 0) {
                this.buffer.append("CONVERT(" + typeName.toUpperCase());
                if (expr.parameters.get(0) instanceof SqlConvertTypeExpr) {
                    this.buffer.append("(");
                    this.buffer.append(((SqlConvertTypeExpr)expr.parameters.get(0)).getLen());
                    this.buffer.append(")");
                }
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (typeName.compareToIgnoreCase("NUMBER") == 0) {
                this.buffer.append("CONVERT(NUMERIC, ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (typeName.compareToIgnoreCase("BLOB") == 0) {
                this.buffer.append("CONVERT(IMAGE, ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (typeName.compareToIgnoreCase("CLOB") == 0) {
                this.buffer.append("CONVERT(CLOB, ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (typeName.compareToIgnoreCase("NCLOB") != 0) throw new FormaterException("not support type:" + typeName);
            this.buffer.append("CONVERT(NCLOB, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CURDATE") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CONVERT(DATETIME, CONVERT(VARCHAR(50) ,GETDATE( ), 101))");
            return;
        }
        if (methodNameI.compareTo("CURTIME") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CONVERT(VARCHAR(50) ,GETDATE( ), 108)");
            return;
        }
        if (methodNameI.compareTo("DATEADD") == 0 || methodNameI.compareTo("DATETIMEADD") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("DATEADD(SS, ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEADD(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DATEDIFF") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("DATEDIFF(SS, ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEDIFF(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYNAME") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATENAME(DW, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYOFMONTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEPART(DAY, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYOFWEEK") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEPART(DW, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYOFYEAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEPART(DY, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("GETDATE") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("GETDATE()");
            return;
        }
        if (methodNameI.compareTo("HOUR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEPART(HH, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MINUTE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEPART(MI, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MONTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEPART(MM, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MONTHNAME") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATENAME(MM, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NOW") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("GETDATE()");
            return;
        }
        if (methodNameI.compareTo("QUARTER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEPART(QQ, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SECOND") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEPART(SS, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("WEEK") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEPART(WK, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("YEAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("YEAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_DATE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CONVERT(DATETIME, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MONTHS_BETWEEN") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEDIFF(MM, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("DAYS_BETWEEN") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEDIFF(DD, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_MONTHS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEADD(month, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_YEARS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEADD(year, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_DAYS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEADD(day, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_HOURS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEADD(hour, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_MINUTES") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEADD(minute, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ADD_SECONDS") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("DATEADD(second, ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ASCII") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ASCII(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHAR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CHAR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CHARINDEX") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("CHARINDEX(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("CHARINDEX(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CONCAT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" + ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            return;
        }
        if (methodNameI.compareTo("LEFT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LEFT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LEN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
            this.buffer.append("LEN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LENGTH") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("unexpect parameters: '" + expr.parameters.get(1) + "'");
            this.buffer.append("LEN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOWER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LOWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LOWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("REPLACE") == 0) {
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            this.buffer.append("REPLACE(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RIGHT") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("RIGHT(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("RTRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SOUNDEX") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("SOUNDEX(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("SUBSTRING") == 0) {
            int startIndex;
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            this.buffer.append("SUBSTRING(");
            this.formatExpr((SqlExpr)expr.parameters.get(0), false);
            this.buffer.append(", ");
            if (expr.parameters.get(1) instanceof SqlIntExpr && (startIndex = ((SqlIntExpr)expr.parameters.get((int)1)).value) < 1) {
                if (startIndex == 0) {
                    expr.parameters.set(1, new SqlIntExpr(1));
                }
                if (startIndex < 0) {
                    throw new FormaterException("SUBSTRING parameter2 cannot not smaller then 1.");
                }
            }
            this.formatExpr((SqlExpr)expr.parameters.get(1), false);
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(2), false);
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TRIM") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LTRIM(RTRIM(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append("))");
            return;
        }
        if (methodNameI.compareTo("UCASE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("UPPER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("UPPER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("UPPER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_DECIMAL") == 0 || methodNameI.compareTo("DECIMAL") == 0 || methodNameI.compareTo("DEC") == 0) {
            if (expr.parameters.size() != 1) {
                if (expr.parameters.size() != 3) throw new FormaterException("TO_DECIMAL's parameters num: " + expr.parameters.size());
                this.buffer.append("CAST(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(" AS NUMERIC(");
                this.buffer.append(expr.parameters.get(1));
                this.buffer.append(", ");
                this.buffer.append(expr.parameters.get(2));
                this.buffer.append("))");
                return;
            }
            if (expr.parameters.get(0) instanceof SqlNullExpr) {
                this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                return;
            }
            this.buffer.append("CAST(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" AS NUMERIC)");
            return;
        }
        if (methodNameI.compareTo("TO_BLOB") == 0 || methodNameI.compareTo("BLOB") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            if (!(expr.parameters.get(0) instanceof SqlNullExpr)) return;
            this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
            return;
        }
        if (methodNameI.compareTo("TOCHAR") == 0 || methodNameI.compareTo("TO_CHAR") == 0) {
            if (expr.parameters.size() == 1) {
                if (expr.parameters.get(0) instanceof SqlNullExpr) {
                    this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                    return;
                }
                this.buffer.append("CONVERT(VARCHAR(8000), ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (expr.parameters.size() == 2 && expr.parameters.get(1).toString().equalsIgnoreCase("YYYY-MM-DD")) {
                this.buffer.append("CONVERT(CHAR(10), ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", 20)");
                return;
            }
            if (expr.parameters.size() == 2 && expr.parameters.get(1).toString().equalsIgnoreCase("YYYY-MM-DD HH24:MI:SS")) {
                this.buffer.append("CONVERT(CHAR(19), ");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", 20)");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            if (!expr.parameters.get(1).toString().equalsIgnoreCase("NUMBER")) throw new FormaterException("ERROR");
            if (!(expr.parameters.get(2) instanceof SqlCharExpr)) {
                if (!(expr.parameters.get(2) instanceof SqlIntExpr)) return;
                this.buffer.append("LTRIM(RTRIM(STR(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", 38, ");
                this.formatExpr((SqlExpr)expr.parameters.get(2));
                this.buffer.append(")))");
                return;
            }
            String style = expr.parameters.get(2).toString();
            if (style.split("D").length <= 0) throw new FormaterException("TO_CHAR()'s NUMBER style not valid.");
            if (style.split("D").length >= 3) throw new FormaterException("TO_CHAR()'s NUMBER style not valid.");
            char[] integerStyle = style.split("D")[0].toCharArray();
            char[] radixStyle = style.split("D")[1].toCharArray();
            int countInteger = 0;
            for (int i = 0; i < integerStyle.length; ++i) {
                if (integerStyle[i] != '9') continue;
                ++countInteger;
            }
            int countradix = 0;
            int i = 0;
            while (true) {
                if (i >= radixStyle.length) {
                    this.buffer.append("CONVERT(VARCHAR, ");
                    this.buffer.append("CAST(");
                    this.formatExpr((SqlExpr)expr.parameters.get(0));
                    this.buffer.append(" AS DECIMAL(");
                    this.buffer.append(countInteger + countradix);
                    this.buffer.append(", ");
                    this.buffer.append(countradix);
                    this.buffer.append(")");
                    this.buffer.append("))");
                    return;
                }
                if (radixStyle[i] == '9') {
                    ++countradix;
                }
                ++i;
            }
        }
        if (methodNameI.compareTo("DATENAME") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("DATENAME(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ISNULL") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("ISNULL(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NULLIF") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("NULLIF(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_NUMBER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("CONVERT(FLOAT, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("TO_INT") == 0 || methodNameI.compareTo("TO_INTEGER") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            if (expr.parameters.get(0) instanceof SqlNullExpr) {
                this.formatNullExpr((SqlNullExpr)expr.parameters.get(0));
                return;
            }
            this.buffer.append("CAST(CONVERT(FLOAT, ");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(") AS INT)");
            return;
        }
        if (methodNameI.compareTo("TO_NVARCHAR") == 0 || methodNameI.compareTo("TONVARCHAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                return;
            }
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            return;
        }
        if (methodNameI.compareTo("TO_VARCHAR") == 0 || methodNameI.compareTo("TOVARCHAR") == 0) {
            if (expr.parameters.size() == 1) {
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                return;
            }
            if (expr.parameters.size() != 2) throw new FormaterException("Unrecognized parameters");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            return;
        }
        if (methodNameI.compareTo("NEWID") == 0) {
            if (expr.parameters.size() != 0) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("LOWER(NEWID())");
            return;
        }
        if (methodNameI.compareTo("NEWBOSID") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("Unrecognized parameters");
            this.buffer.append("DBO.NEWBOSID(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("NATIVE_TYPE") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR parameterNATIVE_TYPE");
            SqlCharExpr cexpr = (SqlCharExpr)expr.parameters.get(0);
            String type = cexpr.text;
            type = DataType.getDataType(3).nativeType(type);
            this.formatExpr(new SqlCharExpr(type));
            return;
        }
        this.formeatUnkownMethodInvokeExpr(expr);
    }

    @Override
    protected void formatBlockStmt(SqlBlockStmt stmt) throws FormaterException {
        SqlBlockStmt.DeclItem item;
        int i;
        int size;
        if (stmt.declItemList != null && stmt.declItemList.size() > 0) {
            size = stmt.declItemList.size();
            for (i = 0; i < size; ++i) {
                String name;
                item = (SqlBlockStmt.DeclItem)stmt.declItemList.get(i);
                if (item instanceof SqlBlockStmt.DeclVarItem) {
                    SqlBlockStmt.DeclVarItem varItem = (SqlBlockStmt.DeclVarItem)item;
                    this.buffer.append("DECLARE ");
                    name = varItem.name;
                    this.buffer.append(name);
                    this.buffer.append(" AS ");
                    if (varItem.dataType.equalsIgnoreCase("BIGINT")) {
                        this.buffer.append("BIGINT");
                    } else if (varItem.dataType.equalsIgnoreCase("BINARY")) {
                        this.buffer.append("BINARY (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("BIT")) {
                        this.buffer.append("BIT");
                    } else if (varItem.dataType.equalsIgnoreCase("CHAR")) {
                        this.buffer.append("CHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("DATETIME")) {
                        this.buffer.append("DATETIME");
                    } else if (varItem.dataType.equalsIgnoreCase("DECIMAL")) {
                        this.buffer.append("DECIMAL (");
                        this.buffer.append(varItem.precision);
                        this.buffer.append(", ");
                        this.buffer.append(varItem.scale);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("FLOAT")) {
                        this.buffer.append("FLOAT");
                    } else if (varItem.dataType.equalsIgnoreCase("IMAGE")) {
                        this.buffer.append("IMAGE");
                    } else if (varItem.dataType.equalsIgnoreCase("INT")) {
                        this.buffer.append("INT");
                    } else if (varItem.dataType.equalsIgnoreCase("MONEY")) {
                        this.buffer.append("MONEY");
                    } else if (varItem.dataType.equalsIgnoreCase("NCHAR")) {
                        this.buffer.append("NCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("NTEXT")) {
                        this.buffer.append("NTEXT");
                    } else if (varItem.dataType.equalsIgnoreCase("NUMERIC")) {
                        this.buffer.append("NUMERIC (");
                        this.buffer.append(varItem.precision);
                        this.buffer.append(", ");
                        this.buffer.append(varItem.scale);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("NVARCHAR")) {
                        this.buffer.append("NVARCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("REAL")) {
                        this.buffer.append("REAL");
                    } else if (varItem.dataType.equalsIgnoreCase("SMALLDATETIME")) {
                        this.buffer.append("SMALLDATETIME");
                    } else if (varItem.dataType.equalsIgnoreCase("SMALLINT")) {
                        this.buffer.append("SMALLINT");
                    } else if (varItem.dataType.equalsIgnoreCase("SMALLMONEY")) {
                        this.buffer.append("SMALLMONEY");
                    } else if (varItem.dataType.equalsIgnoreCase("SQL_VARIANT")) {
                        this.buffer.append("SQL_VARIANT");
                    } else if (varItem.dataType.equalsIgnoreCase("TEXT")) {
                        this.buffer.append("TEXT");
                    } else if (varItem.dataType.equalsIgnoreCase("TIMESTAMP")) {
                        this.buffer.append("TIMESTAMP");
                    } else if (varItem.dataType.equalsIgnoreCase("TINYINT")) {
                        this.buffer.append("TINYINT");
                    } else if (varItem.dataType.equalsIgnoreCase("UNIQUEIDENTIFIER")) {
                        this.buffer.append("UNIQUEIDENTIFIER");
                    } else if (varItem.dataType.equalsIgnoreCase("VARCHAR")) {
                        this.buffer.append("VARCHAR (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("VARBINARY")) {
                        this.buffer.append("VARBINARY (");
                        this.buffer.append(varItem.length);
                        this.buffer.append(")");
                    } else if (varItem.dataType.equalsIgnoreCase("BLOB")) {
                        this.buffer.append("IMAGE");
                    } else if (varItem.dataType.equalsIgnoreCase("CLOB")) {
                        this.buffer.append("TEXT");
                    } else if (varItem.dataType.equalsIgnoreCase("NCLOB")) {
                        this.buffer.append("NTEXT");
                    } else {
                        this.buffer.append(varItem.dataType);
                    }
                    if (varItem.defaultValueExpr != null) {
                        this.buffer.append("\nSET ");
                        this.buffer.append(varItem.name);
                        this.buffer.append(" = ");
                        this.formatExpr(varItem.defaultValueExpr);
                    }
                } else if (item instanceof SqlBlockStmt.DeclCurItem) {
                    SqlBlockStmt.DeclCurItem curItem = (SqlBlockStmt.DeclCurItem)item;
                    this.buffer.append("DECLARE ");
                    name = curItem.name;
                    if (name != null && name.length() > 0 && name.charAt(0) == '@') {
                        name = name.substring(1);
                        this.buffer.append(name);
                    } else {
                        this.buffer.append(name);
                    }
                    this.buffer.append(" CURSOR FOR ");
                    this.formatSelectBase(curItem.select);
                    this.buffer.append(";\n");
                } else {
                    throw new FormaterException("unexpected statement: '" + item + "'");
                }
                this.buffer.append("\n");
            }
            this.buffer.append("\n");
        }
        size = stmt.stmtList.size();
        for (i = 0; i < size; ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append("\n");
        }
        if (stmt.declItemList != null && stmt.declItemList.size() > 0) {
            size = stmt.declItemList.size();
            for (i = 0; i < size; ++i) {
                item = (SqlBlockStmt.DeclItem)stmt.declItemList.get(i);
                if (!(item instanceof SqlBlockStmt.DeclCurItem)) continue;
                this.buffer.append("DEALLOCATE ");
                this.buffer.append(item.name);
                this.buffer.append("\n");
            }
        }
    }

    @Override
    protected void formatSetLocalVariantStmt(SqlSetLocalVariantStmt stmt) throws FormaterException {
        this.buffer.append("SET ");
        this.formatExpr(stmt.variant);
        this.buffer.append(" = ");
        this.formatExpr(stmt.value);
    }

    @Override
    protected void formatIfStmt(SqlIfStmt stmt) throws FormaterException {
        SqlStmt itemStmt;
        int i;
        this.buffer.append("IF ");
        this.formatExpr(stmt.condition);
        this.buffer.append("\n");
        this.buffer.append("BEGIN\n");
        int pos = 0;
        for (i = 0; i < stmt.trueStmtList.size(); ++i) {
            itemStmt = (SqlStmt)stmt.trueStmtList.get(i);
            this.buffer.append("EXEC('");
            pos = this.buffer.length();
            this.formatStmt(itemStmt);
            this.buffer = this.handleComma(this.buffer, pos);
            this.buffer.append("')");
            this.buffer.append("\n");
        }
        this.buffer.append("END\n");
        if (stmt.falseStmtList != null && stmt.falseStmtList.size() > 0) {
            this.buffer.append("ELSE\n");
            this.buffer.append("BEGIN\n");
            for (i = 0; i < stmt.falseStmtList.size(); ++i) {
                itemStmt = (SqlStmt)stmt.falseStmtList.get(i);
                this.buffer.append("EXEC('");
                pos = this.buffer.length();
                this.formatStmt(itemStmt);
                this.buffer = this.handleComma(this.buffer, pos);
                this.buffer.append("')");
                this.buffer.append("\n");
            }
            this.buffer.append("END;\n");
        }
    }

    @Override
    protected void formatWhileStmt(SqlWhileStmt stmt) throws FormaterException {
        this.buffer.append("WHILE ");
        this.formatExpr(stmt.condition);
        this.buffer.append("\n");
        this.buffer.append("BEGIN\n");
        for (int i = 0; i < stmt.stmtList.size(); ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append("\n");
        }
        this.buffer.append("END\n");
    }

    @Override
    protected void formatDeallocateStmt(SqlDeallocateStmt stmt) throws FormaterException {
        this.buffer.append("DEALLOCATE ");
        this.buffer.append(stmt.curName);
    }

    @Override
    protected void formatCloseStmt(SqlCloseStmt stmt) throws FormaterException {
        this.buffer.append("CLOSE ");
        this.buffer.append(stmt.curName);
    }

    @Override
    protected void formatOpenStmt(SqlOpenStmt stmt) throws FormaterException {
        this.buffer.append("OPEN ");
        this.buffer.append(stmt.curName);
    }

    @Override
    protected void formatCursorLoopStmt(SqlCursorLoopStmt stmt) throws FormaterException {
        SqlExpr expr;
        int i;
        String curName = stmt.curName;
        if (curName != null && curName.length() > 0 && curName.charAt(0) == '@') {
            curName = curName.substring(1);
        }
        this.buffer.append("OPEN ");
        this.buffer.append(curName);
        this.buffer.append("\n");
        this.buffer.append("FETCH NEXT FROM ");
        this.buffer.append(curName);
        this.buffer.append(" INTO ");
        int size = stmt.intoList.size();
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            expr = (SqlExpr)stmt.intoList.get(i);
            this.formatExpr(expr);
        }
        this.buffer.append("\n");
        this.buffer.append("WHILE (@@FETCH_STATUS = 0)\n");
        this.buffer.append("BEGIN\n");
        size = stmt.stmtList.size();
        for (i = 0; i < size; ++i) {
            SqlStmt itemStmt = (SqlStmt)stmt.stmtList.get(i);
            this.formatStmt(itemStmt);
            this.buffer.append("\n");
        }
        this.buffer.append("FETCH NEXT FROM ");
        this.buffer.append(curName);
        this.buffer.append(" INTO ");
        size = stmt.intoList.size();
        for (i = 0; i < size; ++i) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            expr = (SqlExpr)stmt.intoList.get(i);
            this.formatExpr(expr);
        }
        this.buffer.append("\n");
        this.buffer.append("END\n");
        this.buffer.append("CLOSE ");
        this.buffer.append(curName);
    }

    @Override
    protected void formatFetchStmt(SqlFetchStmt stmt) throws FormaterException {
        throw new FormaterException("not support format fetch statement");
    }

    @Override
    protected void formatBreakStmt(SqlBreakStmt stmt) throws FormaterException {
        this.buffer.append("BREAK");
    }

    @Override
    protected void formatContinueStmt(SqlContinueStmt stmt) throws FormaterException {
        this.buffer.append("CONTINUE");
    }

    @Override
    protected void formatGotoStmt(SqlGotoStmt stmt) throws FormaterException {
        this.buffer.append("GOTO ");
        this.buffer.append(stmt.name);
    }

    @Override
    protected void formatLabelStmt(SqlLabelStmt stmt) throws FormaterException {
        this.buffer.append(stmt.name);
        this.buffer.append(":");
    }

    @Override
    protected void formatCreateIndexStmt(SqlCreateIndexStmt stmt) throws FormaterException {
        String ts;
        if (stmt.isUnique) {
            this.buffer.append("CREATE UNIQUE INDEX ");
        }
        if (stmt.isCluster) {
            this.buffer.append("CREATE CLUSTERED INDEX ");
        }
        if (!stmt.isCluster && !stmt.isUnique) {
            this.buffer.append("CREATE INDEX ");
        }
        this.buffer.append(this.getIndexName(stmt));
        this.buffer.append(" ON ");
        this.buffer.append(this.formatTableName(stmt.tableName));
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.itemList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
            this.formatExpr(orderByIterm.expr);
            if (orderByIterm.mode != 0) {
                this.buffer.append(" DESC");
            }
            flag = true;
        }
        this.buffer.append(")");
        if (UUTN.isTempTable(stmt.tableName) && this.options != null && (ts = this.options.getTempTableSpace()) != null && ts.length() > 0) {
            this.buffer.append(" ON " + ts);
        }
    }

    @Override
    protected void formatUpdateStmt(SqlUpdateStmt stmt) throws FormaterException {
        SubQueryUpdateItem queryItem;
        SqlUpdate update = stmt.update;
        this.buffer.append("UPDATE ");
        if (update.updateTable.alias != null) {
            this.buffer.append(update.updateTable.alias.toUpperCase());
        } else {
            this.buffer.append(this.formatTableName(update.updateTable.name));
        }
        this.buffer.append(" SET ");
        Iterator iterator = update.updateList.iterator();
        ArrayList<AbstractUpdateItem> subqueryUpdateItemList = new ArrayList<AbstractUpdateItem>();
        int count = 0;
        boolean flag = false;
        for (int t = 0; t < update.updateList.size(); ++t) {
            AbstractUpdateItem abstract_item = (AbstractUpdateItem)update.updateList.get(t);
            if (flag) {
                this.buffer.append(", ");
            }
            if (abstract_item instanceof SqlUpdateItem) {
                SqlUpdateItem item = (SqlUpdateItem)abstract_item;
                this.buffer.append(this.formatColumnName(item.name));
                this.buffer.append(" = ");
                this.formatExpr(item.expr);
            } else if (abstract_item instanceof SubQueryUpdateItem) {
                queryItem = (SubQueryUpdateItem)abstract_item;
                subqueryUpdateItemList.add(abstract_item);
                for (int i = 0; i < queryItem.columnList.size(); ++i) {
                    SqlSelectItem subSelectItem;
                    String column = (String)queryItem.columnList.get(i);
                    if (queryItem.extendedAttributes().get("tableSourceAlias") != null) {
                        column = queryItem.extendedAttributes().get("tableSourceAlias") + "." + column;
                    }
                    if (i != 0) {
                        this.buffer.append(", ");
                    }
                    this.buffer.append(this.formatColumnName(column));
                    this.buffer.append(" = ");
                    if (queryItem.subQuery instanceof SqlSelect) {
                        SqlSelect subQuerySelect = (SqlSelect)queryItem.subQuery;
                        subSelectItem = (SqlSelectItem)subQuerySelect.selectList.get(i);
                        if (subQuerySelect != null && subQuerySelect.tableSource != null && subQuerySelect.tableSource.alias != null && !subQuerySelect.tableSource.alias.trim().equals("")) {
                            subSelectItem.expr.addExtAttr("tableSourceAlias", subQuerySelect.tableSource.alias);
                        }
                    } else {
                        throw new FormaterException("unexpect subquery item: '" + queryItem.subQuery + "'");
                    }
                    this.formatExpr(subSelectItem.expr, false);
                    ++count;
                    flag = true;
                }
            } else {
                throw new FormaterException("unexpect update item: '" + abstract_item + "'");
            }
            flag = true;
        }
        if (update.tableSource != null) {
            throw new FormaterException("update's tableSource is null");
        }
        if (subqueryUpdateItemList.size() == 0) {
            if (update.updateTable.alias != null) {
                this.buffer.append(" FROM ");
                this.buffer.append(this.formatTableName(update.updateTable.name));
                this.buffer.append(" " + update.updateTable.alias.toUpperCase() + " ");
            }
        } else {
            boolean appendTable = false;
            for (int i = 0; i < subqueryUpdateItemList.size(); ++i) {
                StringBuffer oldBuff;
                if (i == 0) {
                    this.buffer.append(" FROM ");
                    if (update.updateTable.alias != null) {
                        this.buffer.append(this.formatTableName(update.updateTable.name));
                        this.buffer.append(" " + update.updateTable.alias.toUpperCase());
                        appendTable = true;
                    }
                }
                queryItem = (SubQueryUpdateItem)subqueryUpdateItemList.get(i);
                if (queryItem.subQuery instanceof SqlSelect) {
                    oldBuff = this.buffer;
                    this.buffer = new StringBuffer();
                    SqlSelect subQuerySelect = (SqlSelect)queryItem.subQuery;
                    this.formatTableSource(subQuerySelect.tableSource);
                    if (this.buffer.length() > 0) {
                        if (appendTable) {
                            oldBuff.append(", ");
                        }
                        oldBuff.append(this.buffer.toString());
                        appendTable = true;
                    }
                } else {
                    throw new FormaterException("unexpect queryItem subQuery: '" + queryItem + "'");
                }
                this.buffer = oldBuff;
            }
        }
        flag = false;
        for (int i = 0; i < subqueryUpdateItemList.size(); ++i) {
            SubQueryUpdateItem queryItem2 = (SubQueryUpdateItem)subqueryUpdateItemList.get(i);
            if (queryItem2.subQuery instanceof SqlSelect) {
                SqlSelect subQuerySelect = (SqlSelect)queryItem2.subQuery;
                if (subQuerySelect.condition == null) continue;
                if (flag) {
                    this.buffer.append(" AND ");
                } else {
                    this.buffer.append(" WHERE ");
                }
                this.formatExpr(subQuerySelect.condition);
                flag = true;
                continue;
            }
            throw new FormaterException("not support query item:" + queryItem2);
        }
        if (update.condition != null) {
            if (flag) {
                this.buffer.append(" AND ");
            } else {
                this.buffer.append(" WHERE ");
            }
            this.formatExpr(update.condition);
            flag = true;
        }
    }

    @Override
    public void formatExpr(SqlExpr expr, boolean appendBrace) throws FormaterException {
        if (expr.type == 8) {
            if (expr.extendedAttributes().get("tableSourceAlias") != null) {
                this.buffer.append(expr.extendedAttributes().get("tableSourceAlias")).append(".").append("*");
            } else {
                this.buffer.append("*");
            }
        } else {
            super.formatExpr(expr, appendBrace);
        }
    }

    @Override
    protected void formatIdentifierExpr(SqlExpr expr) {
        String ident = ((SqlIdentifierExpr)expr).value;
        if (ident.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
            ident = "SYSCOL.NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
            ident = "CDEFAULT";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
            ident = "ISNULLABLE";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
            ident = "SYSOBJ.NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
            ident = "SYSCOL.LENGTH";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_PRECISION.value)) {
            ident = "SYSCOL.PREC";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_SCALE.value)) {
            ident = "SYSCOL.SCALE";
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) {
            ident = "SYSTYPE.NAME";
        } else if (ident.equalsIgnoreCase(Token.INDNAME.value)) {
            ident = "NAME";
        } else if (ident.equalsIgnoreCase(Token.TABNAME.value)) {
            ident = "SYSOBJ.NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
            ident = "SYSOBJ.CRDATE";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
            ident = "CONST_OBJ.NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
            ident = "TABLE_OBJ.NAME";
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
            ident = "CONST_OBJ.XTYPE";
        }
        if (ident != null && ident.length() != 0 && ident.charAt(0) == '\"') {
            if (expr.extendedAttributes().get("tableSourceAlias") != null) {
                this.buffer.append(expr.extendedAttributes().get("tableSourceAlias")).append(".").append(ident.toUpperCase());
            } else {
                this.buffer.append(ident.toUpperCase());
            }
        } else if (expr.extendedAttributes().get("tableSourceAlias") != null) {
            this.buffer.append(expr.extendedAttributes().get("tableSourceAlias")).append(".").append(ident);
        } else {
            this.buffer.append(ident);
        }
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        Map optionMap = select.getOptionMapDirect();
        if (select.limit != null && select.limit.offset != 0) {
            this.buffer.append("SELECT * FROM ( SELECT *,row_number() over (order by rownum_a.temp_column desc) as rownum_temp FROM ( SELECT ");
        } else {
            this.buffer.append("SELECT ");
        }
        boolean flag2 = false;
        if (select.distinct == 1 && select.orderBy.size() != 0) {
            flag2 = this.checkHaveChineseOrderBy(select.orderBy);
        }
        select.selectItemAliasMap = null;
        if (this.checkHaveChineseOrderBy(select.orderBy)) {
            select.selectItemAliasMap = new HashMap();
            for (SqlSelectItem selectItem : select.selectList) {
                if (selectItem.alias == null || selectItem.alias.length() <= 0) continue;
                select.selectItemAliasMap.put(selectItem.alias.toUpperCase(), selectItem.expr);
            }
        }
        this.formatSelectDistinct(select);
        this.formatSelectLimit(select);
        if (flag2) {
            this.buffer.append("* ");
            this.formatSelectInto(select);
            this.buffer.append("FROM ( SELECT TOP 2147483647 ");
        }
        boolean flag = false;
        boolean sysTableFlag = false;
        boolean sysIndexFlag = false;
        boolean sysConstraintFlag = false;
        for (int i = 0; i < select.selectList.size(); ++i) {
            SqlIdentifierExpr tableNameExpr;
            SqlIdentifierExpr columnNameExpr;
            SqlSelectItem item;
            block90: {
                block88: {
                    block100: {
                        block99: {
                            block98: {
                                block97: {
                                    block96: {
                                        block95: {
                                            block94: {
                                                block93: {
                                                    block92: {
                                                        block91: {
                                                            block89: {
                                                                if (flag) {
                                                                    this.buffer.append(", ");
                                                                }
                                                                item = (SqlSelectItem)select.selectList.get(i);
                                                                this.paramData.changeSelectColumn(select, item);
                                                                if (!(item.expr instanceof SqlIdentifierExpr)) break block88;
                                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) || item.alias != null) break block89;
                                                                item.alias = Token.KSQL_COL_NAME.value;
                                                                break block90;
                                                            }
                                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value) || item.alias != null) break block91;
                                                            item.alias = Token.KSQL_COL_DEFAULT.value;
                                                            break block90;
                                                        }
                                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value) || item.alias != null) break block92;
                                                        item.alias = Token.KSQL_COL_NULLABLE.value;
                                                        break block90;
                                                    }
                                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value) || item.alias != null) break block93;
                                                    item.alias = Token.KSQL_COL_TABNAME.value;
                                                    break block90;
                                                }
                                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value) || item.alias != null) break block94;
                                                item.alias = Token.KSQL_COL_LENGTH.value;
                                                break block90;
                                            }
                                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value) || item.alias != null) break block95;
                                            item.alias = Token.KSQL_COL_TYPE.value;
                                            break block90;
                                        }
                                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value) || item.alias != null) break block96;
                                        sysTableFlag = true;
                                        item.alias = Token.TABNAME.value;
                                        break block90;
                                    }
                                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value) || item.alias != null) break block97;
                                    sysTableFlag = true;
                                    item.alias = Token.KSQL_CREATETIME.value;
                                    break block90;
                                }
                                if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value) || item.alias != null) break block98;
                                sysIndexFlag = true;
                                item.alias = Token.INDNAME.value;
                                break block90;
                            }
                            if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) || item.alias != null) break block99;
                            sysConstraintFlag = true;
                            item.alias = Token.KSQL_CONS_NAME.value;
                            break block90;
                        }
                        if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value) || item.alias != null) break block100;
                        sysConstraintFlag = true;
                        item.alias = Token.KSQL_CONS_TABNAME.value;
                        break block90;
                    }
                    if (!((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value) || item.alias != null) break block90;
                    sysConstraintFlag = true;
                    item.alias = Token.KSQL_CONS_TYPE.value;
                    break block90;
                }
                if (item.expr instanceof SqlAggregateExpr) {
                    List TparamList = ((SqlAggregateExpr)item.expr).paramList;
                    for (SqlExpr param : TparamList) {
                        if (!(param instanceof SqlIdentifierExpr)) continue;
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                            ((SqlIdentifierExpr)param).value = "syscol.name";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                            ((SqlIdentifierExpr)param).value = "cdefault";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                            ((SqlIdentifierExpr)param).value = "isnullable";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                            ((SqlIdentifierExpr)param).value = "sysobj.name";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.TABNAME.value)) {
                            sysTableFlag = true;
                            ((SqlIdentifierExpr)param).value = "sysobj.name";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                            sysTableFlag = true;
                            ((SqlIdentifierExpr)param).value = "sysobj.crdate";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.INDNAME.value)) {
                            sysIndexFlag = true;
                            ((SqlIdentifierExpr)param).value = "name";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                            sysConstraintFlag = true;
                            ((SqlIdentifierExpr)param).value = "const_obj.name";
                            continue;
                        }
                        if (((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                            sysConstraintFlag = true;
                            ((SqlIdentifierExpr)param).value = "table_obj.name";
                            continue;
                        }
                        if (!((SqlIdentifierExpr)param).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) continue;
                        sysConstraintFlag = true;
                        ((SqlIdentifierExpr)param).value = "case const_obj.xtype when 'PK' then 'P' when 'UQ' then 'U' else const_obj.xtype end";
                    }
                }
            }
            if (item.alias != null && item.alias.length() != 0) {
                if (item.expr instanceof SqlIdentifierExpr) {
                    if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                        columnNameExpr = new SqlIdentifierExpr();
                        columnNameExpr.value = "syscol.name";
                        this.formatExpr(columnNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "cdefault";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "sysobj.name";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        tableNameExpr.value = "isnullable";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysTableFlag = true;
                        tableNameExpr.value = "sysobj.name";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysTableFlag = true;
                        tableNameExpr.value = "sysobj.crdate";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysIndexFlag = true;
                        tableNameExpr.value = "name";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysConstraintFlag = true;
                        tableNameExpr.value = "const_obj.name";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysConstraintFlag = true;
                        tableNameExpr.value = "table_obj.name";
                        this.formatExpr(tableNameExpr, true);
                    } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                        tableNameExpr = new SqlIdentifierExpr();
                        sysConstraintFlag = true;
                        tableNameExpr.value = "case const_obj.xtype when 'PK' then 'P' when 'UQ' then 'U' else const_obj.xtype end";
                        this.formatExpr(tableNameExpr, true);
                    } else {
                        this.formatExpr(item.expr, true);
                    }
                } else {
                    this.formatExpr(item.expr, true);
                }
                if (item.expr instanceof SqlCharExpr || item.expr instanceof SqlNCharExpr) {
                    this.buffer.append(" COLLATE Chinese_PRC_CS_AS");
                }
                this.buffer.append(" ");
                this.buffer.append(item.alias.toUpperCase());
            } else if (item.expr instanceof SqlIdentifierExpr) {
                if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
                    columnNameExpr = new SqlIdentifierExpr();
                    columnNameExpr.value = "syscol.name";
                    this.formatExpr(columnNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "cdefault";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "isnullable";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "sysobj.name";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "sysobj.name";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "sysobj.crdate";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "name";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "const_obj.name";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "table_obj.name";
                    this.formatExpr(tableNameExpr, false);
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
                    tableNameExpr = new SqlIdentifierExpr();
                    tableNameExpr.value = "case const_obj.xtype when 'PK' then 'P' when 'UQ' then 'U' else const_obj.xtype end";
                    this.formatExpr(tableNameExpr, false);
                } else {
                    this.formatExpr(item.expr, false);
                }
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        if (select.limit != null && select.limit.offset != 0) {
            this.buffer.append(",temp_column=0 ");
        }
        if (!flag2) {
            this.formatSelectInto(select);
        }
        this.formatSelectTabSrc(select);
        this.formatSelectCondition(select, sysTableFlag, sysIndexFlag, sysConstraintFlag);
        if (select.hierarchicalQueryClause != null) {
            throw new FormaterException("NOT SUPPORT hierarchicalQueryClause");
        }
        this.formatSelectGroupBy(select);
        this.formatSelectHaving(select);
        this.formatSelectOrderBy(select);
        if (select.limit != null && select.limit.offset != 0) {
            this.buffer.append(" ) rownum_a ) rownum_t WHERE rownum_t.rownum_temp BETWEEN ").append(select.limit.offset + 1).append(" AND ").append(select.limit.value + select.limit.offset);
        }
        if (optionMap != null && optionMap.size() != 0) {
            this.buffer.append(" OPTION (");
            for (Map.Entry entry : optionMap.entrySet()) {
                String key = (String)entry.getKey();
                if ("HASH GROUP".equalsIgnoreCase(key)) {
                    this.buffer.append(" HASH GROUP");
                    continue;
                }
                if ("ORDER GROUP".equalsIgnoreCase(key)) {
                    this.buffer.append(" ORDER GROUP");
                    continue;
                }
                if ("CONCAT UNION".equalsIgnoreCase(key)) {
                    this.buffer.append(" CONCAT UNION");
                    continue;
                }
                if ("HASH UNION".equalsIgnoreCase(key)) {
                    this.buffer.append(" HASH UNION");
                    continue;
                }
                if ("MERGE UNION".equalsIgnoreCase(key)) {
                    this.buffer.append(" MERGE UNION");
                    continue;
                }
                if ("LOOP JOIN".equalsIgnoreCase(key)) {
                    this.buffer.append(" LOOP JOIN");
                    continue;
                }
                if ("MERGE JOIN".equalsIgnoreCase(key)) {
                    this.buffer.append(" MERGE JOIN");
                    continue;
                }
                if ("HASH JOIN".equalsIgnoreCase(key)) {
                    this.buffer.append(" HASH JOIN");
                    continue;
                }
                if ("FAST".equalsIgnoreCase(key)) {
                    this.buffer.append(" FAST ");
                    this.buffer.append(entry.getValue());
                    continue;
                }
                if ("FASTFIRSTROW".equalsIgnoreCase(key)) {
                    this.buffer.append(" FASTFIRSTROW");
                    continue;
                }
                if ("FORCE ORDER".equalsIgnoreCase(key) || "ORDERED".equalsIgnoreCase(key)) {
                    this.buffer.append(" FORCE ORDER");
                    continue;
                }
                if ("MAXDOP".equalsIgnoreCase(key)) {
                    this.buffer.append(" MAXDOP ");
                    this.buffer.append(entry.getValue());
                    continue;
                }
                if ("ROBUST PLAN".equalsIgnoreCase(key)) {
                    this.buffer.append(" ROBUST PLAN");
                    continue;
                }
                if ("KEEP PLAN".equalsIgnoreCase(key)) {
                    this.buffer.append(" KEEP PLAN");
                    continue;
                }
                if ("KEEPFIXED PLAN".equalsIgnoreCase(key)) {
                    this.buffer.append(" KEEPFIXED PLAN");
                    continue;
                }
                if (!"EXPAND VIEWS".equalsIgnoreCase(key)) continue;
                this.buffer.append(" EXPAND VIEWS");
            }
            this.buffer.append(")");
        }
        if (flag2) {
            this.buffer.append(") ");
            this.buffer.append(new UUTN().toString());
        }
    }

    protected void formatSelectInto(SqlSelect select) {
        if (select.into != null) {
            this.buffer.append(" INTO ");
            this.buffer.append(this.formatTableName(select.into.new_table));
        }
    }

    protected void formatSelectLimit(SqlSelect select) {
        if (select.limit != null) {
            this.buffer.append("TOP ");
            this.buffer.append(select.limit.value + select.limit.offset);
            this.buffer.append(" ");
            if (select.limit.type == 1) {
                this.buffer.append("PERCENT ");
            }
        }
    }
}

