/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.shell;

import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.shell.KDConnection;
import com.kingdee.bos.sql.shell.nologging.NoLoggingProcess;
import com.kingdee.bos.sql.shell.trace.KSqlMonitor;
import com.kingdee.bos.sql.shell.trace.TraceInfo;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class KDDriver
implements Driver {
    public static final String OPTIONS_DBTYPE = "dbtype";
    public static final String OPTIONS_TRANSLATE = "translate";
    public static final String OPTIONS_TRACE = "trace";
    public static final String OPTIONS_FILTER = "filter";
    public static final String OPTIONS_TRACEFILE = "file";
    public static final String OPTIONS_NOLOGGING = "noLogging";
    public static final String OPTIONS_BINDPORT = "bindport";
    public static final String OPTIONS_OPTIMIZE = "optimize";
    public static final String OPTIONS_TEMPTABLESPACE = "temptablespace";
    public static final String OPTIONS_DBSCHEMA = "dbSchema";
    public static final String OPTIONS_TABLESCHEMA = "tableSchema";
    private static final int DEFAULT_LOGINTIMEOUT = 5;
    private static final int MIN_LOGINtIMEOUT = 0;
    private static final int MAX_LOGINtIMEOUT = 30;
    private static final String LOGINTIMEOUT = "logintimeout";
    private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(KDDriver.class);

    private static void initSystemProperty() {
        int loginTimeout = 5;
        try {
            String sysLoginTimeout = System.getProperty(LOGINTIMEOUT);
            if (sysLoginTimeout != null) {
                loginTimeout = Integer.parseInt(sysLoginTimeout);
            }
            if (loginTimeout < 0 || loginTimeout > 30) {
                loginTimeout = 5;
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
        }
        DriverManager.setLoginTimeout(loginTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection connect(String url, Properties properties) throws SQLException {
        KDConnection kdConn;
        block52: {
            TraceInfo traceInfo;
            String password;
            if (url.startsWith("jdbc:ksqle:")) {
                url = KSqlUtil.decodeUrl(url);
            }
            if (!url.startsWith("jdbc:ksql:")) {
                return null;
            }
            Properties properties2 = new Properties();
            Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                properties2.put(entry.getKey(), entry.getValue());
            }
            String user = properties2.getProperty("user");
            if (user.startsWith("ksqle:")) {
                user = KSqlUtil.decodePassword(user);
                properties2.put("user", user);
            }
            if ((password = properties2.getProperty("password")).startsWith("ksqle:")) {
                password = KSqlUtil.decodePassword(password);
                properties2.put("password", password);
            }
            int tempRecycleTime = 0x6DDD00;
            if (properties2.getProperty("recycletime") != null) {
                tempRecycleTime = Integer.parseInt(properties2.getProperty("recycletime"));
            }
            if ((traceInfo = KSqlMonitor.getTraceInfo(url)) == null) {
                traceInfo = KSqlUtil.parseURL(url, tempRecycleTime);
                KSqlMonitor.putTraceInfo(url, traceInfo);
                KSqlUtil.setOptimizeMode(traceInfo.OptimizeMode);
            } else {
                traceInfo = (TraceInfo)traceInfo.clone();
            }
            traceInfo.password = password;
            traceInfo.userName = user;
            String originalURL = traceInfo.originalUrl;
            String driverName = traceInfo.driverName;
            try {
                Class.forName(driverName);
                Connection cn = DriverManager.getConnection(originalURL, properties2);
                kdConn = new KDConnection(cn, traceInfo.dbType, traceInfo);
                NoLoggingProcess.processKDConnection(kdConn);
                if (traceInfo.dbType != 9 && traceInfo.dbType != 1) break block52;
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    String sql = "/*dialect*/SELECT SUBSTR(REG_VAR_NAME, 1, 25) AS NAME FROM TABLE(SYSPROC.REG_LIST_VARIABLES()) AS VAR_TABLES WHERE UCASE(REG_VAR_VALUE) = 'ON' AND (REG_VAR_NAME LIKE 'DB2_SKIPDELETED%' OR REG_VAR_NAME LIKE 'DB2_EVALUNCOMMITTED%' OR REG_VAR_NAME LIKE 'DB2_SKIPINSERTED%')";
                    stmt = kdConn.createStatement();
                    rs = stmt.executeQuery(sql);
                    boolean flag = false;
                    String options = "";
                    while (rs.next()) {
                        if (!flag) {
                            flag = true;
                            options = options + rs.getString(1).trim();
                            continue;
                        }
                        options = options + "," + rs.getString(1).trim();
                    }
                    if (flag) {
                        throw new IllegalStateException("These DB2 options must be set to OFF:" + options);
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"Check DB2 Option Error!", (Throwable)ex);
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"ResultSet close error", (Throwable)e);
                    }
                    finally {
                        try {
                            if (stmt != null) {
                                stmt.close();
                            }
                        }
                        catch (Exception e) {
                            logger.error((Object)"Statement close error", (Throwable)e);
                        }
                    }
                }
            }
            catch (SQLException ex) {
                logger.warn((Object)("Current url : " + url));
                logger.warn((Object)("Current original url : " + originalURL));
                logger.warn((Object)("Current user : " + user));
                logger.warn((Object)ex);
                throw ex;
            }
            catch (ClassNotFoundException ce) {
                throw new SQLException("Class " + driverName + " Not Found");
            }
        }
        this.logNewConnection();
        return kdConn;
    }

    private void logNewConnection() {
        String debug_new = System.getProperty("DEBUG_WHEN_NEW_CONNECTION");
        if ("TRUE".equals(debug_new)) {
            Exception ex = new Exception(System.currentTimeMillis() + ": Create a new database connnection");
            logger.debug((Object)"DEBUG_WHEN_NEW_CONNECTION", (Throwable)ex);
        }
    }

    public synchronized Connection connectByNative(String url, Properties info) throws SQLException {
        if (!url.startsWith("jdbc:ksql:")) {
            return null;
        }
        TraceInfo traceInfo = KSqlUtil.parseURL(url);
        String originalURL = traceInfo.originalUrl;
        String driverName = traceInfo.driverName;
        try {
            Class.forName(driverName);
            Connection cn = DriverManager.getConnection(originalURL, info);
            this.logNewConnection();
            return cn;
        }
        catch (ClassNotFoundException ce) {
            throw new SQLException("Class " + driverName + " Not Found");
        }
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:ksql");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return 3;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("TODO");
    }

    static {
        try {
            DriverManager.registerDriver(new KDDriver());
            KDDriver.initSystemProperty();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage());
        }
    }
}

