/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.privacy;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.MetadataCleaner;
import com.kingdee.bos.dao.xml.impl.MetadataClearListener;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.privacy.DefaultPrivacyService;
import com.kingdee.bos.privacy.IPrivacyService;
import com.kingdee.bos.privacy.ParamData;
import com.kingdee.bos.privacy.PrivacyData;
import com.kingdee.bos.privacy.PrivacyPropertyAccess;
import com.kingdee.bos.privacy.PrivacyPropertyInfo;
import com.kingdee.bos.privacy.encrypt.ComposeEncryptor;
import com.kingdee.bos.privacy.encrypt.EncryptUtils;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.shell.trace.ConnectionLogger;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public class PrivacyPropertyManager {
    private static final ThreadLocal<Boolean> power = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private static Logger log = Logger.getLogger(ConnectionLogger.class);
    public static final String NO_BOSTYPE = "NO_TYPE_";
    private static final Map<String, Boolean> reloadMap = new ConcurrentHashMap<String, Boolean>();
    private static final IPrivacyService ps;
    private static final Map<String, PrivacyPropertyAccess> cache;

    public static void enable() {
        power.set(Boolean.TRUE);
    }

    public static void disable() {
        power.set(Boolean.FALSE);
    }

    public static boolean isEnable() {
        return power.get();
    }

    private PrivacyPropertyManager() {
    }

    public static IPrivacyService getPrivacyService(Context ctx) {
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static PrivacyPropertyAccess getPrivacyPropertyAccess(Context ctx, String tableName) throws BOSException {
        if (reloadMap.get(ctx.getAIS()).booleanValue()) {
            Class<PrivacyPropertyManager> clazz = PrivacyPropertyManager.class;
            // MONITORENTER : com.kingdee.bos.privacy.PrivacyPropertyManager.class
            if (reloadMap.get(ctx.getAIS()).booleanValue()) {
                reloadMap.put(ctx.getAIS(), Boolean.FALSE);
                PrivacyPropertyManager.reload(ctx);
            }
            // MONITOREXIT : clazz
        }
        if (StringUtils.isEmpty((String)tableName)) {
            return null;
        }
        String key = PrivacyPropertyManager.aisKey(ctx.getAIS(), tableName.toLowerCase(Locale.ENGLISH));
        return cache.get(key);
    }

    private static void reload(Context ctx) throws BOSException {
        block11: {
            try {
                Iterator<Map.Entry<String, PrivacyPropertyAccess>> iterator = cache.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, PrivacyPropertyAccess> entry = iterator.next();
                    String key = entry.getKey();
                    if (!key.startsWith(ctx.getAIS() + "$$")) continue;
                    iterator.remove();
                }
                String sql = " select fbostype,ffield,fisSimple,fsolutionId,ftableName,ffieldType from T_Privacy_Mapping where fstate in (?,?,?) and fsolutionId is not null order by fbostype ";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{4, 5, 6});
                if (rs == null) break block11;
                IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                String _tableName = null;
                String lastBosType = null;
                String lastFailSolutionId = null;
                EntityObjectInfo entity = null;
                HashSet<String> errorBostypes = new HashSet<String>();
                while (rs.next()) {
                    String solutionId = rs.getString("fsolutionId");
                    if (solutionId.equals(lastFailSolutionId)) continue;
                    ComposeEncryptor encryptor = EncryptUtils.getEncryptor(ctx, solutionId);
                    if (encryptor == null) {
                        lastFailSolutionId = solutionId;
                        continue;
                    }
                    String bosType = rs.getString("fbostype");
                    if (errorBostypes.contains(bosType)) continue;
                    if (NO_BOSTYPE.equals(bosType)) {
                        _tableName = rs.getString("ftableName");
                        entity = null;
                    } else if (!bosType.equals(lastBosType)) {
                        try {
                            entity = loader.getEntity(BOSObjectType.create((String)bosType));
                            DataTableInfo table = entity.getTable();
                            _tableName = table.getName();
                            lastBosType = bosType;
                        }
                        catch (Throwable e) {
                            errorBostypes.add(bosType);
                            continue;
                        }
                    }
                    String field = rs.getString("ffield");
                    boolean isSimple = 1 == rs.getInt("fisSimple");
                    String ffieldType = rs.getString("ffieldType");
                    if (_tableName == null || StringUtils.isEmpty((String)field)) continue;
                    String key = ctx.getAIS() + "$$" + _tableName.toLowerCase();
                    PrivacyPropertyAccess privacyPropertyAccess = cache.get(key);
                    if (privacyPropertyAccess == null) {
                        privacyPropertyAccess = new PrivacyPropertyAccess();
                        cache.put(key, privacyPropertyAccess);
                    }
                    privacyPropertyAccess.addField(ctx, solutionId, entity, field, isSimple, ffieldType);
                }
            }
            catch (Throwable e) {
                log.error((Object)e.getMessage(), e);
            }
        }
    }

    public static String aisKey(String ais, String key) {
        if (StringUtils.isEmpty((String)key) || StringUtils.isEmpty((String)ais)) {
            return null;
        }
        return ais + "$$" + key;
    }

    public static PrivacyPropertyInfo getPrivacyPropBySqlField(Context ctx, String tableName, String sqlField) throws BOSException {
        PrivacyPropertyAccess privacyPropertyAccess = PrivacyPropertyManager.getPrivacyPropertyAccess(ctx, tableName);
        if (privacyPropertyAccess != null) {
            return privacyPropertyAccess.getPrivacyPropBySqlField(sqlField);
        }
        return null;
    }

    public static boolean isPrivacyField(Context ctx, String tableName, String sqlField) throws BOSException {
        PrivacyPropertyAccess privacyPropertyAccess = PrivacyPropertyManager.getPrivacyPropertyAccess(ctx, tableName);
        if (privacyPropertyAccess != null) {
            return privacyPropertyAccess.getPrivacyPropBySqlField(sqlField) != null;
        }
        return false;
    }

    public static boolean isPrivacyTable(Context ctx, String tableName) throws BOSException {
        return PrivacyPropertyManager.getPrivacyPropertyAccess(ctx, tableName) != null;
    }

    public static boolean isPrivacyField(String ais, String tableName, String sqlField) throws BOSException {
        if (StringUtils.isEmpty((String)tableName)) {
            return false;
        }
        String key = PrivacyPropertyManager.aisKey(ais, tableName.toLowerCase(Locale.ENGLISH));
        PrivacyPropertyAccess privacyPropertyAccess = cache.get(key);
        if (privacyPropertyAccess != null) {
            return privacyPropertyAccess.getPrivacyPropBySqlField(sqlField) != null;
        }
        return false;
    }

    public static String[] getLanguagePostfix(Context ctx) {
        SolutionInfo solution = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        LanguageCollection langs = solution.getLanguages();
        String[] p = new String[langs.size()];
        int size = langs.size();
        for (int i = 0; i < size; ++i) {
            p[i] = "_" + langs.get(i).getPostfix();
        }
        return p;
    }

    public static void clear(String ais) {
        reloadMap.put(ais, Boolean.TRUE);
    }

    public static String testEncrypt(Context ctx, String bostype, String field, String column, Object src) throws BOSException {
        StringBuilder sb = new StringBuilder();
        PrivacyPropertyInfo privacyPropertyInfo = PrivacyPropertyManager.buildPrivacyPropertyInfo(ctx, bostype, field, column);
        if (privacyPropertyInfo != null) {
            PrivacyData privacyData = new PrivacyData(privacyPropertyInfo);
            privacyData.setOriginalValue(src);
            ps.encrypt(ctx, privacyData);
            sb.append("CipherText:").append("\n").append(privacyData.getCipherText()).append("\n").append("HashCode:").append("\n").append(privacyData.getHashCode());
        } else {
            sb.append("No Privacy Field");
        }
        return sb.toString();
    }

    public static String testDecrypt(Context ctx, String bostype, String field, String column, String cipherText) throws BOSException {
        StringBuilder sb = new StringBuilder();
        PrivacyPropertyInfo privacyPropertyInfo = PrivacyPropertyManager.buildPrivacyPropertyInfo(ctx, bostype, field, column);
        if (privacyPropertyInfo != null) {
            PrivacyData privacyData = new PrivacyData(privacyPropertyInfo);
            privacyData.setCipherText(cipherText);
            ps.decrypt(ctx, privacyData);
            sb.append("OriginalValue:").append("\n").append(privacyData.getOriginalValue());
        } else {
            sb.append("No Privacy Field");
        }
        return sb.toString();
    }

    private static PrivacyPropertyInfo buildPrivacyPropertyInfo(Context ctx, String bostype, String field, String column) throws BOSException {
        try {
            String sql = " select top 1 fbostype,fisSimple,fsolutionId,ftableName,ffieldType from T_Privacy_Mapping where (fbostype=? or ftableName=?) and ffield=?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bostype, bostype, field});
            if (rs != null) {
                String tableName = null;
                EntityObjectInfo entity = null;
                if (rs.next()) {
                    String solutionId = rs.getString("fsolutionId");
                    String bosType = rs.getString("fbostype");
                    if (NO_BOSTYPE.equals(bosType)) {
                        tableName = rs.getString("ftableName");
                    } else {
                        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
                        entity = loader.getEntity(BOSObjectType.create((String)bosType));
                        DataTableInfo table = entity.getTable();
                        tableName = table.getName();
                    }
                    boolean isSimple = 1 == rs.getInt("fisSimple");
                    String ffieldType = rs.getString("ffieldType");
                    if (tableName != null && !StringUtils.isEmpty((String)field)) {
                        PrivacyPropertyAccess privacyPropertyAccess = new PrivacyPropertyAccess();
                        privacyPropertyAccess.addField(ctx, solutionId, entity, field, isSimple, ffieldType);
                        return privacyPropertyAccess.getPrivacyPropBySqlField(column);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static String testTranslate(Context ctx, String ksql, int dbType) throws SqlTranslateException {
        ParamData paramData = new ParamData(ctx);
        return TransUtil.translate(ksql, dbType, null, paramData);
    }

    public static String testTranslate(Context ctx, String ksql) throws SqlTranslateException {
        return PrivacyPropertyManager.testTranslate(ctx, ksql, 7);
    }

    public static String checkBostype(Context ctx, String bosType) {
        try {
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)bosType));
            DataTableInfo table = entity.getTable();
            table.getName();
            String sql = "select FFIELD from t_privacy_mapping where fbosType=? ";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bosType});
            while (rs.next()) {
                String field = rs.getString(1);
                PropertyInfo prop = entity.getPropertyByNameRuntime(field);
                if (prop instanceof OwnPropertyInfo) {
                    OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
                    if (ownProp.getMappingField() != null) continue;
                    throw new Exception("\u5b57\u6bb5" + field + "\u5bf9\u5e94\u7684\u8868\u5143\u6570\u636e\u4e0d\u5b58\u5728");
                }
                throw new Exception("\u5b57\u6bb5" + field + "\u5bf9\u5e94\u7684\u5b9e\u4f53\u5143\u6570\u636e\u4e0d\u5b58\u5728");
            }
            return "YES";
        }
        catch (Throwable e) {
            return ExceptionUtils.getStackTrace((Throwable)e);
        }
    }

    public static String checkWhiteList(Context ctx) throws BOSException, SQLException {
        String sql = "select distinct ftableName from T_Privacy_Mapping where fbostype='NO_TYPE_'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> notype = new HashSet<String>();
        while (rs.next()) {
            String tableName = rs.getString(1);
            String sql2 = "SHOW COLUMNS FROM " + tableName;
            IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql2);
            while (rs2.next()) {
                String columnName = rs2.getString("COLUMN_NAME");
                notype.add((tableName + columnName).toLowerCase());
            }
        }
        sql = " select fid,fbostype,ffield,fisSimple,ftableName from T_Privacy_Mapping order by fbostype ";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        String lastBosType = null;
        HashSet<String> errorBostypes = new HashSet<String>();
        HashSet<String> errorFileds = new HashSet<String>();
        HashSet<String> errorIds = new HashSet<String>();
        EntityObjectInfo entity = null;
        while (rs.next()) {
            PropertyInfo prop;
            String fid = rs.getString("fid");
            if (!"C0198DE0".equals(BOSUuid.read((String)fid).getType().toString())) {
                errorIds.add(fid);
            }
            String bosType = rs.getString("fbostype");
            String field = rs.getString("ffield");
            if (errorBostypes.contains(bosType)) continue;
            if (NO_BOSTYPE.equals(bosType)) {
                String tableName = rs.getString("ftableName");
                if (notype.contains((tableName + field).toLowerCase())) continue;
                errorFileds.add(fid);
                continue;
            }
            if (!bosType.equals(lastBosType)) {
                try {
                    entity = loader.getEntity(BOSObjectType.create((String)bosType));
                }
                catch (Throwable e) {
                    errorBostypes.add(bosType);
                    continue;
                }
            }
            if (!(entity == null || (prop = entity.getPropertyByNameRuntime(field)) != null && prop instanceof OwnPropertyInfo)) {
                errorFileds.add(fid);
            }
            lastBosType = bosType;
        }
        StringBuilder result = new StringBuilder();
        result.append("errorBostypes:" + JSON.toJSONString(errorBostypes)).append("\n");
        result.append("errorFileds:" + JSON.toJSONString(errorFileds)).append("\n");
        result.append("errorIds:" + JSON.toJSONString(errorIds)).append("\n");
        return result.toString();
    }

    static {
        try {
            ArrayList list = DCManager.getInstance().getDCList();
            for (Object item : list) {
                DCInfo info = (DCInfo)item;
                String ais = info.getNumber();
                reloadMap.put(ais, Boolean.TRUE);
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        MetadataCleaner.registerListener((MetadataClearListener)new MetadataClearListener(){

            public void clearAll() {
                Context ctx = ConfigMDUtil.getContext();
                if (ctx != null) {
                    this.clear(ctx.getAIS());
                }
            }

            public void clear(String key) {
            }
        });
        ps = new DefaultPrivacyService();
        cache = new HashMap<String, PrivacyPropertyAccess>();
    }
}

