/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.datatype;

public class DataType {
    public static final String CHAR = "CHAR";
    public static final String VARCHAR = "VARCHAR";
    public static final String NCHAR = "NCHAR";
    public static final String NVARCHAR = "NVARCHAR";
    public static final String BINARY = "BINARY";
    public static final String VARBINARY = "VARBINARY";
    public static final String BLOB = "BLOB";
    public static final String CLOB = "CLOB";
    public static final String NCLOB = "NCLOB";
    public static final String INT = "INT";
    public static final String TINYINT = "TINYINT";
    public static final String INTEGER = "INTEGER";
    public static final String DECIMAL = "DECIMAL";
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    public static final String DATETIME = "DATETIME";
    public static final String FUNC_NATIVETYPE = "NATIVE_TYPE";
    private static DB2AS400 instanceDB2AS400 = new DB2AS400();
    private static DB2 instanceDB2 = new DB2();
    private static ORACLE instanceORACLE = new ORACLE();
    private static ORACLE10 instanceORACLE10 = new ORACLE10();
    private static ORACLE9 instanceORACLE9 = new ORACLE9();
    private static PostgresSQL postgreSQL = new PostgresSQL();
    private static MSSQL instanceMSSQL = new MSSQL();
    private static DM instanceDM = new DM();

    public String nativeType(String type) {
        if (type == null) {
            return "";
        }
        return type.toUpperCase();
    }

    public static DataType getDataType(int dbtype) {
        switch (dbtype) {
            case 9: {
                return instanceDB2AS400;
            }
            case 1: {
                return instanceDB2;
            }
            case 2: {
                return instanceORACLE;
            }
            case 7: {
                return instanceORACLE9;
            }
            case 8: {
                return instanceORACLE10;
            }
            case 3: {
                return instanceMSSQL;
            }
            case 5: {
                return postgreSQL;
            }
            case 11: {
                return instanceDM;
            }
        }
        return null;
    }

    static class DM
    extends DataType {
        DM() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.VARCHAR.equalsIgnoreCase(type)) {
                return "VARCHAR2";
            }
            if (DataType.NVARCHAR.equalsIgnoreCase(type)) {
                return "NVARCHAR2";
            }
            if (DataType.DECIMAL.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.INT.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.INTEGER.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.DATETIME.equalsIgnoreCase(type)) {
                return "TIMESTAMP";
            }
            return super.nativeType(type);
        }
    }

    static final class PostgresSQL
    extends DataType {
        PostgresSQL() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.VARCHAR.equalsIgnoreCase(type)) {
                return "CHARACTER VARYING";
            }
            if (DataType.NVARCHAR.equalsIgnoreCase(type)) {
                return "CHARACTER VARYING";
            }
            if (DataType.DECIMAL.equalsIgnoreCase(type)) {
                return "NUMERIC";
            }
            if (DataType.INT.equalsIgnoreCase(type)) {
                return DataType.INTEGER;
            }
            if (DataType.INTEGER.equalsIgnoreCase(type)) {
                return DataType.INTEGER;
            }
            if (DataType.DATETIME.equalsIgnoreCase(type)) {
                return "TIMESTAMP WITHOUT TIME ZONE";
            }
            if (DataType.BLOB.equalsIgnoreCase(type)) {
                return "BYTEA";
            }
            if (DataType.CLOB.equalsIgnoreCase(type)) {
                return "TEXT";
            }
            if (DataType.NCLOB.equalsIgnoreCase(type)) {
                return "TEXT";
            }
            return super.nativeType(type);
        }
    }

    static class ORACLE10
    extends ORACLE9 {
        ORACLE10() {
        }
    }

    static class ORACLE9
    extends ORACLE {
        ORACLE9() {
        }
    }

    static class ORACLE
    extends DataType {
        ORACLE() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.VARCHAR.equalsIgnoreCase(type)) {
                return "VARCHAR2";
            }
            if (DataType.NVARCHAR.equalsIgnoreCase(type)) {
                return "NVARCHAR2";
            }
            if (DataType.DECIMAL.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.INT.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.INTEGER.equalsIgnoreCase(type)) {
                return "NUMBER";
            }
            if (DataType.DATETIME.equalsIgnoreCase(type)) {
                return "TIMESTAMP";
            }
            return super.nativeType(type);
        }
    }

    static class MSSQL
    extends DataType {
        MSSQL() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.BLOB.equalsIgnoreCase(type)) {
                return "IMAGE";
            }
            if (DataType.CLOB.equalsIgnoreCase(type)) {
                return "TEXT";
            }
            if (DataType.NCLOB.equalsIgnoreCase(type)) {
                return "NTEXT";
            }
            return super.nativeType(type);
        }
    }

    static class DB2
    extends DataType {
        DB2() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.TINYINT.equalsIgnoreCase(type)) {
                return "SMALLINT";
            }
            if (DataType.DATETIME.equalsIgnoreCase(type)) {
                return "TIMESTAMP";
            }
            if (DataType.NVARCHAR.equalsIgnoreCase(type)) {
                return "VARGRAPHIC";
            }
            if (DataType.NCHAR.equalsIgnoreCase(type)) {
                return "GRAPHIC";
            }
            if (DataType.NCLOB.equalsIgnoreCase(type)) {
                return DataType.CLOB;
            }
            if (DataType.BINARY.equalsIgnoreCase(type)) {
                return DataType.VARCHAR;
            }
            if (DataType.VARBINARY.equalsIgnoreCase(type)) {
                return DataType.VARCHAR;
            }
            if (DataType.INT.equalsIgnoreCase(type)) {
                return DataType.INT;
            }
            return super.nativeType(type);
        }
    }

    static final class DB2AS400
    extends DB2 {
        DB2AS400() {
        }

        @Override
        public String nativeType(String type) {
            if (DataType.INT.equalsIgnoreCase(type)) {
                return DataType.INTEGER;
            }
            return super.nativeType(type);
        }
    }
}

