/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.shell.trace;

import com.kingdee.bos.sql.CONSTANT;
import com.kingdee.bos.sql.shell.trace.KSqlMonitor;
import com.kingdee.bos.sql.shell.trace.LogItem;
import com.kingdee.bos.sql.shell.trace.LoggerDest;
import com.kingdee.bos.sql.shell.trace.Queue;
import com.kingdee.bos.sql.shell.trace.server.TraceServer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ConnectionLogger {
    private static boolean isValid = false;
    private static boolean isOutput = false;
    private static boolean isFilterTime = false;
    private static long filter_time_threshold = 10000L;
    private static LazyLog lazy = new LazyLog();
    public static final Logger logger = Logger.getLogger((String)ConnectionLogger.class.getName());
    private static LoggerDest[] loggers = new LoggerDest[0];
    private static Queue queue = new Queue();
    private final String fileName;
    private RandomAccessFile logfile;
    private final String filter;
    private final Pattern pattern;
    private int bindPort = -1;
    private static Map loggerMap = new HashMap();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static boolean isOutput() {
        return isOutput;
    }

    public static void setOutput(boolean output) {
        isOutput = output;
    }

    public static boolean isFilterTime() {
        return isFilterTime;
    }

    public static void setFilterTime(boolean isFilter) {
        isFilterTime = isFilter;
    }

    public static long getFilterTimeThreshold() {
        return filter_time_threshold;
    }

    public static void setFilterTimeThreshold(long threshold) {
        filter_time_threshold = threshold;
    }

    public static boolean isValid() {
        return isValid;
    }

    public static void setValid(boolean valid) {
        if (valid) {
            lazy.stopThread();
            lazy = new LazyLog();
            lazy.setName("KSql Lazy Log");
            lazy.setDaemon(true);
            lazy.setPriority(1);
            lazy.start();
        } else {
            lazy.stopThread();
        }
        isValid = valid;
    }

    public static synchronized ConnectionLogger getLogger(String fileName, String filter, int bindPort) {
        ConnectionLogger logger;
        if (fileName == null) {
            fileName = "null";
        }
        if ((logger = (ConnectionLogger)loggerMap.get(fileName)) == null) {
            logger = new ConnectionLogger(fileName, filter, bindPort);
            loggerMap.put(fileName, logger);
        }
        return logger;
    }

    public ConnectionLogger(String fileName, String filter, int bindPort) {
        this.fileName = fileName;
        this.filter = filter;
        this.bindPort = bindPort;
        this.pattern = filter != null && filter.length() > 0 ? Pattern.compile(filter, 2) : null;
        if (fileName != null && fileName.trim().length() > 0 && !fileName.equalsIgnoreCase("null") && !fileName.equalsIgnoreCase("console")) {
            try {
                this.logfile = new RandomAccessFile(fileName, "rw");
                this.logfile.seek(this.logfile.length());
            }
            catch (IOException e) {
                this.logToConsole("Cannot open log file " + fileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        JVMHook hook = new JVMHook();
        Runtime.getRuntime().addShutdownHook(hook);
        String deploy = System.getProperty("eas.deploy");
        String perfLog = deploy + "/PerfLog_Server.properties";
        Properties prop = new Properties();
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(perfLog);
            prop.load(ins);
        }
        catch (Exception exception) {
        }
        finally {
            if (ins != null) {
                try {
                    ((InputStream)ins).close();
                }
                catch (IOException iOException) {}
            }
        }
        String onoff = prop.getProperty("ksql");
        if (onoff != null && onoff.equalsIgnoreCase("on")) {
            isValid = true;
            lazy.setName("KSql Lazy Log");
            lazy.setDaemon(true);
            lazy.setPriority(1);
            lazy.start();
        } else {
            isValid = false;
        }
        String output = prop.getProperty("ksql_output");
        isOutput = output != null && output.equalsIgnoreCase("on");
        String filter = prop.getProperty("ksql_filter_time");
        if (filter != null && filter.equalsIgnoreCase("on")) {
            isFilterTime = true;
            String threshold = prop.getProperty("ksql_filter_time_threshold");
            if (threshold != null) {
                filter_time_threshold = Long.parseLong(threshold);
            }
        } else {
            isFilterTime = false;
        }
    }

    private static void logToFile(Pair pair) {
        LogItem logItem = (LogItem)pair.second;
        if (logItem != null && logItem.dialect_sql != null) {
            logger.debug((Object)("sql_id: " + logItem.dialect_sql.hashCode()));
        } else {
            logger.debug((Object)"sql_id: -1");
        }
        logger.debug((Object)logItem.toString());
    }

    private void logToFile(LogItem logItem) {
        if (this.logfile == null && (this.fileName == null || "null".equalsIgnoreCase(this.fileName))) {
            TraceServer traceSrv = KSqlMonitor.getTraceServer(this.bindPort);
            if (traceSrv != null) {
                traceSrv.writeLogItem(logItem);
            }
            return;
        }
        if (this.pattern != null) {
            if ("exception".equalsIgnoreCase(this.filter) && logItem.errorMessage == null) {
                return;
            }
            if (!this.pattern.matcher(logItem.ksql).find()) {
                return;
            }
        }
        String msg = logItem.toString();
        TraceServer traceSrv = KSqlMonitor.getTraceServer(this.bindPort);
        if (traceSrv != null) {
            traceSrv.writeLogItem(logItem);
        }
        if ("console".equalsIgnoreCase(this.fileName)) {
            logger.info((Object)msg);
        } else {
            try {
                byte[] b = (msg + CONSTANT.LINE_SEPARATOR).getBytes();
                this.logfile.write(b);
            }
            catch (IOException e) {
                this.logToConsole("Error: Cannot write to log file. Disk full?");
            }
        }
    }

    void logToConsole(String msg) {
        logger.info((Object)msg);
    }

    public void write(String msg) {
        queue.put(new Pair(this.fileName, msg));
    }

    public void write(LogItem item) {
        String dialect = item.dialect_sql;
        if (dialect != null) {
            int index = -1;
            while ((index = dialect.indexOf("\r")) > -1) {
                dialect = dialect.substring(0, index) + " " + dialect.substring(index + 1);
            }
            while ((index = dialect.indexOf("\n")) > -1) {
                dialect = dialect.substring(0, index) + " " + dialect.substring(index + 1);
            }
            item.dialect_sql = dialect;
        }
        if (isOutput && (!isFilterTime || isFilterTime && item.timespan >= filter_time_threshold)) {
            queue.put(new Pair(this.fileName, item));
        }
        for (int i = 0; i < loggers.length; ++i) {
            loggers[i].log(item);
        }
    }

    public static synchronized void addLoggerDest(LoggerDest ld) {
        if (ld != null) {
            for (int i = 0; i < loggers.length; ++i) {
                if (loggers[i] != ld) continue;
                return;
            }
            LoggerDest[] lds = new LoggerDest[loggers.length + 1];
            System.arraycopy(loggers, 0, lds, 0, loggers.length);
            lds[ConnectionLogger.loggers.length] = ld;
            loggers = lds;
        }
    }

    public static synchronized void removeLoggerDest(LoggerDest ld) {
        if (ld != null) {
            for (int i = 0; i < loggers.length; ++i) {
                int numMoved;
                if (loggers[i] != ld) continue;
                LoggerDest[] ivms = new LoggerDest[loggers.length - 1];
                if (i > 0) {
                    System.arraycopy(loggers, 0, ivms, 0, i);
                }
                if ((numMoved = loggers.length - i - 1) > 0) {
                    System.arraycopy(loggers, i + 1, ivms, i, numMoved);
                }
                loggers = ivms;
                return;
            }
        }
    }

    static {
        ConnectionLogger.init();
    }

    static class Pair {
        String first;
        Object second;

        public Pair(String first, Object second) {
            this.first = first;
            this.second = second;
        }
    }

    static class JVMHook
    extends Thread {
        JVMHook() {
        }

        @Override
        public void run() {
            while (!queue.isEmpty()) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }

    static class LazyLog
    extends Thread {
        private boolean isRunnable = true;

        LazyLog() {
        }

        public void stopThread() {
            this.isRunnable = false;
        }

        @Override
        public void run() {
            while (this.isRunnable || !queue.isEmpty()) {
                Pair pair = (Pair)queue.get();
                ConnectionLogger.logToFile(pair);
            }
        }
    }
}

