/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Date;

class DateTypeAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    DateTypeAdapter() {
    }

    public JsonElement serialize(Date object, Type type, JsonSerializationContext context) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        String dateStr = format.format(object);
        return new JsonPrimitive(dateStr);
    }

    public Date deserialize(JsonElement object, Type type, JsonDeserializationContext context) throws JsonParseException {
        String dateStr = object.getAsString();
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        try {
            return format.parse(dateStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

