/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.privacy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.privacy.IPrivacyService;
import com.kingdee.bos.privacy.PrivacyData;
import com.kingdee.bos.privacy.encrypt.EncryptUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.DecimalFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public class DefaultPrivacyService
implements IPrivacyService {
    @Override
    public void encrypt(Context ctx, PrivacyData privacyData) throws BOSException {
        Object originalValue = privacyData.getOriginalValue();
        if (originalValue != null) {
            String val = null;
            if (originalValue instanceof Date) {
                val = DateTimeUtils.format((Date)((Date)originalValue));
            } else if (!(originalValue instanceof byte[])) {
                val = String.valueOf(originalValue);
            }
            String cipherText = EncryptUtils.encrypt(val, privacyData.getEncryptor(ctx));
            privacyData.setCipherText(cipherText);
            privacyData.setHashCode(this.hash(ctx, originalValue));
        }
    }

    @Override
    public void decrypt(Context ctx, PrivacyData privacyData) throws BOSException {
        String ciphertext = privacyData.getCipherText();
        if (!StringUtils.isEmpty((String)ciphertext)) {
            Object originalValue = EncryptUtils.decrypt(ctx, ciphertext, privacyData);
            privacyData.setOriginalValue(originalValue);
        }
    }

    @Override
    public String hash(Context ctx, Object obj) throws BOSException {
        String val;
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            val = DateTimeUtils.format((Date)((Date)obj));
        } else if (obj instanceof byte[]) {
            val = Base64.encodeBase64String((byte[])((byte[])obj));
        } else if (obj instanceof Number) {
            Number number = (Number)obj;
            double d = number.doubleValue();
            if (d == 0.0) {
                val = "0";
            } else {
                DecimalFormat df = new DecimalFormat(".0000000000");
                val = df.format(number);
                if (val.indexOf(46) > -1) {
                    char c;
                    int i;
                    for (i = val.length() - 1; i >= 0 && (c = val.charAt(i)) != '.'; --i) {
                        if (c == '0') continue;
                        ++i;
                        break;
                    }
                    val = val.substring(0, i);
                }
            }
        } else {
            val = String.valueOf(obj);
        }
        return EncryptUtils.hashCode(val);
    }
}

