/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.formater;

import com.kingdee.bos.sql.datatype.DataType;
import com.kingdee.bos.sql.dom.AbstractUpdateItem;
import com.kingdee.bos.sql.dom.SqlAlterTableAddDefaultItem;
import com.kingdee.bos.sql.dom.SqlAlterTableAddItem;
import com.kingdee.bos.sql.dom.SqlAlterTableAlterColumnItem;
import com.kingdee.bos.sql.dom.SqlAlterTableDropDefaultItem;
import com.kingdee.bos.sql.dom.SqlAlterTableDropItem;
import com.kingdee.bos.sql.dom.SqlBlockStmt;
import com.kingdee.bos.sql.dom.SqlColumnDef;
import com.kingdee.bos.sql.dom.SqlInsert;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlSubQueryTableSource;
import com.kingdee.bos.sql.dom.SqlTableCheck;
import com.kingdee.bos.sql.dom.SqlTableConstraint;
import com.kingdee.bos.sql.dom.SqlTableForeignKey;
import com.kingdee.bos.sql.dom.SqlTablePrimaryKey;
import com.kingdee.bos.sql.dom.SqlTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.SqlTableUnique;
import com.kingdee.bos.sql.dom.SqlUnionSelect;
import com.kingdee.bos.sql.dom.SqlUpdate;
import com.kingdee.bos.sql.dom.SqlUpdateItem;
import com.kingdee.bos.sql.dom.SubQueryUpdateItem;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlDateTimeExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.dom.expr.SqlNCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlPriorIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlVarRefExpr;
import com.kingdee.bos.sql.dom.stmt.SqlAlterTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlBreakStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCloseStmt;
import com.kingdee.bos.sql.dom.stmt.SqlContinueStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCreateIndexStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlCursorLoopStmt;
import com.kingdee.bos.sql.dom.stmt.SqlDeallocateStmt;
import com.kingdee.bos.sql.dom.stmt.SqlDropViewStmt;
import com.kingdee.bos.sql.dom.stmt.SqlExecStmt;
import com.kingdee.bos.sql.dom.stmt.SqlFetchStmt;
import com.kingdee.bos.sql.dom.stmt.SqlGotoStmt;
import com.kingdee.bos.sql.dom.stmt.SqlIfStmt;
import com.kingdee.bos.sql.dom.stmt.SqlInsertStmt;
import com.kingdee.bos.sql.dom.stmt.SqlLabelStmt;
import com.kingdee.bos.sql.dom.stmt.SqlOpenStmt;
import com.kingdee.bos.sql.dom.stmt.SqlSetLocalVariantStmt;
import com.kingdee.bos.sql.dom.stmt.SqlShowColumnsStmt;
import com.kingdee.bos.sql.dom.stmt.SqlShowTablesStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.dom.stmt.SqlUpdateStmt;
import com.kingdee.bos.sql.dom.stmt.SqlWhileStmt;
import com.kingdee.bos.sql.exception.NotSupportedException;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.parser.Token;
import com.kingdee.bos.sql.util.UUTN;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GaussDBSQLFormater
extends SQLFormater {
    private LinkedList<String> sysProps = new LinkedList();
    private boolean recordSysProps = false;
    boolean IN_PROCEDURE = false;

    public GaussDBSQLFormater() {
        this(null);
    }

    public GaussDBSQLFormater(StringBuffer sb) {
        super(sb);
    }

    @Override
    protected void formatShowTablesStmt(SqlShowTablesStmt stmt) {
        String sql = "select table_name as name from information_schema.tables where table_type = 'BASE TABLE' order by table_name";
        this.buffer.append(sql);
    }

    @Override
    protected void formatShowColumnsStmt(SqlShowColumnsStmt stmt) {
        String sql = "select column_name, data_type, character_maximum_length default_length, numeric_precision as data_precision,numeric_scale data_scale, is_nullable nullable, table_name  from information_schema.columns ";
        if (stmt.tableName != null && stmt.tableName.length() != 0) {
            sql = sql + "where table_name = '" + stmt.tableName.toLowerCase(Locale.ENGLISH) + "' ";
        }
        this.buffer.append(sql);
    }

    @Override
    protected void formatExecStmt(SqlExecStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatDropViewStmt(SqlDropViewStmt stmt) throws FormaterException {
        this.buffer.append("DROP VIEW ");
        this.buffer.append(stmt.viewName);
        this.buffer.append(" CASCADE ");
    }

    @Override
    protected void formatColumnDef(SqlColumnDef column) throws FormaterException {
        if (column.name == null) {
            throw new FormaterException("column name is null");
        }
        if (this.max_length_of_constraint_name != -1 && column.name != null && column.name.length() > this.max_length_of_constraint_name) {
            throw new FormaterException("column name greate than " + this.max_length_of_column_name + ", column name is '" + column.name + "'");
        }
        this.buffer.append(column.name.toLowerCase(Locale.ENGLISH));
        this.buffer.append(" ");
        this.addColumnDataType(column);
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            if (!column.isPrimaryKey) {
                this.buffer.append(" NULL");
            }
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE) {
            this.buffer.append(" NOT NULL");
        }
        if (column.defaultValueExpr != null) {
            this.buffer.append(" DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    @Override
    protected final void formatAlterTableStmt(SqlAlterTableStmt stmt) throws FormaterException {
        this.buffer.append("ALTER TABLE ");
        this.buffer.append(stmt.tableName.toLowerCase(Locale.ENGLISH));
        if (stmt.item instanceof SqlAlterTableAddItem) {
            SqlAlterTableAddItem addColumnDefItem = (SqlAlterTableAddItem)stmt.item;
            this.buffer.append(" ADD ");
            Iterator iterator = addColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ADD ");
                }
                SqlColumnDef columnDef = (SqlColumnDef)iterator.next();
                this.formatColumnDef(columnDef);
                flag = true;
            }
            iterator = addColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                SqlTableConstraint constraint = (SqlTableConstraint)iterator.next();
                try {
                    this.formatTableConstraint(constraint);
                }
                catch (FormaterException ex) {
                    throw new FormaterException("alter table statement invalid. table name is '" + stmt.tableName + "', " + ex.getMessage(), ex);
                }
            }
        } else if (stmt.item instanceof SqlAlterTableDropItem) {
            String columnDef;
            SqlAlterTableDropItem dropColumnDefItem = (SqlAlterTableDropItem)stmt.item;
            this.buffer.append(" DROP ");
            Iterator iterator = dropColumnDefItem.columnDefItemList.iterator();
            boolean flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", DROP ");
                } else {
                    this.buffer.append("COLUMN ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(columnDef);
                flag = true;
            }
            iterator = dropColumnDefItem.constraintItemList.iterator();
            flag = false;
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                } else {
                    this.buffer.append("CONSTRAINT ");
                }
                columnDef = (String)iterator.next();
                this.buffer.append(columnDef);
                flag = true;
            }
        } else if (stmt.item instanceof SqlAlterTableAlterColumnItem) {
            SqlAlterTableAlterColumnItem alterColumnDefItem = (SqlAlterTableAlterColumnItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.formatColumnDefForAlterColumn(alterColumnDefItem.columnDef);
            this.formatColumnDefForAlterColumnNotNull(stmt, alterColumnDefItem.columnDef);
        } else if (stmt.item instanceof SqlAlterTableAddDefaultItem) {
            SqlAlterTableAddDefaultItem addDefaultItem = (SqlAlterTableAddDefaultItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.buffer.append(addDefaultItem.columnName);
            this.buffer.append(" SET DEFAULT ");
            this.formatExpr(addDefaultItem.value);
        } else if (stmt.item instanceof SqlAlterTableDropDefaultItem) {
            SqlAlterTableDropDefaultItem dropDefaultItem = (SqlAlterTableDropDefaultItem)stmt.item;
            this.buffer.append(" ALTER COLUMN ");
            this.buffer.append(dropDefaultItem.columnName);
            this.buffer.append(" DROP DEFAULT");
        } else {
            throw new FormaterException("TODO");
        }
    }

    @Override
    protected void formatDateTimeExpr(SqlDateTimeExpr expr) throws FormaterException {
        this.buffer.append("timestamp");
        if (expr.getYear() < 10) {
            this.buffer.append("'0");
        } else {
            this.buffer.append("'");
        }
        this.buffer.append(expr.getYear());
        if (expr.getMonth() < 10) {
            this.buffer.append("-0");
        } else {
            this.buffer.append("-");
        }
        this.buffer.append(expr.getMonth());
        if (expr.getDate() < 10) {
            this.buffer.append("-0");
        } else {
            this.buffer.append("-");
        }
        this.buffer.append(expr.getDate());
        if (expr.getHour() < 10) {
            this.buffer.append(" 0");
        } else {
            this.buffer.append(" ");
        }
        this.buffer.append(expr.getHour());
        if (expr.getMinute() < 10) {
            this.buffer.append(":0");
        } else {
            this.buffer.append(":");
        }
        this.buffer.append(expr.getMinute());
        if (expr.getSecond() < 10) {
            this.buffer.append(":0");
        } else {
            this.buffer.append(":");
        }
        this.buffer.append(expr.getSecond());
        this.buffer.append("'");
    }

    @Override
    protected void formatSelect(SqlSelect select) throws FormaterException {
        if (select.into != null) {
            this.buffer.append("CREATE TABLE ");
            this.buffer.append(select.into.new_table);
            this.buffer.append(" AS ");
        }
        if (select.limit != null && select.limit.value != -1 && select.orderBy.size() != 0) {
            this.buffer.append("SELECT * FROM (SELECT ");
        } else {
            this.buffer.append("SELECT ");
        }
        if (select.distinct == 1) {
            this.buffer.append("DISTINCT ");
        } else if (select.distinct != 0) {
            throw new FormaterException("distinct option not support.");
        }
        Iterator iterator = null;
        boolean flag = false;
        for (int i = 0; i < select.selectList.size(); ++i) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlSelectItem item = (SqlSelectItem)select.selectList.get(i);
            this.paramData.changeSelectColumn(select, item);
            boolean isIdentifierExpr = false;
            if (item.expr instanceof SqlIdentifierExpr) {
                isIdentifierExpr = true;
                if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) && item.alias == null) {
                    item.alias = Token.KSQL_COL_NAME.value;
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.TABNAME.value) && item.alias == null) {
                    item.alias = Token.TABNAME.value;
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value) && item.alias == null) {
                    item.alias = Token.KSQL_COL_TABNAME.value;
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value) && item.alias == null) {
                    item.alias = Token.KSQL_COL_LENGTH.value;
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_TYPE.value) && item.alias == null) {
                    item.alias = Token.KSQL_COL_TYPE.value;
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value) && item.alias == null) {
                    item.alias = Token.KSQL_COL_NULLABLE.value;
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value) && item.alias == null) {
                    item.alias = Token.KSQL_COL_DEFAULT.value;
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.INDNAME.value) && item.alias == null) {
                    item.alias = Token.INDNAME.value;
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) && item.alias == null) {
                    item.alias = Token.KSQL_CONS_NAME.value;
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value) && item.alias == null) {
                    item.alias = Token.KSQL_CONS_TABNAME.value;
                } else if (((SqlIdentifierExpr)item.expr).value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value) && item.alias == null) {
                    item.alias = Token.KSQL_CONS_TYPE.value;
                } else {
                    isIdentifierExpr = false;
                }
            }
            if (item.alias != null && item.alias.length() != 0) {
                if (item.expr instanceof SqlCharExpr || item.expr instanceof SqlNCharExpr) {
                    this.buffer.append("CAST(");
                    this.formatExpr(item.expr);
                    this.buffer.append(" AS VARCHAR)");
                } else {
                    this.formatExpr(item.expr);
                }
                this.buffer.append(" AS ");
                if (isIdentifierExpr) {
                    this.buffer.append("\"" + item.alias.toUpperCase(Locale.ENGLISH) + "\"");
                } else {
                    this.buffer.append(item.alias.toLowerCase(Locale.ENGLISH));
                }
            } else {
                this.formatExpr(item.expr, false);
            }
            flag = true;
        }
        if (select.tableSource != null) {
            this.buffer.append(" FROM ");
            this.formatTableSource(select.tableSource);
        }
        if (select.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(select.condition);
        }
        if (select.hierarchicalQueryClause != null) {
            throw new FormaterException("NOT SUPPORT hierarchicalQueryClause");
        }
        if (select.groupBy.size() != 0) {
            this.buffer.append(" GROUP BY ");
            if (select.hasWithRollUp) {
                this.buffer.append("ROLLUP(");
            }
            flag = false;
            List groupBys = select.groupBy;
            for (int i = 0; i < groupBys.size(); ++i) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr expr = (SqlExpr)groupBys.get(i);
                this.paramData.changeGroupBy(select, expr);
                this.formatExpr(expr);
                flag = true;
            }
            if (select.hasWithRollUp) {
                this.buffer.append(")");
            }
        }
        if (select.having != null) {
            this.buffer.append(" HAVING ");
            this.formatExpr(select.having);
        }
        if (select.orderBy.size() != 0) {
            this.buffer.append(" ORDER BY ");
            flag = false;
            iterator = select.orderBy.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                this.formatExpr(orderByIterm.expr);
                if (orderByIterm.mode == 0) {
                    this.buffer.append(" ASC");
                } else {
                    this.buffer.append(" DESC");
                }
                flag = true;
            }
        }
        if (select.limit != null && select.limit.value != -1) {
            if (select.orderBy.size() != 0) {
                this.buffer.append(") L_JOBS LIMIT ");
            } else {
                this.buffer.append(" LIMIT ");
            }
            this.buffer.append(select.limit.value);
            if (select.limit.type == 1) {
                throw new FormaterException("Not support");
            }
            if (select.limit.offset != 0) {
                this.buffer.append(" OFFSET ");
                this.buffer.append(select.limit.offset);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void formatMethodInvokeExpr(SqlMethodInvokeExpr expr) throws FormaterException {
        String methodNameI;
        if (expr.owner != null) {
            this.formatExpr(expr.owner);
            this.buffer.append('.');
        }
        if ((methodNameI = expr.methodName.toUpperCase(Locale.ENGLISH)).compareTo("ABS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ABS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ACOS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ACOS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ASIN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ASIN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATAN") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("ATAN(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ATN2") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("ATN2(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("CEILING") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("CEILING(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("COS") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("COS(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("EXP") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("EXP(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("FLOOR") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("FLOOR(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("MOD") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(" % ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("LOG") == 0) {
            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
            this.buffer.append("LOG(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("POWER") == 0) {
            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
            this.buffer.append("POWER(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        }
        if (methodNameI.compareTo("ROUND") == 0) {
            if (expr.parameters.size() == 2) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", CAST(");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(" AS INT))");
                return;
            }
            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
            SqlExpr thirdExpr = (SqlExpr)expr.parameters.get(2);
            if (!(thirdExpr instanceof SqlIntExpr)) {
                throw new FormaterException("ERROR");
            }
            int val = Integer.parseInt(((SqlIntExpr)thirdExpr).text);
            if (val == 0) {
                this.buffer.append("ROUND(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(", ");
                this.formatExpr((SqlExpr)expr.parameters.get(1));
                this.buffer.append(")");
                return;
            }
            this.buffer.append("TRUNC(");
            this.formatExpr((SqlExpr)expr.parameters.get(0));
            this.buffer.append(", ");
            this.formatExpr((SqlExpr)expr.parameters.get(1));
            this.buffer.append(")");
            return;
        } else {
            if (methodNameI.compareToIgnoreCase("SIGN") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("SIGN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("SIN") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("SIN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("SQRT") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("SQRT(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("TAN") == 0) {
                if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                this.buffer.append("TAN(");
                this.formatExpr((SqlExpr)expr.parameters.get(0));
                this.buffer.append(")");
                return;
            }
            if (methodNameI.compareTo("CONVERT") == 0) {
                if (!(expr.parameters.get(0) instanceof SqlIdentifierExpr)) return;
                SqlIdentifierExpr identExpr = (SqlIdentifierExpr)expr.parameters.get(0);
                if (identExpr.value.compareToIgnoreCase("DATETIME") == 0) {
                    this.buffer.append("TO_TIMESTAMP(");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(", 'YYYY-MM-DD HH24:MI:SS')");
                    return;
                }
                if (identExpr.value.compareToIgnoreCase("VARCHAR") == 0 || identExpr.value.compareToIgnoreCase("NVARCHAR") == 0 || identExpr.value.compareToIgnoreCase("CHAR") == 0 || identExpr.value.compareToIgnoreCase("NCHAR") == 0) {
                    this.buffer.append("TO_CHAR(");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(")");
                    return;
                }
                if (identExpr.value.compareToIgnoreCase("INT") == 0 || identExpr.value.compareToIgnoreCase("INTEGER") == 0) {
                    this.buffer.append("CAST(");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" AS INT)");
                    return;
                } else if (identExpr.value.compareToIgnoreCase("FLOAT") == 0) {
                    this.buffer.append("CAST(");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" AS FLOAT)");
                    return;
                } else {
                    if (identExpr.value.compareToIgnoreCase("") != 0) throw new FormaterException("TODO");
                    this.buffer.append("CAST(");
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(" AS DECIMAL)");
                }
                return;
            } else {
                if (methodNameI.compareTo("CURDATE") == 0) {
                    if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                    this.buffer.append("CAST(");
                    this.buffer.append("CURRENT_DATE");
                    this.buffer.append(" AS \"date\")");
                    return;
                }
                if (methodNameI.compareTo("CURTIME") == 0) {
                    if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                    this.buffer.append("now()");
                    return;
                }
                if (methodNameI.compareTo("DATEADD") == 0) {
                    if (expr.parameters.size() == 2) {
                        this.buffer.append("dateadd('second',");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(",");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(")");
                        return;
                    }
                    if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                    SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
                    if (!(datepartExpr instanceof SqlIdentifierExpr)) throw new FormaterException("illegal datepart.");
                    String datepart = ((SqlIdentifierExpr)datepartExpr).value;
                    if (datepart == null || datepart.length() == 0) {
                        throw new FormaterException("illegal datepart.");
                    }
                    if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                        this.buffer.append("dateadd('year',");
                    } else if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                        this.buffer.append("dateadd('month',");
                    } else if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                        this.buffer.append("dateadd('day',");
                    } else if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                        this.buffer.append("dateadd('hour',");
                    } else if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                        this.buffer.append("dateadd('minute',");
                    } else if ("SECOND".equals(datepart) || "SS".equals(datepart) || "S".equals(datepart)) {
                        this.buffer.append("dateadd('second',");
                    } else {
                        if (!"WEEK".equals(datepart)) throw new FormaterException("not support datepart:" + datepart);
                        this.buffer.append("dateadd('week',");
                    }
                    this.formatExpr((SqlExpr)expr.parameters.get(1));
                    this.buffer.append(",");
                    this.formatExpr((SqlExpr)expr.parameters.get(2));
                    this.buffer.append(")");
                    return;
                } else {
                    if (methodNameI.compareTo("DATEDIFF") == 0) {
                        if (expr.parameters.size() == 2) {
                            this.buffer.append("date_part('day',(");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(" - ");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(")) * 60 * 60 * 24 ");
                            return;
                        }
                        if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                        SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
                        if (!(datepartExpr instanceof SqlIdentifierExpr)) throw new FormaterException("illegal datepart.");
                        String datepart = ((SqlIdentifierExpr)datepartExpr).value;
                        if (datepart == null || datepart.length() == 0) {
                            throw new FormaterException("illegal datepart.");
                        }
                        if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                            this.buffer.append("date_part('year',age(");
                            this.formatExpr((SqlExpr)expr.parameters.get(2));
                            this.buffer.append(",");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append("))");
                            return;
                        }
                        if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                            this.buffer.append("(date_part('year',age(");
                            this.formatExpr((SqlExpr)expr.parameters.get(2));
                            this.buffer.append(",");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append("))*12 ");
                            this.buffer.append(" + date_part('month',age(");
                            this.formatExpr((SqlExpr)expr.parameters.get(2));
                            this.buffer.append(",");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")))");
                            return;
                        }
                        if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                            this.buffer.append("cast(");
                            this.formatExpr((SqlExpr)expr.parameters.get(2));
                            this.buffer.append(" as \"date\") - cast(");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(" as \"date\")");
                            return;
                        }
                        if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                            this.buffer.append("date_part('day',(");
                            this.formatExpr((SqlExpr)expr.parameters.get(2));
                            this.buffer.append(" - ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")) *24");
                            return;
                        }
                        if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                            this.buffer.append("date_part('day',(");
                            this.formatExpr((SqlExpr)expr.parameters.get(2));
                            this.buffer.append(" - ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")) *24 *60");
                            return;
                        }
                        if (!"SECOND".equals(datepart) && !"SS".equals(datepart) && !"S".equals(datepart)) throw new FormaterException("not support datepart:" + datepart);
                        this.buffer.append("date_part('day',(");
                        this.formatExpr((SqlExpr)expr.parameters.get(2));
                        this.buffer.append(" - ");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(")) *24 *60 *60");
                        return;
                    }
                    if (methodNameI.compareTo("DATENAME") == 0) {
                        if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                        SqlExpr datepartExpr = (SqlExpr)expr.parameters.get(0);
                        if (!(datepartExpr instanceof SqlIdentifierExpr)) return;
                        String datepart = ((SqlIdentifierExpr)datepartExpr).value;
                        if (datepart == null || datepart.length() == 0) {
                            throw new FormaterException("illegal datepart.");
                        }
                        if ("YEAR".equals(datepart = datepart.toUpperCase(Locale.ENGLISH)) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                            this.buffer.append("DATE_PART('year', ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")");
                            return;
                        }
                        if ("MONTH".equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                            this.buffer.append("DATE_PART('month', ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")");
                            return;
                        }
                        if ("QUARTER".equals(datepart) || "QQ".equals(datepart) || "Q".equals(datepart)) {
                            this.buffer.append("DATE_PART('quarter', ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")");
                            return;
                        }
                        if ("DAYOFYEAR".equals(datepart) || "DY".equals(datepart) || "Y".equals(datepart)) {
                            this.buffer.append("DATE_PART('doy', ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")");
                            return;
                        }
                        if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                            this.buffer.append("DATE_PART('day', ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")");
                            return;
                        }
                        if ("WEEK".equals(datepart) || "WK".equals(datepart) || "WW".equals(datepart)) {
                            this.buffer.append("DATE_PART('week', ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(") + 1");
                            return;
                        }
                        if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                            this.buffer.append("DATE_PART('hour', ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")");
                            return;
                        }
                        if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                            this.buffer.append("DATE_PART('minute', ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")");
                            return;
                        }
                        if (!"SECOND".equals(datepart) && !"SS".equals(datepart) && !"S".equals(datepart)) throw new FormaterException("not support datepart:" + datepart);
                        this.buffer.append("DATE_PART('second', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("DAYNAME") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("DATENAME(DW, ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("DAYOFMONTH") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("CAST(");
                        this.buffer.append("DATE_PART('day', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(") AS INTEGER)");
                        return;
                    }
                    if (methodNameI.compareTo("DAYOFWEEK") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("CAST(");
                        this.buffer.append("DATE_PART('dow', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(") AS INTEGER)");
                        return;
                    }
                    if (methodNameI.compareTo("DAYOFYEAR") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("CAST(");
                        this.buffer.append("DATE_PART('doy', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(") AS INTEGER)");
                        return;
                    }
                    if (methodNameI.compareTo("GETDATE") == 0) {
                        if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                        this.buffer.append("LOCALTIMESTAMP");
                        return;
                    }
                    if (methodNameI.compareTo("HOUR") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("CAST(");
                        this.buffer.append("DATE_PART('hour', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(") AS INTEGER)");
                        return;
                    }
                    if (methodNameI.compareTo("MINUTE") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("CAST(");
                        this.buffer.append("DATE_PART('minute', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(") AS INTEGER)");
                        return;
                    }
                    if (methodNameI.compareTo("MONTH") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("CAST(");
                        this.buffer.append("DATE_PART('month', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(") AS INTEGER)");
                        return;
                    }
                    if (methodNameI.compareTo("MONTHNAME") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("DATENAME(MM, ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("NOW") == 0) {
                        if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                        this.buffer.append("LOCALTIMESTAMP");
                        return;
                    }
                    if (methodNameI.compareTo("QUARTER") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("DATE_PART('quarter', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("SECOND") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("CAST(");
                        this.buffer.append("DATE_PART('second', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(") AS INTEGER)");
                        return;
                    }
                    if (methodNameI.compareTo("WEEK") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("CAST(");
                        this.buffer.append("DATE_PART('week', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(") AS INTEGER)");
                        return;
                    }
                    if (methodNameI.compareTo("YEAR") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("CAST(");
                        this.buffer.append("DATE_PART('year', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(") AS INTEGER)");
                        return;
                    }
                    if (methodNameI.compareTo("TO_DATE") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("CAST(");
                        String type = " AS DATE)";
                        if (expr.parameters.get(0) instanceof SqlCharExpr) {
                            SqlCharExpr dateTimeSqlExpr = (SqlCharExpr)expr.parameters.get(0);
                            if (dateTimeSqlExpr.text.indexOf(".") > 0) {
                                type = " AS TIMESTAMP)";
                            }
                        }
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(type);
                        return;
                    }
                    if (methodNameI.compareTo("DAYS_BETWEEN") == 0) {
                        if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                        this.buffer.append("CAST(DATE_PART('DAY',AGE(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(", ");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(")) AS INTEGER )");
                        return;
                    }
                    if (methodNameI.compareTo("MONTHS_BETWEEN") == 0) {
                        if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                        this.buffer.append("CAST(DATE_PART('MONTHS',AGE(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(", ");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(")) AS INTEGER )");
                        return;
                    }
                    if (methodNameI.compareTo("ADD_MONTHS") == 0) {
                        if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                        this.buffer.append("DATEADD('month', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(", ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("ADD_YEARS") == 0) {
                        if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                        this.buffer.append("DATEADD('year', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(", ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("ADD_DAYS") == 0) {
                        if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                        this.buffer.append("DATEADD('day', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(", ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("ADD_HOURS") == 0) {
                        if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                        this.buffer.append("DATEADD('hour', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(", ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("ADD_MINUTES") == 0) {
                        if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                        this.buffer.append("DATEADD('minute', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(", ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("ADD_SECONDS") == 0) {
                        if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                        this.buffer.append("DATEADD('second', ");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(", ");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("ASCII") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("ASCII(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("CHAR") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("CHR(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareToIgnoreCase("CHARINDEX") == 0) {
                        if (expr.parameters.size() == 2) {
                            this.buffer.append("POSITION(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(" IN ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")");
                            return;
                        }
                        if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                        this.buffer.append("CASE WHEN");
                        this.buffer.append(" POSITION(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(" IN ");
                        this.buffer.append("SUBSTRING(");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(" from ");
                        this.formatExpr((SqlExpr)expr.parameters.get(2));
                        this.buffer.append("+1)) = 0 THEN 0 ELSE ");
                        this.buffer.append("POSITION(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(" IN ");
                        this.buffer.append("SUBSTRING(");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(" from ");
                        this.formatExpr((SqlExpr)expr.parameters.get(2));
                        this.buffer.append("+1)) + ");
                        this.formatExpr((SqlExpr)expr.parameters.get(2));
                        this.buffer.append(" END");
                        return;
                    }
                    if (methodNameI.compareTo("NEWID") == 0) {
                        if (expr.parameters.size() != 0) throw new FormaterException("ERROR");
                        this.buffer.append("LOWER(NEWID())");
                        return;
                    }
                    if (methodNameI.compareTo("NEWBOSID") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("Unrecognized parameters");
                        this.buffer.append("NEWBOSID(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("CONCAT") == 0) {
                        if (expr.parameters.size() < 1) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
                        this.buffer.append("CONCAT(");
                        int ps = expr.parameters.size() - 1;
                        for (int pi = 0; pi < ps; ++pi) {
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(", ");
                        }
                        this.formatExpr((SqlExpr)expr.parameters.get(expr.parameters.size() - 1));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareToIgnoreCase("LEFT") == 0) {
                        if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                        this.buffer.append("SUBSTR(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(", 1, ");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("LEN") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("CHAR_LENGTH(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("LENGTH") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("CHAR_LENGTH(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("LOWER") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("LOWER(");
                        this.buffer.append("CAST(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(" AS VARCHAR)");
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("LCASE") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("LOWER(");
                        this.buffer.append("CAST(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(" AS VARCHAR)");
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("LTRIM") == 0) {
                        if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                        this.buffer.append("LTRIM(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(")");
                        return;
                    }
                    if (methodNameI.compareTo("REPLACE") == 0) {
                        if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                        this.buffer.append("REPLACE(");
                        this.formatExpr((SqlExpr)expr.parameters.get(0));
                        this.buffer.append(", ");
                        this.formatExpr((SqlExpr)expr.parameters.get(1));
                        this.buffer.append(", ");
                        this.formatExpr((SqlExpr)expr.parameters.get(2));
                        this.buffer.append(")");
                        return;
                    } else {
                        if (methodNameI.compareTo("RIGHT") == 0) {
                            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                            this.buffer.append("RIGHT(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(", ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")");
                            return;
                        }
                        if (methodNameI.compareTo("RTRIM") == 0) {
                            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                            this.buffer.append("RTRIM(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(")");
                            return;
                        }
                        if (methodNameI.compareTo("SOUNDEX") == 0) {
                            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                            this.buffer.append("SOUNDEX(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(")");
                            return;
                        }
                        if (methodNameI.compareTo("SUBSTRING") == 0) {
                            int startIndex;
                            if (expr.parameters.size() != 3) throw new FormaterException("ERROR");
                            this.buffer.append("SUBSTRING(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(", ");
                            if (expr.parameters.get(1) instanceof SqlIntExpr && (startIndex = ((SqlIntExpr)expr.parameters.get((int)1)).value) < 1) {
                                if (startIndex == 0) {
                                    expr.parameters.set(1, new SqlIntExpr(1));
                                }
                                if (startIndex < 0) {
                                    throw new FormaterException("SUBSTRING parameter2 cannot not smaller then 1S.");
                                }
                            }
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(", ");
                            this.formatExpr((SqlExpr)expr.parameters.get(2));
                            this.buffer.append(")");
                            return;
                        }
                        if (methodNameI.compareTo("TRIM") == 0) {
                            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                            this.buffer.append("LTRIM(RTRIM(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append("))");
                            return;
                        }
                        if (methodNameI.compareTo("UCASE") == 0) {
                            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                            this.buffer.append("UPPER(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(")");
                            return;
                        }
                        if (methodNameI.compareTo("UPPER") == 0) {
                            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                            this.buffer.append("UPPER(");
                            this.buffer.append("CAST(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(" AS VARCHAR)");
                            this.buffer.append(")");
                            return;
                        }
                        if (methodNameI.compareTo("TOCHAR") == 0 || methodNameI.compareTo("TO_CHAR") == 0) {
                            if (expr.parameters.size() == 1) {
                                this.buffer.append("CAST(");
                                this.formatExpr((SqlExpr)expr.parameters.get(0));
                                this.buffer.append(" AS VARCHAR)");
                                return;
                            }
                            if (expr.parameters.size() == 2) {
                                this.buffer.append("TO_CHAR(");
                                this.formatExpr((SqlExpr)expr.parameters.get(0));
                                this.buffer.append(", ");
                                this.formatExpr((SqlExpr)expr.parameters.get(1));
                                this.buffer.append(")");
                                return;
                            }
                            if (expr.parameters.size() != 3 || !expr.parameters.get(1).toString().equalsIgnoreCase("NUMBER")) throw new FormaterException("not support function " + methodNameI);
                            if (expr.parameters.get(2) instanceof SqlCharExpr) {
                                this.buffer.append("TO_CHAR(");
                                this.formatExpr((SqlExpr)expr.parameters.get(0));
                                this.buffer.append(", ");
                                this.formatExpr((SqlExpr)expr.parameters.get(2));
                                this.buffer.append(")");
                                return;
                            }
                            if (!(expr.parameters.get(2) instanceof SqlIntExpr)) throw new FormaterException("unexcept parameters size: " + expr.parameters.size());
                            this.buffer.append("Trim(TO_CHAR(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(", '999999999999999999999999999990D");
                            int precision = ((SqlIntExpr)expr.parameters.get((int)2)).value;
                            for (int i = 0; i < precision; ++i) {
                                this.buffer.append("9");
                            }
                            this.buffer.append("'))");
                            return;
                        }
                        if (methodNameI.compareTo("ISNULL") == 0) {
                            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                            this.buffer.append("coalesce(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(", ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")");
                            return;
                        }
                        if (methodNameI.compareTo("NULLIF") == 0) {
                            if (expr.parameters.size() != 2) throw new FormaterException("ERROR");
                            this.buffer.append("NULLIF(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(", ");
                            this.formatExpr((SqlExpr)expr.parameters.get(1));
                            this.buffer.append(")");
                            return;
                        }
                        if (methodNameI.compareTo("TO_NUMBER") == 0) {
                            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                            this.buffer.append("CAST(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(" AS FLOAT)");
                            return;
                        }
                        if (methodNameI.compareTo("TO_INT") == 0 || methodNameI.compareTo("TO_INTEGER") == 0) {
                            if (expr.parameters.size() != 1) throw new FormaterException("ERROR");
                            this.buffer.append("FLOOR(CAST(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(" AS INTEGER))");
                            return;
                        }
                        if (methodNameI.compareTo("TO_DECIMAL") == 0 || methodNameI.compareTo("DECIMAL") == 0 || methodNameI.compareTo("DEC") == 0) {
                            if (expr.parameters.size() == 1) {
                                this.buffer.append("CAST(");
                                this.formatExpr((SqlExpr)expr.parameters.get(0));
                                this.buffer.append(" AS DECIMAL)");
                                return;
                            }
                            if (expr.parameters.size() != 3) throw new FormaterException("TO_DECIMAL's parameters num: " + expr.parameters.size());
                            this.buffer.append("CAST(");
                            this.formatExpr((SqlExpr)expr.parameters.get(0));
                            this.buffer.append(" AS DECIMAL(");
                            this.buffer.append(expr.parameters.get(1));
                            this.buffer.append(", ");
                            this.buffer.append(expr.parameters.get(2));
                            this.buffer.append("))");
                            return;
                        }
                        if (methodNameI.compareTo("NATIVE_TYPE") == 0) {
                            if (expr.parameters.size() != 1) throw new FormaterException("ERROR parameterNATIVE_TYPE");
                            SqlCharExpr cexpr = (SqlCharExpr)expr.parameters.get(0);
                            String type = cexpr.text;
                            type = DataType.getDataType(5).nativeType(type);
                            this.formatExpr(new SqlCharExpr(type));
                            return;
                        }
                        this.formeatUnkownMethodInvokeExpr(expr);
                    }
                }
            }
        }
    }

    @Override
    protected void formatBinaryOpExpr(SqlBinaryOpExpr expr, boolean appendBrace) throws FormaterException {
        if (expr.operator == 13) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NULL)");
            return;
        }
        if (expr.operator == 41) {
            this.buffer.append("(");
            this.formatExpr(expr.left);
            this.buffer.append(" IS NOT NULL)");
            return;
        }
        if (expr.operator == 20) {
            this.formatExpr(expr.left);
            this.buffer.append(".");
            this.formatExpr(expr.right);
            return;
        }
        if (expr.operator == 43) {
            this.formatExpr(expr.left, false);
            this.buffer.append(" ESCAPE ");
            this.formatExpr(expr.right, false);
            return;
        }
        if (expr.operator == 10) {
            this.beginRecordSysProps();
            this.formatExpr(expr.left);
            this.buffer.append(" = ");
            if (expr.right.type == 5 && expr.left.type == 4 && ((SqlIdentifierExpr)expr.left).value.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
                this.formatValueKSQL_COL_NULLABLE(expr);
            } else {
                this.formatExpr(expr.right);
            }
            this.endRecordSysProps();
            return;
        }
        if (expr.operator == 0 || expr.operator == 26) {
            if (appendBrace) {
                this.buffer.append("(");
            }
            if (expr.left instanceof SqlBinaryOpExpr && expr.operator != 26) {
                SqlBinaryOpExpr binaryOpLeft = (SqlBinaryOpExpr)expr.left;
                if (binaryOpLeft.operator == 0) {
                    this.formatExpr(binaryOpLeft, false);
                } else {
                    this.formatExpr(binaryOpLeft);
                }
            } else {
                this.formatExpr(expr.left);
            }
            if (expr.operator == 0) {
                this.buffer.append(" + ");
            } else {
                this.buffer.append(" - ");
            }
            if (expr.right instanceof SqlBinaryOpExpr && expr.operator != 26) {
                SqlBinaryOpExpr binaryOpRight = (SqlBinaryOpExpr)expr.right;
                if (binaryOpRight.operator == 0) {
                    this.formatExpr(binaryOpRight, false);
                } else {
                    this.formatExpr(binaryOpRight);
                }
            } else {
                boolean appendQuote = false;
                if (expr.left instanceof SqlMethodInvokeExpr && expr.right.type == 1) {
                    SqlMethodInvokeExpr methodExpr = (SqlMethodInvokeExpr)expr.left;
                    String methodName = methodExpr.methodName.toUpperCase(Locale.ENGLISH);
                    if (methodName.compareTo("NOW") == 0 || methodName.compareTo("GETDATE") == 0) {
                        this.buffer.append("'");
                        appendQuote = true;
                    } else if (methodName.compareTo("TO_DATE") == 0) {
                        if (methodExpr.parameters.get(0) instanceof SqlCharExpr && ((SqlCharExpr)methodExpr.parameters.get((int)0)).text.indexOf(".") > 0) {
                            this.buffer.append("'");
                            appendQuote = true;
                        }
                    } else if (methodName.compareTo("CONVERT") == 0 && methodExpr.parameters.get(0) instanceof SqlIdentifierExpr && ((SqlIdentifierExpr)methodExpr.parameters.get((int)0)).value.compareToIgnoreCase("DATETIME") == 0) {
                        this.buffer.append("'");
                        appendQuote = true;
                    }
                }
                this.formatExpr(expr.right);
                if (appendQuote) {
                    this.buffer.append(" day'");
                }
            }
            if (appendBrace) {
                this.buffer.append(")");
            }
            return;
        }
        if (expr.operator == 1) {
            this.formatExpr(expr.left);
            this.buffer.append(" AS ");
            if (expr.right instanceof SqlIdentifierExpr) {
                String alias = ((SqlIdentifierExpr)expr.right).value.toLowerCase(Locale.ENGLISH);
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlCharExpr) {
                String alias = ((SqlCharExpr)expr.right).text.toLowerCase(Locale.ENGLISH);
                this.buffer.append(alias);
            } else if (expr.right instanceof SqlNCharExpr) {
                String alias = ((SqlNCharExpr)expr.right).text.toLowerCase(Locale.ENGLISH);
                this.buffer.append(alias);
            } else {
                this.formatExpr(expr.right);
            }
            return;
        }
        if (expr.operator == 42) {
            this.buffer.append("CONCAT(");
            this.formatExpr(expr.left);
            this.buffer.append(", ");
            this.formatExpr(expr.right);
            this.buffer.append(")");
            return;
        }
        if (appendBrace) {
            this.buffer.append("(");
        }
        this.formatExpr(expr.left);
        switch (expr.operator) {
            case 0: {
                this.buffer.append(" + ");
                break;
            }
            case 1: {
                this.buffer.append(" AS ");
                break;
            }
            case 2: {
                this.buffer.append(" = ");
                break;
            }
            case 3: {
                throw new FormaterException("not support");
            }
            case 4: {
                throw new FormaterException("not support");
            }
            case 5: {
                throw new FormaterException("not support");
            }
            case 7: {
                this.buffer.append(" AND ");
                break;
            }
            case 8: {
                this.buffer.append(" OR ");
                break;
            }
            case 9: {
                this.buffer.append(" / ");
                break;
            }
            case 10: {
                this.buffer.append(" = ");
                break;
            }
            case 11: {
                this.buffer.append(" > ");
                break;
            }
            case 12: {
                this.buffer.append(" >= ");
                break;
            }
            case 17: {
                throw new FormaterException("not support");
            }
            case 14: {
                this.buffer.append(" < ");
                break;
            }
            case 15: {
                this.buffer.append(" <= ");
                break;
            }
            case 16: {
                this.buffer.append(" <> ");
                break;
            }
            case 18: {
                this.buffer.append(" LIKE ");
                break;
            }
            case 20: {
                this.buffer.append(".");
                break;
            }
            case 21: {
                this.buffer.append(" % ");
                break;
            }
            case 22: {
                this.buffer.append(" * ");
                break;
            }
            case 23: {
                this.buffer.append(" != ");
                break;
            }
            case 25: {
                this.buffer.append(" !> ");
                break;
            }
            case 24: {
                this.buffer.append(" !< ");
                break;
            }
            case 40: {
                this.buffer.append(" NOT LIKE ");
                break;
            }
            case 19: {
                this.buffer.append(" >> ");
                break;
            }
            case 26: {
                this.buffer.append(" - ");
                break;
            }
            case 27: {
                this.buffer.append(" UNION ");
                break;
            }
            default: {
                throw new FormaterException("not support");
            }
        }
        this.formatExpr(expr.right);
        if (appendBrace) {
            this.buffer.append(")");
        }
    }

    @Override
    protected void formatCreateTableStmt(SqlCreateTableStmt stmt) throws FormaterException {
        this.validateCreateTableStmt(stmt);
        this.buffer.append("CREATE");
        if (UUTN.isTempTable(stmt.name)) {
            this.buffer.append(" UNLOGGED");
        }
        this.buffer.append(" TABLE ");
        this.buffer.append(stmt.name.replaceAll("\"", ""));
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.columnList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlColumnDef column = (SqlColumnDef)iterator.next();
            this.formatColumnDef(column);
            flag = true;
        }
        this.formatTableConstraintList(stmt.constraintList);
        this.buffer.append(")");
    }

    @Override
    protected void formatTableSource(SqlTableSourceBase tableSource) throws FormaterException {
        if (tableSource == null) {
            return;
        }
        if (tableSource instanceof SqlTableSource) {
            SqlTableSource simpleTableSource = (SqlTableSource)tableSource;
            if (simpleTableSource.name.equalsIgnoreCase(Token.USERTABLES.value)) {
                this.buffer.append("information_schema.tables");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.USERCOLUMNS.value)) {
                this.buffer.append("information_schema.columns");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSINDEXES.value)) {
                this.buffer.append("pg_indexes");
            } else if (simpleTableSource.name.equalsIgnoreCase(Token.SYSCONSTRAINTS.value)) {
                this.buffer.append("information_schema.table_constraints");
            } else {
                this.buffer.append(simpleTableSource.name.toLowerCase(Locale.ENGLISH));
            }
            if (simpleTableSource.alias != null && simpleTableSource.alias.length() != 0) {
                this.buffer.append(" ");
                this.buffer.append(simpleTableSource.alias.toLowerCase(Locale.ENGLISH));
            }
        } else if (tableSource instanceof SqlJoinedTableSource) {
            SqlJoinedTableSource joinedTable = (SqlJoinedTableSource)tableSource;
            this.formatTableSource(joinedTable.left);
            switch (joinedTable.joinType) {
                case 4: {
                    this.buffer.append(", ");
                    break;
                }
                case 3: {
                    this.buffer.append(" FULL OUTER JOIN ");
                    break;
                }
                case 0: {
                    this.buffer.append(" INNER JOIN ");
                    break;
                }
                case 1: {
                    this.buffer.append(" LEFT OUTER JOIN ");
                    break;
                }
                case 2: {
                    this.buffer.append(" RIGHT OUTER JOIN ");
                    break;
                }
                default: {
                    throw new FormaterException("error");
                }
            }
            this.formatTableSource(joinedTable.right);
            if (joinedTable.condition != null) {
                this.buffer.append(" ON ");
                this.formatExpr(joinedTable.condition);
            }
        } else if (tableSource instanceof SqlSubQueryTableSource) {
            SqlSubQueryTableSource subQueryTableSource = (SqlSubQueryTableSource)tableSource;
            this.buffer.append("(");
            this.formatSelectBase(subQueryTableSource.subQuery);
            this.buffer.append(")");
            if (tableSource.alias != null) {
                this.buffer.append(" ");
                this.buffer.append(tableSource.alias.toLowerCase(Locale.ENGLISH));
            }
        } else {
            throw new FormaterException("TODO");
        }
    }

    @Override
    protected void formatPriorIdentifierExpr(SqlPriorIdentifierExpr expr) throws FormaterException {
        throw new FormaterException("Not Support. PriorIdentifierExpr");
    }

    @Override
    protected void formatCreateIndexStmt(SqlCreateIndexStmt stmt) throws FormaterException {
        if (stmt.isUnique) {
            this.buffer.append("CREATE UNIQUE INDEX ");
        } else {
            this.buffer.append("CREATE INDEX ");
        }
        this.buffer.append(stmt.indexName);
        this.buffer.append(" ON ");
        this.buffer.append(stmt.tableName);
        this.buffer.append(" (");
        boolean flag = false;
        Iterator iterator = stmt.itemList.iterator();
        while (iterator.hasNext()) {
            if (flag) {
                this.buffer.append(", ");
            }
            SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
            this.formatExpr(orderByIterm.expr);
            if (orderByIterm.mode == 0) {
                this.buffer.append(" ASC");
            } else {
                this.buffer.append(" DESC");
            }
            flag = true;
        }
        this.buffer.append(")");
    }

    void beginRecordSysProps() {
        this.recordSysProps = true;
        this.sysProps.clear();
    }

    void endRecordSysProps() {
        this.recordSysProps = false;
    }

    void pushSysProp(String prop) {
        if (this.recordSysProps) {
            this.sysProps.addFirst(prop);
        }
    }

    String popSysProp() {
        if (this.recordSysProps) {
            return this.sysProps.poll();
        }
        return null;
    }

    @Override
    protected void formatChar(SqlCharExpr expr) throws FormaterException {
        String text = expr.text;
        text = text.equalsIgnoreCase(Token.KSQL_CT_P.value) ? "upper('PRIMARY KEY')" : (text.equalsIgnoreCase(Token.KSQL_CT_F.value) ? "upper('FOREIGN KEY')" : (text.equalsIgnoreCase(Token.KSQL_CT_U.value) ? "upper('UNIQUE')" : (text.equalsIgnoreCase(Token.KSQL_CT_C.value) ? "upper('CHECK')" : "'" + text + "'")));
        String prop = this.popSysProp();
        if (prop != null) {
            this.buffer.append(text.toLowerCase(Locale.ENGLISH));
        } else {
            this.buffer.append(text);
        }
    }

    @Override
    protected void formatVarRef(SqlVarRefExpr expr) throws FormaterException {
        String text = null;
        String prop = this.popSysProp();
        if (prop != null && "?".equals(expr.text) && this.isToUpperCase(prop)) {
            text = "LOWER(?)";
        }
        if (text == null) {
            text = expr.text;
        }
        this.buffer.append(text);
    }

    protected boolean isToUpperCase(String value) {
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase(Token.KSQL_COL_NAME.value) || value.equalsIgnoreCase(Token.INDNAME.value) || value.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value) || value.equalsIgnoreCase(Token.TABNAME.value) || value.equalsIgnoreCase(Token.KSQL_CONS_NAME.value) || value.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value) || value.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value);
    }

    @Override
    protected void formatIdentifierExpr(SqlExpr expr) {
        String ident = ((SqlIdentifierExpr)expr).value;
        if (ident.equalsIgnoreCase(Token.KSQL_COL_NAME.value)) {
            ident = "column_name";
            this.pushSysProp(Token.KSQL_COL_NAME.value);
        } else if (ident.equalsIgnoreCase(Token.INDNAME.value)) {
            ident = "indexname";
            this.pushSysProp(Token.INDNAME.value);
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TABNAME.value)) {
            ident = "table_name";
            this.pushSysProp(Token.KSQL_COL_TABNAME.value);
        } else if (ident.equalsIgnoreCase(Token.TABNAME.value)) {
            ident = "table_name";
            this.pushSysProp(Token.TABNAME.value);
        } else if (ident.equalsIgnoreCase(Token.KSQL_CREATETIME.value)) {
            ident = "create_time";
            this.pushSysProp(Token.KSQL_CREATETIME.value);
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_NAME.value)) {
            ident = "constraint_name";
            this.pushSysProp(Token.KSQL_CONS_NAME.value);
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TABNAME.value)) {
            ident = "table_name";
            this.pushSysProp(Token.KSQL_CONS_TABNAME.value);
        } else if (ident.equalsIgnoreCase(Token.KSQL_CONS_TYPE.value)) {
            ident = "constraint_type";
            this.pushSysProp(Token.KSQL_CONS_TYPE.value);
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_DEFAULT.value)) {
            ident = "column_default";
            this.pushSysProp(Token.KSQL_COL_DEFAULT.value);
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_NULLABLE.value)) {
            ident = "is_nullable";
            this.pushSysProp(Token.KSQL_COL_NULLABLE.value);
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_TYPE.value)) {
            ident = "data_type";
            this.pushSysProp(Token.KSQL_COL_TYPE.value);
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_LENGTH.value)) {
            ident = "character_maximum_length";
            this.pushSysProp(Token.KSQL_COL_LENGTH.value);
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_PRECISION.value)) {
            ident = "numeric_precision";
            this.pushSysProp(Token.KSQL_COL_PRECISION.value);
        } else if (ident.equalsIgnoreCase(Token.KSQL_COL_SCALE.value)) {
            ident = "numeric_scale";
            this.pushSysProp(Token.KSQL_COL_SCALE.value);
        }
        if (expr.extendedAttributes().get("tableSourceAlias") != null) {
            this.buffer.append(expr.extendedAttributes().get("tableSourceAlias")).append(".").append(ident.toLowerCase(Locale.ENGLISH));
        } else {
            this.buffer.append(ident.toLowerCase(Locale.ENGLISH));
        }
    }

    @Override
    public void formatInsertStmt(SqlInsertStmt stmt) throws FormaterException {
        int i;
        boolean flag;
        this.buffer.append("INSERT INTO ");
        SqlInsert insert = stmt.insert;
        String tableName = this.formatTableName(insert.tableName);
        this.buffer.append(tableName);
        if (!insert.columnList.isEmpty()) {
            this.buffer.append(" (");
            flag = false;
            boolean hasRowNum = false;
            for (i = 0; i < insert.columnList.size(); ++i) {
                Object colItem = insert.columnList.get(i);
                if (colItem instanceof SqlIdentifierExpr) {
                    SqlIdentifierExpr identExpr = (SqlIdentifierExpr)colItem;
                    if (identExpr.value.equalsIgnoreCase("KSQL_SEQ")) {
                        hasRowNum = true;
                    }
                    if (!hasRowNum) {
                        if (flag) {
                            this.buffer.append(", ");
                        }
                        this.buffer.append(identExpr.value.toLowerCase(Locale.ENGLISH));
                    }
                } else if (colItem instanceof String) {
                    if (flag) {
                        this.buffer.append(", ");
                    }
                    this.buffer.append(((String)colItem).toLowerCase(Locale.ENGLISH));
                } else {
                    throw new FormaterException("unexpect expression: '" + colItem + "'");
                }
                flag = !hasRowNum || flag;
                hasRowNum = false;
            }
            this.buffer.append(")");
        }
        if (insert.valueList.size() != 0) {
            this.buffer.append(" VALUES (");
            flag = false;
            for (i = 0; i < insert.valueList.size(); ++i) {
                if (flag) {
                    this.buffer.append(", ");
                }
                SqlExpr valueExpr = (SqlExpr)insert.valueList.get(i);
                this.formatExpr(valueExpr);
                flag = true;
            }
            this.buffer.append(")");
        } else {
            this.buffer.append(" ");
            this.formatSelectBase(stmt.insert.subQuery);
        }
    }

    @Override
    protected void formatUpdateStmt(SqlUpdateStmt stmt) throws FormaterException {
        SqlSelect subQuerySelect;
        int i;
        SubQueryUpdateItem queryItem;
        SqlUpdate update = stmt.update;
        this.buffer.append("UPDATE ");
        this.buffer.append(update.updateTable.name.toLowerCase(Locale.ENGLISH));
        if (update.updateTable.alias != null) {
            this.buffer.append(" ");
            this.buffer.append(update.updateTable.alias.toLowerCase(Locale.ENGLISH));
        }
        this.buffer.append(" SET ");
        ArrayList<AbstractUpdateItem> subqueryUpdateItemList = new ArrayList<AbstractUpdateItem>();
        int count = 0;
        boolean flag = false;
        for (int t = 0; t < update.updateList.size(); ++t) {
            AbstractUpdateItem abstract_item = (AbstractUpdateItem)update.updateList.get(t);
            if (flag) {
                this.buffer.append(", ");
            }
            if (abstract_item instanceof SqlUpdateItem) {
                SqlUpdateItem item = (SqlUpdateItem)abstract_item;
                this.buffer.append(item.name.toLowerCase(Locale.ENGLISH));
                this.buffer.append(" = ");
                this.formatExpr(item.expr);
            } else if (abstract_item instanceof SubQueryUpdateItem) {
                queryItem = (SubQueryUpdateItem)abstract_item;
                if (queryItem.columnList.size() == 1) {
                    String column = (String)queryItem.columnList.get(0);
                    this.buffer.append(column.toLowerCase(Locale.ENGLISH));
                    this.buffer.append(" = (");
                    this.formatSelectBase(queryItem.subQuery);
                    this.buffer.append(")");
                } else {
                    subqueryUpdateItemList.add(abstract_item);
                    for (int i2 = 0; i2 < queryItem.columnList.size(); ++i2) {
                        SqlSelectItem subSelectItem;
                        String column = (String)queryItem.columnList.get(i2);
                        if (i2 != 0) {
                            this.buffer.append(", ");
                        }
                        this.buffer.append(column.toLowerCase(Locale.ENGLISH));
                        this.buffer.append(" = ");
                        if (queryItem.subQuery instanceof SqlSelect) {
                            SqlSelect subQuerySelect2 = (SqlSelect)queryItem.subQuery;
                            subSelectItem = (SqlSelectItem)subQuerySelect2.selectList.get(i2);
                            if (subQuerySelect2 != null && subQuerySelect2.tableSource != null && subQuerySelect2.tableSource.alias != null && !subQuerySelect2.tableSource.alias.trim().equals("")) {
                                subSelectItem.expr.addExtAttr("tableSourceAlias", subQuerySelect2.tableSource.alias);
                            }
                        } else {
                            throw new FormaterException("TODO");
                        }
                        this.formatExpr(subSelectItem.expr, false);
                        ++count;
                        flag = true;
                    }
                }
            } else {
                throw new FormaterException("not support");
            }
            flag = true;
        }
        if (update.tableSource != null) {
            throw new FormaterException("not support");
        }
        HashMap<String, SqlExpr> litertalMap = new HashMap<String, SqlExpr>();
        for (i = 0; i < subqueryUpdateItemList.size(); ++i) {
            if (i == 0) {
                this.buffer.append(" FROM ");
            } else {
                this.buffer.append(", ");
            }
            queryItem = (SubQueryUpdateItem)subqueryUpdateItemList.get(i);
            if (queryItem.subQuery instanceof SqlSelect) {
                subQuerySelect = (SqlSelect)queryItem.subQuery;
                this.formatTableSource(subQuerySelect.tableSource);
                if (subQuerySelect.tableSource instanceof SqlSubQueryTableSource) {
                    String tabSrcAlias = subQuerySelect.tableSource.alias;
                    SqlSelectBase subTabSourceQuery = ((SqlSubQueryTableSource)subQuerySelect.tableSource).subQuery;
                    if (subTabSourceQuery instanceof SqlSelect) {
                        List selectList = ((SqlSelect)subTabSourceQuery).selectList;
                        for (int j = 0; j < selectList.size(); ++j) {
                            SqlSelectItem selectItem = (SqlSelectItem)selectList.get(j);
                            if (selectItem.alias == null || selectItem.alias.length() == 0 || !(selectItem.expr instanceof SqlCharExpr)) continue;
                            String literalName = tabSrcAlias.toLowerCase(Locale.ENGLISH) + "." + selectItem.alias.toLowerCase(Locale.ENGLISH);
                            litertalMap.put(literalName, selectItem.expr);
                        }
                    }
                }
                if (subQuerySelect.condition == null) continue;
                subQuerySelect.condition = this.replaceLiteral(subQuerySelect.condition, litertalMap);
                continue;
            }
            throw new FormaterException("TODO");
        }
        flag = false;
        if (update.condition != null) {
            this.buffer.append(" WHERE ");
            this.formatExpr(update.condition);
            flag = true;
        }
        for (i = 0; i < subqueryUpdateItemList.size(); ++i) {
            queryItem = (SubQueryUpdateItem)subqueryUpdateItemList.get(i);
            if (queryItem.subQuery instanceof SqlSelect) {
                subQuerySelect = (SqlSelect)queryItem.subQuery;
                if (subQuerySelect.condition == null) continue;
                if (flag) {
                    this.buffer.append(" AND ");
                } else {
                    this.buffer.append(" WHERE ");
                }
                this.formatExpr(subQuerySelect.condition);
                flag = true;
                continue;
            }
            throw new FormaterException("TODO");
        }
        for (AbstractUpdateItem abstract_item : update.updateList) {
            if (!(abstract_item instanceof SubQueryUpdateItem)) continue;
            if (flag) {
                this.buffer.append(" AND ");
            } else {
                this.buffer.append(" WHERE ");
                flag = true;
            }
            this.buffer.append("EXISTS (");
            this.formatSelectBase(((SubQueryUpdateItem)abstract_item).subQuery);
            this.buffer.append(")");
        }
    }

    private SqlExpr replaceLiteral(SqlExpr expr, Map literalMap) {
        if (expr instanceof SqlBinaryOpExpr) {
            expr = this.replaceLiteral((SqlBinaryOpExpr)expr, literalMap);
        }
        return expr;
    }

    private SqlExpr replaceLiteral(SqlBinaryOpExpr expr, Map literalMap) {
        if (expr.left instanceof SqlIdentifierExpr && expr.right instanceof SqlIdentifierExpr && expr.operator == 20) {
            SqlIdentifierExpr leftIdentExpr = (SqlIdentifierExpr)expr.left;
            SqlIdentifierExpr rightIdentExpr = (SqlIdentifierExpr)expr.right;
            String name = leftIdentExpr.value.toLowerCase(Locale.ENGLISH) + "." + rightIdentExpr.value.toLowerCase(Locale.ENGLISH);
            SqlExpr literalExpr = (SqlExpr)literalMap.get(name);
            if (literalExpr != null) {
                return literalExpr;
            }
        } else {
            expr.left = this.replaceLiteral(expr.left, literalMap);
            expr.right = this.replaceLiteral(expr.right, literalMap);
        }
        return expr;
    }

    @Override
    protected void formatBlockStmt(SqlBlockStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatSetLocalVariantStmt(SqlSetLocalVariantStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatIfStmt(SqlIfStmt stmt) throws FormaterException {
        SqlStmt itemStmt;
        int i;
        boolean tagbegin = false;
        if (!this.IN_PROCEDURE) {
            this.buffer.append("DO $$\n");
            this.buffer.append("BEGIN\n");
            tagbegin = true;
            this.IN_PROCEDURE = true;
        }
        this.buffer.append("IF ");
        this.formatExpr(stmt.condition);
        this.buffer.append("\nTHEN\n");
        int pos = 0;
        for (i = 0; i < stmt.trueStmtList.size(); ++i) {
            itemStmt = (SqlStmt)stmt.trueStmtList.get(i);
            pos = this.buffer.length();
            this.formatStmt(itemStmt);
            this.buffer.append(";\n");
        }
        this.buffer.append("END IF");
        if (stmt.falseStmtList != null && stmt.falseStmtList.size() > 0) {
            this.buffer.append("ELSE\n");
            this.buffer.append("BEGIN\n");
            for (i = 0; i < stmt.falseStmtList.size(); ++i) {
                itemStmt = (SqlStmt)stmt.falseStmtList.get(i);
                pos = this.buffer.length();
                this.formatStmt(itemStmt);
                this.buffer.append(";\n");
            }
            this.buffer.append("END IF");
        }
        if (tagbegin) {
            this.buffer.append(";\n");
            this.buffer.append("END$$\n");
            this.IN_PROCEDURE = false;
        }
    }

    @Override
    protected void formatWhileStmt(SqlWhileStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatDeallocateStmt(SqlDeallocateStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatCloseStmt(SqlCloseStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatOpenStmt(SqlOpenStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatCursorLoopStmt(SqlCursorLoopStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatFetchStmt(SqlFetchStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatBreakStmt(SqlBreakStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatContinueStmt(SqlContinueStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatGotoStmt(SqlGotoStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    @Override
    protected void formatLabelStmt(SqlLabelStmt stmt) throws FormaterException {
        throw new FormaterException("TODO");
    }

    protected final void formatTableConstraintList(Collection constraintList) throws FormaterException {
        for (SqlTableConstraint constraint : constraintList) {
            this.buffer.append(", ");
            this.formatTableConstraint(constraint);
        }
    }

    protected void formatTableConstraint(SqlTableConstraint constraint) throws FormaterException {
        this.validConstraintName(constraint.name);
        if (constraint.name != null && constraint.name.length() != 0) {
            this.buffer.append("CONSTRAINT ");
            this.buffer.append(constraint.name);
        }
        if (constraint instanceof SqlTablePrimaryKey) {
            SqlTablePrimaryKey primaryKey = (SqlTablePrimaryKey)constraint;
            this.buffer.append(" PRIMARY KEY (");
            boolean flag = false;
            Iterator iterator = primaryKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableUnique) {
            SqlTableUnique unique = (SqlTableUnique)constraint;
            if (unique.clustered) {
                this.buffer.append(" UNIQUE CLUSTERED (");
            } else {
                this.buffer.append(" UNIQUE (");
            }
            boolean flag = false;
            Iterator iterator = unique.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableForeignKey) {
            SqlTableForeignKey foreignKey = (SqlTableForeignKey)constraint;
            this.buffer.append(" FOREIGN KEY (");
            boolean flag = false;
            Iterator iterator = foreignKey.columnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String columnName = (String)iterator.next();
                this.buffer.append(columnName);
                flag = true;
            }
            this.buffer.append(")");
            this.buffer.append(" REFERENCES ");
            this.buffer.append(foreignKey.refTableName);
            this.buffer.append(" (");
            flag = false;
            iterator = foreignKey.refColumnList.iterator();
            while (iterator.hasNext()) {
                if (flag) {
                    this.buffer.append(", ");
                }
                String refColumnName = (String)iterator.next();
                this.buffer.append(refColumnName);
                flag = true;
            }
            this.buffer.append(")");
        } else if (constraint instanceof SqlTableCheck) {
            SqlTableCheck check = (SqlTableCheck)constraint;
            this.buffer.append(" CHECK (");
            this.formatExpr(check.expr, false);
            this.buffer.append(")");
        } else {
            throw new FormaterException("TODO");
        }
    }

    protected void formatColumnDefForAlterColumnNotNull(SqlAlterTableStmt stmt, SqlColumnDef column) throws FormaterException {
        if (column.defaultValueExpr != null) {
            this.buffer.append(";ALTER TABLE ").append(stmt.tableName.toLowerCase(Locale.ENGLISH)).append(" ALTER COLUMN ");
            this.buffer.append(column.name.toLowerCase(Locale.ENGLISH));
            this.buffer.append(" set DEFAULT ");
            this.formatExpr(column.defaultValueExpr);
        }
        if (column.allowNull != null && column.allowNull == Boolean.TRUE) {
            if (column.getNullWord() != null && column.getNullWord().toLowerCase(Locale.ENGLISH).equals("null")) {
                this.buffer.append(";ALTER TABLE ").append(stmt.tableName.toLowerCase(Locale.ENGLISH)).append(" ALTER COLUMN ");
                this.buffer.append(column.name.toLowerCase(Locale.ENGLISH));
                this.buffer.append(" drop NOT NULL");
            }
        } else if (column.allowNull != null && column.allowNull == Boolean.FALSE && this.buffer.indexOf(" INTEGER") < 0) {
            this.buffer.append(";ALTER TABLE ").append(stmt.tableName.toLowerCase(Locale.ENGLISH)).append(" ALTER COLUMN ");
            this.buffer.append(column.name.toLowerCase(Locale.ENGLISH));
            this.buffer.append(" set NOT NULL");
        }
    }

    protected void formatColumnDefForAlterColumn(SqlColumnDef column) throws FormaterException {
        if (column.name == null) {
            throw new FormaterException("column name is null");
        }
        if (this.max_length_of_constraint_name != -1 && column.name != null && column.name.length() > this.max_length_of_constraint_name) {
            throw new FormaterException("column name greate than " + this.max_length_of_column_name + ", column name is '" + column.name + "'");
        }
        this.buffer.append(column.name.toLowerCase(Locale.ENGLISH));
        this.buffer.append(" type ");
        this.addColumnDataType(column);
        if ((column.dataType.equalsIgnoreCase("INTEGER") || column.dataType.equalsIgnoreCase("INT")) && !column.autoIncrement) {
            this.buffer.append(" USING(").append(column.name.toLowerCase(Locale.ENGLISH)).append("::INTEGER)");
        }
        if (column.containtName != null && column.containtName.length() != 0) {
            this.validConstraintName(column.containtName);
            this.buffer.append(" CONSTRAINT ");
            this.buffer.append(column.containtName);
        }
        if (column.isPrimaryKey) {
            this.buffer.append(" PRIMARY KEY");
        }
        if (column.isUnique) {
            this.buffer.append(" UNIQUE");
        }
        if (column.checkExpr != null) {
            this.buffer.append(" CHECK (");
            this.formatExpr(column.checkExpr);
            this.buffer.append(")");
        }
    }

    private void addColumnDataType(SqlColumnDef column) throws FormaterException {
        if (column.dataType.equalsIgnoreCase("BIGINT") || column.dataType.equalsIgnoreCase("INT8")) {
            this.buffer.append("BIGINT");
        } else if (column.dataType.equalsIgnoreCase("BIGSERIAL") || column.dataType.equalsIgnoreCase("SERIAL8")) {
            this.buffer.append("BIGSERIAL");
        } else if (column.dataType.equalsIgnoreCase("BIT")) {
            this.buffer.append("BIT (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BIT VARYING") || column.dataType.equalsIgnoreCase("VARBIT")) {
            this.buffer.append("BIT VARYING (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("BOOLEAN") || column.dataType.equalsIgnoreCase("BOOL")) {
            this.buffer.append("BOOLEAN");
        } else if (column.dataType.equalsIgnoreCase("BOX")) {
            this.buffer.append("BOX");
        } else if (column.dataType.equalsIgnoreCase("BYTEA")) {
            this.buffer.append("BYTEA");
        } else if (column.dataType.equalsIgnoreCase("CHARACTER") || column.dataType.equalsIgnoreCase("CHAR")) {
            this.buffer.append("CHARACTER (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CHARACTER VARYING") || column.dataType.equalsIgnoreCase("VARCHAR") || column.dataType.equalsIgnoreCase("VARCHAR2")) {
            this.buffer.append("CHARACTER VARYING (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("CIDR")) {
            this.buffer.append("CIDR");
        } else if (column.dataType.equalsIgnoreCase("CIRCLE")) {
            this.buffer.append("CIRCLE");
        } else if (column.dataType.equalsIgnoreCase("DATE")) {
            this.buffer.append("DATE");
        } else if (column.dataType.equalsIgnoreCase("DOUBLE PRECISION")) {
            this.buffer.append("DOUBLE PRECISION");
        } else if (column.dataType.equalsIgnoreCase("INET")) {
            this.buffer.append("INET");
        } else if (column.dataType.equalsIgnoreCase("INTEGER") || column.dataType.equalsIgnoreCase("INT") || column.dataType.equalsIgnoreCase("INT4")) {
            if (column.autoIncrement) {
                this.buffer.append("SERIAL");
            } else {
                this.buffer.append("INTEGER");
            }
        } else if (column.dataType.equalsIgnoreCase("INTERVAL")) {
            this.buffer.append("INTERVAL (");
            this.buffer.append(column.precision);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("LINE")) {
            this.buffer.append("LINE");
        } else if (column.dataType.equalsIgnoreCase("LSEG")) {
            this.buffer.append("LSEG");
        } else if (column.dataType.equalsIgnoreCase("MACADDR")) {
            this.buffer.append("MACADDR");
        } else if (column.dataType.equalsIgnoreCase("MONEY")) {
            this.buffer.append("MONEY");
        } else if (column.dataType.equalsIgnoreCase("NUMERIC")) {
            this.buffer.append("NUMERIC (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("PATH")) {
            this.buffer.append("PATH");
        } else if (column.dataType.equalsIgnoreCase("POINT")) {
            this.buffer.append("POINT");
        } else if (column.dataType.equalsIgnoreCase("POLYGON")) {
            this.buffer.append("POLYGON");
        } else if (column.dataType.equalsIgnoreCase("REAL") || column.dataType.equalsIgnoreCase("FLOAT4")) {
            this.buffer.append("REAL");
        } else if (column.dataType.equalsIgnoreCase("SMALLINT") || column.dataType.equalsIgnoreCase("INT2")) {
            this.buffer.append("SMALLINT");
        } else if (column.dataType.equalsIgnoreCase("SERIAL") || column.dataType.equalsIgnoreCase("SERIAL4")) {
            this.buffer.append("SERIAL");
        } else if (column.dataType.equalsIgnoreCase("TEXT")) {
            this.buffer.append("TEXT");
        } else if (column.dataType.equalsIgnoreCase("TIME") || column.dataType.equalsIgnoreCase("TIME WITHOUT TIME ZONE")) {
            if (column.precision == -1) {
                this.buffer.append("TIME WITHOUT TIME ZONE");
            } else {
                this.buffer.append("TIME (");
                this.buffer.append(column.precision);
                this.buffer.append(") WITHOUT TIME ZONE");
            }
        } else if (column.dataType.equalsIgnoreCase("TIMETZ") || column.dataType.equalsIgnoreCase("TIME WITH TIME ZONE")) {
            if (column.precision == -1) {
                this.buffer.append("TIME WITH TIME ZONE");
            } else {
                this.buffer.append("TIME (");
                this.buffer.append(column.precision);
                this.buffer.append(") WITH TIME ZONE");
            }
        } else if (column.dataType.equalsIgnoreCase("TIMESTAMP") || column.dataType.equalsIgnoreCase("TIMESTAMP WITHOUT TIME ZONE")) {
            if (column.precision == -1) {
                this.buffer.append("TIMESTAMP WITHOUT TIME ZONE");
            } else {
                this.buffer.append("TIMESTAMP (");
                this.buffer.append(column.precision);
                this.buffer.append(") WITHOUT TIME ZONE");
            }
        } else if (column.dataType.equalsIgnoreCase("TIMESTAMPZ") || column.dataType.equalsIgnoreCase("TIMESTAMP WITH TIME ZONE")) {
            if (column.precision == -1) {
                this.buffer.append("TIMESTAMP WITH TIME ZONE");
            } else {
                this.buffer.append("TIMESTAMP (");
                this.buffer.append(column.precision);
                this.buffer.append(") WITH TIME ZONE");
            }
        } else if (column.dataType.equalsIgnoreCase("BLOB")) {
            this.buffer.append("BYTEA");
        } else if (column.dataType.equalsIgnoreCase("CLOB")) {
            this.buffer.append("TEXT");
        } else if (column.dataType.equalsIgnoreCase("DATETIME")) {
            this.buffer.append("TIMESTAMP WITHOUT TIME ZONE");
        } else if (column.dataType.equalsIgnoreCase("DECIMAL")) {
            this.buffer.append("NUMERIC (");
            this.buffer.append(column.precision);
            this.buffer.append(", ");
            this.buffer.append(column.scale);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("NCHAR")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length).append(")");
        } else if (column.dataType.equalsIgnoreCase("NCLOB")) {
            this.buffer.append("TEXT");
        } else if (column.dataType.equalsIgnoreCase("NVARCHAR") || column.dataType.equalsIgnoreCase("NVARCHAR2")) {
            this.buffer.append("VARCHAR (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else if (column.dataType.equalsIgnoreCase("VARBINARY")) {
            this.buffer.append("BIT VARYING (");
            this.buffer.append(column.length);
            this.buffer.append(")");
        } else {
            throw new FormaterException("not support datatype, column name is '" + column.name + "' datatype is '" + column.dataType + "'");
        }
    }

    protected void formatValueKSQL_COL_NULLABLE(SqlBinaryOpExpr expr) {
        SqlCharExpr charExpr = (SqlCharExpr)expr.right;
        if (charExpr.text.equalsIgnoreCase("Y")) {
            this.buffer.append("'YES'");
        } else if (charExpr.text.equalsIgnoreCase("N")) {
            this.buffer.append("'NO'");
        } else {
            throw new NotSupportedException("unexpected expression: " + expr.toString());
        }
    }

    @Override
    public void formatSelectBase(SqlSelectBase select) throws FormaterException {
        if (select instanceof SqlSelect) {
            this.formatSelect((SqlSelect)select);
        } else if (select instanceof SqlUnionSelect) {
            SqlUnionSelect unionSelect = (SqlUnionSelect)select;
            if (unionSelect.left instanceof SqlUnionSelect && ((SqlUnionSelect)unionSelect.left).option != unionSelect.option) {
                this.buffer.append('(');
                this.formatSelectBase(unionSelect.left);
                this.buffer.append(')');
            } else {
                this.buffer.append('(');
                this.handleSqlSelectInUnionSelect(unionSelect.left);
                this.buffer.append(')');
                select.subQueries.addAll(unionSelect.left.subQueries);
            }
            if (unionSelect.option == 0) {
                this.buffer.append(" UNION ");
            } else if (unionSelect.option == 1) {
                this.buffer.append(" UNION ALL ");
            } else {
                throw new FormaterException("Eorr Union Option.");
            }
            if (unionSelect.right instanceof SqlUnionSelect) {
                if (((SqlUnionSelect)unionSelect.right).option != unionSelect.option) {
                    this.buffer.append('(');
                    this.formatSelectBase(unionSelect.right);
                    this.buffer.append(')');
                } else {
                    this.handleSqlSelectInUnionSelect(unionSelect.right);
                    select.subQueries.addAll(unionSelect.right.subQueries);
                }
            } else {
                this.buffer.append('(');
                this.handleSqlSelectInUnionSelect(unionSelect.right);
                this.buffer.append(')');
                select.subQueries.addAll(unionSelect.right.subQueries);
            }
            if (unionSelect.orderBy.size() != 0) {
                this.buffer.append(" ORDER BY ");
                boolean flag = false;
                Iterator iterator = unionSelect.orderBy.iterator();
                while (iterator.hasNext()) {
                    if (flag) {
                        this.buffer.append(", ");
                    }
                    SqlOrderByItem orderByIterm = (SqlOrderByItem)iterator.next();
                    this.formatExpr(orderByIterm.expr);
                    if (orderByIterm.mode == 0) {
                        this.buffer.append(" ASC");
                    } else {
                        this.buffer.append(" DESC");
                    }
                    flag = true;
                }
            }
        }
    }
}

