/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.sql.shell.trace.client;

import com.kingdee.bos.sql.shell.trace.LogItem;
import com.kingdee.bos.sql.shell.trace.client.ITraceListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

public class NTraceClient {
    public static final int DEFAULT_PORT = 9791;
    private int port;
    private Socket socket;
    private String hostname;
    private Thread thread;

    public NTraceClient(String hostname) {
        this(hostname, 9791);
    }

    public NTraceClient(String hostname, int port) {
        this.port = port;
        this.hostname = hostname;
    }

    public void connect(ITraceListener listener) throws IOException {
        InetSocketAddress addr = new InetSocketAddress(this.hostname, this.port);
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        socketChannel.connect(addr);
        while (!socketChannel.finishConnect()) {
            Thread.yield();
        }
        this.thread = new Thread(new TraceRunner(listener, socketChannel));
        this.thread.start();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    class LogItemReaderInputStream
    extends InputStream {
        private ByteBuffer buff;

        public LogItemReaderInputStream(ByteBuffer buff) {
            this.buff = buff;
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.buff.position() == this.buff.limit()) {
                this.buff.clear();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.buff.get();
        }
    }

    class LogItemReader
    implements Runnable {
        private LogItemReaderInputStream logItemInputStream;
        private ITraceListener listener;

        public LogItemReader(LogItemReaderInputStream logItemInputStream, ITraceListener listener) {
            this.logItemInputStream = logItemInputStream;
            this.listener = listener;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        LogItem item = LogItem.readLogItem(this.logItemInputStream);
                        this.listener.receive(item);
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }
    }

    class TraceRunner
    implements Runnable {
        private ITraceListener listener;
        private SocketChannel socketChannel;

        public TraceRunner(ITraceListener listener, SocketChannel socketChannel) {
            this.listener = listener;
            this.socketChannel = socketChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Selector selector = Selector.open();
                this.socketChannel.register(selector, 1);
                ByteBuffer buff = ByteBuffer.allocateDirect(1024);
                buff.clear();
                LogItemReaderInputStream logItemInputStream = new LogItemReaderInputStream(buff);
                LogItemReader reader = new LogItemReader(logItemInputStream, this.listener);
                Thread thread = new Thread(reader);
                thread.setName("KSQL NTraceClient LogItemReader");
                thread.start();
                while (selector.select() > 0) {
                    Set<SelectionKey> readyKeys = selector.selectedKeys();
                    Iterator<SelectionKey> i = readyKeys.iterator();
                    while (i.hasNext()) {
                        SelectionKey sk = i.next();
                        i.remove();
                        SocketChannel nextReady = (SocketChannel)sk.channel();
                        LogItemReaderInputStream logItemReaderInputStream = logItemInputStream;
                        synchronized (logItemReaderInputStream) {
                            nextReady.read(buff);
                            buff.flip();
                        }
                        logItemInputStream.notify();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

