/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.api;

import com.kingdee.shr.api.OSFWSClient;
import com.kingdee.shr.api.Response;
import com.kingdee.shr.api.Token;
import com.kingdee.shr.sso.client.ltpa.LtpaTokenManager;
import com.kingdee.shr.sso.client.util.SSOUtil;
import com.kingdee.shr.sso.client.util.UrlUtil;
import com.kingdee.shr.util.DataHandlerUtil;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.utils.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHRClient {
    private static final String JSESSIONID_KEY = "JSESSIONID";
    private static final String SERVICE_PATH = "/shr/msf/service.do";
    private static final String SHR_SSO_TOKEN = "_shr_sso_token";
    private static final String USERNAME = "username";
    private static final String SERVICE_NAME = "serviceName";
    private static final String METHOD = "method";
    private static final String METHOD_NAME = "callService";
    private static final String REFERER = "Referer";
    private static final int timeoutTime = 60000;
    private static final int timeoutSocketIOTime = 180000;
    private static final Logger logger = LoggerFactory.getLogger(SHRClient.class);

    public Token login(HttpServletRequest request) throws HttpException, IOException {
        return this.login(request, null);
    }

    public Token login(HttpServletRequest request, String serverUrl) throws HttpException, IOException {
        String url = SSOUtil.generateUrl(request, serverUrl);
        return this.loginShr(request, url);
    }

    public Token loginByUser(HttpServletRequest request) throws HttpException, IOException {
        return this.loginByUser(request, null);
    }

    public Token loginByUser(HttpServletRequest request, String serverUrl) throws HttpException, IOException {
        String loginUrl = SSOUtil.getLoginUrl(request, serverUrl);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(USERNAME, "user");
        SSOUtil.assembleLoginParameters(request, parameters);
        String url = UrlUtil.assembleUrl(loginUrl, parameters);
        return this.loginShr(request, url);
    }

    public Response executeService(String serverUrl, String serviceName, Map<String, Object> param) throws HttpException, IOException {
        return this.executeServiceByName(serverUrl, serviceName, param, "user");
    }

    public Response executeServiceByName(String serverUrl, String serviceName, Map<String, Object> param, String name) throws HttpException, IOException {
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpClient httpClient = (CloseableHttpClient)this.createHttpClient(serverUrl);
        Token token = this.loginShrByName(context, serverUrl, name, (HttpClient)httpClient);
        Response response = this.executeOSFService(context, serverUrl, serviceName, param, httpClient);
        this.logout(serverUrl, token, httpClient);
        return response;
    }

    public Token loginShrByName(HttpClientContext context, String serverUrl, String name, HttpClient client) throws IOException, HttpException {
        String loginUrl = serverUrl + "/OTP2sso.jsp";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(USERNAME, name);
        String password = LtpaTokenManager.generate((String)parameters.get(USERNAME), LtpaTokenManager.getDefaultLtpaConfig(), "OTP").toString();
        parameters.put("password", password);
        parameters.put("userAuthPattern", "OTP");
        parameters.put("isNotCheckRelogin", "true");
        parameters.put("redirectTo", "/home.do");
        String url = UrlUtil.assembleUrl(loginUrl, parameters);
        HttpGet httpGet = new HttpGet(url);
        httpGet.setHeader(REFERER, serverUrl);
        httpGet.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.88 Safari/537.36");
        HttpResponse httpResponse = client.execute((HttpUriRequest)httpGet, (HttpContext)context);
        int status = httpResponse.getStatusLine().getStatusCode();
        String msg = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        Token token = null;
        if (!StringUtils.isEmpty((String)msg) && msg.contains("sso access error")) {
            throw new HttpException("login shr fail, status: " + msg.replace("\r\n", ""));
        }
        if (status != 200) {
            if (500 == status) {
                throw new HttpException("login shr fail, status: " + status + ",please check server-side apusic logs!");
            }
            throw new HttpException("login shr fail, status: " + status);
        }
        logger.info("login shr success!");
        token = this.getToken(context.getCookieStore().getCookies());
        EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        return token;
    }

    public Response executeOSFService(HttpClientContext context, String serverUrl, String serviceName, Map<String, Object> param, CloseableHttpClient httpClient) throws HttpException, IOException {
        String loginUrl = serverUrl + SERVICE_PATH;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(METHOD, METHOD_NAME);
        parameters.put(SERVICE_NAME, serviceName);
        String url = UrlUtil.assembleUrl(loginUrl, parameters);
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        if (param != null && param.size() > 0) {
            for (Map.Entry<String, Object> stringObjectEntry : param.entrySet()) {
                params.add(new BasicNameValuePair(stringObjectEntry.getKey(), stringObjectEntry.getValue().toString()));
            }
        }
        String cookieString = UrlUtil.cookiesToString(context.getCookieStore().getCookies());
        httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
        httpPost.setHeader(REFERER, serverUrl);
        httpPost.setHeader("Cookie", cookieString);
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost, (HttpContext)context);
        int status = httpResponse.getStatusLine().getStatusCode();
        Response response = new Response();
        if (status == 200) {
            String content = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            try {
                content = DataHandlerUtil.formatResponseDataHandle(content, true);
                response.setData(content);
            }
            catch (HttpException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HttpException("Call OSF error,decrypt error: " + e.getMessage());
            }
        } else {
            logger.error("Method failed: " + httpResponse.getStatusLine());
            throw new HttpException("status: " + status + ", request url: " + url + " failed");
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        return response;
    }

    public void logout(String serverUrl, Token token, CloseableHttpClient httpClient) throws IOException {
        CloseableHttpResponse httpResponse;
        if (serverUrl == null || serverUrl.isEmpty()) {
            return;
        }
        boolean endWithSHR = serverUrl.endsWith("shr");
        if (!endWithSHR && !serverUrl.endsWith("shr/")) {
            logger.error("login shr fail, unsupported to logout by domain, serverUrl: " + serverUrl);
            return;
        }
        int sepLength = endWithSHR ? 3 : 4;
        serverUrl = serverUrl.substring(0, serverUrl.length() - sepLength);
        HttpGet easssoLogout = new HttpGet(serverUrl + "eassso/logout");
        HttpGet logoutPortalMethod = new HttpGet(serverUrl + "easportal/logout.jsp?JSESSIONID=" + token.getValue());
        HttpGet logoutMethod = new HttpGet(serverUrl + "easweb/logout?isSso=true&JSESSIONID=" + token.getValue());
        HttpGet shrLogout = new HttpGet(serverUrl + "shr/shr_loginout/logoutAndReleaseResource.do?ticked=true");
        try {
            httpResponse = httpClient.execute((HttpUriRequest)easssoLogout);
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
        catch (Exception e) {
            logger.error("logout " + serverUrl + "eassso/logout fail", (Throwable)e);
        }
        try {
            httpResponse = httpClient.execute((HttpUriRequest)logoutPortalMethod);
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
        catch (Exception e) {
            logger.error("logout " + serverUrl + "easportal/logout.jsp fail", (Throwable)e);
        }
        try {
            httpResponse = httpClient.execute((HttpUriRequest)logoutMethod);
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
        catch (Exception e) {
            logger.error("logout " + serverUrl + "easweb/logout fail", (Throwable)e);
        }
        try {
            httpResponse = httpClient.execute((HttpUriRequest)shrLogout);
            EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        }
        catch (Exception e) {
            logger.error("logout " + serverUrl + "shr/shr_loginout/logoutAndReleaseResource.do?ticked=true fail", (Throwable)e);
        }
        httpClient.close();
    }

    public Response execute(HttpServletRequest request, String serviceName, Map<String, Object> parameters) throws IOException, HttpException {
        String serverUrl = SSOUtil.getServerUrl(request);
        if (SSOUtil.isWebService(request)) {
            Response res = new Response();
            res.setData(new OSFWSClient().proceedOSF(serverUrl, serviceName, parameters));
            return res;
        }
        return this.execute(request, serverUrl, serviceName, parameters);
    }

    public Response execute(HttpServletRequest request, String serverUrl, String serviceName, Map<String, Object> parameters) throws IOException, HttpException {
        if (serverUrl == null || serverUrl.length() == 0) {
            throw new HttpException("serverUrl is null");
        }
        if (serviceName == null) {
            throw new HttpException("serviceName is null");
        }
        Token token = (Token)request.getSession().getAttribute(SHR_SSO_TOKEN);
        if (token == null) {
            token = this.login(request);
        }
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpClient client = (CloseableHttpClient)this.createHttpClient(serverUrl);
        this.addToken((HttpContext)context, token);
        String url = this.generateRequestUrl(serverUrl, serviceName, parameters);
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader(REFERER, serverUrl);
        CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost, (HttpContext)context);
        int status = httpResponse.getStatusLine().getStatusCode();
        Response response = new Response();
        if (status == 200) {
            String content = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            try {
                content = DataHandlerUtil.formatResponseDataHandle(content, true);
                response.setData(content);
            }
            catch (HttpException e) {
                throw e;
            }
            catch (Exception e) {
                throw new HttpException("Call OSF error,decrypt error: " + e.getMessage());
            }
        } else {
            logger.error("Method failed: " + httpResponse.getStatusLine());
            throw new HttpException("status: " + status + ", request url: " + url + " failed");
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        try {
            this.logout(serverUrl, token, client);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return response;
    }

    private HttpClient createHttpClient(String serverUrl) {
        LaxRedirectStrategy redirectStrategy = new LaxRedirectStrategy();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(180000).setCookieSpec("standard").setCookieSpec("compatibility").setCircularRedirectsAllowed(true).setRedirectsEnabled(true).setMaxRedirects(10).build();
        CloseableHttpClient httpClient = null;
        if (serverUrl != null && serverUrl.startsWith("https")) {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContextBuilder.create().loadTrustMaterial((chain, authType) -> true).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setRedirectStrategy((RedirectStrategy)redirectStrategy).setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionFactory).build();
        } else {
            httpClient = HttpClients.custom().setDefaultRequestConfig(requestConfig).setRedirectStrategy((RedirectStrategy)redirectStrategy).build();
        }
        return httpClient;
    }

    private Token getToken(List<Cookie> cookies) throws HttpException {
        for (Cookie cookie : cookies) {
            if (!JSESSIONID_KEY.equalsIgnoreCase(cookie.getName()) || cookie.getPath().contains("sso")) continue;
            Token token = new Token();
            token.setDomain(cookie.getDomain());
            token.setPath(cookie.getPath());
            token.setValue(cookie.getValue());
            return token;
        }
        throw new HttpException("getToken fail, cookies: " + this.cookieToString(cookies));
    }

    private String cookieToString(List<Cookie> cookies) {
        Cookie cookie = null;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cookies.size(); ++i) {
            cookie = cookies.get(i);
            if (i != 0) {
                sb.append(",");
            }
            sb.append("[name=");
            sb.append(cookie.getName());
            sb.append(", path=");
            sb.append(cookie.getPath());
            sb.append(", value=");
            sb.append(cookie.getValue());
            sb.append("]");
        }
        return sb.toString();
    }

    private Token loginShr(HttpServletRequest request, String loginUrl) throws IOException, HttpException {
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpClient client = (CloseableHttpClient)this.createHttpClient(loginUrl);
        HttpGet httpGet = new HttpGet(loginUrl);
        httpGet.addHeader(REFERER, loginUrl);
        CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpGet, (HttpContext)context);
        int status = httpResponse.getStatusLine().getStatusCode();
        Token token = null;
        if (status != 200) {
            throw new HttpException("login shr fail, status: " + status);
        }
        token = this.getToken(context.getCookieStore().getCookies());
        request.getSession().setAttribute(SHR_SSO_TOKEN, (Object)token);
        EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
        client.close();
        return token;
    }

    private void addToken(HttpContext context, Token token) {
        HttpClientContext httpClientContext = (HttpClientContext)context;
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicClientCookie cookie = new BasicClientCookie(JSESSIONID_KEY, token.getValue());
        cookie.setDomain(token.getDomain());
        cookie.setPath(token.getPath());
        cookieStore.addCookie((Cookie)cookie);
        httpClientContext.setCookieStore((CookieStore)cookieStore);
    }

    private String generateRequestUrl(String serverUrl, String serviceName, Map<String, Object> parameters) {
        if (parameters == null) {
            parameters = new HashMap<String, Object>();
        }
        parameters.put(SERVICE_NAME, serviceName);
        parameters.put(METHOD, METHOD_NAME);
        String url = serverUrl + SERVICE_PATH;
        return UrlUtil.assembleUrl(url, parameters);
    }
}

