/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.attendanceexception.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.attendanceexception.AttendanceExceptionLogFactory;
import com.kingdee.eas.custom.attendanceexception.AttendanceExceptionLogInfo;
import com.kingdee.eas.custom.attendanceexception.CenterLeaderRelationFactory;
import com.kingdee.eas.custom.attendanceexception.IAttendanceExceptionLog;
import com.kingdee.eas.custom.attendanceexception.ICenterLeaderRelation;
import com.kingdee.eas.custom.attendanceexception.bean.SyncAttendanceDataBean;
import com.kingdee.eas.custom.attendanceexception.bizEnum.PushTypeEnum;
import com.kingdee.eas.custom.attendanceexception.task.AbstractAttendanceExceptionFacadeControllerBean;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AttendanceFileCollection;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.IAttendanceFile;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.CallStatusEnum;
import com.kingdee.util.DateTimeUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AttendanceExceptionFacadeControllerBean
extends AbstractAttendanceExceptionFacadeControllerBean {
    private static Logger logger = Logger.getLogger(AttendanceExceptionFacadeControllerBean.class);
    private Properties propt = new Properties();
    private static final String SOURCE = "EHR";

    public AttendanceExceptionFacadeControllerBean() throws BOSException {
        String syncOAConfigPath = System.getProperty("EAS_HOME") + "/server/properties/scy/attendanceException.properties";
        try {
            this.propt.load(new FileInputStream(syncOAConfigPath));
        }
        catch (IOException e) {
            e.printStackTrace();
            String errorMsg = "\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u62a5\u9519\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff1a" + syncOAConfigPath + "   " + e.getMessage();
            throw new BOSException(errorMsg);
        }
    }

    @Override
    protected void _notifyEmployeeException(Context ctx) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"AttendanceExceptionFacadeControllerBean.notifyEmployeeException start");
        }
        super._notifyEmployeeException(ctx);
        IAttendanceExceptionLog iAttendanceExceptionLog = AttendanceExceptionLogFactory.getLocalInstance(ctx);
        PushTypeEnum pushTypeEnum = PushTypeEnum.EMPLOYEEREMINDER;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd E HH:mm:ss");
        java.util.Date preDay = AtsDateUtils.getPreDay((java.util.Date)new java.util.Date());
        logger.error((Object)("_notifyEmployeeCumulativeException preDay: " + sdf.format(preDay)));
        Map<String, List<SyncAttendanceDataBean>> exceptionData = this.getAttendanceExceptionData(ctx, preDay, preDay, pushTypeEnum, 0);
        String yearMonthDay = DateTimeUtils.format((java.util.Date)preDay, (String)"yyyy\u5e74MM\u6708dd\u65e5");
        for (String personNumber : exceptionData.keySet()) {
            String msgId = UUID.randomUUID().toString();
            AttendanceExceptionLogInfo logInfo = new AttendanceExceptionLogInfo();
            logInfo.setMessageId(msgId);
            logInfo.setPushType(pushTypeEnum);
            try {
                JSONObject dingMsgBean = new JSONObject();
                dingMsgBean.put("msgTempCode", (Object)"work_notice_03");
                dingMsgBean.put("toAllUser", (Object)false);
                dingMsgBean.put("userIdList", (Object)personNumber);
                dingMsgBean.put("source", (Object)SOURCE);
                JSONObject param = new JSONObject();
                param.put("msgId", (Object)msgId);
                param.put("time", (Object)yearMonthDay);
                dingMsgBean.put("param", (Object)param);
                this.sendAttendanceExceptionMsg(dingMsgBean, logInfo);
                List<SyncAttendanceDataBean> syncAttendanceDataBeans = exceptionData.get(personNumber);
                syncAttendanceDataBeans.stream().forEach(syncAttendanceDataBean -> syncAttendanceDataBean.setMsgId(msgId));
                this.pushAttendanceExceptionData(syncAttendanceDataBeans, logInfo);
            }
            catch (Exception e) {
                String message = e.getMessage();
                logger.error((Object)("\u5458\u5de5\u4e2a\u4eba\u5f02\u5e38\u63d0\u9192\u62a5\u9519 " + message), (Throwable)e);
                if (message.contains("connect timed out")) {
                    iAttendanceExceptionLog.save((CoreBaseInfo)logInfo);
                    break;
                }
                logInfo.setPushStatus(CallStatusEnum.failure);
                logInfo.setPushResult(message);
            }
            iAttendanceExceptionLog.save((CoreBaseInfo)logInfo);
        }
        if (logger.isInfoEnabled()) {
            long endTime = System.currentTimeMillis();
            float duration = (float)(endTime - startTime) / 1000.0f;
            logger.info((Object)String.format("AttendanceExceptionFacadeControllerBean.notifyEmployeeException end, duration: %fS", Float.valueOf(duration)));
        }
    }

    @Override
    protected void _notifyEmployeeCumulativeException(Context ctx, String exceptionLimit) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"AttendanceExceptionFacadeControllerBean.notifyEmployeeCumulativeException start");
        }
        super._notifyEmployeeCumulativeException(ctx, exceptionLimit);
        int limit = 5;
        if (StringUtils.isNotBlank((CharSequence)exceptionLimit)) {
            limit = Integer.parseInt(exceptionLimit);
        }
        IAttendanceExceptionLog iAttendanceExceptionLog = AttendanceExceptionLogFactory.getLocalInstance(ctx);
        PushTypeEnum pushTypeEnum = PushTypeEnum.EMPLOYEEEXCEPTIONALERT;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd E HH:mm:ss");
        java.util.Date today = new java.util.Date();
        java.util.Date currentFirstDay = AtsDateUtils.getCurrentFirstDay((java.util.Date)today);
        logger.error((Object)("_notifyEmployeeCumulativeException currentFirstDay: " + sdf.format(currentFirstDay)));
        java.util.Date preDay = AtsDateUtils.getPreDay((java.util.Date)today);
        logger.error((Object)("_notifyEmployeeCumulativeException preDay: " + sdf.format(preDay)));
        Map<String, List<SyncAttendanceDataBean>> exceptionData = this.getAttendanceExceptionData(ctx, currentFirstDay, preDay, pushTypeEnum, limit);
        String yearMonth = DateTimeUtils.format((java.util.Date)today, (String)"yyyy\u5e74MM\u6708");
        for (String personNumber : exceptionData.keySet()) {
            String msgId = UUID.randomUUID().toString();
            AttendanceExceptionLogInfo logInfo = new AttendanceExceptionLogInfo();
            logInfo.setMessageId(msgId);
            logInfo.setPushType(pushTypeEnum);
            try {
                JSONObject dingMsgBean = new JSONObject();
                dingMsgBean.put("msgTempCode", (Object)"work_notice_02");
                dingMsgBean.put("toAllUser", (Object)false);
                dingMsgBean.put("userIdList", (Object)personNumber);
                dingMsgBean.put("source", (Object)SOURCE);
                JSONObject param = new JSONObject();
                param.put("msgId", (Object)msgId);
                param.put("time", (Object)yearMonth);
                param.put("eorNum", (Object)limit);
                dingMsgBean.put("param", (Object)param);
                this.sendAttendanceExceptionMsg(dingMsgBean, logInfo);
                List<SyncAttendanceDataBean> syncAttendanceDataBeans = exceptionData.get(personNumber);
                syncAttendanceDataBeans.stream().forEach(syncAttendanceDataBean -> syncAttendanceDataBean.setMsgId(msgId));
                this.pushAttendanceExceptionData(syncAttendanceDataBeans, logInfo);
                this.addRemindRecord(ctx, yearMonth, personNumber);
            }
            catch (Exception e) {
                String message = e.getMessage();
                logger.error((Object)("\u63d0\u9192\u5458\u5de5\u7d2f\u8ba1\u5f02\u5e38\u62a5\u9519: " + message), (Throwable)e);
                if (message.contains("connect timed out")) {
                    iAttendanceExceptionLog.save((CoreBaseInfo)logInfo);
                    break;
                }
                logInfo.setPushStatus(CallStatusEnum.failure);
                logInfo.setPushResult(message);
            }
            iAttendanceExceptionLog.save((CoreBaseInfo)logInfo);
        }
        if (logger.isInfoEnabled()) {
            long endTime = System.currentTimeMillis();
            float duration = (float)(endTime - startTime) / 1000.0f;
            logger.info((Object)String.format("AttendanceExceptionFacadeControllerBean.notifyEmployeeCumulativeException end, duration: %fS", Float.valueOf(duration)));
        }
    }

    @Override
    protected void _alertLeaderExceptionTotal(Context ctx) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        if (logger.isInfoEnabled()) {
            logger.info((Object)"AttendanceExceptionFacadeControllerBean.alertLeaderExceptionTotal start");
        }
        super._alertLeaderExceptionTotal(ctx);
        IAttendanceExceptionLog iAttendanceExceptionLog = AttendanceExceptionLogFactory.getLocalInstance(ctx);
        ICenterLeaderRelation iCenterLeaderRelation = CenterLeaderRelationFactory.getLocalInstance(ctx);
        Map leaders = iCenterLeaderRelation.getLeaders();
        PushTypeEnum pushTypeEnum = PushTypeEnum.CENTERLEADERREMINDER;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd E HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        int intWeek = calendar.get(7);
        calendar.add(7, 2 - intWeek);
        java.util.Date monday = calendar.getTime();
        logger.error((Object)("_alertLeaderExceptionTotal startDate: " + sdf.format(monday)));
        calendar.add(7, 4);
        java.util.Date endDate = calendar.getTime();
        logger.error((Object)("_alertLeaderExceptionTotal endDate: " + sdf.format(endDate)));
        List<Map<String, Object>> exceptionDataList = this.getAttendanceExceptionDataForLeader(ctx, monday, endDate, pushTypeEnum);
        String mondayFormat = DateTimeUtils.format((java.util.Date)monday, (String)"yyyy\u5e74MM\u6708dd\u65e5");
        String endDateFormat = DateTimeUtils.format((java.util.Date)endDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
        for (String orgLongNumber : leaders.keySet()) {
            AttendanceExceptionLogInfo logInfo = new AttendanceExceptionLogInfo();
            String msgId = UUID.randomUUID().toString();
            logInfo.setMessageId(msgId);
            logInfo.setPushType(pushTypeEnum);
            try {
                AdminOrgUnitInfo orgInfo = this.getOrgInfo(ctx, orgLongNumber);
                String orgName = orgInfo.getName();
                String alertUsers = (String)leaders.get(orgLongNumber);
                if (StringUtils.isBlank((CharSequence)alertUsers)) {
                    throw new BOSException(orgName + "\u7684\u8d1f\u8d23\u4eba\u4e3a\u7a7a!");
                }
                Integer attendanceCount = this.getAttendanceCount(ctx, orgLongNumber);
                HashSet lateEmployees = new HashSet();
                HashSet earlyLeaveEmployees = new HashSet();
                HashSet absentEmployees = new HashSet();
                HashSet exceptionEmployees = new HashSet();
                ArrayList syncAttendanceDataBeans = new ArrayList();
                exceptionDataList.stream().forEach(map -> {
                    SyncAttendanceDataBean exceptionDataBean = (SyncAttendanceDataBean)map.get("data");
                    String departmentManagerCode = exceptionDataBean.getDepartmentManagerCode();
                    if (departmentManagerCode.startsWith(orgLongNumber)) {
                        Map attendanceFlags = (Map)map.get("attendanceFlags");
                        String personNumber = exceptionDataBean.getEmployeeId();
                        exceptionDataBean.setMsgId(msgId);
                        syncAttendanceDataBeans.add(exceptionDataBean);
                        exceptionEmployees.add(personNumber);
                        if (((Boolean)attendanceFlags.get("lateEmployees")).booleanValue()) {
                            lateEmployees.add(personNumber);
                        }
                        if (((Boolean)attendanceFlags.get("earlyLeaveEmployees")).booleanValue()) {
                            earlyLeaveEmployees.add(personNumber);
                        }
                        if (((Boolean)attendanceFlags.get("absentEmployees")).booleanValue()) {
                            absentEmployees.add(personNumber);
                        }
                    }
                });
                JSONObject dingMsgBean = new JSONObject();
                dingMsgBean.put("msgTempCode", (Object)"work_notice_01");
                dingMsgBean.put("toAllUser", (Object)false);
                dingMsgBean.put("userIdList", (Object)alertUsers);
                dingMsgBean.put("source", (Object)SOURCE);
                JSONObject param = new JSONObject();
                param.put("msgId", (Object)msgId);
                param.put("time", (Object)(mondayFormat + "-" + endDateFormat));
                param.put("centerNum", (Object)attendanceCount);
                param.put("eorNum", (Object)exceptionEmployees.size());
                param.put("lateNum", (Object)lateEmployees.size());
                param.put("earlyNum", (Object)earlyLeaveEmployees.size());
                param.put("hookyNum", (Object)absentEmployees.size());
                param.put("depart", (Object)orgName);
                dingMsgBean.put("param", (Object)param);
                this.sendAttendanceExceptionMsg(dingMsgBean, logInfo);
                this.pushAttendanceExceptionData(syncAttendanceDataBeans, logInfo);
            }
            catch (Exception e) {
                String message = e.getMessage();
                logger.error((Object)("\u63d0\u9192\u4e2d\u5fc3\u8d1f\u8d23\u4eba\u7d2f\u8ba1\u5f02\u5e38\u62a5\u9519 " + message), (Throwable)e);
                if (message.contains("connect timed out")) {
                    iAttendanceExceptionLog.save((CoreBaseInfo)logInfo);
                    break;
                }
                logInfo.setPushStatus(CallStatusEnum.failure);
                logInfo.setPushResult(message);
            }
            iAttendanceExceptionLog.save((CoreBaseInfo)logInfo);
        }
        if (logger.isInfoEnabled()) {
            long endTime = System.currentTimeMillis();
            float duration = (float)(endTime - startTime) / 1000.0f;
            logger.info((Object)String.format("AttendanceExceptionFacadeControllerBean.alertLeaderExceptionTotal end, duration: %fS", Float.valueOf(duration)));
        }
    }

    protected Map<String, List<SyncAttendanceDataBean>> getAttendanceExceptionData(Context ctx, java.util.Date startDate, java.util.Date endDate, PushTypeEnum pushType, int limit) throws BOSException {
        String sql = this.getSql(startDate, endDate, pushType);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            IRowSet iRowSet = DBUtil.executeQuery((Context)ctx, (String)sql);
            HashMap<String, List<SyncAttendanceDataBean>> result = new HashMap<String, List<SyncAttendanceDataBean>>();
            HashMap<String, Integer> personExceptionTimes = new HashMap<String, Integer>();
            while (iRowSet.next()) {
                SyncAttendanceDataBean data = this.setAttendanceResult(iRowSet, sdf, pushType);
                int times = data.getTimes();
                String personNumber = data.getEmployeeId();
                if (personExceptionTimes.containsKey(personNumber)) {
                    Integer i = (Integer)personExceptionTimes.get(personNumber);
                    personExceptionTimes.put(personNumber, i + times);
                } else {
                    personExceptionTimes.put(personNumber, times);
                }
                if (!result.containsKey(personNumber)) {
                    result.put(personNumber, new ArrayList());
                }
                ((List)result.get(personNumber)).add(data);
            }
            if (PushTypeEnum.EMPLOYEEEXCEPTIONALERT.equals((Object)pushType)) {
                String yearMonth = DateTimeUtils.format((java.util.Date)startDate, (String)"yyyy\u5e74MM\u6708");
                Set<String> remindRecord = this.getRemindRecord(ctx, yearMonth);
                for (Map.Entry entry : personExceptionTimes.entrySet()) {
                    if ((Integer)entry.getValue() >= limit && !remindRecord.contains(entry.getKey())) continue;
                    result.remove(entry.getKey());
                }
            }
            return result;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected List<Map<String, Object>> getAttendanceExceptionDataForLeader(Context ctx, java.util.Date startDate, java.util.Date endDate, PushTypeEnum pushType) throws BOSException {
        String sql = this.getSql(startDate, endDate, pushType);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<Map<String, Object>> attendanceExceptionDatas = new ArrayList<Map<String, Object>>();
        try {
            IRowSet iRowSet = DBUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                SyncAttendanceDataBean data = this.setAttendanceResult(iRowSet, sdf, pushType);
                LinkedHashMap<String, Boolean> attendanceFlags = new LinkedHashMap<String, Boolean>();
                attendanceFlags.put("lateEmployees", iRowSet.getInt("s19") > 0);
                attendanceFlags.put("earlyLeaveEmployees", iRowSet.getInt("s21") > 0);
                attendanceFlags.put("absentEmployees", iRowSet.getBigDecimal("s23").compareTo(BigDecimal.ZERO) > 0);
                map.put("data", data);
                map.put("attendanceFlags", attendanceFlags);
                attendanceExceptionDatas.add(map);
            }
            return attendanceExceptionDatas;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected SyncAttendanceDataBean setAttendanceResult(IRowSet iRowSet, SimpleDateFormat sdf, PushTypeEnum pushType) throws SQLException {
        SyncAttendanceDataBean data = new SyncAttendanceDataBean();
        data.setEmployeeId(iRowSet.getString("personNumber"));
        data.setEmployeeName(iRowSet.getString("personName"));
        Date attenceDate = iRowSet.getDate("attenceDate");
        if (attenceDate != null) {
            data.setExceptionDate(sdf.format(attenceDate));
        }
        data.setDepartmentCode(iRowSet.getString("adminOrgNumber"));
        data.setDepartmentName(iRowSet.getString("adminOrgName"));
        data.setDepartmentManagerCode(iRowSet.getString("adminOrgLongNumber"));
        data.setDepartmentSortCode(iRowSet.getString("sortCode"));
        String displayName = iRowSet.getString("displayName");
        if (StringUtils.isNotBlank((CharSequence)displayName)) {
            displayName = displayName.substring(displayName.indexOf("_") + 1, displayName.length());
        }
        data.setDepartmentManagerName(displayName);
        StringBuilder attendanceResult = new StringBuilder();
        int times = 0;
        LinkedHashMap<String, Boolean> attendanceFlags = new LinkedHashMap<String, Boolean>();
        int s19 = iRowSet.getInt("s19");
        int s21 = iRowSet.getInt("s21");
        BigDecimal s23 = iRowSet.getBigDecimal("s23");
        attendanceFlags.put("\u8fdf\u5230", s19 > 0);
        attendanceFlags.put("\u65e9\u9000", s21 > 0);
        attendanceFlags.put("\u65f7\u5de5", s23.compareTo(BigDecimal.ZERO) > 0);
        if (PushTypeEnum.EMPLOYEEEXCEPTIONALERT.equals((Object)pushType)) {
            int s113 = iRowSet.getInt("s113");
            attendanceFlags.put("\u4e2a\u4eba\u539f\u56e0\u8865\u5361\u6b21\u6570", s113 > 0);
        }
        for (Map.Entry entry : attendanceFlags.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            ++times;
            attendanceResult.append((String)entry.getKey()).append("\u3001");
        }
        if (attendanceResult.length() > 0) {
            attendanceResult.setLength(attendanceResult.length() - 1);
        }
        data.setTimes(times);
        data.setAttendanceResult(attendanceResult.toString());
        return data;
    }

    protected String getSql(java.util.Date startDate, java.util.Date endDate, PushTypeEnum pushType) throws BOSException {
        if (startDate == null || endDate == null) {
            logger.error((Object)"getAttendanceExceptionData startDate or endDate is null");
            throw new BOSException("getAttendanceExceptionData startDate or endDate is null");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        StringBuilder sql = new StringBuilder().append("select").append("\n").append("    person.fid as personId,").append("\n").append("    person.fnumber as personNumber,").append("\n").append("    person.Fname_l2 as personName,").append("\n").append("    attendanceResult.FAttenceDate as attenceDate,").append("\n").append("    attendanceResult.s19 as s19,").append("\n").append("    attendanceResult.s21 as s21,").append("\n").append("    attendanceResult.s23 as s23,").append("\n").append("    attendanceResult.s113 as s113,").append("\n").append("    adminOrg.fid as adminOrgId,").append("\n").append("    adminOrg.fnumber as adminOrgNumber,").append("\n").append("    adminOrg.fname_l2 as adminOrgName,").append("\n").append("    adminOrg.FLongNumber as adminOrgLongNumber,").append("\n").append("    adminOrg.FSortCode as sortCode,").append("\n").append("    adminOrg.FDisplayName_L2 as displayName").append("\n").append("from").append("\n").append("    T_HR_ATS_AttendanceResult attendanceResult").append("\n").append("    left join t_bd_person person on person.fid = attendanceResult.FProposerID").append("\n").append("    left join T_ORG_admin adminOrg on attendanceResult.FAdminOrgUnitID = adminOrg.fid").append("\n").append("where").append("\n").append("    attendanceResult.FAttenceDate >= { TS '").append(sdf.format(startDate)).append("' }").append("\n").append("    and attendanceResult.FAttenceDate <= { TS '").append(sdf.format(endDate)).append("' }").append("\n").append("    and (").append("\n").append("        attendanceResult.s19 > 0").append("\n").append("        or attendanceResult.s21 > 0").append("\n").append("        or attendanceResult.s23 > 0").append("\n");
        if (PushTypeEnum.EMPLOYEEEXCEPTIONALERT.equals((Object)pushType)) {
            sql.append("         or attendanceResult.S113 > 0").append("\n");
        }
        sql.append("    );").append("\n");
        if (logger.isInfoEnabled()) {
            logger.info((Object)String.format("AttendanceExceptionFacadeControllerBean.getSql: %s", sql.toString()));
        }
        return sql.toString();
    }

    protected void sendAttendanceExceptionMsg(JSONObject dingMsgBean, AttendanceExceptionLogInfo logInfo) throws BOSException {
        try {
            String url = this.propt.getProperty("sendDingMsgUrl");
            if (url == null || url.isEmpty()) {
                logger.error((Object)"pushAttendanceExceptionData url is null");
                throw new BOSException("pushAttendanceExceptionData url is null");
            }
            logger.error((Object)("pushAttendanceExceptionData url: " + url));
            if (dingMsgBean == null) {
                logger.error((Object)"pushAttendanceExceptionData dingMsgBean is null");
                throw new BOSException("pushAttendanceExceptionData dingMsgBean is null");
            }
            String params = dingMsgBean.toJSONString();
            logInfo.setMessageRequest(params);
            OkHttpClient client = new OkHttpClient();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)params);
            Request request = new Request.Builder().url(url).post(body).addHeader("Accept", "*/*").addHeader("Accept-Encoding", "gzip, deflate, br").addHeader("User-Agent", "PostmanRuntime-ApipostRuntime/1.1.0").addHeader("Connection", "keep-alive").addHeader("Content-Type", "application/json").build();
            Response response = client.newCall(request).execute();
            logger.error((Object)("response----" + response.isSuccessful()));
            if (response.isSuccessful()) {
                String resultBody = response.body().string();
                logInfo.setMessageResponse(resultBody);
                logger.error((Object)("resultBody----" + resultBody));
                JSONObject result = JSONObject.parseObject((String)resultBody);
                if (!result.getBoolean("success").booleanValue()) {
                    throw new BOSException(result.getString("msg"));
                }
            } else {
                throw new BOSException("\u63a5\u53e3\u8bf7\u6c42\u8d85\u65f6");
            }
            logInfo.setPushStatus(CallStatusEnum.success);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("\u53d1\u9001\u8003\u52e4\u5f02\u5e38\u6d88\u606f\u62a5\u9519: " + e.getMessage());
        }
    }

    protected void pushAttendanceExceptionData(List list, AttendanceExceptionLogInfo logInfo) throws BOSException {
        try {
            String url = this.propt.getProperty("syncAttendanceDataUrl");
            if (url == null || url.isEmpty()) {
                logger.error((Object)"pushAttendanceExceptionData url is null");
                throw new BOSException("pushAttendanceExceptionData url is null");
            }
            logger.error((Object)("pushAttendanceExceptionData url: " + url));
            if (list == null || list.size() <= 0) {
                logger.error((Object)"pushAttendanceExceptionData list is null");
                throw new BOSException("pushAttendanceExceptionData list is null");
            }
            String params = JSON.toJSONString((Object)list);
            logInfo.setDataPushRequest(params);
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(120L, TimeUnit.SECONDS).writeTimeout(120L, TimeUnit.SECONDS).readTimeout(120L, TimeUnit.SECONDS).build();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)params);
            Request request = new Request.Builder().url(url).post(body).addHeader("Accept", "*/*").addHeader("Accept-Encoding", "gzip, deflate, br").addHeader("User-Agent", "PostmanRuntime-ApipostRuntime/1.1.0").addHeader("Connection", "keep-alive").addHeader("Content-Type", "application/json").build();
            Response response = client.newCall(request).execute();
            logger.error((Object)("pushAttendanceExceptionData response----" + response.isSuccessful()));
            if (response.isSuccessful()) {
                String resultBody = response.body().string();
                logInfo.setDataPushResponse(resultBody);
                logger.error((Object)("resultBody----" + resultBody));
                JSONObject result = JSONObject.parseObject((String)resultBody);
                if (!result.getBoolean("success").booleanValue()) {
                    throw new BOSException(result.getString("msg"));
                }
            } else {
                throw new BOSException("\u63a5\u53e3\u8bf7\u6c42\u8d85\u65f6");
            }
            logInfo.setPushStatus(CallStatusEnum.success);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("\u63a8\u9001\u8003\u52e4\u6570\u636e\u62a5\u9519: " + e.getMessage());
        }
    }

    public String convertSetToString(Set set) {
        if (set != null && set.size() > 0) {
            Iterator iter = set.iterator();
            StringBuffer sql = new StringBuffer();
            while (iter.hasNext()) {
                sql.append(iter.next()).append(",");
            }
            sql.deleteCharAt(sql.length() - 1);
            return sql.toString();
        }
        return "";
    }

    public int getAttendanceCount(Context ctx, String orgLongNumber) {
        try {
            IAttendanceFile iAttendanceFile = AttendanceFileFactory.getLocalInstance((Context)ctx);
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filterItems = filterInfo.getFilterItems();
            filterItems.add(new FilterItemInfo("attendFileState", (Object)"1"));
            filterItems.add(new FilterItemInfo("isAttendance", (Object)"1"));
            filterItems.add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(orgLongNumber + "%"), CompareType.LIKE));
            EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, null, null);
            AttendanceFileCollection attendanceFileCol = iAttendanceFile.getAttendanceFileCollection(viewInfo);
            return attendanceFileCol.size();
        }
        catch (BOSException e) {
            logger.error((Object)("\u83b7\u53d6" + orgLongNumber + "\u8003\u52e4\u603b\u4eba\u6570\u62a5\u9519: " + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public AdminOrgUnitInfo getOrgInfo(Context ctx, String orgLongNumber) throws BOSException {
        AdminOrgUnitCollection adminOrgUnitCollection = null;
        try {
            IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filterItems = filterInfo.getFilterItems();
            filterItems.add(new FilterItemInfo("unitLayerType", (Object)"00000000-0000-0000-0000-00000000000362824988"));
            filterItems.add(new FilterItemInfo("longNumber", (Object)"0"));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            sic.add("name");
            adminOrgUnitCollection = iAdminOrgUnit.getAdminOrgUnitCollection("where longNumber = '" + orgLongNumber + "'");
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u7ec4\u7ec7\u62a5\u9519: " + e.getMessage()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (adminOrgUnitCollection == null || adminOrgUnitCollection.size() == 0) {
            throw new BOSException("\u672a\u627e\u5230\u957f\u7f16\u7801\u4e3a[" + orgLongNumber + "]\u7684\u7ec4\u7ec7");
        }
        return adminOrgUnitCollection.get(0);
    }

    private Set<String> getRemindRecord(Context ctx, String yearMonth) {
        HashSet<String> remindRecordSet = new HashSet<String>();
        try {
            String querySql = "select personNumber from T_Remind_Record where yearMonth=?";
            IRowSet iRowSet = DBUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{yearMonth});
            while (iRowSet.next()) {
                remindRecordSet.add(iRowSet.getString("personNumber"));
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u83b7\u53d6\u63d0\u9192\u8bb0\u5f55\u62a5\u9519: " + e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
        return remindRecordSet;
    }

    private void addRemindRecord(Context ctx, String yearMonth, String personNumber) {
        try {
            String querySql = "insert into T_Remind_Record(yearMonth,personNumber) values (?,?)";
            DBUtil.execute((Context)ctx, (String)querySql, (Object[])new Object[]{yearMonth, personNumber});
        }
        catch (Exception e) {
            logger.error((Object)("\u65b0\u589e\u63d0\u9192\u8bb0\u5f55\u62a5\u9519: " + e.getMessage()), (Throwable)e);
            throw new RuntimeException("\u65b0\u589e\u63d0\u9192\u8bb0\u5f55\u62a5\u9519: " + e.getMessage());
        }
    }
}

