/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.sso;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.cp.eip.sso.util.CASLoginConfigPropUtil;
import com.kingdee.eas.cp.eip.sso.util.CloudParamUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.log4j.Logger;

public class OAToSHR
extends HttpServlet {
    private static Logger logger = Logger.getLogger(OAToSHR.class);
    private Properties prop = new Properties();
    private String propPath = System.getProperty("EAS_HOME") + "/server/properties/scy/OASSOConfig.properties";
    private final String SECRETKEY = "jOK7MpIonY+/56ulnl6RGQ==";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.error((Object)"OAToSHR -> doGet");
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.error((Object)"OAToSHR -> doPost");
        BufferedReader streamReader = null;
        String resultStr = null;
        this.prop.load(new FileInputStream(this.propPath));
        logger.error((Object)("OAToSHR  requestUrl" + req.getRequestURL().toString()));
        try {
            String ticket = req.getParameter("ticket");
            logger.error((Object)("\u63a5\u6536\u5230\u7684\u8bf7\u6c42\u53c2\u6570\u662f\uff1aticket " + ticket));
            if (StringUtils.isEmpty((String)ticket)) {
                this.authorize(req, resp);
            } else {
                this.callBack(req, resp, ticket);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("msgType", "0");
            result.put("reason", e.getMessage());
            resultStr = JSON.toJSONString(result);
            resp.setStatus(500);
            PrintWriter writer = resp.getWriter();
            resp.setContentType("application/json");
            writer.write(resultStr);
            writer.close();
        }
        finally {
            try {
                if (streamReader != null) {
                    streamReader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void authorize(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String authorizePath = this.prop.getProperty("authorizePath");
        if (StringUtils.isEmpty((String)authorizePath)) {
            throw new RuntimeException("authorizePath\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String response_type = this.prop.getProperty("response_type");
        if (StringUtils.isEmpty((String)response_type)) {
            throw new RuntimeException("response_type\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String client_id = this.prop.getProperty("client_id");
        if (StringUtils.isEmpty((String)client_id)) {
            throw new RuntimeException("client_id\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String redirect_uri1 = this.prop.getProperty("redirect_uri1");
        if (StringUtils.isEmpty((String)redirect_uri1)) {
            throw new RuntimeException("redirect_uri1\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String redirectUrl = req.getParameter("redirect");
        logger.error((Object)("callBack redirectUrl" + redirectUrl));
        String encrypt = OAToSHR.encrypt(redirectUrl, "jOK7MpIonY+/56ulnl6RGQ==");
        logger.error((Object)("callBack encrypt" + encrypt));
        redirect_uri1 = redirect_uri1 + "?redirect=" + URLEncoder.encode(encrypt, "UTF-8");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", client_id);
        params.put("response_type", response_type);
        params.put("redirect_uri", URLEncoder.encode(redirect_uri1, "UTF-8"));
        String urlString = OAToSHR.appendUrl(authorizePath, params);
        resp.sendRedirect(urlString);
        logger.error((Object)("authorize url" + urlString));
    }

    public void callBack(HttpServletRequest req, HttpServletResponse resp, String ticket) throws SHRWebException, UnsupportedEncodingException {
        logger.error((Object)"callback\u65b9\u6cd5\u5165\u53c2");
        if (StringUtils.isEmpty((String)ticket)) {
            throw new RuntimeException("ticket\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String getAccessTokenPath = this.prop.getProperty("getAccessTokenPath");
        if (StringUtils.isEmpty((String)getAccessTokenPath)) {
            throw new RuntimeException("getAccessTokenPath\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String client_secret = this.prop.getProperty("client_secret");
        if (StringUtils.isEmpty((String)client_secret)) {
            throw new RuntimeException("client_secret\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String client_id = this.prop.getProperty("client_id");
        if (StringUtils.isEmpty((String)client_id)) {
            throw new RuntimeException("client_id\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String redirect_uri2 = this.prop.getProperty("redirect_uri2");
        if (StringUtils.isEmpty((String)redirect_uri2)) {
            throw new RuntimeException("redirect_uri2\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String getLoginIdPath = this.prop.getProperty("getLoginIdPath");
        if (StringUtils.isEmpty((String)getLoginIdPath)) {
            throw new RuntimeException("getLoginIdPath\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String redirectUrl = req.getParameter("redirect");
        logger.error((Object)("callBack redirectUrl" + redirectUrl));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", client_id);
        params.put("client_secret", client_secret);
        params.put("grant_type", "authorization_code");
        params.put("code", ticket);
        params.put("redirect_uri", URLEncoder.encode(redirect_uri2, "UTF-8"));
        try {
            String token = this.getAccessToken(getAccessTokenPath, params);
            logger.error((Object)token);
            String loginId = this.loginId2userId(getLoginIdPath, token);
            String loginUrl = this.login(loginId, redirectUrl);
            resp.sendRedirect(loginUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private String login(String userNumber, String redirectUrl) throws Exception {
        String password = LtpaTokenManager.generate((String)userNumber, (String)LtpaTokenManager.getDefaultLtpaConfig()).toString();
        logger.error((Object)("login: password" + password));
        String serverName = this.prop.getProperty("serverName");
        if (StringUtils.isEmpty((String)serverName)) {
            throw new RuntimeException("serverName\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        StringBuilder url = new StringBuilder();
        url.append("/shr/index2sso.jsp?username=").append(userNumber).append("&password=").append(password).append("&redirectTo=");
        StringBuilder redirectUrlStr = new StringBuilder();
        if (StringUtils.isEmpty((String)redirectUrl)) {
            redirectUrlStr.append(serverName).append("/shr/dynamic.do?uipk=shr.perself.homepage");
        } else {
            String decrpt = OAToSHR.decrypt(redirectUrl, "jOK7MpIonY+/56ulnl6RGQ==");
            if (decrpt.contains(serverName)) {
                redirectUrlStr.append(decrpt);
            } else {
                redirectUrlStr.append(serverName).append(decrpt);
            }
        }
        url.append(URLEncoder.encode(redirectUrlStr.toString(), "UTF-8"));
        logger.error((Object)("login: url" + url));
        return url.toString();
    }

    private String getAccessToken(String getAccessTokenPath, Map<String, String> params) throws IOException {
        logger.error((Object)("getAccessToken\u65b9\u6cd5\u53c2\u6570: " + params));
        String url = OAToSHR.appendUrl(getAccessTokenPath, params);
        logger.error((Object)("access_token url" + url));
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(url).get().addHeader("content-type", "multipart/form-data; boundary=---011000010111000001101001").build();
        Response response = client.newCall(request).execute();
        if (response.isSuccessful()) {
            String string = response.body().string();
            JSONObject jsonObject = JSONObject.parseObject((String)string);
            String code = jsonObject.getString("code");
            if ("0".equals(code)) {
                String access_token = jsonObject.getString("access_token");
                logger.error((Object)("access_token " + access_token));
                return access_token;
            }
            throw new RuntimeException(jsonObject.getString("msg"));
        }
        throw new RuntimeException("\u83b7\u53d6token\u8d85\u65f6");
    }

    private String loginId2userId(String getLoginIdPath, String accessToken) throws IOException, BOSException, SQLException {
        if (StringUtils.isEmpty((String)accessToken)) {
            throw new RuntimeException("accessToken\u4e0d\u80fd\u4e3a\u7a7a! ");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        String url = OAToSHR.appendUrl(getLoginIdPath, params);
        logger.error((Object)("loginId2userId url" + url));
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(url).get().addHeader("content-type", "multipart/form-data; boundary=---011000010111000001101001").build();
        Response response = client.newCall(request).execute();
        if (response.isSuccessful()) {
            String string = response.body().string();
            JSONObject jsonObject = JSONObject.parseObject((String)string);
            String code = jsonObject.getString("code");
            if ("0".equals(code)) {
                JSONObject attributes = jsonObject.getJSONObject("attributes");
                String loginid = attributes.getString("loginid");
                String dataCenter = CASLoginConfigPropUtil.getDataCenter();
                String locale = CASLoginConfigPropUtil.getLocale();
                if (!StringUtils.isEmpty((String)dataCenter) && !StringUtils.isEmpty((String)locale)) {
                    Context ctx = CloudParamUtil.getContext((String)dataCenter, (String)locale, (String)"administrator");
                    String sql = "SELECT count(1) total FROM T_PM_USER WHERE fnumber=?";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{loginid});
                    int total = 0;
                    if (rs.next()) {
                        total = rs.getInt("total");
                    }
                    if (total <= 0) {
                        logger.error((Object)("SHR\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7528\u6237, loginid:" + loginid));
                        throw new RuntimeException("SHR\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7528\u6237, loginid: " + loginid);
                    }
                    if (total > 1) {
                        logger.error((Object)("SHR\u627e\u5230\u591a\u4e2a\u5bf9\u5e94\u7684\u7528\u6237, loginid:" + loginid));
                        throw new RuntimeException("SHR\u627e\u5230\u591a\u4e2a\u5bf9\u5e94\u7684\u7528\u6237, loginid: " + loginid);
                    }
                    return loginid;
                }
                logger.error((Object)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u62a5\u9519,\u6570\u636e\u4e2d\u5fc3\u6ca1\u627e\u5230!");
                throw new RuntimeException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u62a5\u9519,\u6570\u636e\u4e2d\u5fc3\u6ca1\u627e\u5230!");
            }
            logger.error((Object)jsonObject.getString("msg"));
            throw new RuntimeException(jsonObject.getString("msg"));
        }
        logger.error((Object)"\u7f51\u7edc\u8d85\u65f6");
        throw new RuntimeException("\u7f51\u7edc\u8d85\u65f6");
    }

    private static String appendUrl(String url, Map<String, String> data) {
        logger.error((Object)("appendUrl_url: " + url));
        logger.error((Object)("appendUrl_data: " + data));
        StringBuilder paramStr = new StringBuilder();
        for (String key : data.keySet()) {
            paramStr.append(key).append("=").append(data.get(key)).append("&");
        }
        paramStr.deleteCharAt(paramStr.lastIndexOf("&"));
        String str = url.contains("?") ? url + "&" + paramStr : url + "?" + paramStr;
        logger.error((Object)("\u62fc\u63a5\u540e\u7684\u5730\u5740\u4e3a:" + str));
        return str;
    }

    public static String encrypt(String plainText, String encodedKey) throws Exception {
        byte[] decodedKey = Base64.getDecoder().decode(encodedKey);
        SecretKeySpec secretKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, secretKey);
        byte[] encryptedBytes = cipher.doFinal(plainText.getBytes("UTF-8"));
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    public static String decrypt(String encryptedText, String encodedKey) throws Exception {
        byte[] decodedKey = Base64.getDecoder().decode(encodedKey);
        SecretKeySpec secretKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, secretKey);
        byte[] decodedBytes = Base64.getDecoder().decode(encryptedText);
        byte[] decryptedBytes = cipher.doFinal(decodedBytes);
        return new String(decryptedBytes, "UTF-8");
    }
}

