/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.sso;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.cp.eip.sso.util.CASLoginConfigPropUtil;
import com.kingdee.eas.cp.eip.sso.util.CloudParamUtil;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.log4j.Logger;

public class SsoUtil {
    private static Logger logger = Logger.getLogger(SsoUtil.class);

    public static String checkFlowEffectiveStateForPc(String redirect, String serverName) throws BOSException, SQLException {
        if (StringUtils.isEmpty((String)redirect)) {
            throw new RuntimeException("\u91cd\u5b9a\u5411\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)serverName)) {
            throw new RuntimeException("serverName\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        int index = redirect.indexOf("?");
        HashMap<String, String> params = new HashMap<String, String>();
        if (index > 0) {
            String redirectParams = redirect.substring(index + 1);
            String[] arrary = redirectParams.split("&");
            for (int i = 0; i < arrary.length; ++i) {
                String[] split = arrary[i].split("=");
                params.put(split[0], split[1]);
            }
        } else {
            return redirect;
        }
        String assignmentId = (String)params.get("AssignmentId");
        if (StringUtils.isEmpty((String)assignmentId)) {
            assignmentId = (String)params.get("assignId");
        }
        if (StringUtils.isEmpty((String)assignmentId)) {
            return redirect;
        }
        String dataCenter = CASLoginConfigPropUtil.getDataCenter();
        String locale = CASLoginConfigPropUtil.getLocale();
        if (!StringUtils.isEmpty((String)dataCenter) && !StringUtils.isEmpty((String)locale)) {
            Context ctx = CloudParamUtil.getContext((String)dataCenter, (String)locale, (String)"administrator");
            String sql = "SELECT count(1) total FROM T_WFR_Assign WHERE FASSIGNID = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{assignmentId});
            int total = 0;
            while (rs.next()) {
                total = rs.getInt("total");
            }
            if (total <= 0) {
                return serverName + "/shr/flowErrorPage.jsp";
            }
            return redirect;
        }
        logger.error((Object)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u62a5\u9519,\u6570\u636e\u4e2d\u5fc3\u6ca1\u627e\u5230!");
        throw new RuntimeException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u62a5\u9519,\u6570\u636e\u4e2d\u5fc3\u6ca1\u627e\u5230!");
    }

    public static String checkFlowEffectiveStateForMbos(String redirect, String serverName, String getLoginIdPath, String token) throws SQLException, BOSException, IOException {
        if (StringUtils.isEmpty((String)getLoginIdPath)) {
            throw new RuntimeException("getLoginIdPath\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)serverName)) {
            throw new RuntimeException("serverName\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)token)) {
            throw new RuntimeException("token\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if ((redirect = SsoUtil.checkFlowEffectiveStateForPc(redirect, serverName)).contains("/shr/flowErrorPage.jsp")) {
            String userNumber = SsoUtil.loginId2userId(getLoginIdPath, token);
            String password = LtpaTokenManager.generate((String)userNumber, (String)LtpaTokenManager.getDefaultLtpaConfig()).toString();
            logger.error((Object)("login: password" + password));
            StringBuilder url = new StringBuilder();
            url.append(serverName).append("/shr/index2sso.jsp?username=").append(userNumber).append("&password=").append(password).append("&redirectTo=");
            String encode = URLEncoder.encode(redirect, "UTF-8");
            url.append(URLEncoder.encode(encode, "UTF-8"));
            return url.toString();
        }
        return redirect;
    }

    public static String checkBillExistForPc(String redirect, String serverName) throws BOSException, SQLException, EASBizException, UnsupportedEncodingException {
        if (StringUtils.isEmpty((String)redirect)) {
            throw new RuntimeException("\u91cd\u5b9a\u5411\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)serverName)) {
            throw new RuntimeException("serverName\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        int index = redirect.indexOf("?");
        HashMap<String, String> params = new HashMap<String, String>();
        if (index > 0) {
            String redirectParams = redirect.substring(index + 1);
            String[] arrary = redirectParams.split("&");
            for (int i = 0; i < arrary.length; ++i) {
                String[] split = arrary[i].split("=");
                if (split.length <= 1) continue;
                params.put(split[0], split[1]);
            }
        } else {
            return redirect;
        }
        String assignmentId = (String)params.get("AssignmentId");
        if (StringUtils.isEmpty((String)assignmentId)) {
            assignmentId = (String)params.get("assignId");
        }
        if (StringUtils.isEmpty((String)assignmentId)) {
            assignmentId = (String)params.get("assignmentId");
        }
        String billID = (String)params.get("billID");
        if (StringUtils.isEmpty((String)assignmentId) || StringUtils.isEmpty((String)billID)) {
            return redirect;
        }
        String dataCenter = CASLoginConfigPropUtil.getDataCenter();
        String locale = CASLoginConfigPropUtil.getLocale();
        if (!StringUtils.isEmpty((String)dataCenter) && !StringUtils.isEmpty((String)locale)) {
            String bosType;
            Context ctx = CloudParamUtil.getContext((String)dataCenter, (String)locale, (String)"administrator");
            ICoreBillBase bosObject = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType(bosType = BOSUuid.read((String)(billID = URLDecoder.decode(billID, "UTF-8"))).getType().toString()));
            if (bosObject.exists((IObjectPK)new ObjectUuidPK(billID))) {
                return redirect;
            }
            return serverName + "/shr/flowErrorPage.jsp";
        }
        logger.error((Object)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u62a5\u9519,\u6570\u636e\u4e2d\u5fc3\u6ca1\u627e\u5230!");
        throw new RuntimeException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u62a5\u9519,\u6570\u636e\u4e2d\u5fc3\u6ca1\u627e\u5230!");
    }

    public static String checkBillExistForMbos(String redirect, String serverName, String getLoginIdPath, String token) throws BOSException, SQLException, EASBizException, IOException {
        if (StringUtils.isEmpty((String)getLoginIdPath)) {
            throw new RuntimeException("getLoginIdPath\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)serverName)) {
            throw new RuntimeException("serverName\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)token)) {
            throw new RuntimeException("token\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if ((redirect = SsoUtil.checkBillExistForPc(redirect, serverName)).contains("/shr/flowErrorPage.jsp")) {
            String userNumber = SsoUtil.loginId2userId(getLoginIdPath, token);
            String password = LtpaTokenManager.generate((String)userNumber, (String)LtpaTokenManager.getDefaultLtpaConfig()).toString();
            logger.error((Object)("login: password" + password));
            StringBuilder url = new StringBuilder();
            url.append(serverName).append("/shr/index2sso.jsp?username=").append(userNumber).append("&password=").append(password).append("&redirectTo=");
            String encode = URLEncoder.encode(redirect, "UTF-8");
            url.append(URLEncoder.encode(encode, "UTF-8"));
            return url.toString();
        }
        return redirect;
    }

    public static String loginId2userId(String getLoginIdPath, String accessToken) throws IOException, BOSException, SQLException {
        if (StringUtils.isEmpty((String)accessToken)) {
            throw new RuntimeException("accessToken\u4e0d\u80fd\u4e3a\u7a7a! ");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        String url = SsoUtil.appendUrl(getLoginIdPath, params);
        logger.error((Object)("loginId2userId url" + url));
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(url).get().addHeader("content-type", "multipart/form-data; boundary=---011000010111000001101001").build();
        Response response = client.newCall(request).execute();
        if (response.isSuccessful()) {
            String string = response.body().string();
            JSONObject jsonObject = JSONObject.parseObject((String)string);
            String code = jsonObject.getString("code");
            if ("0".equals(code)) {
                JSONObject attributes = jsonObject.getJSONObject("attributes");
                String loginid = attributes.getString("loginid");
                String dataCenter = CASLoginConfigPropUtil.getDataCenter();
                String locale = CASLoginConfigPropUtil.getLocale();
                if (!StringUtils.isEmpty((String)dataCenter) && !StringUtils.isEmpty((String)locale)) {
                    Context ctx = CloudParamUtil.getContext((String)dataCenter, (String)locale, (String)"administrator");
                    String sql = "SELECT count(1) total FROM T_PM_USER WHERE fnumber=?";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{loginid});
                    int total = 0;
                    if (rs.next()) {
                        total = rs.getInt("total");
                    }
                    if (total <= 0) {
                        logger.error((Object)("SHR\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7528\u6237, loginid:" + loginid));
                        throw new RuntimeException("SHR\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u7528\u6237, loginid: " + loginid);
                    }
                    if (total > 1) {
                        logger.error((Object)("SHR\u627e\u5230\u591a\u4e2a\u5bf9\u5e94\u7684\u7528\u6237, loginid:" + loginid));
                        throw new RuntimeException("SHR\u627e\u5230\u591a\u4e2a\u5bf9\u5e94\u7684\u7528\u6237, loginid: " + loginid);
                    }
                    return loginid;
                }
                logger.error((Object)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u62a5\u9519,\u6570\u636e\u4e2d\u5fc3\u6ca1\u627e\u5230!");
                throw new RuntimeException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u62a5\u9519,\u6570\u636e\u4e2d\u5fc3\u6ca1\u627e\u5230!");
            }
            logger.error((Object)jsonObject.getString("msg"));
            throw new RuntimeException(jsonObject.getString("msg"));
        }
        logger.error((Object)"\u7f51\u7edc\u8d85\u65f6");
        throw new RuntimeException("\u7f51\u7edc\u8d85\u65f6");
    }

    public static String getAccessToken(String getAccessTokenPath, Map<String, String> params) throws IOException {
        logger.error((Object)("getAccessToken\u65b9\u6cd5\u53c2\u6570: " + params));
        String url = SsoUtil.appendUrl(getAccessTokenPath, params);
        logger.error((Object)("access_token url" + url));
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(url).get().addHeader("content-type", "multipart/form-data; boundary=---011000010111000001101001").build();
        Response response = client.newCall(request).execute();
        if (response.isSuccessful()) {
            String string = response.body().string();
            JSONObject jsonObject = JSONObject.parseObject((String)string);
            String code = jsonObject.getString("code");
            if ("0".equals(code)) {
                String access_token = jsonObject.getString("access_token");
                logger.error((Object)("access_token " + access_token));
                return access_token;
            }
            throw new RuntimeException(jsonObject.getString("msg"));
        }
        throw new RuntimeException("\u83b7\u53d6token\u8d85\u65f6");
    }

    public static String appendUrl(String url, Map<String, String> data) {
        logger.error((Object)("appendUrl_url: " + url));
        logger.error((Object)("appendUrl_data: " + data));
        StringBuilder paramStr = new StringBuilder();
        for (String key : data.keySet()) {
            paramStr.append(key).append("=").append(data.get(key)).append("&");
        }
        paramStr.deleteCharAt(paramStr.lastIndexOf("&"));
        String str = url.contains("?") ? url + "&" + paramStr : url + "?" + paramStr;
        logger.error((Object)("\u62fc\u63a5\u540e\u7684\u5730\u5740\u4e3a:" + str));
        return str;
    }
}

