/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.synctask.handler;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.custom.sso.ExpiringMapCache;
import com.kingdee.eas.custom.synctask.SyncTranForMJFacadeFactory;
import com.kingdee.eas.custom.synctask.handler.EncryptUtils;
import com.kingdee.eas.custom.synctask.utils.HRTimeWebUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AttendanceFileFactory;
import com.kingdee.eas.hr.ats.AttendanceFileInfo;
import com.kingdee.eas.hr.ats.PunchCardRecordCollection;
import com.kingdee.eas.hr.ats.PunchCardRecordFactory;
import com.kingdee.eas.hr.ats.PunchCardRecordInfo;
import com.kingdee.eas.hr.ats.PunchCardSourceEnum;
import com.kingdee.eas.hr.ats.PunchCardStateEnum;
import com.kingdee.shr.ats.web.handler.PunchCardRecordListHandler;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.util.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;

public class PunchCardRecordListHandlerEx
extends PunchCardRecordListHandler {
    Logger logger = Logger.getLogger(PunchCardRecordListHandlerEx.class);
    private Context ctx = SHRContext.getInstance().getContext();
    private Properties propt = new Properties();
    private static ExpiringMapCache<String, String> cache = new ExpiringMapCache();
    private long durationInMillis = 84600000L;

    public PunchCardRecordListHandlerEx() throws BOSException {
        String syncOAConfigPath = System.getProperty("EAS_HOME") + "/server/properties/scy/syncMJConfig.properties";
        try {
            this.propt.load(new FileInputStream(syncOAConfigPath));
        }
        catch (IOException e) {
            e.printStackTrace();
            String errorMsg = "\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u62a5\u9519\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\uff1a" + syncOAConfigPath + "   " + e.getMessage();
            throw new BOSException(errorMsg);
        }
    }

    public void syncZKPunchCardDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException {
        SyncTranForMJFacadeFactory.getLocalInstance((Context)this.ctx).syncPunchRecordFromMJ(null, null);
    }

    public void syncPunchRecordFromMJAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, ShrWebBizException {
        SyncTranForMJFacadeFactory.getLocalInstance((Context)this.ctx).syncAccessRecord("", "");
    }

    protected void _syncAccessRecord(Context ctx, String startDate, String endDate) throws ShrWebBizException {
        this.logger.error((Object)"_syncAccessRecord------");
        Properties properties = new Properties();
        properties.put("version", this.propt.getProperty("version"));
        properties.put("tenantCode", this.propt.getProperty("tenantCode"));
        properties.put("language", this.propt.getProperty("language"));
        properties.put("tenantSecret", this.propt.getProperty("tenantSecret"));
        properties.put("account", this.propt.getProperty("account"));
        properties.put("password", this.propt.getProperty("password"));
        properties.put("getTokenPath", this.propt.getProperty("getTokenPath"));
        try {
            JSONObject params = new JSONObject();
            params.put("count", (Object)"100");
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -3);
            Date threeDaysAgoDate = calendar.getTime();
            params.put("rowTimeStamp", (Object)threeDaysAgoDate.getTime());
            String payload = params.toJSONString();
            Map<String, String> headers = this.getHeader(payload, false);
            OkHttpClient client = new OkHttpClient.Builder().build();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)payload);
            Request.Builder requestBuilder = new Request.Builder().url(this.propt.getProperty("getMJPath")).method("POST", body).addHeader("Content-Type", "application/json");
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.header(header.getKey(), header.getValue());
            }
            Response response = client.newCall(requestBuilder.build()).execute();
            this.logger.error((Object)("response----" + response.isSuccessful()));
            if (response.isSuccessful()) {
                this.resetToken();
                ObjectMapper mapper = new ObjectMapper();
                String resultBody = response.body().string();
                this.logger.error((Object)("resultBody----" + resultBody));
                JSONObject result = JSONObject.parseObject((String)resultBody);
                this.logger.error((Object)("respMap----" + result));
                if (result.get((Object)"code").equals("0") || Integer.parseInt(result.get((Object)"code").toString()) == 0) {
                    int i;
                    String data = result.get((Object)"data").toString();
                    JSONArray jsonArray = JSONArray.parseArray((String)result.get((Object)"data").toString());
                    this.logger.error((Object)("jsonArray---" + jsonArray.toString()));
                    this.logger.error((Object)("jsonArray---" + jsonArray.size()));
                    IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                    PersonCollection personCollection = iPerson.getPersonCollection("select number ");
                    HashSet<String> set = new HashSet<String>();
                    for (i = 0; i < personCollection.size(); ++i) {
                        PersonInfo personInfo = personCollection.get(i);
                        set.add(personInfo.getNumber().toString());
                    }
                    for (i = 0; i < jsonArray.size(); ++i) {
                        JSONObject resultData = jsonArray.getJSONObject(i);
                        this.saveMJPunchCardData(ctx, resultData, set);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ShrWebBizException(e.getMessage());
        }
    }

    public void saveMJPunchCardData(Context ctx, JSONObject resultData, Set set) {
        this.logger.error((Object)"saveMJPunchCardData----");
        try {
            int success = 0;
            int error = 0;
            HashSet<String> setCardId = new HashSet<String>();
            HashSet<String> EquNoSet = new HashSet<String>();
            Timestamp minDateTime = null;
            Timestamp maxDateTime = null;
            CoreBaseCollection cardCollFinally = new CoreBaseCollection();
            CoreBaseCollection cardColl = new CoreBaseCollection();
            JSONArray formatErrorRecords = new JSONArray();
            JSONArray duplicateRecords = new JSONArray();
            JSONArray notExistRecords = new JSONArray();
            JSONArray seccussArray = new JSONArray();
            ++success;
            String personNumber = resultData.getString("empCode");
            String punchCardDate = resultData.getString("checkTime");
            String RecDate = punchCardDate.substring(0, 10);
            String RecTime = punchCardDate.substring(11, 19);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
            SimpleDateFormat sdfymd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = sdf.parse(punchCardDate);
            String format = sdfymd.format(date);
            Date punchDate = HRTimeWebUtils.stringToShortDate((String)RecDate, (boolean)true);
            Timestamp punchCardTime = HRTimeWebUtils.stringToTimestamp((String)format, (boolean)true);
            if (punchCardDate != null && punchCardTime != null) {
                PunchCardRecordInfo cardInfo = new PunchCardRecordInfo();
                cardInfo.setEquipmentNum("001");
                cardInfo.setAttendanceNum(personNumber);
                cardInfo.setPunchCardDate(punchDate);
                cardInfo.setPunchCardTime(punchCardTime);
                cardInfo.setPunchCardSource(PunchCardSourceEnum.attenceMachine);
                cardInfo.setPunchCardPlace((String)resultData.get((Object)"checkLocation"));
                PunchCardStateEnum punchCardStateEnum = (Boolean)resultData.get((Object)"isActive") != false ? PunchCardStateEnum.normal : PunchCardStateEnum.cancelled;
                cardInfo.setPunchCardState(punchCardStateEnum);
                cardInfo.setDescription("\u95e8\u7981\u6253\u5361\u673a");
                EquNoSet.add("001");
                if (!StringUtils.isEmpty((String)personNumber)) {
                    if (!set.contains(personNumber)) {
                        return;
                    }
                    setCardId.add(personNumber);
                    cardColl.add((CoreBaseInfo)cardInfo);
                }
                if (minDateTime != null && maxDateTime != null) {
                    if (punchCardTime.getTime() < minDateTime.getTime()) {
                        minDateTime = punchCardTime;
                    } else if (punchCardTime.getTime() > maxDateTime.getTime()) {
                        maxDateTime = punchCardTime;
                    }
                } else {
                    minDateTime = punchCardTime;
                    maxDateTime = punchCardTime;
                }
            } else {
                formatErrorRecords.add((Object)resultData);
            }
            Map attendanceFileMap = AttendanceFileFactory.getLocalInstance((Context)ctx).getPersonByAttendanceNum(setCardId);
            this.logger.error((Object)("attendanceFileMap-----" + attendanceFileMap));
            this.logger.error((Object)("setCardId-----" + setCardId));
            PunchCardRecordCollection existColl = this.getExistedPunchCardRecordCollection(ctx, minDateTime, maxDateTime, setCardId);
            this.logger.error((Object)("existColl-----" + existColl.size()));
            for (int i = 0; i < cardColl.size(); ++i) {
                HashMap<String, String> map = new HashMap<String, String>();
                PunchCardRecordInfo cardInfo = (PunchCardRecordInfo)cardColl.get(i);
                JSONObject jsObject = new JSONObject();
                jsObject.put("deviceid", (Object)cardInfo.getEquipmentNum());
                jsObject.put("userid", (Object)cardInfo.getAttendanceNum());
                jsObject.put("RecDate", (Object)HRTimeWebUtils.dateShortToString((Date)cardInfo.getPunchCardDate()));
                jsObject.put("RecTime", (Object)HRTimeWebUtils.timestampToString((Timestamp)cardInfo.getPunchCardTime()).substring(11));
                map.put("userid", cardInfo.getAttendanceNum());
                map.put("RecDate", HRTimeWebUtils.dateShortToString((Date)cardInfo.getPunchCardDate()));
                map.put("RecTime", HRTimeWebUtils.timestampToString((Timestamp)cardInfo.getPunchCardTime()).substring(11));
                if (attendanceFileMap.containsKey(cardInfo.getAttendanceNum())) {
                    if (existColl.contains(cardInfo)) {
                        duplicateRecords.add((Object)jsObject);
                    } else {
                        cardInfo.setPunchCardPlace(cardInfo.getPunchCardPlace());
                        cardInfo.setPunchCardSource(PunchCardSourceEnum.attenceMachine);
                        AttendanceFileInfo attendanceFileInfo = (AttendanceFileInfo)attendanceFileMap.get(cardInfo.getAttendanceNum());
                        cardInfo.setProposer(attendanceFileInfo.getProposer());
                        cardInfo.setHrOrgUnit(attendanceFileInfo.getHrOrgUnit());
                        cardInfo.setAdminOrgUnit(attendanceFileInfo.getAdminOrgUnit());
                        cardInfo.setCreator((UserInfo)ctx.get((Object)"UserInfo"));
                        cardInfo.setLastUpdateUser((UserInfo)ctx.get((Object)"UserInfo"));
                        cardInfo.setCreateTime(new Timestamp(new Date().getTime()));
                        cardInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
                        cardCollFinally.add((CoreBaseInfo)cardInfo);
                    }
                    seccussArray.add(map);
                    continue;
                }
                ++error;
                notExistRecords.add((Object)jsObject);
            }
            this.logger.error((Object)("cardCollFinally-----" + cardCollFinally.size()));
            this.logger.error((Object)("success-----" + success));
            this.logger.error((Object)("error-----" + error));
            this.logger.error((Object)("notExistRecords--list---" + notExistRecords));
            this.logger.error((Object)("notExistRecords-----" + notExistRecords.size()));
            this.logger.error((Object)("seccussArray--Size-----" + seccussArray.size()));
            this.logger.error((Object)("seccussArray-----" + seccussArray));
            IObjectPK[] iObjectPKS = PunchCardRecordFactory.getLocalInstance((Context)ctx).saveBatchData(cardCollFinally);
            this.logger.error((Object)("iObjectPKS----" + iObjectPKS.length));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void resetToken() {
        String token = (String)cache.get((Object)"token");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)token)) {
            this.getTokenByRemote();
        } else {
            cache.put((Object)"token", (Object)token, this.durationInMillis);
        }
    }

    private Map<String, String> getHeader(String payload, boolean isGetToken) {
        HashMap<String, String> signParams = new HashMap<String, String>();
        signParams.put("version", this.propt.getProperty("version"));
        signParams.put("transId", UUID.randomUUID().toString());
        signParams.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        signParams.put("tenantCode", this.propt.getProperty("tenantCode"));
        signParams.put("language", this.propt.getProperty("language"));
        if (!isGetToken) {
            signParams.put("token", this.getToken());
        }
        signParams.put("payload", payload);
        signParams.put("tenantSecret", this.propt.getProperty("tenantSecret"));
        signParams.put("sign", this.createSign(signParams));
        return signParams;
    }

    private String getToken() {
        String token = (String)cache.get((Object)"token");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)token)) {
            token = this.getTokenByRemote();
        }
        return token;
    }

    private String getTokenByRemote() {
        try {
            JSONObject params = new JSONObject();
            params.put("account", (Object)this.propt.getProperty("account"));
            String password = this.propt.getProperty("password");
            params.put("password", (Object)EncryptUtils.sha256((String)password, (boolean)false));
            String payload = params.toJSONString();
            String getTokenPath = this.propt.getProperty("getTokenPath");
            Map<String, String> headers = this.getHeader(payload, true);
            OkHttpClient client = new OkHttpClient.Builder().build();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)payload);
            Request.Builder requestBuilder = new Request.Builder().url(getTokenPath).method("POST", body).addHeader("Content-Type", "application/json");
            for (Map.Entry<String, String> header : headers.entrySet()) {
                requestBuilder.header(header.getKey(), header.getValue());
            }
            Response response = client.newCall(requestBuilder.build()).execute();
            ObjectMapper mapper = new ObjectMapper();
            if (response.isSuccessful()) {
                Map result = (Map)mapper.readValue(response.body().string(), Map.class);
                if ("success".equals(result.get("msg"))) {
                    String token = (String)result.get("data");
                    cache.put((Object)"token", (Object)token, 84600000L);
                    return token;
                }
                throw new RuntimeException("\u8fdc\u7a0b\u83b7\u53d6token\u62a5\u9519: ");
            }
            throw new RuntimeException("\u8fdc\u7a0b\u83b7\u53d6token\u62a5\u9519: ");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("\u8fdc\u7a0b\u83b7\u53d6token\u62a5\u9519: " + e.getMessage());
        }
    }

    private String createSign(Map<String, String> signParams) {
        String tenantSecret = signParams.get("tenantSecret");
        signParams.remove("tenantSecret");
        String linkStr = PunchCardRecordListHandlerEx.createLinkStr(signParams, "&");
        linkStr = linkStr + "&tenantSecret=" + tenantSecret;
        return EncryptUtils.sha256((String)linkStr, (boolean)true);
    }

    private static String createLinkStr(Map<String, String> params, String linkStr) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder content = new StringBuilder();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            if (i == keys.size() - 1) {
                content.append(key).append("=").append(value);
                continue;
            }
            content.append(key).append("=").append(value).append(linkStr);
        }
        return content.toString();
    }

    private PunchCardRecordCollection getExistedPunchCardRecordCollection(Context ctx, Timestamp minDateTime, Timestamp maxDateTime, Set<String> setCardId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("punchCardDate"));
        evi.getSelector().add(new SelectorItemInfo("punchCardTime"));
        evi.getSelector().add(new SelectorItemInfo("punchCardSource"));
        evi.getSelector().add(new SelectorItemInfo("equipmentNum"));
        evi.getSelector().add(new SelectorItemInfo("attendanceNum"));
        fi.getFilterItems().add(new FilterItemInfo("attendanceNum", setCardId, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("punchCardTime", (Object)maxDateTime, CompareType.LESS_EQUALS));
        fi.getFilterItems().add(new FilterItemInfo("punchCardTime", (Object)minDateTime, CompareType.GREATER_EQUALS));
        PunchCardRecordCollection existColl = PunchCardRecordFactory.getLocalInstance((Context)ctx).getPunchCardRecordCollection(evi);
        return existColl;
    }
}

