/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.flow.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.define.ManpowerActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.message.AssignReadFactory;
import com.kingdee.eas.base.message.AssignReadInfo;
import com.kingdee.eas.base.message.IAssignRead;
import com.kingdee.eas.base.message.URLInfo;
import com.kingdee.eas.base.message.util.ProcessCenterUtil;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveException;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.service.app.service.BatchApproveService;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchApproveServiceEx
extends BatchApproveService {
    private static Logger logger = Logger.getLogger(BatchApproveServiceEx.class);

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        ArrayList<Map<Object, Object>> results = new ArrayList<Map<Object, Object>>();
        String assignmentIds = (String)param.get("assignmentIds");
        String opinion = (String)param.get("opinion");
        StringBuilder errorMsg = new StringBuilder();
        if (StringUtils.isEmpty((String)assignmentIds)) {
            errorMsg.append("\u5de5\u4f5c\u6d41\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a!").append(System.lineSeparator());
        } else {
            try {
                assignmentIds = URLDecoder.decode(assignmentIds, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                errorMsg.append("\u5de5\u4f5c\u6d41\u4efb\u52a1id\u6570\u636e\u9519\u8bef, " + e.getMessage());
            }
        }
        if (StringUtils.isEmpty((String)opinion)) {
            errorMsg.append("\u5ba1\u6279\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a!");
        } else {
            logger.error((Object)("opinion_>1 " + opinion));
            try {
                opinion = URLDecoder.decode(opinion, "utf-8");
                logger.error((Object)("opinion_>2 " + opinion));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                errorMsg.append("\u5ba1\u6279\u610f\u89c1\u6570\u636e\u9519\u8bef, " + e.getMessage());
            }
        }
        logger.error((Object)("assignmentIds>2 " + assignmentIds));
        if (errorMsg.length() > 0) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("code", "0");
            result.put("msg", errorMsg.toString());
            results.add(result);
        }
        String[] assignmentIdArray = assignmentIds.split("[,\uff0c]");
        for (int i = 0; i < assignmentIdArray.length; ++i) {
            results.add(this.handle(ctx, assignmentIdArray[i], opinion));
        }
        return results;
    }

    private Map<String, String> handle(Context ctx, String assignmentId, String opinion) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("assignmentId", assignmentId);
        try {
            String errorMessage;
            String bosType = BOSUuid.read((String)assignmentId).getType().toString();
            if ("9623EB51".equals(bosType)) {
                try {
                    IAssignRead assignReadIns = AssignReadFactory.getLocalInstance((Context)ctx);
                    AssignReadInfo assignReadInfo = assignReadIns.getAssignReadInfo((IObjectPK)new ObjectUuidPK(assignmentId));
                    if (assignReadInfo == null) {
                        throw new BOSException("\u4efb\u52a1\u9605\u8bfb\u6570\u636e\u4e0d\u5b58\u5728: " + assignmentId);
                    }
                    assignmentId = assignReadInfo.getAssignID().toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BOSException("\u83b7\u53d6\u4efb\u52a1\u9605\u8bfb\u6570\u636e\u62a5\u9519: " + assignmentId);
                }
            }
            if (!StringUtils.isEmpty((String)(errorMessage = this.verifyData(ctx, assignmentId)))) {
                throw new BOSException(errorMessage);
            }
            this.doApprove(ctx, assignmentId, opinion);
            result.put("code", "1");
            result.put("msg", "\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("code", "0");
            String error = e.getMessage();
            if (e instanceof IllegalArgumentException) {
                result.put("msg", "\u6d41\u7a0bid\u65e0\u6548 " + assignmentId);
            }
            result.put("msg", error);
        }
        return result;
    }

    private String verifyData(Context ctx, String assignmentId) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        Map map = service.getActivityDefAndActivityInstInfo(assignmentId);
        Object act = map.get("ACTIVITYDEF");
        if (!(act instanceof ApproveActivityDef) && act instanceof ManpowerActivityDef) {
            return SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"labor_node_not_supported");
        }
        AssignmentInfo assignmentInfo = service.getAssignmentById(assignmentId);
        ActivityInstInfo actInstInfo = null;
        if (null != assignmentInfo) {
            actInstInfo = service.getActivityInstByActInstId(assignmentInfo.getActInstId());
        }
        if (actInstInfo != null && (actInstInfo.getState().equalsIgnoreCase("open.not_running.suspended") || actInstInfo.getState().equalsIgnoreCase("open.not_running.blocked"))) {
            return new MultiApproveException(MultiApproveException.FLOW_NOT_RUNNING).getMessage();
        }
        if (assignmentInfo == null) {
            return new MultiApproveException(MultiApproveException.ASSIGNMENTINFO_NULL).getMessage();
        }
        if (assignmentInfo.getState().equals((Object)WfAssignmentState.CANCELED)) {
            return new MultiApproveException(MultiApproveException.ASSIGNMENTSTATE_CANCELED).getMessage();
        }
        if (assignmentInfo.getState().equals((Object)WfAssignmentState.COMPLETED)) {
            return new MultiApproveException(MultiApproveException.ASSIGNMENTSTATE_COMPLETED).getMessage();
        }
        if (assignmentInfo.getState().equals((Object)WfAssignmentState.REJECTED)) {
            return new MultiApproveException(MultiApproveException.ASSIGNMENTSTATE_REJECTED).getMessage();
        }
        return assignmentInfo.getState().equals((Object)WfAssignmentState.PROCESSING) ? new MultiApproveException(MultiApproveException.ASSIGNMENTSTATE_COMPLETED).getMessage() : null;
    }

    private IObjectPK doApprove(Context ctx, String assignmentId, String opinion) throws BOSException, EASBizException {
        IMultiApprove multiApprove = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveInfo mInfo = new MultiApproveInfo();
        mInfo.setAssignment(assignmentId);
        URLInfo info = ProcessCenterUtil.getUrlInfos((String)assignmentId, (Context)ctx);
        String billID = info.getBillID();
        mInfo.setBillId(BOSUuid.read((String)billID));
        mInfo.setIsPass(ApproveResult.PASS);
        mInfo.setHandlerOpinion(0);
        mInfo.setOpinion(opinion);
        mInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        mInfo.setHandlerContent("\u540c\u610f");
        mInfo.setExtendedProperty("isAddNew", "isAddNew");
        mInfo.setExtendedProperty("assignmentID", assignmentId);
        mInfo.setExtendedProperty("businuessObjectId", billID);
        IObjectPK pk = multiApprove.submit((CoreBaseInfo)mInfo);
        return pk;
    }
}

