/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.messageWebService;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.bos.workflow.metas.AssignInfo;
import com.kingdee.bos.workflow.metas.IAssign;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.eas.base.message.AssignReadCollection;
import com.kingdee.eas.base.message.AssignReadFactory;
import com.kingdee.eas.base.message.AssignReadInfo;
import com.kingdee.eas.base.message.IAssignRead;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.webservice.MessageWebServiceDao;
import com.kingdee.eas.base.message.webservice.WSMessage;
import com.kingdee.eas.base.message.webservice.WfrAssignMessage;
import com.kingdee.eas.base.message.webservice.WfrProcMessage;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class OAMessageWebServiceDao
implements MessageWebServiceDao {
    private static Logger logger = Logger.getLogger(OAMessageWebServiceDao.class);
    private Properties prop = new Properties();
    private final String MBOSURL = "https://mbos.kdeascloud.com/mbos/mbosw/getWorkflowUrl?assignId={0}&eid={1}&storeEid={2}&name=approveui.navui&billID={3}";
    private final String MBOSAPPROVECENTERURL = "https://mbos.kdeascloud.com/mbos/page/loadPage?appid=10036&eid={0}&path=lczs2&name=lczshome.navui";
    private final String PASSASSIGNMENTURL = "{0}/easweb/dynamicPage.do?event=initialize&method=doEvent&uipk=com.kingdee.bos.workflow.metas.approve&type=passComent&sourceIDs={1}&msgId={2}&assignmentId={3}&passid={4}&billID={5}";
    private final String MBOSPASSASSIGNMENTURL = "https://mbos.kdeascloud.com/mbos/page/loadPage?path=lczs2&name=approveui.navui&lczstype=list&eid={0}&appid=10036&cometype=myreceivepass&billID={1}&fprocinstid={2}&fpassid={3}&msgid={4}&operateState=VIEW&storeEid={5}";
    String propPath = System.getProperty("EAS_HOME") + "/server/properties/scy/receiveOAConfig.properties";

    public OAMessageWebServiceDao() {
        try {
            this.prop.load(new FileInputStream(this.propPath));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("OA\u5f85\u529e\u6d88\u606f \u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25!" + e.getMessage());
        }
    }

    public boolean addMessage(WSMessage message) {
        logger.error((Object)"*********OAMessageWebServiceDao addMessage \u6d88\u606f\u76d1\u542c\u5f00\u59cb**********");
        return this.sendMessage(message, "0", "0");
    }

    public boolean removeMessage(String s) {
        logger.error((Object)"*********OAMessageWebServiceDao removeMessage111 \u6d88\u606f\u76d1\u542c\u5f00\u59cb**********");
        logger.error((Object)("*********OAMessageWebServiceDao s " + s));
        return false;
    }

    public boolean removeMessage(String s, Context context) {
        logger.error((Object)"*********OAMessageWebServiceDao removeMessage222 \u6d88\u606f\u76d1\u542c\u5f00\u59cb**********");
        logger.error((Object)("*********OAMessageWebServiceDao s " + s));
        return false;
    }

    public boolean updateMessage(String s) {
        logger.error((Object)"*********OAMessageWebServiceDao updateMessages444 \u6d88\u606f\u76d1\u542c\u5f00\u59cb**********");
        logger.error((Object)("*********OAMessageWebServiceDao s " + s));
        return false;
    }

    public boolean updateMessage(String s, Context context) {
        logger.error((Object)"*********OAMessageWebServiceDao updateMessages3333 \u6d88\u606f\u76d1\u542c\u5f00\u59cb**********");
        logger.error((Object)("*********OAMessageWebServiceDao s " + s));
        return false;
    }

    public boolean updateMessages(String s, MsgStatus msgStatus) {
        logger.error((Object)"*********OAMessageWebServiceDao updateMessages111 \u6d88\u606f\u76d1\u542c\u5f00\u59cb**********");
        logger.error((Object)("*********OAMessageWebServiceDao s " + s));
        logger.error((Object)("*********OAMessageWebServiceDao msgStatus " + msgStatus.getAlias()));
        return false;
    }

    public boolean updateMessages(String id, MsgStatus msgStatus, Context ctx) {
        logger.error((Object)"*********OAMessageWebServiceDao updateMessages2222 \u6d88\u606f\u76d1\u542c\u5f00\u59cb**********");
        logger.error((Object)("*********OAMessageWebServiceDao id " + id));
        logger.error((Object)("*********OAMessageWebServiceDao msgStatus " + msgStatus.getAlias()));
        BOSUuid bosId = BOSUuid.read((String)id);
        String bosType = bosId.getType().toString();
        logger.error((Object)("*********OAMessageWebServiceDao bosType " + bosType));
        if ("9623EB51".equals(bosType)) {
            try {
                IAssignRead assignReadIns = AssignReadFactory.getLocalInstance((Context)ctx);
                AssignReadInfo assignReadInfo = assignReadIns.getAssignReadInfo((IObjectPK)new ObjectUuidPK(id));
                String assignID = assignReadInfo.getAssignID().toString();
                IAssign iAssign = AssignFactory.getLocalInstance((Context)ctx);
                IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                AssignInfo assignInfo = iAssign.getValue((IObjectPK)new ObjectUuidPK(assignID));
                WSMessage wsMessage = new WSMessage();
                wsMessage.setMsgID(id);
                wsMessage.setTitle(assignInfo.getSubject());
                wsMessage.setBillId(assignInfo.getBizObjID());
                wsMessage.setContext(ctx);
                String priorPerformerID = assignInfo.getPriorPerformerID();
                PersonInfo sender = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(priorPerformerID));
                wsMessage.setSenderNumber(sender.getNumber());
                wsMessage.setSender(sender.getName());
                String personEmpId = assignInfo.getPersonEmpID().toString();
                PersonInfo reciever = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(personEmpId));
                wsMessage.setReceivers(reciever.getName());
                wsMessage.setRecieveNumber(reciever.getNumber());
                wsMessage.setRecieverID(personEmpId);
                if (MsgStatus.READED.equals((Object)msgStatus)) {
                    return this.sendMessage(wsMessage, "0", "1");
                }
                return this.sendMessage(wsMessage, "0", "0");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean addInitiatorMessage(WfrProcMessage wfrProcMessage) {
        logger.error((Object)"*********OAMessageWebServiceDao addInitiatorMessage \u6d88\u606f\u76d1\u542c\u5f00\u59cb**********");
        return false;
    }

    public boolean addCompletedMessage(WfrAssignMessage wfrAssignMessage) {
        try {
            logger.error((Object)"*********OAMessageWebServiceDao addCompletedMessage \u6d88\u606f\u76d1\u542c\u5f00\u59cb**********");
            String assignId = wfrAssignMessage.getAssignId();
            logger.error((Object)("*********OAMessageWebServiceDao assignId " + assignId));
            String assignSubject = wfrAssignMessage.getAssignSubject();
            String billID = wfrAssignMessage.getBillID();
            String handler = wfrAssignMessage.getHandler();
            String handlerNumber = wfrAssignMessage.getHandlerNumber();
            String state = wfrAssignMessage.getState();
            logger.error((Object)("*********OAMessageWebServiceDao state " + state));
            WfAssignmentState stateEnum = WfAssignmentState.getEnum((String)state);
            Context ctx = wfrAssignMessage.getCtx();
            IAssignRead iAssignRead = AssignReadFactory.getLocalInstance((Context)ctx);
            AssignReadCollection assignReadCollection = iAssignRead.getAssignReadCollection("where assignID='" + assignId + "'");
            String msgId = null;
            if (assignReadCollection.size() <= 0) {
                throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u4efb\u52a1\u9605\u8bfb\u8868  assignId: " + assignId);
            }
            msgId = assignReadCollection.get(0).getId().toString();
            if (WfAssignmentState.COMPLETED.equals((Object)stateEnum) || WfAssignmentState.REJECTED.equals((Object)stateEnum) || WfAssignmentState.CANCELED.equals((Object)stateEnum)) {
                WSMessage wsMessage = new WSMessage();
                wsMessage.setMsgID(msgId);
                wsMessage.setTitle(assignSubject);
                wsMessage.setBillId(billID);
                wsMessage.setContext(ctx);
                wsMessage.setSenderNumber(wfrAssignMessage.getInitiatorNumber());
                wsMessage.setSender(wfrAssignMessage.getInitiator());
                wsMessage.setReceivers(handler);
                wsMessage.setRecieveNumber(handlerNumber);
                wsMessage.setRecieverID(wfrAssignMessage.getHandlerId());
                return this.sendMessage(wsMessage, "2", "1");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean sendMessage(WSMessage message, String isremark, String viewtype) {
        Context ctx = message.getContext();
        ctx.setCaller((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-00000000000013B7DE7F"));
        try {
            String serverName = this.prop.getProperty("serverName");
            String receiveOAPath = this.prop.getProperty("receiveOAPath");
            if (StringUtils.isEmpty((CharSequence)receiveOAPath)) {
                throw new RuntimeException("\u53d1\u9001OA\u5f85\u529e\u6d88\u606f,\u63a8\u9001\u5f02\u6b65\u6d88\u606f\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
            }
            JSONObject params = new JSONObject();
            String syscode = this.prop.getProperty("syscode", "SHR");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            String now = sdf.format(date);
            params.put("syscode", (Object)syscode);
            params.put("flowid", (Object)message.getMsgID());
            MsgBizType bizType = message.getBizType();
            if (MsgBizType.URGENT.equals((Object)bizType)) {
                params.put("requestname", (Object)message.getBody());
            } else {
                params.put("requestname", (Object)message.getTitle());
            }
            MsgType type = message.getType();
            if (type != null) {
                params.put("workflowname", (Object)type.getAlias());
            } else {
                params.put("workflowname", (Object)"\u4efb\u52a1");
            }
            String billId = message.getBillId();
            logger.error((Object)("billId: " + billId));
            params.put("pcurl", (Object)this.getPcUrl(ctx, serverName, message.getMsgID(), bizType));
            params.put("appurl", (Object)this.getAppUrl(ctx, serverName, message.getMsgID(), bizType));
            params.put("nodename", (Object)"sHR");
            params.put("isremark", (Object)isremark);
            params.put("viewtype", (Object)viewtype);
            params.put("creator", (Object)message.getSenderNumber());
            params.put("createdatetime", (Object)now);
            params.put("receiver", (Object)message.getRecieveNumber());
            params.put("receivedatetime", (Object)now);
            params.put("receivets", (Object)String.valueOf(date.getTime()));
            logger.error((Object)("addMessage -> params: " + params));
            OkHttpClient client = new OkHttpClient();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)params.toString());
            Request request = new Request.Builder().url(receiveOAPath).post(body).addHeader("content-type", "application/json").build();
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                String result = response.body().string();
                logger.error((Object)("addMessage -> result:" + result));
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String operResult = jsonObject.getString("operResult");
                if ("1".equals(operResult)) {
                    return true;
                }
                logger.error((Object)jsonObject.getString("message"));
            } else {
                logger.error((Object)"\u53d1\u9001OA\u5f85\u529e\u6d88\u606f \u8d85\u65f6");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private String getPcUrl(Context ctx, String serverName, String msgId, MsgBizType bizType) throws UnsupportedEncodingException, BOSException, EASBizException, SQLException {
        StringBuilder pcurl = new StringBuilder();
        pcurl.append(serverName).append("/shr/api/oAToSHR?redirect=");
        String bosType = BOSUuid.read((String)msgId).getType().toString();
        if ("41C9B39B".equals(bosType) && MsgBizType.WORKFLOW.equals((Object)bizType)) {
            String querySql = " select * from T_BAS_Message where fid =?";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{msgId});
            String sourceIDs = null;
            String billID = null;
            while (iRowSet.next()) {
                sourceIDs = iRowSet.getString("FSourceIDs");
                billID = iRowSet.getString("FSourceID");
            }
            String[] split = sourceIDs.split(":");
            String assignmentId = null;
            String passid = null;
            for (int i = 0; i < split.length; ++i) {
                String value = split[i];
                if (value.endsWith("WFWKITEM")) {
                    assignmentId = value;
                    continue;
                }
                if (!value.endsWith("PASSID")) continue;
                passid = value;
            }
            String redirectUrl = MessageFormat.format("{0}/easweb/dynamicPage.do?event=initialize&method=doEvent&uipk=com.kingdee.bos.workflow.metas.approve&type=passComent&sourceIDs={1}&msgId={2}&assignmentId={3}&passid={4}&billID={5}", serverName, URLEncoder.encode(sourceIDs, "UTF-8"), URLEncoder.encode(msgId, "UTF-8"), URLEncoder.encode(assignmentId, "UTF-8"), URLEncoder.encode(passid, "UTF-8"), URLEncoder.encode(billID, "UTF-8"));
            pcurl.append(URLEncoder.encode(redirectUrl, "UTF-8"));
            logger.error((Object)("pcurl: " + pcurl));
            return pcurl.toString();
        }
        if ("41C9B39B".equals(bosType) && MsgBizType.URGENT.equals((Object)bizType)) {
            String querySql = " select * from T_BAS_Message where fid =?";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{msgId});
            String assignID = null;
            while (iRowSet.next()) {
                assignID = iRowSet.getString("FSourceID");
            }
            StringBuilder redirectUrl = new StringBuilder();
            if (!StringUtils.isEmpty((CharSequence)assignID)) {
                AssignInfo assignInfo = AssignFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(assignID));
                String billID = assignInfo.getBizObjID();
                redirectUrl.append(serverName).append("/easweb/webviews/workflow/transferApprove.jsp?AssignmentId=").append(URLEncoder.encode(assignID, "UTF-8")).append("&billID=").append(URLEncoder.encode(billID, "UTF-8"));
            } else {
                redirectUrl.append(serverName).append("/shr/dynamic.do?uipk=shr.perself.homepage");
            }
            pcurl.append(URLEncoder.encode(redirectUrl.toString(), "UTF-8"));
            logger.error((Object)("pcurl: " + pcurl));
            return pcurl.toString();
        }
        if ("9623EB51".equals(bosType)) {
            IAssignRead assignReadIns = AssignReadFactory.getLocalInstance((Context)ctx);
            AssignReadInfo assignReadInfo = assignReadIns.getAssignReadInfo((IObjectPK)new ObjectUuidPK(msgId));
            String assignID = assignReadInfo.getAssignID().toString();
            StringBuilder redirectUrl = new StringBuilder();
            if (!StringUtils.isEmpty((CharSequence)assignID)) {
                AssignInfo assignInfo = AssignFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(assignID));
                String billID = assignInfo.getBizObjID();
                redirectUrl.append(serverName).append("/easweb/webviews/workflow/transferApprove.jsp?AssignmentId=").append(URLEncoder.encode(assignID, "UTF-8")).append("&billID=").append(URLEncoder.encode(billID, "UTF-8"));
            } else {
                redirectUrl.append(serverName).append("/shr/dynamic.do?uipk=shr.perself.homepage");
            }
            pcurl.append(URLEncoder.encode(redirectUrl.toString(), "UTF-8"));
            logger.error((Object)("pcurl: " + pcurl));
            return pcurl.toString();
        }
        throw new RuntimeException("bosType\u7c7b\u578b\u672a\u627e\u5230: " + bosType);
    }

    private String getAppUrl(Context ctx, String serverName, String msgId, MsgBizType bizType) throws UnsupportedEncodingException, BOSException, EASBizException, SQLException {
        StringBuilder appUrl = new StringBuilder();
        appUrl.append(serverName).append("/shr/api/oAToMBos?redirect=");
        String bosType = BOSUuid.read((String)msgId).getType().toString();
        String eid = this.prop.getProperty("eid");
        if (StringUtils.isEmpty((CharSequence)eid)) {
            throw new RuntimeException("\u53d1\u9001OA\u5f85\u529e\u6d88\u606f,eid\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        if ("41C9B39B".equals(bosType) && MsgBizType.WORKFLOW.equals((Object)bizType)) {
            String querySql = " select * from T_BAS_Message where fid =?";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{msgId});
            String sourceIDs = null;
            String billID = null;
            while (iRowSet.next()) {
                sourceIDs = iRowSet.getString("FSourceIDs");
                billID = iRowSet.getString("FSourceID");
            }
            String[] split = sourceIDs.split(":");
            String assignmentId = null;
            String passid = null;
            String procinstid = null;
            for (int i = 0; i < split.length; ++i) {
                String value = split[i];
                if (value.endsWith("WFWKITEM")) {
                    assignmentId = value;
                    continue;
                }
                if (value.endsWith("PASSID")) {
                    passid = value;
                    continue;
                }
                if (!value.endsWith("WFPCINST")) continue;
                procinstid = value;
            }
            String redirectUrl = MessageFormat.format("https://mbos.kdeascloud.com/mbos/page/loadPage?path=lczs2&name=approveui.navui&lczstype=list&eid={0}&appid=10036&cometype=myreceivepass&billID={1}&fprocinstid={2}&fpassid={3}&msgid={4}&operateState=VIEW&storeEid={5}", eid, URLEncoder.encode(billID, "UTF-8"), URLEncoder.encode(procinstid, "UTF-8"), URLEncoder.encode(passid, "UTF-8"), URLEncoder.encode(msgId, "UTF-8"), eid);
            appUrl.append(URLEncoder.encode(redirectUrl, "UTF-8"));
        } else if ("41C9B39B".equals(bosType) && MsgBizType.URGENT.equals((Object)bizType)) {
            String querySql = " select * from T_BAS_Message where fid =?";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{msgId});
            String assignID = null;
            while (iRowSet.next()) {
                assignID = iRowSet.getString("FSourceID");
            }
            String redirectUrl = null;
            if (!StringUtils.isEmpty((CharSequence)assignID)) {
                IAssign iAssign = AssignFactory.getLocalInstance((Context)ctx);
                AssignInfo assignInfo = iAssign.getValue((IObjectPK)new ObjectUuidPK(assignID));
                String billId = assignInfo.getBizObjID();
                redirectUrl = MessageFormat.format("https://mbos.kdeascloud.com/mbos/mbosw/getWorkflowUrl?assignId={0}&eid={1}&storeEid={2}&name=approveui.navui&billID={3}", URLEncoder.encode(assignID, "UTF-8"), eid, "21231", URLEncoder.encode(billId, "UTF-8"));
            } else {
                redirectUrl = MessageFormat.format("https://mbos.kdeascloud.com/mbos/page/loadPage?appid=10036&eid={0}&path=lczs2&name=lczshome.navui", eid);
            }
            appUrl.append(URLEncoder.encode(redirectUrl, "UTF-8"));
        } else if ("9623EB51".equals(bosType)) {
            IAssignRead assignReadIns = AssignReadFactory.getLocalInstance((Context)ctx);
            AssignReadInfo assignReadInfo = assignReadIns.getAssignReadInfo((IObjectPK)new ObjectUuidPK(msgId));
            String assignID = assignReadInfo.getAssignID().toString();
            String redirectUrl = null;
            if (!StringUtils.isEmpty((CharSequence)assignID)) {
                IAssign iAssign = AssignFactory.getLocalInstance((Context)ctx);
                AssignInfo assignInfo = iAssign.getValue((IObjectPK)new ObjectUuidPK(assignID));
                String billId = assignInfo.getBizObjID();
                redirectUrl = MessageFormat.format("https://mbos.kdeascloud.com/mbos/mbosw/getWorkflowUrl?assignId={0}&eid={1}&storeEid={2}&name=approveui.navui&billID={3}", URLEncoder.encode(assignID, "UTF-8"), eid, "21231", URLEncoder.encode(billId, "UTF-8"));
            } else {
                redirectUrl = MessageFormat.format("https://mbos.kdeascloud.com/mbos/page/loadPage?appid=10036&eid={0}&path=lczs2&name=lczshome.navui", eid);
            }
            appUrl.append(URLEncoder.encode(redirectUrl, "UTF-8"));
        }
        logger.error((Object)("appUrl: " + appUrl));
        return appUrl.toString();
    }

    private boolean deleteMessage(String flowId, String userId) {
        try {
            OkHttpClient client = new OkHttpClient();
            JSONObject params = new JSONObject();
            String deleteMsgPath = this.prop.getProperty("deleteMsgPath");
            if (StringUtils.isEmpty((CharSequence)deleteMsgPath)) {
                throw new RuntimeException("\u5220\u9664OA\u6d88\u606f\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
            }
            String syscode = this.prop.getProperty("syscode", "SHR");
            params.put("syscode", (Object)syscode);
            params.put("flowid", (Object)flowId);
            params.put("userid", (Object)userId);
            String paramsStr = params.toString();
            logger.error((Object)("OAMessageWebServiceDao  deleteMessage-> params:" + paramsStr));
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)paramsStr);
            Request request = new Request.Builder().url(deleteMsgPath).post(body).addHeader("content-type", "application/json").build();
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                String result = response.body().string();
                logger.error((Object)("deleteMessage -> result:" + result));
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String operResult = jsonObject.getString("operResult");
                if ("1".equals(operResult)) {
                    return true;
                }
                logger.error((Object)jsonObject.getString("message"));
            } else {
                logger.error((Object)"\u5220\u9664OA\u5f85\u529e\u6d88\u606f \u8d85\u65f6");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

