/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.sso;

import com.alibaba.fastjson.JSON;
import com.kingdee.eas.custom.sso.SsoUtil;
import com.kingdee.eas.utils.ExpiringMapCache;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class OAToMBos
extends HttpServlet {
    private static Logger logger = Logger.getLogger(OAToMBos.class);
    private static ExpiringMapCache<String, String> redirectUrlCache = new ExpiringMapCache();
    private Properties prop = new Properties();
    private String propPath = System.getProperty("EAS_HOME") + "/server/properties/scy/OAToMBosConfig.properties";
    private final String MBOSAPPROVECENTERURL = "https://mbos.kdeascloud.com/mbos/page/loadPage?appid=10036&eid={0}&path=lczs2&name=lczshome.navui";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.error((Object)"OAToMBos -> doGet");
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.error((Object)"OAToMBos -> doPost");
        BufferedReader streamReader = null;
        String resultStr = null;
        this.prop.load(new FileInputStream(this.propPath));
        logger.error((Object)("OAToMBos  requestUrl" + req.getRequestURL().toString()));
        try {
            String ticket = req.getParameter("ticket");
            String token = req.getParameter("token");
            logger.error((Object)("\u63a5\u6536\u5230\u7684\u8bf7\u6c42\u53c2\u6570\u662f\uff1aticket " + ticket));
            if (!StringUtils.isEmpty((String)ticket)) {
                this.redirectMbos(req, resp, ticket);
            } else if (!StringUtils.isEmpty((String)token)) {
                this.getTokenUrl(req, resp, token);
            } else {
                this.authorize(req, resp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("msgType", "0");
            result.put("reason", e.getMessage());
            resultStr = JSON.toJSONString(result);
            resp.setStatus(500);
            PrintWriter writer = resp.getWriter();
            resp.setContentType("application/json");
            writer.write(resultStr);
            writer.close();
        }
        finally {
            try {
                if (streamReader != null) {
                    streamReader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void redirectMbos(HttpServletRequest req, HttpServletResponse resp, String ticket) throws IOException {
        if (StringUtils.isEmpty((String)ticket)) {
            throw new RuntimeException("ticket\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String getAccessTokenPath = this.prop.getProperty("getAccessTokenPath");
        if (StringUtils.isEmpty((String)getAccessTokenPath)) {
            throw new RuntimeException("getAccessTokenPath\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String serverName = this.prop.getProperty("serverName");
        if (StringUtils.isEmpty((String)serverName)) {
            throw new RuntimeException("serverName\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String client_secret = this.prop.getProperty("client_secret");
        if (StringUtils.isEmpty((String)client_secret)) {
            throw new RuntimeException("client_secret\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String client_id = this.prop.getProperty("client_id");
        if (StringUtils.isEmpty((String)client_id)) {
            throw new RuntimeException("client_id\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String redirect_uri2 = this.prop.getProperty("redirect_uri2");
        if (StringUtils.isEmpty((String)redirect_uri2)) {
            throw new RuntimeException("redirect_uri2\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String getLoginIdPath = this.prop.getProperty("getLoginIdPath");
        if (StringUtils.isEmpty((String)getLoginIdPath)) {
            throw new RuntimeException("getLoginIdPath\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String redirectUrlKey = req.getParameter("redirect");
        logger.error((Object)("callBack redirectUrl" + redirectUrlKey));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", client_id);
        params.put("client_secret", client_secret);
        params.put("grant_type", "authorization_code");
        params.put("code", ticket);
        params.put("redirect_uri", URLEncoder.encode(redirect_uri2, "UTF-8"));
        try {
            String redirectUrl = null;
            String token = SsoUtil.getAccessToken(getAccessTokenPath, params);
            logger.error((Object)token);
            if (StringUtils.isEmpty((String)redirectUrlKey)) {
                String eid = this.prop.getProperty("eid");
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)eid)) {
                    throw new RuntimeException("eid\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
                }
                redirectUrl = MessageFormat.format("https://mbos.kdeascloud.com/mbos/page/loadPage?appid=10036&eid={0}&path=lczs2&name=lczshome.navui", eid);
            } else {
                redirectUrl = (String)redirectUrlCache.get((Object)redirectUrlKey);
            }
            HashMap<String, String> toMbosparams = new HashMap<String, String>();
            toMbosparams.put("token", token);
            redirectUrl = SsoUtil.checkBillExistForMbos(redirectUrl, serverName, getLoginIdPath, token);
            String urlString = SsoUtil.appendUrl(redirectUrl, toMbosparams);
            resp.sendRedirect(urlString);
            logger.error((Object)("redirectMbos url" + urlString));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    public void authorize(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        String authorizePath = this.prop.getProperty("authorizePath");
        if (StringUtils.isEmpty((String)authorizePath)) {
            throw new RuntimeException("authorizePath\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String response_type = this.prop.getProperty("response_type");
        if (StringUtils.isEmpty((String)response_type)) {
            throw new RuntimeException("response_type\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String client_id = this.prop.getProperty("client_id");
        if (StringUtils.isEmpty((String)client_id)) {
            throw new RuntimeException("client_id\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String redirect_uri1 = this.prop.getProperty("redirect_uri1");
        if (StringUtils.isEmpty((String)redirect_uri1)) {
            throw new RuntimeException("redirect_uri1\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        String redirectUrl = req.getParameter("redirect");
        if (StringUtils.isEmpty((String)redirectUrl)) {
            redirectUrl = "https://mbos.kdeascloud.com/mbos/page/loadPage?appid=10036&eid={0}&path=lczs2&name=lczshome.navui";
        }
        Random random = new Random();
        String key = System.currentTimeMillis() + String.valueOf(random.nextInt(99999));
        redirectUrlCache.put((Object)key, (Object)redirectUrl, 300000L);
        logger.error((Object)("callBack redirectUrl" + redirectUrl));
        redirect_uri1 = redirect_uri1 + "?redirect=" + key;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", client_id);
        params.put("response_type", response_type);
        params.put("redirect_uri", URLEncoder.encode(redirect_uri1, "UTF-8"));
        String urlString = SsoUtil.appendUrl(authorizePath, params);
        resp.sendRedirect(urlString);
        logger.error((Object)("authorize url" + urlString));
    }

    public void getTokenUrl(HttpServletRequest req, HttpServletResponse resp, String token) throws SHRWebException, IOException {
        logger.error((Object)"getTokenUrl\u65b9\u6cd5\u5165\u53c2");
        if (StringUtils.isEmpty((String)token)) {
            throw new RuntimeException("token\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String getLoginIdPath = this.prop.getProperty("getLoginIdPath");
        if (StringUtils.isEmpty((String)getLoginIdPath)) {
            throw new RuntimeException("getLoginIdPath\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + this.propPath);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String loginId = SsoUtil.loginId2userId(getLoginIdPath, token);
            result.put("status", "0");
            result.put("message", loginId);
            resp.setStatus(200);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("status", "1");
            result.put("message", e.getMessage());
            resp.setStatus(500);
        }
        PrintWriter writer = resp.getWriter();
        resp.setContentType("application/json");
        writer.write(JSON.toJSONString(result));
        writer.close();
    }
}

