/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.synctask.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.taskmng.util.StringUtil;
import com.kingdee.eas.custom.synctask.SyncTranForIOTFacadeFactory;
import com.kingdee.eas.custom.synctask.SyncTranForOAFacadeFactory;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.emp.web.handler.EmployeeListHandler;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsBody;
import com.kingdee.shr.base.syssetting.api.bean.BatchMessageTipsHeader;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;

public class EmployeeListHandlerEx
extends EmployeeListHandler {
    public Logger logger = Logger.getLogger(EmployeeListHandlerEx.class);
    public Context ctx = SHRContext.getInstance().getContext();
    public static Map<String, String> personStatusMap = new HashMap<String, String>();

    public void getPersonBatchInfoAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, ShrWebBizException {
        try {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)this.ctx);
            PersonCollection personCollection = null;
            String ids = request.getParameter("ids");
            if (StringUtil.isEmpty((String)ids)) {
                personCollection = iPerson.getPersonCollection();
            } else {
                Set adminOrgIds = AtsUtil.toSet((String)ids);
                FilterInfo filterInfo = new FilterInfo();
                FilterItemCollection filterItems = filterInfo.getFilterItems();
                filterItems.add(new FilterItemInfo("id", (Object)adminOrgIds, CompareType.INCLUDE));
                EntityViewInfo entityViewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, null, null);
                personCollection = iPerson.getPersonCollection(entityViewInfo);
            }
            ArrayList list = new ArrayList();
            for (int i = 0; i < personCollection.size(); ++i) {
                PersonInfo personInfo = personCollection.get(i);
                HashMap<String, String> personMap = new HashMap<String, String>();
                personMap.put("person.name", personInfo.getName());
                personMap.put("person.number", personInfo.getNumber());
                personMap.put("person.id", personInfo.getId().toString());
                personMap.put("id", personInfo.getId().toString());
                list.add(personMap);
            }
            JSONUtils.SUCCESS(list);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ShrWebBizException((Throwable)e);
        }
    }

    public void syncPersonToIotAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, ShrWebBizException {
        String billId = request.getParameter("billId");
        IPerson iPerson = PersonFactory.getLocalInstance((Context)this.ctx);
        PersonCollection personCollection = null;
        Set personIds = null;
        HashMap<String, String> personNameAndNumberMap = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)billId)) {
            personCollection = iPerson.getPersonCollection("select id,number");
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < personCollection.size(); ++i) {
                PersonInfo personInfo = personCollection.get(i);
                String personId = personInfo.getId().toString();
                String personNumber = personInfo.getNumber().toString();
                sb.append(personId).append(",");
                personNameAndNumberMap.put(personNumber, personId);
            }
            sb.deleteCharAt(sb.lastIndexOf(","));
            billId = sb.toString();
        } else {
            personCollection = iPerson.getPersonCollection("select id,number where id in (" + AtsUtil.getStrFromString((String)billId) + ")");
        }
        personIds = AtsUtil.toSet((String)billId);
        try {
            Map resultMap = SyncTranForIOTFacadeFactory.getLocalInstance((Context)this.ctx).syncPersonToIot(billId);
            int failure = 0;
            int success = personIds.size();
            BatchMessageTipsHeader batchMessageTipsHeader = new BatchMessageTipsHeader();
            for (int i = 0; i < personCollection.size(); ++i) {
                BatchMessageTipsBody body = new BatchMessageTipsBody();
                PersonInfo personInfo = personCollection.get(i);
                body.setId(personInfo.getId().toString());
                String personNumber = personInfo.getNumber();
                if (resultMap.containsKey(personNumber)) {
                    body.setMuitTipsState(false);
                    body.setMuitTipsMessage((String)resultMap.get(personNumber));
                    ++failure;
                } else {
                    body.setMuitTipsState(true);
                }
                batchMessageTipsHeader.addResult(body);
            }
            this.logger.error((Object)"handleEnableWithTips----- >> ");
            batchMessageTipsHeader.setBillId(billId);
            batchMessageTipsHeader.setFailureCount(failure);
            batchMessageTipsHeader.setSuccessCount(success -= failure);
            ObjectMapper mapper = new ObjectMapper();
            this.logger.error((Object)("handleEnableWithTips----- >> " + mapper.writeValueAsString((Object)batchMessageTipsHeader)));
            this.logger.error((Object)("handleEnableWithTips--size--- >> " + batchMessageTipsHeader.getResult().size()));
            request.setAttribute("res_method_data", (Object)batchMessageTipsHeader);
            this.writeSuccessData(batchMessageTipsHeader);
            this.logger.error((Object)"handleEnableWithTips----- end ");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ShrWebBizException((Throwable)e);
        }
    }

    public void syncPersonToOAAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, EASBizException, SHRWebException {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            this.logger.error((Object)("----headerNames------key\u3010" + headerName + "\u3011-value\u3010 " + headerValue + "\u3011"));
        }
        Enumeration enu = request.getParameterNames();
        while (enu.hasMoreElements()) {
            String paraName = (String)enu.nextElement();
            this.logger.error((Object)("----ParameterNames------key\u3010" + paraName + "\u3011-value\u3010 " + request.getParameter(paraName) + "\u3011"));
        }
        this.handleEnableWithTips(request, "");
    }

    protected void handleEnableWithTips(HttpServletRequest request, String methodName) throws SHRWebException {
        String billId = request.getParameter("billId");
        if (StringUtils.isEmpty((String)billId)) {
            billId = (String)request.getAttribute("billId");
        }
        if (StringUtils.isEmpty((String)billId)) {
            billId = request.getParameter("billIds[]");
        }
        if (StringUtils.isEmpty((String)billId)) {
            billId = (String)request.getAttribute("billId[]");
        }
        try {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)this.ctx);
            if (StringUtils.isEmpty((String)billId)) {
                PersonCollection personCollection = iPerson.getPersonCollection("select id");
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < personCollection.size(); ++i) {
                    String personId = personCollection.get(i).getId().toString();
                    sb.append(personId).append(",");
                }
                sb.deleteCharAt(sb.lastIndexOf(","));
                billId = sb.toString();
            }
            Map resultMap = SyncTranForOAFacadeFactory.getLocalInstance((Context)this.ctx).syncPersonToOA(billId, null);
            this.logger.error((Object)("handleEnableWithTips----- resultMap----" + resultMap));
            if (resultMap != null && !resultMap.isEmpty()) {
                this.logger.error((Object)"handleEnableWithTips----- start ");
                this.logger.error((Object)("handleEnableWithTips----- billId-- " + billId));
                PersonCollection personCollection = iPerson.getPersonCollection("select id,number where id in (" + AtsUtil.getStrFromString((String)billId) + ")");
                int sucess = 0;
                int failure = 0;
                BatchMessageTipsHeader batchMessageTipsHeader = new BatchMessageTipsHeader();
                for (int i = 0; i < personCollection.size(); ++i) {
                    BatchMessageTipsBody body = new BatchMessageTipsBody();
                    PersonInfo personInfo = personCollection.get(i);
                    body.setId(personInfo.getId().toString());
                    String personNumber = personInfo.getNumber();
                    Map map = (Map)resultMap.get(personNumber);
                    this.logger.error((Object)("map----" + map));
                    if (map == null) {
                        ++failure;
                        body.setMuitTipsState(Boolean.FALSE.booleanValue());
                        body.setMuitTipsMessage("\u540c\u6b65\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u6216\u68c0\u67e5\u662f\u5426\u540c\u6b65OA\u5b57\u6bb5\u662f\u5426\u7b49\u4e8e\u5426!");
                    } else if ("success".equals(map.get("state"))) {
                        ++sucess;
                        body.setMuitTipsState(Boolean.TRUE.booleanValue());
                        body.setMuitTipsMessage((String)map.get("msg"));
                    } else {
                        ++failure;
                        body.setMuitTipsState(Boolean.FALSE.booleanValue());
                        body.setMuitTipsMessage((String)map.get("msg"));
                    }
                    batchMessageTipsHeader.addResult(body);
                }
                this.logger.error((Object)"handleEnableWithTips----- >> ");
                batchMessageTipsHeader.setBillId(billId);
                batchMessageTipsHeader.setFailureCount(failure);
                batchMessageTipsHeader.setSuccessCount(sucess);
                this.logger.error((Object)("batchMessageTipsHeader  " + batchMessageTipsHeader.getSuccessCount()));
                request.setAttribute("res_method_data", (Object)batchMessageTipsHeader);
                this.writeSuccessData(batchMessageTipsHeader);
                this.logger.error((Object)"handleEnableWithTips----- end ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ShrWebBizException((Throwable)e);
        }
    }

    static {
        personStatusMap.put("001", "1");
        personStatusMap.put("011", "1");
        personStatusMap.put("006", "1");
        personStatusMap.put("007", "1");
        personStatusMap.put("005", "1");
        personStatusMap.put("012", "1");
        personStatusMap.put("031", "1");
        personStatusMap.put("S01", "1");
        personStatusMap.put("S02", "1");
        personStatusMap.put("S05", "1");
        personStatusMap.put("S03", "1");
        personStatusMap.put("S20", "1");
        personStatusMap.put("002", "3");
        personStatusMap.put("010", "3");
        personStatusMap.put("009", "3");
        personStatusMap.put("003", "3");
        personStatusMap.put("004", "3");
        personStatusMap.put("013", "3");
        personStatusMap.put("020", "3");
        personStatusMap.put("021", "3");
        personStatusMap.put("030", "3");
        personStatusMap.put("S04", "3");
        personStatusMap.put("S08", "3");
        personStatusMap.put("S09", "3");
        personStatusMap.put("035", "3");
        personStatusMap.put("S07", "3");
    }
}

