/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.messageWebService;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.message.AssignReadFactory;
import com.kingdee.eas.base.message.AssignReadInfo;
import com.kingdee.eas.base.message.IAssignRead;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.message.webservice.MessageWebServiceDao;
import com.kingdee.eas.base.message.webservice.WSMessage;
import com.kingdee.eas.base.message.webservice.WfrAssignMessage;
import com.kingdee.eas.base.message.webservice.WfrProcMessage;
import java.io.FileInputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class OAMessageWebServiceDao
implements MessageWebServiceDao {
    private static Logger logger = Logger.getLogger(OAMessageWebServiceDao.class);

    public boolean addMessage(WSMessage message) {
        logger.error((Object)"*********OAMessageWebServiceDao \u6d88\u606f\u76d1\u542c\u5f00\u59cb**********");
        try {
            Properties prop = new Properties();
            String propPath = System.getProperty("EAS_HOME") + "/server/properties/scy/receiveOAConfig.properties";
            prop.load(new FileInputStream(propPath));
            String receiveOAPath = prop.getProperty("receiveOAPath");
            String serverName = prop.getProperty("serverName");
            if (StringUtils.isEmpty((CharSequence)receiveOAPath)) {
                logger.error((Object)("\u53d1\u9001OA\u5f85\u529e\u6d88\u606f,\u63a8\u9001\u5f02\u6b65\u6d88\u606f\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a! \u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6: " + propPath));
                return false;
            }
            JSONObject params = new JSONObject();
            String syscode = prop.getProperty("syscode", "SHR");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            String now = sdf.format(date);
            params.put("syscode", (Object)syscode);
            params.put("flowid", (Object)message.getMsgID());
            params.put("requestname", (Object)message.getTitle());
            MsgType type = message.getType();
            if (type != null) {
                params.put("workflowname", (Object)type.getAlias());
            }
            String billId = message.getBillId();
            logger.error((Object)("billId: " + billId));
            StringBuilder url = new StringBuilder();
            StringBuilder redirectUrl = new StringBuilder();
            url.append(serverName).append("/shr/api/oAToSHR?redirect=");
            if (!StringUtils.isEmpty((CharSequence)message.getMsgID())) {
                IAssignRead assignReadIns = AssignReadFactory.getLocalInstance((Context)message.getContext());
                AssignReadInfo assignReadInfo = assignReadIns.getAssignReadInfo((IObjectPK)new ObjectUuidPK(message.getMsgID()));
                String assignID = assignReadInfo.getAssignID().toString();
                redirectUrl.append(serverName).append("/easweb/webviews/workflow/transferApprove.jsp?AssignmentId=").append(assignID);
            } else {
                redirectUrl.append(serverName).append("/shr/dynamic.do?uipk=shr.perself.homepage");
            }
            url.append(URLEncoder.encode(redirectUrl.toString(), "UTF-8"));
            params.put("pcurl", (Object)url);
            params.put("appurl", (Object)url);
            params.put("isremark", (Object)"0");
            params.put("viewtype", (Object)"1");
            params.put("creator", (Object)message.getSenderNumber());
            params.put("createdatetime", (Object)now);
            params.put("receiver", (Object)message.getRecieveNumber());
            params.put("receivedatetime", (Object)now);
            params.put("receivets", (Object)String.valueOf(date.getTime()));
            logger.error((Object)("addMessage -> params: " + params));
            OkHttpClient client = new OkHttpClient();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)params.toString());
            Request request = new Request.Builder().url(receiveOAPath).post(body).addHeader("content-type", "application/json").build();
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                String result = response.body().string();
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                String operResult = jsonObject.getString("operResult");
                if ("1".equals(operResult)) {
                    return true;
                }
                logger.error((Object)jsonObject.getString("message"));
            } else {
                logger.error((Object)"\u53d1\u9001OA\u5f85\u529e\u6d88\u606f \u8d85\u65f6");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean removeMessage(String s) {
        return false;
    }

    public boolean removeMessage(String s, Context context) {
        return false;
    }

    public boolean updateMessage(String s) {
        return false;
    }

    public boolean updateMessage(String s, Context context) {
        return false;
    }

    public boolean updateMessages(String s, MsgStatus msgStatus) {
        return false;
    }

    public boolean updateMessages(String s, MsgStatus msgStatus, Context context) {
        return false;
    }

    public boolean addInitiatorMessage(WfrProcMessage wfrProcMessage) {
        return false;
    }

    public boolean addCompletedMessage(WfrAssignMessage wfrAssignMessage) {
        return false;
    }
}

