/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.shrToOA;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.elecontract.util.URLUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class GetSsoOAUrl
implements IHRMsfService {
    private static Logger logger = Logger.getLogger(GetSsoOAUrl.class);
    private static Properties prop = new Properties();
    private static String propPath = System.getProperty("EAS_HOME") + "/server/properties/scy/OASSOConfig.properties";

    public Object process(Context ctx, Map<String, Object> params) throws EASBizException, BOSException {
        String ssoPath = (String)params.get("ssoPath");
        HashMap<String, String> result = new HashMap<String, String>();
        String ssoOAUrl = null;
        try {
            if (StringUtils.isBlank((CharSequence)ssoPath)) {
                throw new BOSException("\u5355\u70b9\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            String token = this.getToken(ctx);
            ssoOAUrl = MessageFormat.format(ssoPath, token);
            result.put("result", "success");
            result.put("data", ssoOAUrl);
        }
        catch (BOSException e) {
            e.printStackTrace();
            result.put("result", "error");
            result.put("summary", e.getMessage());
        }
        return result;
    }

    public String getToken(Context ctx) throws BOSException {
        String getSsoTokenUrl = prop.getProperty("getSsoTokenUrl");
        String ssoAppid = prop.getProperty("ssoAppid");
        StringBuilder errorMsg = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)getSsoTokenUrl)) {
            errorMsg.append("\u83b7\u53d6sso\u63a5\u53e3\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!\n");
        }
        if (StringUtils.isBlank((CharSequence)ssoAppid)) {
            errorMsg.append("ssoAppid\u4e0d\u80fd\u4e3a\u7a7a!\n");
        }
        if (errorMsg.length() > 0) {
            throw new BOSException(errorMsg.toString());
        }
        String loginId = ContextUtil.getCurrentUserInfo((Context)ctx).getNumber();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appid", ssoAppid);
        params.put("loginid", loginId);
        String getUrl = URLUtils.assembleUrl((String)getSsoTokenUrl, params);
        logger.error((Object)("getToken getUrl: " + getUrl));
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url(getUrl).get().addHeader("Accept", "*/*").addHeader("Accept-Encoding", "gzip, deflate, br").addHeader("User-Agent", "PostmanRuntime-ApipostRuntime/1.1.0").addHeader("Connection", "keep-alive").addHeader("content-type", "multipart/form-data; boundary=---011000010111000001101001").build();
        try {
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                return response.body().string();
            }
            throw new BOSException("\u83b7\u53d6ssoToken\u8d85\u65f6");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BOSException("\u83b7\u53d6ssoToken\u62a5\u9519: " + e.getMessage());
        }
    }

    static {
        try {
            prop.load(new FileInputStream(propPath));
        }
        catch (IOException e) {
            logger.error((Object)("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u62a5\u9519: " + e.getMessage()));
            e.printStackTrace();
        }
    }
}

