/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.attendanceexception.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.attendanceexception.CenterLeaderRelationCollection;
import com.kingdee.eas.custom.attendanceexception.CenterLeaderRelationEntryCollection;
import com.kingdee.eas.custom.attendanceexception.CenterLeaderRelationEntryInfo;
import com.kingdee.eas.custom.attendanceexception.CenterLeaderRelationInfo;
import com.kingdee.eas.custom.attendanceexception.app.AbstractCenterLeaderRelationControllerBean;
import com.kingdee.eas.custom.synctask.utils.HRTimeWebUtils;
import com.kingdee.eas.hr.ats.AtsUtil;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CenterLeaderRelationControllerBean
extends AbstractCenterLeaderRelationControllerBean {
    private static Logger logger = Logger.getLogger(CenterLeaderRelationControllerBean.class);
    private final String FIRSTLEVELORGID = "00000000-0000-0000-0000-00000000000362824988";

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean exists;
        CenterLeaderRelationInfo info = (CenterLeaderRelationInfo)model;
        AdminOrgUnitInfo department = info.getDepartment();
        if (department == null) {
            throw new BOSException("\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String orgId = department.getId().toString();
        IAdminOrgUnit iAdminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        department = iAdminOrgUnit.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        String unitLayerTypeId = department.getUnitLayerType().getId().toString();
        if (!"00000000-0000-0000-0000-00000000000362824988".equals(unitLayerTypeId)) {
            String orgName = department.getName();
            throw new BOSException(String.valueOf(orgName) + "\u4e0d\u662f\u4e00\u7ea7\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u7ef4\u62a4\u8d1f\u8d23\u4eba\uff01");
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("department", (Object)department.getId()));
        if (info.getId() != null) {
            filterItems.add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        if (exists = this.exists(ctx, filterInfo)) {
            String orgName = department.getName();
            throw new BOSException("\u7ec4\u7ec7[" + orgName + "]\u6570\u636e\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        CenterLeaderRelationEntryCollection entrys = info.getEntry();
        if (entrys.size() <= 0) {
            throw new BOSException("\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        HashSet<String> personIds = new HashSet<String>();
        ArrayList<String> numbers = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        int i = entrys.size() - 1;
        while (i >= 0) {
            CenterLeaderRelationEntryInfo entryInfo = entrys.get(i);
            PersonInfo person = entryInfo.getPerson();
            String personId = person.getId().toString();
            if (personIds.contains(personId)) {
                entrys.remove(entryInfo);
            } else {
                personIds.add(personId);
                numbers.add(person.getNumber());
                names.add(person.getName());
            }
            --i;
        }
        Collections.reverse(numbers);
        Collections.reverse(names);
        info.setPersonNumbers(this.listToString(numbers));
        info.setPersonNames(this.listToString(names));
        return super._save(ctx, model);
    }

    @Override
    protected Map _getLeaders(Context ctx) throws BOSException {
        super._getLeaders(ctx);
        Map<String, Set<String>> orgLeadersMap = this.getOrgLeaders(ctx);
        CenterLeaderRelationCollection relationCol = this.getCenterLeaderRelationCollection(ctx, "select id,department.number,personNumbers,notifyOrgLeader");
        int i = 0;
        while (i < relationCol.size()) {
            CenterLeaderRelationInfo info = relationCol.get(i);
            AdminOrgUnitInfo department = info.getDepartment();
            String personNumbers = info.getPersonNumbers();
            boolean notifyOrgLeader = info.isNotifyOrgLeader();
            if (department != null && StringUtils.isNotBlank((CharSequence)personNumbers)) {
                String orgNumber = department.getNumber();
                Set set = AtsUtil.toSet((String)personNumbers);
                if (orgLeadersMap.containsKey(orgNumber) && notifyOrgLeader) {
                    orgLeadersMap.get(orgNumber).addAll(set);
                } else {
                    orgLeadersMap.put(orgNumber, set);
                }
            } else {
                String id = info.getId().toString();
                logger.error((Object)("CenterLeaderRelationInfo exist department is null or personNumbers is null, id=" + id));
            }
            ++i;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("CenterLeaderRelationControllerBean getLeaders: " + orgLeadersMap));
        }
        return orgLeadersMap;
    }

    protected Map<String, Set<String>> getOrgLeaders(Context ctx) throws BOSException {
        HashMap<String, Set<String>> orgLeadersMap = new HashMap<String, Set<String>>();
        String curentShortStringDate = HRTimeWebUtils.getCurentShortStringDate();
        IPersonPosition iPersonPosition = PersonPositionFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("personDep.unitLayerType", (Object)"00000000-0000-0000-0000-00000000000362824988"));
        filterItems.add(new FilterItemInfo("personDep.isSealUp", (Object)"0"));
        filterItems.add(new FilterItemInfo("primaryPosition.isRespPosition", (Object)"1"));
        filterItems.add(new FilterItemInfo("primaryPosition.deletedStatus", (Object)"1"));
        filterItems.add(new FilterItemInfo("LEFFDT", (Object)curentShortStringDate, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("endDateTime", (Object)curentShortStringDate, CompareType.GREATER_EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("person.number");
        sic.add("personDep.number");
        EntityViewInfo viewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, (SelectorItemCollection)sic, null);
        PersonPositionCollection personPositionCollection = iPersonPosition.getPersonPositionCollection(viewInfo);
        int i = 0;
        while (i < personPositionCollection.size()) {
            PersonPositionInfo personPositionInfo = personPositionCollection.get(i);
            AdminOrgUnitInfo personDep = personPositionInfo.getPersonDep();
            String orgNumber = personDep.getNumber();
            PersonInfo person = personPositionInfo.getPerson();
            String personNumber = person.getNumber();
            if (orgLeadersMap.containsKey(orgNumber)) {
                ((Set)orgLeadersMap.get(orgNumber)).add(personNumber);
            } else {
                HashSet<String> set = new HashSet<String>();
                set.add(personNumber);
                orgLeadersMap.put(orgNumber, set);
            }
            ++i;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("orgLeadersMap = " + orgLeadersMap));
        }
        return orgLeadersMap;
    }

    protected String listToString(List<String> list) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (list != null && i < list.size()) {
            sb.append(list.get(i)).append(",");
            ++i;
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.lastIndexOf(","));
        }
        return sb.toString();
    }
}

