/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.attendanceexception.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.custom.attendanceexception.CenterLeaderRelationCollection;
import com.kingdee.eas.custom.attendanceexception.CenterLeaderRelationEntryCollection;
import com.kingdee.eas.custom.attendanceexception.CenterLeaderRelationEntryInfo;
import com.kingdee.eas.custom.attendanceexception.CenterLeaderRelationFactory;
import com.kingdee.eas.custom.attendanceexception.CenterLeaderRelationInfo;
import com.kingdee.eas.custom.attendanceexception.ICenterLeaderRelation;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.app.io.fileImport.BaseColumnInfo;
import com.kingdee.shr.base.syssetting.app.io.fileImport.BaseImportService;
import com.kingdee.shr.base.syssetting.app.io.fileImport.BaseRowInfo;
import com.kingdee.shr.base.syssetting.app.io.fileImport.ImportException;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CenterLeaderRelationImportService
extends BaseImportService {
    private static Logger logger = Logger.getLogger(CenterLeaderRelationImportService.class);

    protected void setOtherFieldInfo(CoreBaseInfo baseInfo, BaseRowInfo row) throws ImportException {
        super.setOtherFieldInfo(baseInfo, row);
        try {
            CenterLeaderRelationInfo relationInfo = (CenterLeaderRelationInfo)baseInfo;
            CenterLeaderRelationEntryCollection entrys = relationInfo.getEntry();
            entrys.clear();
            Map mapColumnInfo = row.getMapColumnInfo();
            Context ctx = this.getContext();
            IPerson iPerson = null;
            iPerson = PersonFactory.getLocalInstance((Context)ctx);
            for (String key : mapColumnInfo.keySet()) {
                String value;
                BaseColumnInfo columnInfo = (BaseColumnInfo)mapColumnInfo.get(key);
                String propName = columnInfo.getPropName();
                String name = columnInfo.getName();
                if (!columnInfo.isCustomField() || !propName.startsWith("person") || StringUtils.isEmpty((String)(value = row.getValueOfString(propName)))) continue;
                String filter = null;
                if (value.contains("##")) {
                    String[] split = value.split("##");
                    String number = split[0];
                    filter = "where number = '" + number + "'";
                } else {
                    filter = "where number = '" + value + "' or name = '" + value + "'";
                }
                PersonCollection personCollection = iPerson.getPersonCollection(filter);
                if (personCollection.size() > 0) {
                    PersonInfo personInfo = personCollection.get(0);
                    CenterLeaderRelationEntryInfo entry = new CenterLeaderRelationEntryInfo();
                    entry.setPerson(personInfo);
                    entrys.add(entry);
                    continue;
                }
                throw new ImportException(String.valueOf(name) + " " + value + " \u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6709\u8bef");
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new ImportException((Throwable)e);
        }
    }

    public void completeGenerateExcel(Map<String, BaseColumnInfo> columnInfoMap, XSSFWorkbook wb, XSSFSheet sheet) {
        Context ctx = this.getContext();
        int beginRow = 4;
        try {
            ICenterLeaderRelation iCenterLeaderRelation = CenterLeaderRelationFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = this.getSelectorItemCollection(columnInfoMap);
            SorterItemCollection sortItems = new SorterItemCollection();
            sortItems.add(new SorterItemInfo("department.sortCode"));
            EntityViewInfo entityViewInfo = EntityViewInfo.getInstance(null, (SelectorItemCollection)sic, (SorterItemCollection)sortItems);
            CenterLeaderRelationCollection relationCollection = iCenterLeaderRelation.getCenterLeaderRelationCollection(entityViewInfo);
            Map<Integer, String> columnIndexMap = this.getColumnIndexFn(columnInfoMap);
            int fillColumnCount = columnInfoMap.size();
            int j = 0;
            while (j < relationCollection.size()) {
                XSSFRow row = sheet.createRow(beginRow++);
                CenterLeaderRelationInfo relationInfo = relationCollection.get(j);
                CenterLeaderRelationEntryCollection entrys = relationInfo.getEntry();
                int k = 0;
                while (k < fillColumnCount) {
                    block11: {
                        String value;
                        Cell createCell;
                        Object obj;
                        block12: {
                            String columnName;
                            block10: {
                                obj = null;
                                createCell = row.createCell(k);
                                columnName = columnIndexMap.get(k);
                                value = null;
                                if (!columnName.startsWith("person")) break block10;
                                String num = columnName.replace("person", "");
                                if (StringUtils.isEmpty((String)num)) break block11;
                                Integer index = Integer.valueOf(num);
                                if (index > entrys.size()) {
                                    value = "";
                                } else {
                                    CenterLeaderRelationEntryInfo entryInfo = entrys.get(index - 1);
                                    obj = entryInfo.getPerson();
                                }
                                break block12;
                            }
                            obj = relationInfo.get(columnName);
                        }
                        if (obj != null) {
                            if (obj instanceof CoreBaseInfo) {
                                CoreBaseInfo coreBaseInfo = (CoreBaseInfo)obj;
                                value = coreBaseInfo.get("number") + "##" + coreBaseInfo.get("name");
                            } else {
                                value = obj instanceof Boolean ? ((Boolean)obj != false ? "\u662f" : "\u5426") : obj.toString();
                            }
                        }
                        createCell.setCellValue(value);
                    }
                    ++k;
                }
                ++j;
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("fetched too much rows")) {
                throw new ImportException("\u67e5\u8be2\u7684\u6570\u636e\u91cf\u8d85\u51fa\u9650\u5236\uff01\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u4fee\u6539\u914d\u7f6e\uff0c\u6216\u8005\u51cf\u5c11\u4e0b\u8f7d\u7684\u6570\u636e\u91cf\u3002");
            }
            e.printStackTrace();
            throw new ImportException(e.getMessage());
        }
    }

    protected Map<Integer, String> getColumnIndexFn(Map<String, BaseColumnInfo> columnInfoMap) {
        HashMap<Integer, String> columnIndexMap = new HashMap<Integer, String>();
        Iterator<String> keys = columnInfoMap.keySet().iterator();
        int var4 = 0;
        while (keys.hasNext()) {
            String key = keys.next();
            columnIndexMap.put(var4++, key);
        }
        return columnIndexMap;
    }

    protected SelectorItemCollection getSelectorItemCollection(Map<String, BaseColumnInfo> columnInfoMap) {
        SelectorItemCollection sic = new SelectorItemCollection();
        for (String key : columnInfoMap.keySet()) {
            BaseColumnInfo columnInfo = columnInfoMap.get(key);
            if (columnInfo.isCustomField() || columnInfo.isDynamicColumn()) continue;
            String supplierEntityName = columnInfo.getSupplierEntityName();
            if (DataType.OBJECTVALUE.equals((Object)columnInfo.getPropDataType()) || !StringUtils.isEmpty((String)supplierEntityName)) {
                sic.add(String.valueOf(key) + ".*");
                continue;
            }
            sic.add(key);
        }
        sic.add("entry.person.number");
        sic.add("entry.person.name");
        return sic;
    }
}

