/*
 * Decompiled with CFR 0.152.
 */
package uzi9.uzi9q.opmcepaq.epaq.plugin.other;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;

public class GenConstantUtils {
    private String packagePath;
    private String entityId;
    private StringBuilder content;
    private String devISVId;
    protected Map<String, String> codeLineMap;
    protected final String LINEFEED = "\r\n";
    protected SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public GenConstantUtils(String entityId, String packagePath, String devISVId) {
        this.entityId = entityId;
        this.packagePath = packagePath;
        this.devISVId = devISVId;
        this.content = new StringBuilder();
        this.codeLineMap = new HashMap<String, String>();
    }

    public StringBuilder getContent() {
        return this.content;
    }

    public void createEntityInfoJava() {
        String javaName = this.rename(this.entityId + "Constant");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)this.entityId);
        DataEntityPropertyCollection mainEntityProperties = mainEntityType.getProperties();
        this.createPrefixCode(this.content, javaName, mainEntityType.getDisplayName().getLocaleValue());
        for (IDataEntityProperty property : mainEntityProperties) {
            this.createProperteyCode(this.content, property);
            if (!(property instanceof EntryProp)) continue;
            this.handleEntryProp((EntryProp)property, this.content);
        }
        this.createSuffixCode(this.content);
    }

    public void createFormJava() {
        String javaName = this.rename(this.entityId + "Constant");
        String id = MetadataDao.getIdByNumber((String)this.entityId, (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        this.createPrefixCode(this.content, javaName, formMeta.getName().getLocaleValue());
        List items = formMeta.getItems();
        for (ControlAp item : items) {
            if (item instanceof FieldAp) continue;
            String className = item.getClass().getName();
            String[] parts = className.split("\\.");
            className = parts[parts.length - 1];
            String annotation = String.format("Type:%s,Name:%s", className, item.getName().getLocaleValue());
            this.setContentCode(this.content, item.getKey(), annotation);
        }
        this.createSuffixCode(this.content);
    }

    private void createPrefixCode(StringBuilder content, String javaName, String entityName) {
        String packageName = "kd.constant";
        if (StringUtils.isNotBlank((CharSequence)this.packagePath)) {
            packageName = this.packagePath;
        }
        String rdNumber = RequestContext.get().getUserName();
        String dateStr = this.formatter.format(new Date());
        String prefixCode = "package " + packageName + ";" + "\r\n" + "\r\n" + "/**" + "\r\n" + " * " + entityName + "\u5e38\u91cf\u7c7b" + "\r\n" + " *" + "\r\n" + " * @author " + rdNumber + "\r\n" + " * @version 1.0" + "\r\n" + " * @date " + dateStr + "\r\n" + " */" + "\r\n" + "public class " + javaName + " {" + "\r\n";
        content.append(prefixCode);
        this.codeLineMap.put(this.entityId, "\u5b9e\u4f53\u6807\u8bc6");
        String annotation = "    /**\r\n";
        annotation = annotation + "    * \u5b9e\u4f53\u6807\u8bc6\r\n";
        annotation = annotation + "     **/\r\n";
        String code = "    public static final String ENTITYID = \"" + this.entityId + "\";" + "\r\n";
        content.append(annotation).append(code);
    }

    private void createProperteyCode(StringBuilder content, IDataEntityProperty iDataEntityProperty) {
        String propertyName = iDataEntityProperty.getName();
        LocaleString displayNameObj = iDataEntityProperty.getDisplayName();
        if (displayNameObj == null && !"id".equals(propertyName)) {
            return;
        }
        String disPlayName = "\u7f3a\u7701id\u5b57\u6bb5";
        if (displayNameObj != null) {
            disPlayName = displayNameObj.getLocaleValue_zh_CN();
        }
        this.setContentCode(content, propertyName, disPlayName);
    }

    private void setContentCode(StringBuilder content, String propertyName, String disPlayName) {
        if (this.codeLineMap.get(propertyName = this.deleteISVMark(propertyName)) == null) {
            this.codeLineMap.put(propertyName, disPlayName);
            String uppercasePropertyName = propertyName.toUpperCase();
            String annotation = "    /**\r\n";
            annotation = annotation + "    * " + disPlayName + "\r\n";
            annotation = annotation + "     **/\r\n";
            String code = "    public static final String " + uppercasePropertyName + " = \"" + propertyName + "\";" + "\r\n";
            content.append(annotation).append(code);
        }
    }

    private void handleEntryProp(EntryProp entryProp, StringBuilder content) {
        DynamicObjectType entryPropType = entryProp.getDynamicCollectionItemPropertyType();
        for (IDataEntityProperty entryPropProperty : entryPropType.getProperties()) {
            this.createProperteyCode(content, entryPropProperty);
            if (!(entryPropProperty instanceof SubEntryProp)) continue;
            this.handleSubEntryProp((SubEntryProp)entryPropProperty, content);
        }
    }

    private void handleSubEntryProp(SubEntryProp subEntryProp, StringBuilder content) {
        DynamicObjectType subEntryPropType = subEntryProp.getDynamicCollectionItemPropertyType();
        for (IDataEntityProperty subEntryPropProperty : subEntryPropType.getProperties()) {
            this.createProperteyCode(content, subEntryPropProperty);
        }
    }

    private void createSuffixCode(StringBuilder content) {
        content.append("}\r\n");
    }

    private String rename(String javaName) {
        String splitStr = "_";
        String result = "";
        if (javaName.contains(splitStr)) {
            String[] splitArray = javaName.split(splitStr);
            for (int i = 0; i < splitArray.length; ++i) {
                result = result + this.toUpperFirstChar(splitArray[i]);
            }
        } else {
            result = this.toUpperFirstChar(javaName);
        }
        return result;
    }

    private String toUpperFirstChar(String string) {
        char[] chars = string.toCharArray();
        if (chars[0] >= 'a' && chars[0] <= 'z') {
            chars[0] = (char)(chars[0] - 32);
            return String.valueOf(chars);
        }
        return string;
    }

    public String deleteISVMark(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        if (StringUtils.isEmpty((CharSequence)this.getDevISVId())) {
            return str.toUpperCase();
        }
        String devISVId = this.getDevISVId();
        for (String key : devISVId.split(",")) {
            if (str.indexOf(key = key + "_") != 0) continue;
            str = str.substring(key.length());
            break;
        }
        return str.toUpperCase();
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = packagePath;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void setContent(StringBuilder content) {
        this.content = content;
    }

    public String getDevISVId() {
        return this.devISVId;
    }

    public void setDevISVId(String devISVId) {
        this.devISVId = devISVId;
    }
}

