/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.zlb;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.Properties;
import org.gradle.wrapper.GradleWrapperMain;
import org.gradle.zlb.FileCopyUtils;

public class GradleUtils {
    private static final String GRADLE_LAUNCHER_KEY = "gradle-launcher-";
    private static final String GRADLE_FILE_PATH = "/bin/gradle";
    private static final String GRADLE_HOME = "GRADLE_HOME";
    private static final String GRADLE_USER_HOME = "GRADLE_USER_HOME";
    private static final String GRADLE_WRAPPER_DIST = "wrapper/dists";
    private static final String GRADLE_WRAPPER_PROP = "/gradle/wrapper/gradle-wrapper.properties";
    private static final String GRADLE_DOWNLOAD_HOST = "mirrors.cloud.tencent.com";
    private static final String GRADLE_WRAPPER_URL = "https://mirrors.cloud.tencent.com/gradle/gradle-7.5-bin.zip";

    public static String getGradleHome() {
        return System.getenv(GRADLE_HOME);
    }

    public static String getGradleUseHome() {
        return System.getenv(GRADLE_USER_HOME);
    }

    public static String getGradleVersion() {
        File gradleFile;
        String gradleVersion = null;
        String gradleHome = GradleUtils.getGradleHome();
        if (gradleHome != null && (gradleFile = new File(gradleHome + GRADLE_FILE_PATH)).exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(gradleHome + GRADLE_FILE_PATH));){
                while (br.read() > 0) {
                    String line = br.readLine();
                    if (!line.contains(GRADLE_LAUNCHER_KEY)) continue;
                    gradleVersion = line.substring(line.indexOf(GRADLE_LAUNCHER_KEY)).replace(GRADLE_LAUNCHER_KEY, "").replace(".jar", "");
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return gradleVersion;
            }
        }
        return gradleVersion;
    }

    public static boolean isValidVersion(String gradleVersion) {
        if (gradleVersion != null && gradleVersion.contains(".")) {
            try {
                String[] versionArr = gradleVersion.split("\\.");
                if (Integer.parseInt(versionArr[0]) > 7 || Integer.parseInt(versionArr[0]) == 7 && Integer.parseInt(versionArr[1]) >= 5) {
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static File rootDir(File wrapperJar) {
        return wrapperJar.getParentFile().getParentFile().getParentFile();
    }

    public static File wrapperProperties(File wrapperJar) {
        return new File(wrapperJar.getParent(), wrapperJar.getName().replaceFirst("\\.jar$", ".properties"));
    }

    public static File wrapperJar() {
        URI location;
        try {
            location = GradleWrapperMain.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!location.getScheme().equals("file")) {
            throw new RuntimeException(String.format("Cannot determine classpath for wrapper Jar from codebase '%s'.", location));
        }
        try {
            return Paths.get(location).toFile();
        }
        catch (NoClassDefFoundError e) {
            return new File(location.getPath());
        }
    }

    public static void copyLocalGradleToWrapperDir(String projectDir) {
        try {
            String localGradleVersion;
            boolean isValidVersion;
            String gradleHome = GradleUtils.getGradleHome();
            File gradleHomeDir = null;
            if (gradleHome == null) {
                return;
            }
            gradleHomeDir = new File(gradleHome);
            if (!gradleHomeDir.exists()) {
                return;
            }
            String gradleUserHome = GradleUtils.getGradleUseHome();
            File propertiesFile = new File(projectDir + GRADLE_WRAPPER_PROP);
            String distributionPath = GRADLE_WRAPPER_DIST;
            String distributionUrl = GRADLE_WRAPPER_URL;
            if (propertiesFile.exists()) {
                Properties prop = new Properties();
                prop.load(new FileReader(propertiesFile));
                if (prop.containsKey("distributionUrl")) {
                    URI distUrl = new URI(prop.getProperty("distributionUrl"));
                    distributionUrl = distUrl.toString();
                }
                if (prop.containsKey("distributionPath")) {
                    distributionPath = prop.getProperty("distributionPath");
                }
            }
            if (!(isValidVersion = GradleUtils.isValidVersion(localGradleVersion = GradleUtils.getGradleVersion()))) {
                return;
            }
            String zipFileName = GradleUtils.getDistName(distributionUrl);
            String zipFileNameWithSuffix = GradleUtils.removeExtension(zipFileName);
            String distDirName = zipFileName.substring(0, zipFileName.length() - 8);
            String distDirPath = gradleUserHome + "/" + distributionPath + "/" + GradleUtils.distDirPath(zipFileNameWithSuffix, distributionUrl);
            File distDir = new File(distDirPath);
            File distGradleDir = new File(distDir.getAbsolutePath(), distDirName);
            File okFile = new File(distDirPath + "/" + zipFileName + ".ok");
            File lckFile = new File(distDirPath + "/" + zipFileName + ".lck");
            if (distGradleDir.exists()) {
                return;
            }
            distGradleDir.mkdirs();
            File gradleHomeDirBin = new File(gradleHomeDir, "bin");
            File gradleHomeDirLib = new File(gradleHomeDir, "lib");
            FileCopyUtils.copyDir(gradleHomeDirBin, new File(distGradleDir, "bin"));
            FileCopyUtils.copyDir(gradleHomeDirLib, new File(distGradleDir, "lib"));
            if (!lckFile.exists()) {
                lckFile.createNewFile();
            }
            if (!okFile.exists()) {
                okFile.createNewFile();
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private static String getDistName(String url) {
        int p = url.lastIndexOf("/");
        if (p < 0) {
            return url;
        }
        return url.substring(p + 1);
    }

    private static String removeExtension(String name) {
        int p = name.lastIndexOf(".");
        if (p < 0) {
            return name;
        }
        return name.substring(0, p);
    }

    private static String distDirPath(String distName, String distributionUrl) {
        String urlHash = GradleUtils.getHash(distributionUrl);
        return distName + "/" + urlHash;
    }

    private static String getHash(String distributionUrl) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] bytes = distributionUrl.getBytes();
            messageDigest.update(bytes);
            return new BigInteger(1, messageDigest.digest()).toString(36);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not hash input string.", e);
        }
    }

    public static boolean isNetworkReachable() {
        try {
            InetAddress addr = InetAddress.getByName(GRADLE_DOWNLOAD_HOST);
            boolean isReachable = addr.isReachable(2000);
            return isReachable;
        }
        catch (IOException e) {
            return false;
        }
    }
}

